/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl.expression;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.model.jpa.criteria.impl.ExpressionVisitor;
import io.micronaut.data.model.jpa.criteria.impl.expression.AbstractExpression;
import io.micronaut.data.model.jpa.criteria.impl.expression.BinaryExpressionType;
import jakarta.persistence.criteria.Expression;

@Internal
public final class BinaryExpression<E>
extends AbstractExpression<E> {
    private final BinaryExpressionType type;
    private final Expression<?> left;
    private final Expression<?> right;

    public BinaryExpression(Expression<?> left, Expression<?> right, BinaryExpressionType type, @Nullable Class<E> expressionType) {
        super(expressionType);
        this.left = left;
        this.right = right;
        this.type = type;
    }

    @Override
    public Class<E> getJavaType() {
        Class javaType = super.getJavaType();
        if (javaType == null) {
            return this.left.getJavaType();
        }
        return javaType;
    }

    @NonNull
    public BinaryExpressionType getType() {
        return this.type;
    }

    @NonNull
    public Expression<?> getLeft() {
        return this.left;
    }

    @NonNull
    public Expression<?> getRight() {
        return this.right;
    }

    @Override
    public void visitExpression(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public String toString() {
        return "BinaryExpression{type=" + this.type + ", left=" + this.left + ", right=" + this.right + "}";
    }
}

