/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.micronaut.core.annotation.Creator;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.model.Sort;
import io.micronaut.serde.annotation.Serdeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Serdeable
final class DefaultSort
implements Sort {
    private final List<Sort.Order> orderBy;

    @Creator
    DefaultSort(List<Sort.Order> orderBy) {
        this.orderBy = orderBy;
    }

    DefaultSort() {
        this.orderBy = Collections.emptyList();
    }

    @Override
    @NonNull
    public DefaultSort order(@NonNull Sort.Order order) {
        ArgumentUtils.requireNonNull((String)"order", (Object)order);
        ArrayList<Sort.Order> newOrderBy = new ArrayList<Sort.Order>(this.orderBy);
        newOrderBy.add(order);
        return new DefaultSort(newOrderBy);
    }

    @Override
    @NonNull
    public List<Sort.Order> getOrderBy() {
        return Collections.unmodifiableList(this.orderBy);
    }

    @Override
    @JsonIgnore
    public boolean isSorted() {
        return CollectionUtils.isNotEmpty(this.orderBy);
    }

    @Override
    @NonNull
    public DefaultSort order(@NonNull String propertyName) {
        return this.order(new Sort.Order(propertyName));
    }

    @Override
    @NonNull
    public DefaultSort order(@NonNull String propertyName, @NonNull Sort.Order.Direction direction) {
        return this.order(new Sort.Order(propertyName, direction, false));
    }

    public String toString() {
        return "DefaultSort{orderBy=" + this.orderBy + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultSort that = (DefaultSort)o;
        return this.orderBy.equals(that.orderBy);
    }

    public int hashCode() {
        return Objects.hash(this.orderBy);
    }
}

