/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.naming;

import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.annotation.MappedProperty;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.Embedded;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.naming.NamingStrategies;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

@FunctionalInterface
@Introspected
public interface NamingStrategy {
    public static final NamingStrategy DEFAULT = new NamingStrategies.UnderScoreSeparatedLowerCase();

    @NonNull
    public String mappedName(@NonNull String var1);

    @NonNull
    default public String mappedName(@NonNull PersistentEntity entity) {
        ArgumentUtils.requireNonNull((String)"entity", (Object)entity);
        return entity.getAnnotationMetadata().stringValue(MappedEntity.class).filter(StringUtils::isNotEmpty).orElseGet(() -> this.mappedName(entity.getSimpleName()));
    }

    @NonNull
    default public String mappedName(Embedded embedded, PersistentProperty property) {
        return this.mappedName(embedded.getName() + this.mappedAssociatedName(property.getPersistedName()));
    }

    @NonNull
    default public String mappedName(@NonNull PersistentProperty property) {
        ArgumentUtils.requireNonNull((String)"property", (Object)property);
        if (property instanceof Association) {
            Association association = (Association)property;
            return this.mappedName(association);
        }
        return property.getAnnotationMetadata().stringValue(MappedProperty.class).filter(StringUtils::isNotEmpty).orElseGet(() -> this.mappedName(property.getName()));
    }

    @NonNull
    default public String mappedName(Association association) {
        String providedName = association.getAnnotationMetadata().stringValue(MappedProperty.class).orElse(null);
        if (providedName != null) {
            return providedName;
        }
        if (association.isForeignKey()) {
            Optional<Association> inverseSide = association.getInverseSide().map(Function.identity());
            Association owningAssociation = inverseSide.orElse(association);
            return this.mappedName(owningAssociation.getOwner().getDecapitalizedName() + owningAssociation.getAssociatedEntity().getSimpleName());
        }
        return switch (association.getKind()) {
            case Relation.Kind.ONE_TO_ONE, Relation.Kind.MANY_TO_ONE -> this.mappedName(association.getName() + this.getForeignKeySuffix());
            default -> this.mappedName(association.getName());
        };
    }

    @NonNull
    default public String mappedAssociatedName(@NonNull String associatedName) {
        return NameUtils.capitalize((String)associatedName);
    }

    @NonNull
    default public String mappedName(@NonNull List<Association> associations, @NonNull PersistentProperty property) {
        if (associations.isEmpty()) {
            return this.mappedName(property);
        }
        StringBuilder sb = new StringBuilder();
        Association foreignAssociation = null;
        for (Association association : associations) {
            String assocName;
            if (association.getKind() != Relation.Kind.EMBEDDED && foreignAssociation == null) {
                foreignAssociation = association;
            }
            String originalAssocName = association.getName();
            String string = assocName = association.getKind() == Relation.Kind.EMBEDDED ? association.getAnnotationMetadata().stringValue(MappedProperty.class).orElse(originalAssocName) : originalAssocName;
            if (!sb.isEmpty()) {
                sb.append(this.mappedAssociatedName(assocName));
                continue;
            }
            sb.append(assocName);
        }
        if (foreignAssociation != null) {
            PersistentProperty associatedEntityIdentity;
            PersistentEntity associatedEntity = foreignAssociation.getAssociatedEntity();
            PersistentProperty persistentProperty = associatedEntityIdentity = associatedEntity != null ? associatedEntity.getIdentity() : null;
            if (associatedEntity != null && associatedEntity.equals(property.getOwner()) && associatedEntityIdentity != null && associatedEntityIdentity.equals(property)) {
                String providedName = foreignAssociation.getAnnotationMetadata().stringValue(MappedProperty.class).orElse(null);
                if (providedName != null) {
                    return providedName;
                }
                sb.append(this.getForeignKeySuffix());
                return this.mappedName(sb.toString());
            }
            if (foreignAssociation.isForeignKey()) {
                throw new IllegalStateException("Foreign association cannot be mapped!");
            }
        } else {
            String providedName = property.getAnnotationMetadata().stringValue(MappedProperty.class).orElse(null);
            if (providedName != null) {
                return providedName;
            }
        }
        if (!sb.isEmpty()) {
            sb.append(this.mappedAssociatedName(property.getName()));
        } else {
            sb.append(property.getName());
        }
        return this.mappedName(sb.toString());
    }

    default public String mappedJoinTableColumn(PersistentEntity associated, List<Association> associations, PersistentProperty property) {
        StringBuilder sb = new StringBuilder();
        sb.append(associated.getDecapitalizedName());
        for (Association association : associations) {
            sb.append(this.mappedAssociatedName(association.getName()));
        }
        if (associations.isEmpty()) {
            sb.append(this.getForeignKeySuffix());
        } else {
            sb.append(this.mappedAssociatedName(property.getName()));
        }
        return this.mappedName(sb.toString());
    }

    @NonNull
    default public String getForeignKeySuffix() {
        return "Id";
    }
}

