/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.model.DefaultCursoredPageable;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.Sort;
import io.micronaut.serde.annotation.Serdeable;

@Serdeable
@Introspected
@JsonIgnoreProperties(ignoreUnknown=true)
public interface CursoredPageable
extends Pageable {
    public boolean isBackward();

    @Override
    default public Pageable.Mode getMode() {
        return this.isBackward() ? Pageable.Mode.CURSOR_PREVIOUS : Pageable.Mode.CURSOR_NEXT;
    }

    @NonNull
    public static CursoredPageable from(Sort sort) {
        if (sort == null) {
            sort = Sort.UNSORTED;
        }
        return new DefaultCursoredPageable(-1, null, Pageable.Mode.CURSOR_NEXT, 0, sort, true);
    }

    @NonNull
    public static CursoredPageable from(@JsonProperty(value="size") int size, @JsonProperty(value="sort") @Nullable Sort sort) {
        if (sort == null) {
            sort = UNSORTED;
        }
        return new DefaultCursoredPageable(size, null, Pageable.Mode.CURSOR_NEXT, 0, sort, true);
    }

    @Internal
    @JsonCreator
    @NonNull
    public static CursoredPageable from(@JsonProperty(value="number") int page, @Nullable Pageable.Cursor cursor, Pageable.Mode mode, int size, @Nullable Sort sort, boolean requestTotal) {
        if (sort == null) {
            sort = UNSORTED;
        }
        return new DefaultCursoredPageable(size, cursor, mode, page, sort, requestTotal);
    }
}

