/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.query.builder.sql;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.model.DataType;
import java.util.EnumSet;

public enum Dialect {
    H2(true, false, EnumSet.of(Join.Type.DEFAULT, new Join.Type[]{Join.Type.LEFT, Join.Type.LEFT_FETCH, Join.Type.RIGHT, Join.Type.RIGHT_FETCH, Join.Type.FETCH, Join.Type.INNER})),
    MYSQL(true, true, EnumSet.of(Join.Type.DEFAULT, new Join.Type[]{Join.Type.LEFT, Join.Type.LEFT_FETCH, Join.Type.RIGHT, Join.Type.RIGHT_FETCH, Join.Type.FETCH, Join.Type.INNER})),
    POSTGRES(true, false, Join.Type.ALL_TYPES, false, true, true, true),
    SQL_SERVER(false, false, Join.Type.ALL_TYPES),
    ORACLE(true, true, Join.Type.ALL_TYPES, true, false, false, false),
    ANSI(true, false, Join.Type.ALL_TYPES);

    private final boolean supportsBatch;
    private final boolean stringUUID;
    private final boolean supportsJsonEntity;
    private final EnumSet<Join.Type> joinTypesSupported;
    private final boolean supportsUpdateReturning;
    private final boolean supportsInsertReturning;
    private final boolean supportsDeleteReturning;

    private Dialect(boolean supportsBatch, boolean stringUUID, EnumSet<Join.Type> joinTypesSupported) {
        this(supportsBatch, stringUUID, joinTypesSupported, false, false, false, false);
    }

    private Dialect(boolean supportsBatch, boolean stringUUID, EnumSet<Join.Type> joinTypesSupported, boolean supportsJsonEntity, boolean supportsUpdateReturning, boolean supportsInsertReturning, boolean supportsDeleteReturning) {
        this.supportsBatch = supportsBatch;
        this.stringUUID = stringUUID;
        this.joinTypesSupported = joinTypesSupported;
        this.supportsJsonEntity = supportsJsonEntity;
        this.supportsUpdateReturning = supportsUpdateReturning;
        this.supportsInsertReturning = supportsInsertReturning;
        this.supportsDeleteReturning = supportsDeleteReturning;
    }

    public final boolean allowBatch() {
        return this.supportsBatch;
    }

    public final DataType getDataType(@NonNull DataType type) {
        if (type == DataType.UUID && this.stringUUID) {
            return DataType.STRING;
        }
        return type;
    }

    public final boolean requiresStringUUID(@NonNull DataType type) {
        return type == DataType.UUID && this.stringUUID;
    }

    public final boolean supportsJoinType(@NonNull Join.Type joinType) {
        return this.joinTypesSupported.contains((Object)joinType);
    }

    public boolean supportsJsonEntity() {
        return this.supportsJsonEntity;
    }

    public boolean supportsUpdateReturning() {
        return this.supportsUpdateReturning;
    }

    public boolean supportsInsertReturning() {
        return this.supportsInsertReturning;
    }

    public boolean supportsDeleteReturning() {
        return this.supportsDeleteReturning;
    }
}

