/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl.predicate;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.model.jpa.criteria.impl.CriteriaUtils;
import jakarta.persistence.criteria.Expression;

@Internal
public enum PredicateBinaryOp {
    EQUALS,
    NOT_EQUALS,
    EQUALS_IGNORE_CASE,
    NOT_EQUALS_IGNORE_CASE,
    GREATER_THAN,
    GREATER_THAN_OR_EQUALS,
    LESS_THAN,
    LESS_THAN_OR_EQUALS,
    REGEX,
    CONTAINS,
    CONTAINS_IGNORE_CASE,
    STARTS_WITH,
    ENDS_WITH,
    STARTS_WITH_IGNORE_CASE,
    ENDS_WITH_IGNORE_CASE,
    ARRAY_CONTAINS;


    void validate(@Nullable Expression<?> left, @Nullable Expression<?> right) {
        switch (this) {
            case EQUALS: 
            case NOT_EQUALS: 
            case EQUALS_IGNORE_CASE: 
            case NOT_EQUALS_IGNORE_CASE: {
                break;
            }
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUALS: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUALS: {
                CriteriaUtils.requireComparableExpression(left);
                CriteriaUtils.requireComparableExpression(right);
                break;
            }
            case REGEX: 
            case CONTAINS: 
            case CONTAINS_IGNORE_CASE: 
            case STARTS_WITH: 
            case ENDS_WITH: 
            case STARTS_WITH_IGNORE_CASE: 
            case ENDS_WITH_IGNORE_CASE: {
                CriteriaUtils.requireStringExpression(left);
                CriteriaUtils.requireStringExpression(right);
                break;
            }
            case ARRAY_CONTAINS: {
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported predicate: " + this);
            }
        }
    }

    @Nullable
    public PredicateBinaryOp negate() {
        return switch (this) {
            case EQUALS -> NOT_EQUALS;
            case NOT_EQUALS -> EQUALS;
            default -> null;
        };
    }
}

