/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.model.jpa.criteria.IExpression;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.PersistentEntitySubquery;
import io.micronaut.data.model.jpa.criteria.PersistentPropertyPath;
import io.micronaut.data.model.jpa.criteria.impl.expression.LiteralExpression;
import io.micronaut.data.model.jpa.criteria.impl.predicate.BinaryPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.ConjunctionPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.DisjunctionPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.InPredicate;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.ParameterExpression;
import jakarta.persistence.criteria.Subquery;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

@Internal
public final class CriteriaUtils {
    private CriteriaUtils() {
    }

    public static boolean isNumeric(@NonNull Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return Number.class.isAssignableFrom(ReflectionUtils.getPrimitiveType(clazz));
        }
        return Number.class.isAssignableFrom(clazz);
    }

    public static boolean isBoolean(@NonNull Class<?> clazz) {
        return Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE.isAssignableFrom(clazz);
    }

    public static boolean isComparable(@NonNull Class<?> clazz) {
        return Comparable.class.isAssignableFrom(clazz) || CriteriaUtils.isNumeric(clazz);
    }

    public static boolean isTextual(@NonNull Class<?> clazz) {
        return CharSequence.class.isAssignableFrom(clazz);
    }

    public static List<IExpression<Boolean>> requireBoolExpressions(Iterable<? extends Expression<?>> restrictions) {
        return CollectionUtils.iterableToList(restrictions).stream().map(CriteriaUtils::requireBoolExpression).toList();
    }

    public static <T> IExpression<T> requireIExpression(Expression<T> exp) {
        if (exp instanceof IExpression) {
            IExpression expression = (IExpression)exp;
            return expression;
        }
        throw new IllegalStateException("Expected an IExpression! Got: " + exp);
    }

    public static <T> PersistentEntitySubquery<T> requirePersistentEntitySubquery(Subquery<T> subquery) {
        if (subquery instanceof PersistentEntitySubquery) {
            PersistentEntitySubquery persistentEntitySubquery = (PersistentEntitySubquery)subquery;
            return persistentEntitySubquery;
        }
        throw new IllegalStateException("Expected an PersistentEntitySubquery! Got: " + subquery);
    }

    public static IExpression<String> requireNumericExpression(Expression<?> exp) {
        IExpression<String> expression = CriteriaUtils.requireIExpression(exp);
        if (expression instanceof ParameterExpression || expression.getExpressionType().isNumeric()) {
            return expression;
        }
        throw new IllegalStateException("Expected a numeric expression! Got: " + expression.getExpressionType().getName());
    }

    public static IExpression<String> requireStringExpression(Expression<?> exp) {
        IExpression<String> expression = CriteriaUtils.requireIExpression(exp);
        if (expression instanceof ParameterExpression || expression.getExpressionType().isTextual()) {
            return expression;
        }
        throw new IllegalStateException("Expected a string expression! Got: " + expression.getExpressionType().getName());
    }

    public static <T> Expression<T> requireComparableExpression(Expression<T> exp) {
        IExpression<T> expression = CriteriaUtils.requireIExpression(exp);
        if (expression instanceof ParameterExpression || expression.getExpressionType().isComparable()) {
            return expression;
        }
        throw new IllegalStateException("Expected a comparable expression! Got: " + expression.getExpressionType().getName());
    }

    public static IExpression<Boolean> requireBoolExpression(Expression<?> exp) {
        IExpression<Boolean> expression = CriteriaUtils.requireIExpression(exp);
        if (expression instanceof ParameterExpression || expression.getExpressionType().isBoolean()) {
            return expression;
        }
        throw new IllegalStateException("Expected a boolean expression! Got: " + expression.getExpressionType().getName());
    }

    public static <T> ParameterExpression<T> requireParameter(Expression<T> exp) {
        if (exp instanceof ParameterExpression) {
            ParameterExpression parameterExpression = (ParameterExpression)exp;
            return parameterExpression;
        }
        throw new IllegalStateException("Expression is expected to be a parameter! Got: " + exp);
    }

    public static <T> PersistentPropertyPath<T> requireProperty(Expression<? extends T> exp) {
        if (exp instanceof PersistentPropertyPath) {
            PersistentPropertyPath persistentPropertyPath = (PersistentPropertyPath)exp;
            return persistentPropertyPath;
        }
        throw new IllegalStateException("Expression is expected to be a property path! Got: " + exp);
    }

    public static <T> IExpression<T> requirePropertyOrRoot(Expression<T> exp) {
        if (exp instanceof PersistentPropertyPath || exp instanceof PersistentEntityRoot) {
            return (IExpression)exp;
        }
        throw new IllegalStateException("Expression is expected to be a property path or a root! Got: " + exp);
    }

    public static IllegalStateException notSupportedOperation() {
        return new IllegalStateException("Not supported operation!");
    }

    public static boolean hasVersionPredicate(Expression<?> predicate) {
        if (predicate instanceof BinaryPredicate) {
            PersistentPropertyPath pp;
            BinaryPredicate binaryPredicate = (BinaryPredicate)predicate;
            Expression<?> expression = binaryPredicate.getLeftExpression();
            if (expression instanceof PersistentPropertyPath && (pp = (PersistentPropertyPath)expression).getProperty() == pp.getProperty().getOwner().getVersion()) {
                return true;
            }
            Expression<?> expression2 = binaryPredicate.getRightExpression();
            if (expression2 instanceof PersistentPropertyPath && (pp = (PersistentPropertyPath)expression2).getProperty() == pp.getProperty().getOwner().getVersion()) {
                return true;
            }
        }
        if (predicate instanceof ConjunctionPredicate) {
            ConjunctionPredicate conjunctionPredicate = (ConjunctionPredicate)predicate;
            for (IExpression<Boolean> iExpression : conjunctionPredicate.getPredicates()) {
                if (!CriteriaUtils.hasVersionPredicate(iExpression)) continue;
                return true;
            }
        }
        if (predicate instanceof DisjunctionPredicate) {
            DisjunctionPredicate disjunctionPredicate = (DisjunctionPredicate)predicate;
            for (IExpression<Boolean> iExpression : disjunctionPredicate.getPredicates()) {
                if (!CriteriaUtils.hasVersionPredicate(iExpression)) continue;
                return true;
            }
        }
        return false;
    }

    public static Set<ParameterExpression<?>> extractPredicateParameters(Expression<?> predicate) {
        if (predicate == null) {
            return Collections.emptySet();
        }
        LinkedHashSet properties = new LinkedHashSet();
        CriteriaUtils.extractPredicateParameters(predicate, properties);
        return properties;
    }

    private static void extractPredicateParameters(Expression<?> predicate, Set<ParameterExpression<?>> parameters) {
        if (predicate instanceof LiteralExpression) {
            return;
        }
        if (predicate instanceof BinaryPredicate) {
            Expression<?> expression;
            ParameterExpression parameterExpression;
            BinaryPredicate binaryPredicate = (BinaryPredicate)predicate;
            Expression<?> expression2 = binaryPredicate.getLeftExpression();
            if (expression2 instanceof ParameterExpression) {
                parameterExpression = (ParameterExpression)expression2;
                parameters.add(parameterExpression);
            }
            if ((expression = binaryPredicate.getRightExpression()) instanceof ParameterExpression) {
                parameterExpression = (ParameterExpression)expression;
                parameters.add(parameterExpression);
            }
        } else if (predicate instanceof InPredicate) {
            InPredicate pp = (InPredicate)predicate;
            for (Expression<?> expression : pp.getValues()) {
                if (!(expression instanceof ParameterExpression)) continue;
                ParameterExpression parameterExpression = (ParameterExpression)expression;
                parameters.add(parameterExpression);
            }
        } else if (predicate instanceof ConjunctionPredicate) {
            ConjunctionPredicate conjunctionPredicate = (ConjunctionPredicate)predicate;
            for (IExpression<Boolean> iExpression : conjunctionPredicate.getPredicates()) {
                CriteriaUtils.extractPredicateParameters(iExpression, parameters);
            }
        } else if (predicate instanceof DisjunctionPredicate) {
            DisjunctionPredicate disjunctionPredicate = (DisjunctionPredicate)predicate;
            for (IExpression<Boolean> iExpression : disjunctionPredicate.getPredicates()) {
                CriteriaUtils.extractPredicateParameters(iExpression, parameters);
            }
        } else {
            throw new IllegalStateException("Unsupported predicate type: " + predicate.getClass().getSimpleName());
        }
    }
}

