/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.micronaut.core.annotation.Creator;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.ReflectiveAccess;
import io.micronaut.data.model.CursoredPage;
import io.micronaut.data.model.DefaultPage;
import io.micronaut.data.model.Pageable;
import io.micronaut.serde.annotation.Serdeable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Serdeable
@Internal
final class DefaultCursoredPage<T>
extends DefaultPage<T>
implements CursoredPage<T> {
    private final List<Pageable.Cursor> cursors;

    @JsonCreator
    @Creator
    @ReflectiveAccess
    DefaultCursoredPage(@JsonProperty(value="content") List<T> content, @JsonProperty(value="pageable") Pageable pageable, @JsonProperty(value="cursors") List<Pageable.Cursor> cursors, @JsonProperty(value="totalSize") Long totalSize) {
        super(content, pageable, totalSize);
        if (content.size() != cursors.size()) {
            throw new IllegalArgumentException("The number of cursors must match the number of content items for a page");
        }
        this.cursors = cursors;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultCursoredPage)) {
            return false;
        }
        DefaultCursoredPage that = (DefaultCursoredPage)o;
        return Objects.equals(this.cursors, that.cursors) && super.equals(o);
    }

    @Override
    public Optional<Pageable.Cursor> getCursor(int i) {
        return i >= this.cursors.size() || i < 0 ? Optional.empty() : Optional.of(this.cursors.get(i));
    }

    @Override
    public List<Pageable.Cursor> getCursors() {
        return this.cursors;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.cursors, super.hashCode());
    }

    @Override
    public String toString() {
        return "DefaultPage{totalSize=" + this.getTotalSize() + ",content=" + String.valueOf(this.getContent()) + ",pageable=" + String.valueOf(this.getPageable()) + ",cursors=" + String.valueOf(this.cursors) + "}";
    }
}

