/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.query.builder.sql.validation;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.model.query.builder.sql.validation.BaseSqlTableMappingValidator;
import io.micronaut.data.model.schema.sql.SqlColumnMapping;
import io.micronaut.data.model.schema.sql.SqlDbType;
import io.micronaut.data.model.schema.sql.metadata.SqlColumnMetadata;
import jakarta.inject.Singleton;

@Internal
@Singleton
final class OracleSqlTableMappingValidator
extends BaseSqlTableMappingValidator {
    OracleSqlTableMappingValidator() {
    }

    @Override
    public Dialect getSupportedDialect() {
        return Dialect.ORACLE;
    }

    @Override
    protected boolean matchingDialectColumnType(SqlColumnMapping columnMapping, SqlColumnMetadata columnMetadata) {
        if (columnMapping.getDbType() == SqlDbType.UUID) {
            return OracleSqlTableMappingValidator.uuidMatchesVarchar(columnMetadata);
        }
        if (columnMetadata.type() == 2) {
            Object oracleSqlType = "NUMBER";
            if (columnMetadata.columnSize() > 0) {
                oracleSqlType = (String)oracleSqlType + "(" + columnMetadata.columnSize();
                if (columnMetadata.decimalDigits() > 0) {
                    oracleSqlType = (String)oracleSqlType + "," + columnMetadata.decimalDigits();
                }
                oracleSqlType = (String)oracleSqlType + ")";
            }
            return columnMapping.getSqlType(Dialect.ORACLE).equalsIgnoreCase((String)oracleSqlType);
        }
        if (OracleSqlTableMappingValidator.isOracleBinaryDoubleOrFloat(columnMetadata.typeName())) {
            return OracleSqlTableMappingValidator.isFloatOrRealOrDouble(columnMapping.getDbType().getType());
        }
        return false;
    }

    private static boolean isOracleBinaryDoubleOrFloat(String typeName) {
        return "BINARY_DOUBLE".equalsIgnoreCase(typeName) || "BINARY_FLOAT".equalsIgnoreCase(typeName);
    }
}

