/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.query.builder.sql.validation;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.model.query.builder.sql.validation.BaseSqlTableMappingValidator;
import io.micronaut.data.model.schema.sql.SqlColumnMapping;
import io.micronaut.data.model.schema.sql.SqlDbType;
import io.micronaut.data.model.schema.sql.metadata.SqlColumnMetadata;
import jakarta.inject.Singleton;

@Internal
@Singleton
final class MySqlTableMappingValidator
extends BaseSqlTableMappingValidator {
    MySqlTableMappingValidator() {
    }

    @Override
    public Dialect getSupportedDialect() {
        return Dialect.MYSQL;
    }

    @Override
    protected boolean matchingDialectColumnType(SqlColumnMapping columnMapping, SqlColumnMetadata columnMetadata) {
        if (columnMapping.getDbType() == SqlDbType.UUID) {
            return MySqlTableMappingValidator.uuidMatchesVarchar(columnMetadata) || columnMetadata.type() == 1111 && columnMetadata.typeName().equalsIgnoreCase("uuid");
        }
        if (columnMapping.getDbType() == SqlDbType.BOOLEAN) {
            return columnMetadata.type() == -7;
        }
        if (columnMapping.getDbType() == SqlDbType.JSON) {
            return columnMetadata.type() == -1;
        }
        return false;
    }
}

