/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.jpa.criteria.ExpressionType;
import io.micronaut.data.model.jpa.criteria.IExpression;
import io.micronaut.data.model.jpa.criteria.IPredicate;
import io.micronaut.data.model.jpa.criteria.ISelection;
import io.micronaut.data.model.jpa.criteria.PersistentEntityQuery;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.PersistentPropertyPath;
import io.micronaut.data.model.jpa.criteria.impl.CriteriaUtils;
import io.micronaut.data.model.jpa.criteria.impl.QueryResultPersistentEntityCriteriaQuery;
import io.micronaut.data.model.jpa.criteria.impl.predicate.BinaryPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.ConjunctionPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.DisjunctionPredicate;
import io.micronaut.data.model.jpa.criteria.impl.selection.CompoundSelection;
import io.micronaut.data.model.jpa.criteria.impl.util.Joiner;
import io.micronaut.data.model.query.JoinPath;
import io.micronaut.data.model.query.builder.QueryBuilder2;
import io.micronaut.data.model.query.builder.QueryResult;
import jakarta.persistence.criteria.AbstractQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.metamodel.EntityType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

@Internal
public abstract class AbstractPersistentEntityQuery<T, Self extends PersistentEntityQuery<T>>
implements AbstractQuery<T>,
QueryResultPersistentEntityCriteriaQuery,
PersistentEntityQuery<T> {
    protected Map<Integer, String> parametersInRole = new LinkedHashMap<Integer, String>();
    protected final CriteriaBuilder criteriaBuilder;
    protected final ExpressionType<T> resultType;
    protected Predicate predicate;
    protected Selection<?> selection;
    protected PersistentEntityRoot<?> entityRoot;
    protected List<Order> orders;
    protected int max = -1;
    protected int offset = 0;
    protected boolean forUpdate;
    protected boolean distinct;

    protected AbstractPersistentEntityQuery(ExpressionType<T> resultType, CriteriaBuilder criteriaBuilder) {
        this.resultType = resultType;
        this.criteriaBuilder = criteriaBuilder;
    }

    @Override
    public PersistentEntity getPersistentEntity() {
        return this.entityRoot.getPersistentEntity();
    }

    public final Map<Integer, String> getParametersInRole() {
        return this.parametersInRole;
    }

    protected abstract Self self();

    @Override
    public QueryResult buildQuery(AnnotationMetadata annotationMetadata, QueryBuilder2 queryBuilder) {
        return queryBuilder.buildSelect(annotationMetadata, this.toSelectQueryDefinition());
    }

    public QueryBuilder2.SelectQueryDefinition toSelectQueryDefinition() {
        return new SelectQueryDefinitionImpl(this.entityRoot, this.entityRoot.getPersistentEntity(), this.predicate, this.selection == null ? this.entityRoot : this.selection, this.calculateJoins(this.entityRoot.getPersistentEntity()), this.forUpdate, this.distinct, this.orders == null ? List.of() : this.orders, this.max, this.offset, this.parametersInRole);
    }

    private Map<String, JoinPath> calculateJoins(PersistentEntity persistentEntity) {
        Joiner joiner = new Joiner();
        Object object = this.predicate;
        if (object instanceof IPredicate) {
            IPredicate predicateVisitable = (IPredicate)object;
            predicateVisitable.visitPredicate(joiner);
        }
        if ((object = this.selection) instanceof ISelection) {
            ISelection selectionVisitable = (ISelection)object;
            selectionVisitable.visitSelection(joiner);
            this.entityRoot.visitSelection(joiner);
        } else {
            this.entityRoot.visitSelection(joiner);
        }
        if (this.orders != null) {
            for (Order o : this.orders) {
                joiner.joinIfNeeded(CriteriaUtils.requireProperty(o.getExpression()));
            }
        }
        LinkedHashMap<String, JoinPath> joinPaths = new LinkedHashMap<String, JoinPath>();
        for (Map.Entry entry : joiner.getJoins().entrySet()) {
            Joiner.Joined joined = (Joiner.Joined)entry.getValue();
            Join.Type joinType = this.calculateJoinType(joined);
            String path = (String)entry.getKey();
            io.micronaut.data.model.PersistentPropertyPath propertyPath = persistentEntity.getPropertyPath(path);
            if (propertyPath == null) {
                throw new IllegalArgumentException("Invalid association path. Element [" + path + "] is not an association for [" + persistentEntity + "]");
            }
            Association[] associationPath = propertyPath.getProperty() instanceof Association ? (Association[])Stream.concat(propertyPath.getAssociations().stream(), Stream.of(propertyPath.getProperty())).toArray(Association[]::new) : propertyPath.getAssociations().toArray(new Association[0]);
            JoinPath jp = new JoinPath(path, associationPath, joinType, joined.getAlias());
            joinPaths.put((String)entry.getKey(), jp);
        }
        return joinPaths;
    }

    private Join.Type calculateJoinType(Joiner.Joined joined) {
        Join.Type joinType = Optional.ofNullable(joined.getType()).orElse(Join.Type.DEFAULT);
        if (!this.isProjected(joined.getAssociation())) {
            joinType = switch (joinType) {
                case Join.Type.INNER, Join.Type.FETCH -> Join.Type.DEFAULT;
                case Join.Type.LEFT_FETCH -> Join.Type.LEFT;
                case Join.Type.RIGHT_FETCH -> Join.Type.RIGHT;
                default -> joinType;
            };
        }
        return joinType;
    }

    private boolean isProjected(Join<?, ?> join) {
        return this.isProjected(this.selection, join);
    }

    private boolean isProjected(Selection<?> selection, Join<?, ?> join) {
        Selection<?> root;
        if (selection instanceof CompoundSelection) {
            CompoundSelection compoundSelection = (CompoundSelection)selection;
            return true;
        }
        Selection<?> selection2 = root = selection == null ? this.entityRoot : selection;
        while (join != null) {
            if (join == root) {
                return true;
            }
            From parent = join.getParent();
            if (parent == root) {
                return true;
            }
            if (parent instanceof Join) {
                Join nextJoin;
                join = nextJoin = (Join)parent;
                continue;
            }
            return false;
        }
        return false;
    }

    public abstract <X> PersistentEntityRoot<X> from(Class<X> var1);

    public <X> PersistentEntityRoot<X> from(EntityType<X> entity) {
        if (this.entityRoot != null) {
            throw new IllegalStateException("The root entity is already specified!");
        }
        return null;
    }

    @Override
    public abstract <X> PersistentEntityRoot<X> from(PersistentEntity var1);

    public Self limit(int limit) {
        this.max = limit;
        return this.self();
    }

    public Self offset(int offset) {
        this.offset = offset;
        return this.self();
    }

    public Self forUpdate(boolean forUpdate) {
        this.forUpdate = forUpdate;
        return this.self();
    }

    public Self where(Expression<Boolean> restriction) {
        if (restriction instanceof ConjunctionPredicate) {
            ConjunctionPredicate conjunctionPredicate = (ConjunctionPredicate)restriction;
            this.predicate = conjunctionPredicate;
        } else {
            this.predicate = new ConjunctionPredicate(Collections.singleton((IExpression)restriction));
        }
        return this.self();
    }

    public Self where(Predicate ... restrictions) {
        Objects.requireNonNull(restrictions);
        this.predicate = restrictions.length > 0 ? (restrictions.length == 1 ? restrictions[0] : new ConjunctionPredicate(((Stream)Arrays.stream(restrictions).sequential()).map(x -> (IExpression)x).toList())) : null;
        return this.self();
    }

    public Self groupBy(Expression<?> ... grouping) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Self groupBy(List<Expression<?>> grouping) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Self having(Expression<Boolean> restriction) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Self having(Predicate ... restrictions) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Self distinct(boolean distinct) {
        this.distinct = distinct;
        return this.self();
    }

    public Set<Root<?>> getRoots() {
        if (this.entityRoot != null) {
            return Collections.singleton(this.entityRoot);
        }
        return Collections.emptySet();
    }

    public List<Expression<?>> getGroupList() {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Predicate getGroupRestriction() {
        throw CriteriaUtils.notSupportedOperation();
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public Class<T> getResultType() {
        return this.resultType.getJavaType();
    }

    public Selection<T> getSelection() {
        return this.selection;
    }

    public Predicate getRestriction() {
        return this.predicate;
    }

    public final boolean hasOnlyIdRestriction() {
        return this.isOnlyIdRestriction((Expression<?>)this.predicate);
    }

    private boolean isOnlyIdRestriction(Expression<?> predicate) {
        DisjunctionPredicate disjunctionPredicate;
        ConjunctionPredicate conjunctionPredicate;
        if (predicate instanceof BinaryPredicate) {
            BinaryPredicate binaryPredicate = (BinaryPredicate)predicate;
            Expression<?> expression = binaryPredicate.getLeftExpression();
            if (expression instanceof PersistentPropertyPath) {
                PersistentPropertyPath pp = (PersistentPropertyPath)expression;
                return pp.getProperty() == pp.getProperty().getOwner().getIdentity();
            }
            expression = binaryPredicate.getRightExpression();
            if (expression instanceof PersistentPropertyPath) {
                PersistentPropertyPath pp = (PersistentPropertyPath)expression;
                return pp.getProperty() == pp.getProperty().getOwner().getIdentity();
            }
        }
        if (predicate instanceof ConjunctionPredicate && (conjunctionPredicate = (ConjunctionPredicate)predicate).getPredicates().size() == 1) {
            return this.isOnlyIdRestriction((Expression)conjunctionPredicate.getPredicates().iterator().next());
        }
        if (predicate instanceof DisjunctionPredicate && (disjunctionPredicate = (DisjunctionPredicate)predicate).getPredicates().size() == 1) {
            return this.isOnlyIdRestriction((Expression)disjunctionPredicate.getPredicates().iterator().next());
        }
        return false;
    }

    public final boolean hasVersionRestriction() {
        if (this.entityRoot.getPersistentEntity().getVersion() == null) {
            return false;
        }
        return CriteriaUtils.hasVersionPredicate(this.predicate);
    }

    @Internal
    private static final class SelectQueryDefinitionImpl
    extends BaseQueryDefinitionImpl
    implements QueryBuilder2.SelectQueryDefinition {
        private final Root<?> root;
        private final Selection<?> selection;
        private final boolean isForUpdate;
        private final boolean isDistinct;
        private final List<Order> order;
        private final int limit;
        private final int offset;
        private final Map<Integer, String> parametersInRole;

        public SelectQueryDefinitionImpl(Root<?> root, PersistentEntity persistentEntity, Predicate predicate, Selection<?> selection, Map<String, JoinPath> joinPaths, boolean isForUpdate, boolean isDistinct, List<Order> order, int limit, int offset, Map<Integer, String> parametersInRole) {
            super(persistentEntity, predicate, joinPaths);
            this.root = root;
            this.selection = selection;
            this.isForUpdate = isForUpdate;
            this.isDistinct = isDistinct;
            this.order = order;
            this.limit = limit;
            this.offset = offset;
            this.parametersInRole = parametersInRole;
        }

        @Override
        public Map<Integer, String> parametersInRole() {
            return this.parametersInRole;
        }

        @Override
        public Root<?> root() {
            return this.root;
        }

        @Override
        public Selection<?> selection() {
            return this.selection;
        }

        @Override
        public List<Order> order() {
            return this.order;
        }

        @Override
        public int limit() {
            return this.limit;
        }

        @Override
        public int offset() {
            return this.offset;
        }

        @Override
        public boolean isForUpdate() {
            return this.isForUpdate;
        }

        @Override
        public boolean isDistinct() {
            return this.isDistinct;
        }
    }

    @Internal
    static abstract class BaseQueryDefinitionImpl
    implements QueryBuilder2.BaseQueryDefinition {
        private final PersistentEntity persistentEntity;
        private final Predicate predicate;
        private final Map<String, JoinPath> joinPaths;

        protected BaseQueryDefinitionImpl(PersistentEntity persistentEntity, Predicate predicate, Map<String, JoinPath> joinPaths) {
            this.persistentEntity = persistentEntity;
            this.predicate = predicate;
            this.joinPaths = joinPaths;
        }

        @Override
        public PersistentEntity persistentEntity() {
            return this.persistentEntity;
        }

        @Override
        public Predicate predicate() {
            return this.predicate;
        }

        @Override
        public Collection<JoinPath> getJoinPaths() {
            return Collections.unmodifiableCollection(this.joinPaths.values());
        }

        @Override
        public Optional<JoinPath> getJoinPath(String path) {
            if (path != null) {
                return Optional.ofNullable(this.joinPaths.get(path));
            }
            return Optional.empty();
        }
    }
}

