/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.jpa.criteria.ExpressionType;
import io.micronaut.data.model.jpa.criteria.IExpression;
import io.micronaut.data.model.jpa.criteria.impl.expression.ClassExpressionType;
import io.micronaut.data.model.jpa.criteria.impl.predicate.PredicateUnaryOp;
import io.micronaut.data.model.jpa.criteria.impl.predicate.UnaryPredicate;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import java.util.List;
import java.util.StringJoiner;

public interface PersistentPropertyPath<T>
extends Path<T>,
IExpression<T> {
    @NonNull
    public PersistentProperty getProperty();

    @NonNull
    public List<Association> getAssociations();

    default public io.micronaut.data.model.PersistentPropertyPath getPropertyPath() {
        return new io.micronaut.data.model.PersistentPropertyPath(this.getAssociations(), this.getProperty());
    }

    @NonNull
    default public String getPathAsString() {
        StringJoiner joiner = new StringJoiner(".");
        for (Association association : this.getAssociations()) {
            joiner.add(association.getName());
        }
        joiner.add(this.getProperty().getName());
        return joiner.toString();
    }

    @Override
    default public ExpressionType<T> getExpressionType() {
        return new ClassExpressionType(this.getJavaType());
    }

    @Override
    default public Predicate isNull() {
        return new UnaryPredicate(this, PredicateUnaryOp.IS_NULL);
    }

    @Override
    default public Predicate isNotNull() {
        return new UnaryPredicate(this, PredicateUnaryOp.IS_NON_NULL);
    }
}

