/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.query.builder.sql;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Creator;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.EntityRepresentation;
import io.micronaut.data.annotation.GeneratedValue;
import io.micronaut.data.annotation.Index;
import io.micronaut.data.annotation.Indexes;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.annotation.Repository;
import io.micronaut.data.annotation.sql.JoinColumns;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.exceptions.MappingException;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.Embedded;
import io.micronaut.data.model.JsonDataType;
import io.micronaut.data.model.PersistentAssociationPath;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentEntityUtils;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.PersistentPropertyPath;
import io.micronaut.data.model.jpa.criteria.impl.DefaultPersistentPropertyPath;
import io.micronaut.data.model.jpa.criteria.impl.PersistentPropertyOrder;
import io.micronaut.data.model.naming.NamingStrategy;
import io.micronaut.data.model.query.JoinPath;
import io.micronaut.data.model.query.builder.QueryBuilder2;
import io.micronaut.data.model.query.builder.QueryParameterBinding;
import io.micronaut.data.model.query.builder.QueryResult;
import io.micronaut.data.model.query.builder.sql.AbstractSqlLikeQueryBuilder2;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilderUtils;
import io.micronaut.data.model.query.builder.sql.SqlQueryConfiguration;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Selection;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

@Internal
public class SqlQueryBuilder2
extends AbstractSqlLikeQueryBuilder2 {
    public static final String DEFAULT_POSITIONAL_PARAMETER_MARKER = "?";
    public static final String STANDARD_FOR_UPDATE_CLAUSE = " FOR UPDATE";
    public static final String SQL_SERVER_FOR_UPDATE_CLAUSE = " WITH (UPDLOCK, ROWLOCK)";
    private static final String ANN_JOIN_TABLE = "io.micronaut.data.annotation.sql.JoinTable";
    private static final String ANN_JOIN_COLUMNS = "io.micronaut.data.annotation.sql.JoinColumns";
    private static final String VALUE_MEMBER = "value";
    private static final String BLANK_SPACE = " ";
    private static final String SEQ_SUFFIX = "_seq";
    private static final String INSERT_INTO = "INSERT INTO ";
    private static final String JDBC_REPO_ANNOTATION = "io.micronaut.data.jdbc.annotation.JdbcRepository";
    private final Dialect dialect;
    private final Map<Dialect, DialectConfig> perDialectConfig = new EnumMap<Dialect, DialectConfig>(Dialect.class);

    @Creator
    public SqlQueryBuilder2(AnnotationMetadata annotationMetadata) {
        if (annotationMetadata != null) {
            this.dialect = annotationMetadata.enumValue(JDBC_REPO_ANNOTATION, "dialect", Dialect.class).orElseGet(() -> annotationMetadata.enumValue(Repository.class, "dialect", Dialect.class).orElse(Dialect.ANSI));
            AnnotationValue annotation = annotationMetadata.getAnnotation(SqlQueryConfiguration.class);
            if (annotation != null) {
                List dialectConfigs = annotation.getAnnotations(VALUE_MEMBER, SqlQueryConfiguration.DialectConfiguration.class);
                for (AnnotationValue dialectConfig : dialectConfigs) {
                    dialectConfig.enumValue("dialect", Dialect.class).ifPresent(dialect -> {
                        DialectConfig dc = new DialectConfig();
                        this.perDialectConfig.put((Dialect)((Object)dialect), dc);
                        dialectConfig.stringValue("positionalParameterFormat").ifPresent(format -> {
                            dc.positionalFormatter = format;
                        });
                        dialectConfig.stringValue("positionalParameterName").ifPresent(format -> {
                            dc.positionalNameFormatter = format;
                        });
                        dialectConfig.booleanValue("escapeQueries").ifPresent(escape -> {
                            dc.escapeQueries = escape;
                        });
                    });
                }
            }
        } else {
            this.dialect = Dialect.ANSI;
        }
    }

    public SqlQueryBuilder2() {
        this.dialect = Dialect.ANSI;
    }

    public SqlQueryBuilder2(Dialect dialect) {
        ArgumentUtils.requireNonNull((String)"dialect", (Object)((Object)dialect));
        this.dialect = dialect;
    }

    @Override
    public Dialect getDialect() {
        return this.dialect;
    }

    @Override
    protected boolean shouldEscape(@NonNull PersistentEntity entity) {
        DialectConfig config = this.perDialectConfig.get((Object)this.dialect);
        if (config != null && config.escapeQueries != null) {
            return config.escapeQueries;
        }
        return super.shouldEscape(entity);
    }

    @Override
    protected String asLiteral(Object value) {
        if ((this.dialect == Dialect.SQL_SERVER || this.dialect == Dialect.ORACLE) && value instanceof Boolean) {
            Boolean vBoolean = (Boolean)value;
            return vBoolean != false ? "1" : "0";
        }
        return super.asLiteral(value);
    }

    @NonNull
    public String buildBatchCreateTableStatement(PersistentEntity ... entities) {
        return Arrays.stream(entities).flatMap(entity -> Stream.of(this.buildCreateTableStatements((PersistentEntity)entity))).collect(Collectors.joining(System.getProperty("line.separator")));
    }

    @NonNull
    public String buildBatchDropTableStatement(PersistentEntity ... entities) {
        return Arrays.stream(entities).flatMap(entity -> Stream.of(this.buildDropTableStatements((PersistentEntity)entity))).collect(Collectors.joining("\n"));
    }

    @NonNull
    public String[] buildDropTableStatements(@NonNull PersistentEntity entity) {
        String tableName = this.getTableName(entity);
        boolean escape = this.shouldEscape(entity);
        String sql = "DROP TABLE " + tableName;
        Collection<Association> foreignKeyAssociations = this.getJoinTableAssociations(entity);
        ArrayList<CallSite> dropStatements = new ArrayList<CallSite>();
        for (Association association : foreignKeyAssociations) {
            AnnotationMetadata associationMetadata = association.getAnnotationMetadata();
            NamingStrategy namingStrategy = this.getNamingStrategy(entity);
            String joinTableName = associationMetadata.stringValue(ANN_JOIN_TABLE, "name").orElseGet(() -> this.getMappedName(namingStrategy, association));
            dropStatements.add((CallSite)((Object)("DROP TABLE " + (escape ? this.quote(joinTableName) : joinTableName) + ";")));
        }
        dropStatements.add((CallSite)((Object)sql));
        return dropStatements.toArray(new String[0]);
    }

    @NonNull
    public String buildJoinTableInsert(@NonNull PersistentEntity entity, @NonNull Association association) {
        if (!SqlQueryBuilder2.isForeignKeyWithJoinTable(association)) {
            throw new IllegalArgumentException("Join table inserts can only be built for foreign key associations that are mapped with a join table.");
        }
        Optional<Association> inverseSide = association.getInverseSide().map(Function.identity());
        Association owningAssociation = inverseSide.orElse(association);
        AnnotationMetadata annotationMetadata = owningAssociation.getAnnotationMetadata();
        NamingStrategy namingStrategy = this.getNamingStrategy(entity);
        Object joinTableName = annotationMetadata.stringValue(ANN_JOIN_TABLE, "name").orElseGet(() -> this.getMappedName(namingStrategy, association));
        joinTableName = this.quote((String)joinTableName);
        String joinTableSchema = annotationMetadata.stringValue(ANN_JOIN_TABLE, "schema").orElse(this.getSchemaName(entity));
        if (StringUtils.isNotEmpty((CharSequence)joinTableSchema)) {
            joinTableSchema = this.quote(joinTableSchema);
            joinTableName = joinTableSchema + "." + (String)joinTableName;
        }
        List<String> leftJoinColumns = this.resolveJoinTableJoinColumns(annotationMetadata, true, entity, namingStrategy);
        List<String> rightJoinColumns = this.resolveJoinTableJoinColumns(annotationMetadata, false, association.getAssociatedEntity(), namingStrategy);
        boolean escape = this.shouldEscape(entity);
        String columns = Stream.concat(leftJoinColumns.stream(), rightJoinColumns.stream()).map(columnName -> escape ? this.quote((String)columnName) : columnName).collect(Collectors.joining(","));
        String placeholders = IntStream.range(0, leftJoinColumns.size() + rightJoinColumns.size()).mapToObj(i -> this.formatParameter(i + 1).toString()).collect(Collectors.joining(","));
        return INSERT_INTO + (String)joinTableName + " (" + columns + ") VALUES (" + placeholders + ")";
    }

    public static boolean isForeignKeyWithJoinTable(@NonNull Association association) {
        if (!association.isForeignKey()) {
            return false;
        }
        if (association.getAnnotationMetadata().stringValue(Relation.class, "mappedBy").isPresent()) {
            return false;
        }
        AnnotationValue joinColumnsAnnotationValue = association.getAnnotationMetadata().getAnnotation(JoinColumns.class);
        return joinColumnsAnnotationValue == null || CollectionUtils.isEmpty((Collection)joinColumnsAnnotationValue.getAnnotations(VALUE_MEMBER));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public String[] buildCreateTableStatements(@NonNull PersistentEntity entity) {
        Object leftProperties;
        ArgumentUtils.requireNonNull((String)"entity", (Object)entity);
        String unescapedTableName = this.getUnescapedTableName(entity);
        String tableName = this.getTableName(entity);
        boolean escape = this.shouldEscape(entity);
        ArrayList<String> createStatements = new ArrayList<String>();
        String schema = this.getSchemaName(entity);
        if (StringUtils.isNotEmpty((CharSequence)schema)) {
            if (escape) {
                schema = this.quote(schema);
            }
            createStatements.add("CREATE SCHEMA " + schema + ";");
        }
        Collection<Association> foreignKeyAssociations = this.getJoinTableAssociations(entity);
        NamingStrategy namingStrategy = this.getNamingStrategy(entity);
        if (CollectionUtils.isNotEmpty(foreignKeyAssociations)) {
            for (Association association : foreignKeyAssociations) {
                String columnName;
                PersistentPropertyPath pp2;
                void var16_17;
                String joinTableSchema;
                StringBuilder joinTableBuilder = new StringBuilder("CREATE TABLE ");
                PersistentEntity associatedEntity = association.getAssociatedEntity();
                Optional inverseSide = association.getInverseSide().map(Function.identity());
                Association owningAssociation = inverseSide.orElse(association);
                AnnotationMetadata annotationMetadata = owningAssociation.getAnnotationMetadata();
                String string = annotationMetadata.stringValue(ANN_JOIN_TABLE, "name").orElseGet(() -> this.getMappedName(namingStrategy, association));
                if (escape) {
                    String string2 = this.quote(string);
                }
                if (StringUtils.isNotEmpty((CharSequence)(joinTableSchema = (String)annotationMetadata.stringValue(ANN_JOIN_TABLE, "schema").orElse(null)))) {
                    if (escape) {
                        joinTableSchema = this.quote(joinTableSchema);
                    }
                } else {
                    joinTableSchema = schema;
                }
                if (StringUtils.isNotEmpty((CharSequence)joinTableSchema)) {
                    joinTableBuilder.append(joinTableSchema).append('.');
                }
                joinTableBuilder.append((String)var16_17).append(" (");
                leftProperties = new ArrayList();
                ArrayList rightProperties = new ArrayList();
                boolean isAssociationOwner = inverseSide.isEmpty();
                List<String> leftJoinTableColumns = this.resolveJoinTableJoinColumns(annotationMetadata, isAssociationOwner, entity, namingStrategy);
                List<String> rightJoinTableColumns = this.resolveJoinTableJoinColumns(annotationMetadata, !isAssociationOwner, association.getAssociatedEntity(), namingStrategy);
                PersistentProperty property2 = entity.getIdentity();
                PersistentEntityUtils.traversePersistentProperties(Collections.emptyList(), property2, (arg_0, arg_1) -> SqlQueryBuilder2.lambda$buildCreateTableStatements$12((List)leftProperties, arg_0, arg_1));
                PersistentProperty property1 = associatedEntity.getIdentity();
                PersistentEntityUtils.traversePersistentProperties(Collections.emptyList(), property1, (associations, property) -> rightProperties.add(PersistentPropertyPath.of(associations, property, "")));
                if (leftJoinTableColumns.size() == leftProperties.size()) {
                    for (int i2 = 0; i2 < leftJoinTableColumns.size(); ++i2) {
                        pp2 = (PersistentPropertyPath)leftProperties.get(i2);
                        columnName = leftJoinTableColumns.get(i2);
                        if (escape) {
                            columnName = this.quote(columnName);
                        }
                        joinTableBuilder.append(SqlQueryBuilderUtils.addTypeToColumn(pp2.getProperty(), columnName, this.dialect, true)).append(',');
                    }
                } else {
                    Iterator i2 = leftProperties.iterator();
                    while (i2.hasNext()) {
                        PersistentPropertyPath pp2 = (PersistentPropertyPath)i2.next();
                        columnName = namingStrategy.mappedJoinTableColumn(entity, pp2.getAssociations(), pp2.getProperty());
                        if (escape) {
                            columnName = this.quote(columnName);
                        }
                        joinTableBuilder.append(SqlQueryBuilderUtils.addTypeToColumn(pp2.getProperty(), columnName, this.dialect, true)).append(',');
                    }
                }
                if (rightJoinTableColumns.size() == rightProperties.size()) {
                    for (int i = 0; i < rightJoinTableColumns.size(); ++i) {
                        pp2 = (PersistentPropertyPath)rightProperties.get(i);
                        columnName = rightJoinTableColumns.get(i);
                        if (escape) {
                            columnName = this.quote(columnName);
                        }
                        joinTableBuilder.append(SqlQueryBuilderUtils.addTypeToColumn(pp2.getProperty(), columnName, this.dialect, true)).append(',');
                    }
                } else {
                    for (PersistentPropertyPath pp2 : rightProperties) {
                        columnName = namingStrategy.mappedJoinTableColumn(entity, pp2.getAssociations(), pp2.getProperty());
                        if (escape) {
                            columnName = this.quote(columnName);
                        }
                        joinTableBuilder.append(SqlQueryBuilderUtils.addTypeToColumn(pp2.getProperty(), columnName, this.dialect, true)).append(',');
                    }
                }
                joinTableBuilder.setLength(joinTableBuilder.length() - 1);
                joinTableBuilder.append(")");
                if (this.dialect != Dialect.ORACLE) {
                    joinTableBuilder.append(';');
                }
                createStatements.add(joinTableBuilder.toString());
            }
        }
        boolean generatePkAfterColumns = false;
        ArrayList<String> primaryColumnsName = new ArrayList<String>();
        ArrayList<String> columns = new ArrayList<String>();
        List<PersistentProperty> identities = entity.getIdentityProperties();
        for (PersistentProperty identity : identities) {
            ArrayList ids = new ArrayList();
            PersistentEntityUtils.traversePersistentProperties(Collections.emptyList(), identity, (associations, property) -> ids.add(PersistentPropertyPath.of(associations, property, "")));
            int n = ids.size();
            if (n > 1) {
                generatePkAfterColumns = true;
            } else if (!(n <= 0 || identity.isGenerated() || this.dialect == Dialect.MYSQL && ((PersistentPropertyPath)ids.get(0)).getProperty().getDataType() == DataType.BYTE_ARRAY)) {
                generatePkAfterColumns = true;
            }
            boolean finalGeneratePkAfterColumns = generatePkAfterColumns;
            leftProperties = ids.iterator();
            while (leftProperties.hasNext()) {
                PersistentPropertyPath pp = (PersistentPropertyPath)leftProperties.next();
                String column = this.getMappedName(namingStrategy, pp.getAssociations(), pp.getProperty());
                if (escape) {
                    column = this.quote(column);
                }
                primaryColumnsName.add(column);
                column = SqlQueryBuilderUtils.addTypeToColumn(pp.getProperty(), column, this.dialect, this.isRequired(pp.getAssociations(), pp.getProperty()));
                if (this.isNotForeign(pp.getAssociations())) {
                    column = this.addGeneratedStatementToColumn(pp.getProperty(), column, !finalGeneratePkAfterColumns);
                }
                columns.add(column);
            }
        }
        PersistentProperty version = entity.getVersion();
        if (version != null && !version.isGenerated()) {
            String column = this.getMappedName(namingStrategy, Collections.emptyList(), version);
            if (escape) {
                column = this.quote(column);
            }
            column = SqlQueryBuilderUtils.addTypeToColumn(version, column, this.dialect, true);
            columns.add(column);
        }
        BiConsumer<List<Association>, PersistentProperty> addColumn = (associations, property) -> {
            String column = this.getMappedName(namingStrategy, (List<Association>)associations, (PersistentProperty)property);
            if (escape) {
                column = this.quote(column);
            }
            column = SqlQueryBuilderUtils.addTypeToColumn(property, column, this.dialect, this.isRequired((List<Association>)associations, (PersistentProperty)property));
            if (this.isNotForeign((List<Association>)associations)) {
                column = this.addGeneratedStatementToColumn((PersistentProperty)property, column, false);
            }
            columns.add(column);
        };
        for (PersistentProperty persistentProperty : entity.getPersistentProperties()) {
            PersistentEntityUtils.traversePersistentProperties(Collections.emptyList(), persistentProperty, addColumn);
        }
        StringBuilder builder = new StringBuilder("CREATE TABLE ").append(tableName).append(" (");
        builder.append(String.join((CharSequence)",", columns));
        if (generatePkAfterColumns) {
            builder.append(", PRIMARY KEY(").append(String.join((CharSequence)",", primaryColumnsName)).append(')');
        }
        if (this.dialect == Dialect.ORACLE) {
            builder.append(")");
        } else {
            builder.append(");");
        }
        for (PersistentProperty identity : identities) {
            if (!identity.isGenerated()) continue;
            GeneratedValue.Type idGeneratorType = identity.getAnnotationMetadata().enumValue(GeneratedValue.class, GeneratedValue.Type.class).orElseGet(() -> this.selectAutoStrategy(identity));
            boolean isSequence = idGeneratorType == GeneratedValue.Type.SEQUENCE;
            String generatedDefinition = identity.getAnnotationMetadata().stringValue(GeneratedValue.class, "definition").orElse(null);
            if (generatedDefinition != null) {
                createStatements.add(generatedDefinition);
                continue;
            }
            if (!isSequence) continue;
            boolean isSqlServer = this.dialect == Dialect.SQL_SERVER;
            String sequenceName = this.quote(unescapedTableName + SEQ_SUFFIX);
            String createSequenceStmt = "CREATE SEQUENCE " + sequenceName;
            if (isSqlServer) {
                createSequenceStmt = createSequenceStmt + " AS BIGINT";
            }
            createSequenceStmt = createSequenceStmt + " MINVALUE 1 START WITH 1";
            if (this.dialect == Dialect.ORACLE) {
                createSequenceStmt = createSequenceStmt + " CACHE 100 NOCYCLE";
            } else if (isSqlServer) {
                createSequenceStmt = createSequenceStmt + " INCREMENT BY 1";
            }
            createStatements.add(createSequenceStmt);
        }
        createStatements.add(builder.toString());
        this.addIndexes(entity, tableName, createStatements);
        return createStatements.toArray(new String[0]);
    }

    private void addIndexes(PersistentEntity entity, String tableName, List<String> createStatements) {
        List<String> indexes = this.createIndexes(entity, tableName);
        if (CollectionUtils.isNotEmpty(indexes)) {
            createStatements.addAll(indexes);
        }
    }

    private List<String> createIndexes(PersistentEntity entity, String tableName) {
        ArrayList<String> indexStatements = new ArrayList<String>();
        Optional<List> indexes = entity.findAnnotation(Indexes.class).map(idxes -> idxes.getAnnotations(VALUE_MEMBER, Index.class));
        Stream.of(indexes).flatMap(Optional::stream).flatMap(Collection::stream).forEach(index -> indexStatements.add(this.addIndex(entity, new IndexConfiguration((AnnotationValue<?>)index, tableName, entity.getPersistedName()))));
        return indexStatements;
    }

    private String addIndex(PersistentEntity entity, IndexConfiguration config) {
        String indexName = config.index.stringValue("name").orElse(String.format("idx_%s%s", this.prepareNames(config.unquotedTableName), this.makeTransformedColumnList(this.provideColumnList(config))));
        if (this.shouldEscape(entity)) {
            indexName = this.quote(indexName);
        }
        StringBuilder indexBuilder = new StringBuilder();
        indexBuilder.append("CREATE ").append(config.index.booleanValue("unique").map(isUnique -> isUnique != false ? "UNIQUE " : "").orElse("")).append("INDEX ");
        indexBuilder.append(indexName).append(" ON ").append(Optional.ofNullable(config.tableName).orElseThrow(() -> new NullPointerException("Table name cannot be null"))).append(" (").append(this.provideColumnList(config));
        if (this.dialect == Dialect.ORACLE) {
            indexBuilder.append(")");
        } else {
            indexBuilder.append(");");
        }
        return indexBuilder.toString();
    }

    private String provideColumnList(IndexConfiguration config) {
        return String.join((CharSequence)", ", (String[])config.index.getValues().get("columns"));
    }

    private String makeTransformedColumnList(String columnList) {
        return Arrays.stream(this.prepareNames(columnList).split(",")).map(col -> "_" + col).collect(Collectors.joining());
    }

    private String prepareNames(String columnList) {
        return columnList.chars().mapToObj(c -> String.valueOf((char)c)).filter(x -> !x.equals(BLANK_SPACE)).filter(x -> !x.equals("\"")).map(String::toLowerCase).collect(Collectors.joining());
    }

    private boolean isRequired(List<Association> associations, PersistentProperty property) {
        PersistentProperty foreignAssociation = null;
        for (Association association : associations) {
            if (!association.isRequired()) {
                return false;
            }
            if (association.getKind() == Relation.Kind.EMBEDDED || foreignAssociation != null) continue;
            foreignAssociation = association;
        }
        if (foreignAssociation != null) {
            return foreignAssociation.isRequired();
        }
        return property.isRequired();
    }

    private boolean isNotForeign(List<Association> associations) {
        for (Association association : associations) {
            if (association.getKind() == Relation.Kind.EMBEDDED) continue;
            return false;
        }
        return true;
    }

    @Override
    protected String getTableAsKeyword() {
        return BLANK_SPACE;
    }

    private String addGeneratedStatementToColumn(PersistentProperty prop, String column, boolean isPk) {
        if (prop.isGenerated()) {
            boolean addPkBefore;
            GeneratedValue.Type type = prop.getAnnotationMetadata().enumValue(GeneratedValue.class, GeneratedValue.Type.class).orElse(GeneratedValue.Type.AUTO);
            if (type == GeneratedValue.Type.AUTO) {
                type = prop.getDataType() == DataType.UUID ? GeneratedValue.Type.UUID : (this.dialect == Dialect.ORACLE ? GeneratedValue.Type.SEQUENCE : GeneratedValue.Type.IDENTITY);
            }
            boolean bl = addPkBefore = this.dialect != Dialect.H2 && this.dialect != Dialect.ORACLE;
            if (isPk && addPkBefore) {
                column = (String)column + " PRIMARY KEY";
            }
            switch (this.dialect) {
                case POSTGRES: {
                    if (type == GeneratedValue.Type.SEQUENCE) {
                        column = (String)column + " NOT NULL";
                        break;
                    }
                    if (type == GeneratedValue.Type.IDENTITY) {
                        if (isPk) {
                            column = (String)column + " GENERATED ALWAYS AS IDENTITY";
                            break;
                        }
                        column = (String)column + " NOT NULL";
                        break;
                    }
                    if (type != GeneratedValue.Type.UUID) break;
                    column = (String)column + " NOT NULL DEFAULT uuid_generate_v4()";
                    break;
                }
                case SQL_SERVER: {
                    if (type == GeneratedValue.Type.UUID) {
                        column = (String)column + " NOT NULL DEFAULT newid()";
                        break;
                    }
                    if (type == GeneratedValue.Type.SEQUENCE) {
                        if (!isPk) break;
                        column = (String)column + " NOT NULL";
                        break;
                    }
                    column = (String)column + " IDENTITY(1,1) NOT NULL";
                    break;
                }
                case ORACLE: {
                    if (type == GeneratedValue.Type.UUID) {
                        column = (String)column + " NOT NULL DEFAULT SYS_GUID()";
                        break;
                    }
                    if (type == GeneratedValue.Type.IDENTITY) {
                        if (isPk) {
                            column = (String)column + " GENERATED ALWAYS AS IDENTITY (MINVALUE 1 START WITH 1 CACHE 100 NOCYCLE)";
                            break;
                        }
                        column = (String)column + " NOT NULL";
                        break;
                    }
                    column = (String)column + " NOT NULL";
                    break;
                }
                default: {
                    if (type == GeneratedValue.Type.UUID) {
                        if (this.dialect != Dialect.MYSQL) {
                            column = (String)column + " NOT NULL DEFAULT random_uuid()";
                            break;
                        }
                        column = (String)column + " NOT NULL";
                        break;
                    }
                    column = (String)column + " AUTO_INCREMENT";
                }
            }
            if (isPk && !addPkBefore) {
                column = (String)column + " PRIMARY KEY";
            }
        }
        return column;
    }

    @NonNull
    private List<String> resolveJoinTableJoinColumns(AnnotationMetadata annotationMetadata, boolean associationOwner, PersistentEntity entity, NamingStrategy namingStrategy) {
        List<String> joinColumns = this.getJoinedColumns(annotationMetadata, associationOwner, "name");
        if (!joinColumns.isEmpty()) {
            return joinColumns;
        }
        ArrayList<String> columns = new ArrayList<String>();
        PersistentProperty property1 = entity.getIdentity();
        PersistentEntityUtils.traversePersistentProperties(Collections.emptyList(), property1, (associations, property) -> columns.add(namingStrategy.mappedJoinTableColumn(entity, (List<Association>)associations, (PersistentProperty)property)));
        return columns;
    }

    @NonNull
    private List<String> resolveJoinTableAssociatedColumns(AnnotationMetadata annotationMetadata, boolean associationOwner, PersistentEntity entity, NamingStrategy namingStrategy) {
        List<String> joinColumns = this.getJoinedColumns(annotationMetadata, associationOwner, "referencedColumnName");
        if (!joinColumns.isEmpty()) {
            return joinColumns;
        }
        PersistentProperty identity = entity.getIdentity();
        if (identity == null) {
            throw new MappingException("Cannot have a foreign key association without an ID on entity: " + entity.getName());
        }
        ArrayList<String> columns = new ArrayList<String>();
        PersistentEntityUtils.traversePersistentProperties(identity, (associations, property) -> {
            String columnName = this.getMappedName(namingStrategy, (List<Association>)associations, (PersistentProperty)property);
            columns.add(columnName);
        });
        return columns;
    }

    @NonNull
    private List<String> getJoinedColumns(AnnotationMetadata annotationMetadata, boolean associationOwner, String columnType) {
        AnnotationValue joinTable = annotationMetadata.getAnnotation(ANN_JOIN_TABLE);
        if (joinTable != null) {
            return joinTable.getAnnotations(associationOwner ? "joinColumns" : "inverseJoinColumns").stream().flatMap(ann -> ann.stringValue(columnType).stream()).toList();
        }
        return Collections.emptyList();
    }

    @NonNull
    private Collection<Association> getJoinTableAssociations(PersistentEntity persistentEntity) {
        return Stream.concat(Stream.of(persistentEntity.getIdentity()), persistentEntity.getPersistentProperties().stream()).flatMap(SqlQueryBuilder2::flatMapEmbedded).filter(p -> {
            if (p instanceof Association) {
                Association a = (Association)p;
                return SqlQueryBuilder2.isForeignKeyWithJoinTable(a);
            }
            return false;
        }).map(p -> (Association)p).toList();
    }

    @Override
    protected SqlSelectionVisitor createSelectionVisitor(AnnotationMetadata annotationMetadata, AbstractSqlLikeQueryBuilder2.QueryState queryState, boolean distinct) {
        return new SqlSelectionVisitor(queryState, annotationMetadata, distinct);
    }

    private static Stream<? extends PersistentProperty> flatMapEmbedded(PersistentProperty pp) {
        if (pp instanceof Embedded) {
            Embedded embedded = (Embedded)pp;
            PersistentEntity embeddedEntity = embedded.getAssociatedEntity();
            return embeddedEntity.getPersistentProperties().stream().flatMap(SqlQueryBuilder2::flatMapEmbedded);
        }
        return Stream.of(pp);
    }

    @Override
    public String resolveJoinType(Join.Type jt) {
        if (!this.dialect.supportsJoinType(jt)) {
            throw new IllegalArgumentException("Unsupported join type [" + jt + "] by dialect [" + this.dialect + "]");
        }
        return switch (jt) {
            case Join.Type.LEFT, Join.Type.LEFT_FETCH -> " LEFT JOIN ";
            case Join.Type.RIGHT, Join.Type.RIGHT_FETCH -> " RIGHT JOIN ";
            case Join.Type.OUTER, Join.Type.OUTER_FETCH -> " FULL OUTER JOIN ";
            default -> " INNER JOIN ";
        };
    }

    @Override
    @NonNull
    public QueryResult buildInsert(AnnotationMetadata repositoryMetadata, QueryBuilder2.InsertQueryDefinition definition) {
        String builder;
        Selection<?> returningSelection = definition.returningSelection();
        if (returningSelection != null && !this.getDialect().supportsInsertReturning()) {
            throw new IllegalStateException("Dialect: " + this.getDialect() + " doesn't support INSERT ... RETURNING clause");
        }
        PersistentEntity entity = definition.persistentEntity();
        boolean escape = this.shouldEscape(entity);
        String unescapedTableName = this.getUnescapedTableName(entity);
        ArrayList<QueryParameterBinding> parameterBindings = new ArrayList<QueryParameterBinding>();
        if (this.isJsonEntity(repositoryMetadata, entity)) {
            AnnotationValue entityRepresentationAnnotationValue = entity.getAnnotationMetadata().getAnnotation(EntityRepresentation.class);
            String columnName = (String)entityRepresentationAnnotationValue.getRequiredValue("column", String.class);
            final int key = 1;
            builder = INSERT_INTO + this.getTableName(entity) + " VALUES (" + this.formatParameter(key) + ")";
            for (PersistentProperty identity : entity.getIdentityProperties()) {
                if (identity.isGenerated()) {
                    String identityName = identity.getPersistedName();
                    builder = "BEGIN " + builder + " RETURNING JSON_VALUE(" + columnName + ",'$." + identityName + "') INTO " + this.formatParameter(key + 1) + "; END;";
                }
                parameterBindings.add(new QueryParameterBinding(){

                    @Override
                    public String getName() {
                        return String.valueOf(key);
                    }

                    @Override
                    public String getKey() {
                        return String.valueOf(key);
                    }

                    @Override
                    public DataType getDataType() {
                        return DataType.JSON;
                    }

                    @Override
                    public JsonDataType getJsonDataType() {
                        return JsonDataType.DEFAULT;
                    }
                });
            }
        } else {
            NamingStrategy namingStrategy = this.getNamingStrategy(entity);
            Collection<? extends PersistentProperty> persistentProperties = entity.getPersistentProperties();
            ArrayList<String> columns = new ArrayList<String>();
            ArrayList<String> resultColumns = new ArrayList<String>();
            ArrayList<String> values = new ArrayList<String>();
            for (PersistentProperty persistentProperty : persistentProperties) {
                PersistentEntityUtils.traversePersistentProperties(Collections.emptyList(), persistentProperty, (associations, property) -> {
                    if (prop.isGenerated()) {
                        String columnName = this.getMappedName(namingStrategy, (List<Association>)associations, (PersistentProperty)property);
                        if (escape) {
                            columnName = this.quote(columnName);
                        }
                        resultColumns.add(columnName);
                        return;
                    }
                    this.addWriteExpression(values, prop);
                    final String key = String.valueOf(values.size());
                    String[] path = this.asStringPath((List<Association>)associations, (PersistentProperty)property);
                    parameterBindings.add(new QueryParameterBinding(){
                        final /* synthetic */ PersistentProperty val$property;
                        final /* synthetic */ String[] val$path;
                        {
                            this.val$property = persistentProperty;
                            this.val$path = stringArray;
                        }

                        @Override
                        public String getName() {
                            return key;
                        }

                        @Override
                        public String getKey() {
                            return key;
                        }

                        @Override
                        public DataType getDataType() {
                            return this.val$property.getDataType();
                        }

                        @Override
                        public JsonDataType getJsonDataType() {
                            return this.val$property.getJsonDataType();
                        }

                        @Override
                        public String[] getPropertyPath() {
                            return this.val$path;
                        }
                    });
                    String columnName = this.getMappedName(namingStrategy, (List<Association>)associations, (PersistentProperty)property);
                    if (escape) {
                        columnName = this.quote(columnName);
                    }
                    columns.add(columnName);
                    resultColumns.add(columnName);
                });
            }
            final PersistentProperty version = entity.getVersion();
            if (version != null && !version.isGenerated()) {
                this.addWriteExpression(values, version);
                final String string = String.valueOf(values.size());
                parameterBindings.add(new QueryParameterBinding(){

                    @Override
                    public String getName() {
                        return string;
                    }

                    @Override
                    public String getKey() {
                        return string;
                    }

                    @Override
                    public DataType getDataType() {
                        return version.getDataType();
                    }

                    @Override
                    public JsonDataType getJsonDataType() {
                        return null;
                    }

                    @Override
                    public String[] getPropertyPath() {
                        return new String[]{version.getName()};
                    }
                });
                String columnName = this.getMappedName(namingStrategy, Collections.emptyList(), version);
                if (escape) {
                    columnName = this.quote(columnName);
                }
                columns.add(columnName);
                resultColumns.add(columnName);
            }
            for (PersistentProperty identity : entity.getIdentityProperties()) {
                PersistentEntityUtils.traversePersistentProperties(Collections.emptyList(), identity, (associations, property) -> {
                    String columnName = this.getMappedName(namingStrategy, (List<Association>)associations, (PersistentProperty)property);
                    if (escape) {
                        columnName = this.quote(columnName);
                    }
                    boolean isSequence = false;
                    if (this.isNotForeign((List<Association>)associations)) {
                        resultColumns.add(columnName);
                        Optional generated = property.findAnnotation(GeneratedValue.class);
                        if (generated.isPresent()) {
                            GeneratedValue.Type idGeneratorType = generated.flatMap(av -> av.enumValue(GeneratedValue.Type.class)).orElseGet(() -> this.selectAutoStrategy((PersistentProperty)property));
                            if (idGeneratorType == GeneratedValue.Type.SEQUENCE) {
                                isSequence = true;
                            } else if (this.dialect != Dialect.MYSQL || property.getDataType() != DataType.UUID) {
                                return;
                            }
                        }
                    }
                    if (isSequence) {
                        values.add(this.getSequenceStatement(unescapedTableName, (PersistentProperty)property));
                    } else {
                        this.addWriteExpression((List<String>)values, (PersistentProperty)property);
                        final String key = String.valueOf(values.size());
                        String[] path = this.asStringPath((List<Association>)associations, (PersistentProperty)property);
                        parameterBindings.add(new QueryParameterBinding(){
                            final /* synthetic */ PersistentProperty val$property;
                            final /* synthetic */ String[] val$path;
                            {
                                this.val$property = persistentProperty;
                                this.val$path = stringArray;
                            }

                            @Override
                            public String getName() {
                                return key;
                            }

                            @Override
                            public String getKey() {
                                return key;
                            }

                            @Override
                            public DataType getDataType() {
                                return this.val$property.getDataType();
                            }

                            @Override
                            public JsonDataType getJsonDataType() {
                                return this.val$property.getJsonDataType();
                            }

                            @Override
                            public String[] getPropertyPath() {
                                return this.val$path;
                            }
                        });
                    }
                    columns.add(columnName);
                });
            }
            builder = INSERT_INTO + this.getTableName(entity) + " (" + String.join((CharSequence)",", columns) + ") VALUES (" + String.join((CharSequence)String.valueOf(','), values) + ")";
            if (definition.returningSelection() != null) {
                builder = builder + " RETURNING " + String.join((CharSequence)",", resultColumns);
            }
        }
        return QueryResult.of(builder, Collections.emptyList(), parameterBindings, Collections.emptyMap());
    }

    private String[] asStringPath(List<Association> associations, PersistentProperty property) {
        if (associations.isEmpty()) {
            return new String[]{property.getName()};
        }
        ArrayList<String> path = new ArrayList<String>(associations.size() + 1);
        for (Association association : associations) {
            path.add(association.getName());
        }
        path.add(property.getName());
        return path.toArray(new String[0]);
    }

    private String getSequenceStatement(String unescapedTableName, PersistentProperty property) {
        String sequenceName = this.resolveSequenceName(property, unescapedTableName);
        return switch (this.dialect) {
            case Dialect.ORACLE -> this.quote(sequenceName) + ".nextval";
            case Dialect.POSTGRES -> "nextval('" + sequenceName + "')";
            case Dialect.SQL_SERVER -> "NEXT VALUE FOR " + this.quote(sequenceName);
            default -> throw new IllegalStateException("Cannot generate a sequence for dialect: " + this.dialect);
        };
    }

    private String resolveSequenceName(PersistentProperty identity, String unescapedTableName) {
        return identity.getAnnotationMetadata().stringValue(GeneratedValue.class, "ref").map(n -> {
            if (StringUtils.isEmpty((CharSequence)n)) {
                return unescapedTableName + SEQ_SUFFIX;
            }
            return n;
        }).orElseGet(() -> unescapedTableName + SEQ_SUFFIX);
    }

    @Override
    protected String getAliasName(PersistentEntity entity) {
        return entity.getAliasName();
    }

    private String getSchemaName(PersistentEntity entity) {
        return entity.getAnnotationMetadata().stringValue(MappedEntity.class, "schema").orElseGet(() -> entity.getAnnotationMetadata().stringValue(MappedEntity.class, "schema").orElse(null));
    }

    @Override
    public String getTableName(PersistentEntity entity) {
        boolean escape = this.shouldEscape(entity);
        String tableName = entity.getPersistedName();
        String schema = this.getSchemaName(entity);
        if (StringUtils.isNotEmpty((CharSequence)schema)) {
            if (escape) {
                return this.quote(schema) + "." + this.quote(tableName);
            }
            return schema + "." + tableName;
        }
        return escape ? this.quote(tableName) : tableName;
    }

    private boolean addWriteExpression(List<String> values, PersistentProperty property) {
        DataType dt = property.getDataType();
        String transformer = this.getDataTransformerWriteValue(null, property).orElse(null);
        if (transformer != null) {
            return values.add(transformer);
        }
        if (dt == DataType.JSON) {
            switch (this.dialect) {
                case POSTGRES: {
                    values.add("to_json(" + this.formatParameter(values.size() + 1).name() + "::json)");
                    break;
                }
                case H2: {
                    values.add(this.formatParameter(values.size() + 1).name() + " FORMAT JSON");
                    break;
                }
                case MYSQL: {
                    values.add("CONVERT(" + this.formatParameter(values.size() + 1).name() + " USING UTF8MB4)");
                    break;
                }
                default: {
                    values.add(this.formatParameter(values.size() + 1).name());
                }
            }
            return true;
        }
        return values.add(this.formatParameter(values.size() + 1).name());
    }

    @Override
    protected void appendUpdateSetParameter(StringBuilder sb, String alias, PersistentProperty prop, Runnable appendParameter) {
        String transformed = this.getDataTransformerWriteValue(alias, prop).orElse(null);
        if (transformed != null) {
            this.appendTransformed(sb, transformed, appendParameter);
            return;
        }
        if (prop.getDataType() == DataType.JSON) {
            switch (this.dialect) {
                case H2: {
                    appendParameter.run();
                    sb.append(" FORMAT JSON");
                    break;
                }
                case MYSQL: {
                    sb.append("CONVERT(");
                    appendParameter.run();
                    sb.append(" USING UTF8MB4)");
                    break;
                }
                case POSTGRES: {
                    sb.append("to_json(");
                    appendParameter.run();
                    sb.append("::json)");
                    break;
                }
                default: {
                    super.appendUpdateSetParameter(sb, alias, prop, appendParameter);
                    break;
                }
            }
        } else {
            super.appendUpdateSetParameter(sb, alias, prop, appendParameter);
        }
    }

    @Override
    protected void buildJoin(String joinType, StringBuilder query, AbstractSqlLikeQueryBuilder2.QueryState queryState, PersistentAssociationPath joinAssociation, PersistentEntity associationOwner, String currentJoinAlias, String lastJoinAlias) {
        List joinColumnValues;
        Association association = joinAssociation.getAssociation();
        List<Association> joinAssociationsPath = joinAssociation.getAssociations();
        PersistentEntity associatedEntity = association.getAssociatedEntity();
        boolean escape = this.shouldEscape(associationOwner);
        String mappedBy = association.getAnnotationMetadata().stringValue(Relation.class, "mappedBy").orElse(null);
        AnnotationValue joinColumnsAnnotationValue = association.getAnnotationMetadata().getAnnotation(JoinColumns.class);
        List list = joinColumnValues = joinColumnsAnnotationValue == null ? null : joinColumnsAnnotationValue.getAnnotations(VALUE_MEMBER);
        if (association.getKind() == Relation.Kind.MANY_TO_MANY || association.isForeignKey() && StringUtils.isEmpty((CharSequence)mappedBy) && CollectionUtils.isEmpty((Collection)joinColumnValues)) {
            Object finalTableName;
            String joinTableSchema;
            PersistentProperty identity = associatedEntity.getIdentity();
            if (identity == null) {
                throw new IllegalArgumentException("Associated entity [" + associatedEntity.getName() + "] defines no ID. Cannot join.");
            }
            PersistentProperty associatedId = associationOwner.getIdentity();
            if (associatedId == null) {
                throw new MappingException("Cannot join on entity [" + associationOwner.getName() + "] that has no declared ID");
            }
            Optional<Association> inverseSide = association.getInverseSide().map(Function.identity());
            Association owningAssociation = inverseSide.orElse(association);
            boolean isAssociationOwner = association.getInverseSide().isEmpty();
            NamingStrategy namingStrategy = associationOwner.getNamingStrategy();
            AnnotationMetadata annotationMetadata = owningAssociation.getAnnotationMetadata();
            List<String> ownerJoinColumns = this.resolveJoinTableAssociatedColumns(annotationMetadata, isAssociationOwner, associationOwner, namingStrategy);
            List<String> ownerJoinTableColumns = this.resolveJoinTableJoinColumns(annotationMetadata, isAssociationOwner, associationOwner, namingStrategy);
            List<String> associationJoinColumns = this.resolveJoinTableAssociatedColumns(annotationMetadata, !isAssociationOwner, associatedEntity, namingStrategy);
            List<String> associationJoinTableColumns = this.resolveJoinTableJoinColumns(annotationMetadata, !isAssociationOwner, associatedEntity, namingStrategy);
            if (escape) {
                ownerJoinColumns = ownerJoinColumns.stream().map(this::quote).toList();
                ownerJoinTableColumns = ownerJoinTableColumns.stream().map(this::quote).toList();
                associationJoinColumns = associationJoinColumns.stream().map(this::quote).toList();
                associationJoinTableColumns = associationJoinTableColumns.stream().map(this::quote).toList();
            }
            if (StringUtils.isNotEmpty((CharSequence)(joinTableSchema = annotationMetadata.stringValue(ANN_JOIN_TABLE, "schema").orElse(this.getSchemaName(associationOwner)))) && escape) {
                joinTableSchema = this.quote(joinTableSchema);
            }
            String joinTableName = annotationMetadata.stringValue(ANN_JOIN_TABLE, "name").orElseGet(() -> this.getMappedName(namingStrategy, association));
            String joinTableAlias = annotationMetadata.stringValue(ANN_JOIN_TABLE, "alias").orElseGet(() -> currentJoinAlias + joinTableName + "_");
            Object object = finalTableName = escape ? this.quote(joinTableName) : joinTableName;
            if (StringUtils.isNotEmpty((CharSequence)joinTableSchema)) {
                finalTableName = joinTableSchema + "." + (String)finalTableName;
            }
            this.join(query, queryState.baseQueryDefinition(), joinType, (String)finalTableName, joinTableAlias, lastJoinAlias, ownerJoinColumns, ownerJoinTableColumns);
            query.append(' ');
            this.join(query, queryState.baseQueryDefinition(), joinType, this.getTableName(associatedEntity), currentJoinAlias, joinTableAlias, associationJoinTableColumns, associationJoinColumns);
        } else if (StringUtils.isNotEmpty((CharSequence)mappedBy)) {
            PersistentProperty ownerIdentity = associationOwner.getIdentity();
            if (ownerIdentity == null) {
                throw new IllegalArgumentException("Associated entity [" + associationOwner + "] defines no ID. Cannot join.");
            }
            PersistentPropertyPath mappedByPropertyPath = associatedEntity.getPropertyPath(mappedBy);
            if (mappedByPropertyPath == null) {
                throw new MappingException("Foreign key association with mappedBy references a property that doesn't exist [" + mappedBy + "] of entity: " + associatedEntity.getName());
            }
            this.join(query, joinType, queryState, associatedEntity, associationOwner, lastJoinAlias, currentJoinAlias, new PersistentPropertyPath(joinAssociationsPath, ownerIdentity), mappedByPropertyPath);
        } else {
            PersistentProperty associatedProperty = associatedEntity.getIdentity();
            if (associatedProperty == null) {
                throw new IllegalArgumentException("Associated entity [" + associatedEntity.getName() + "] defines no ID. Cannot join.");
            }
            this.join(query, joinType, queryState, associatedEntity, associationOwner, lastJoinAlias, currentJoinAlias, joinAssociation, new PersistentPropertyPath(List.of(), associatedProperty));
        }
        String additionalWhere = this.resolveWhereForAnnotationMetadata(currentJoinAlias, associatedEntity.getAnnotationMetadata());
        if (StringUtils.isNotEmpty((CharSequence)additionalWhere)) {
            query.append(" AND ").append(additionalWhere);
        }
    }

    private void join(StringBuilder sb, String joinType, AbstractSqlLikeQueryBuilder2.QueryState queryState, PersistentEntity associatedEntity, PersistentEntity associationOwner, String leftTableAlias, String rightTableAlias, PersistentPropertyPath leftPropertyPath, PersistentPropertyPath rightPropertyPath) {
        boolean escape = this.shouldEscape(associationOwner);
        ArrayList<String> onLeftColumns = new ArrayList<String>();
        ArrayList<String> onRightColumns = new ArrayList<String>();
        PersistentProperty leftProperty = leftPropertyPath.getProperty();
        PersistentProperty rightProperty = rightPropertyPath.getProperty();
        Association association = null;
        if (leftProperty instanceof Association) {
            Association associationLeft;
            association = associationLeft = (Association)leftProperty;
        } else if (rightProperty instanceof Association) {
            Association associationRight;
            association = associationRight = (Association)rightProperty;
        }
        if (association != null) {
            Optional<Association> inverse = association.getInverseSide().map(Function.identity());
            Association owner = inverse.orElse(association);
            boolean isOwner = leftProperty == owner;
            AnnotationValue joinColumnsHolder = owner.getAnnotationMetadata().getAnnotation(ANN_JOIN_COLUMNS);
            if (joinColumnsHolder != null) {
                onLeftColumns.addAll(joinColumnsHolder.getAnnotations(VALUE_MEMBER).stream().flatMap(ann -> ann.stringValue(isOwner ? "name" : "referencedColumnName").stream()).toList());
                onRightColumns.addAll(joinColumnsHolder.getAnnotations(VALUE_MEMBER).stream().flatMap(ann -> ann.stringValue(isOwner ? "referencedColumnName" : "name").stream()).toList());
            }
        }
        if (onLeftColumns.isEmpty()) {
            PersistentEntityUtils.traversePersistentProperties(leftProperty, (associations, p) -> {
                String column = this.getMappedName(this.getNamingStrategy(leftProperty.getOwner()), this.merge((List)leftPropertyPath.getAssociations(), (List)associations), (PersistentProperty)p);
                onLeftColumns.add(column);
            });
            if (onLeftColumns.isEmpty()) {
                throw new MappingException("Cannot join on entity [" + leftProperty.getOwner().getName() + "] that has no declared ID");
            }
        }
        if (onRightColumns.isEmpty()) {
            PersistentEntityUtils.traversePersistentProperties(rightProperty, (associations, p) -> {
                String column = this.getMappedName(this.getNamingStrategy(rightProperty.getOwner()), this.merge((List)rightPropertyPath.getAssociations(), (List)associations), (PersistentProperty)p);
                onRightColumns.add(column);
            });
        }
        this.join(sb, queryState.baseQueryDefinition(), joinType, this.getTableName(associatedEntity), rightTableAlias, leftTableAlias, escape ? onLeftColumns.stream().map(this::quote).toList() : onLeftColumns, escape ? onRightColumns.stream().map(this::quote).toList() : onRightColumns);
    }

    private void join(StringBuilder builder, QueryBuilder2.BaseQueryDefinition queryDefinition, String joinType, String tableName, String tableAlias, String onTableName, List<String> onLeftColumns, List<String> onRightColumns) {
        if (onLeftColumns.size() != onRightColumns.size()) {
            throw new IllegalStateException("Un-matching join columns size: " + onLeftColumns.size() + " != " + onRightColumns.size() + BLANK_SPACE + onLeftColumns + ", " + onRightColumns);
        }
        builder.append(joinType).append(tableName).append(' ').append(tableAlias);
        if (queryDefinition instanceof QueryBuilder2.SelectQueryDefinition) {
            QueryBuilder2.SelectQueryDefinition selectQueryDefinition = (QueryBuilder2.SelectQueryDefinition)queryDefinition;
            this.appendForUpdate(AbstractSqlLikeQueryBuilder2.QueryPosition.AFTER_TABLE_NAME, selectQueryDefinition, builder);
        }
        builder.append(" ON ");
        for (int i = 0; i < onLeftColumns.size(); ++i) {
            String leftColumn = onLeftColumns.get(i);
            String rightColumn = onRightColumns.get(i);
            builder.append(onTableName).append('.').append(leftColumn).append('=').append(tableAlias).append('.').append(rightColumn);
            if (i + 1 == onLeftColumns.size()) continue;
            builder.append(" AND ");
        }
    }

    private <T> List<T> merge(List<T> left, List<T> right) {
        if (left.isEmpty()) {
            return right;
        }
        if (right.isEmpty()) {
            return left;
        }
        ArrayList<T> associations = new ArrayList<T>(left.size() + right.size());
        associations.addAll(left);
        associations.addAll(right);
        return associations;
    }

    @Override
    protected String quote(String persistedName) {
        return switch (this.dialect) {
            case Dialect.H2, Dialect.MYSQL -> "`" + persistedName + "`";
            case Dialect.SQL_SERVER -> "[" + persistedName + "]";
            case Dialect.ORACLE -> "\"" + persistedName.toUpperCase(Locale.ENGLISH) + "\"";
            default -> "\"" + persistedName + "\"";
        };
    }

    @Override
    public String getColumnName(PersistentProperty persistentProperty) {
        return persistentProperty.getPersistedName();
    }

    @Override
    protected void appendForUpdate(AbstractSqlLikeQueryBuilder2.QueryPosition queryPosition, QueryBuilder2.SelectQueryDefinition definition, StringBuilder queryBuilder) {
        boolean isSqlServer;
        if (definition.isForUpdate() && ((isSqlServer = Dialect.SQL_SERVER.equals((Object)this.dialect)) && queryPosition.equals((Object)AbstractSqlLikeQueryBuilder2.QueryPosition.AFTER_TABLE_NAME) || !isSqlServer && queryPosition.equals((Object)AbstractSqlLikeQueryBuilder2.QueryPosition.END_OF_QUERY))) {
            queryBuilder.append(isSqlServer ? SQL_SERVER_FOR_UPDATE_CLAUSE : STANDARD_FOR_UPDATE_CLAUSE);
        }
    }

    @Override
    protected boolean computePropertyPaths() {
        return true;
    }

    @Override
    protected boolean isAliasForBatch(PersistentEntity persistentEntity, AnnotationMetadata annotationMetadata) {
        return this.isJsonEntity(annotationMetadata, persistentEntity);
    }

    @Override
    public AbstractSqlLikeQueryBuilder2.Placeholder formatParameter(int index) {
        DialectConfig dialectConfig = this.perDialectConfig.get((Object)this.dialect);
        String name = dialectConfig != null && dialectConfig.positionalNameFormatter != null ? String.format(dialectConfig.positionalNameFormatter, index) : String.valueOf(index);
        if (dialectConfig != null && dialectConfig.positionalFormatter != null) {
            return new AbstractSqlLikeQueryBuilder2.Placeholder(String.format(dialectConfig.positionalFormatter, name), name);
        }
        return new AbstractSqlLikeQueryBuilder2.Placeholder(DEFAULT_POSITIONAL_PARAMETER_MARKER, name);
    }

    protected GeneratedValue.Type selectAutoStrategy(PersistentProperty property) {
        if (property.getDataType() == DataType.UUID) {
            return GeneratedValue.Type.UUID;
        }
        if (this.dialect == Dialect.ORACLE) {
            return GeneratedValue.Type.SEQUENCE;
        }
        return GeneratedValue.Type.AUTO;
    }

    public final String positionalParameterFormat() {
        DialectConfig dialectConfig = this.perDialectConfig.get((Object)this.dialect);
        if (dialectConfig != null && dialectConfig.positionalFormatter != null) {
            return dialectConfig.positionalFormatter;
        }
        return DEFAULT_POSITIONAL_PARAMETER_MARKER;
    }

    @Override
    public QueryResult buildSelect(@NonNull AnnotationMetadata annotationMetadata, @NonNull QueryBuilder2.SelectQueryDefinition definition) {
        if (definition.parametersInRole().isEmpty()) {
            AbstractSqlLikeQueryBuilder2.QueryState queryState = this.buildQuery(annotationMetadata, definition, new AbstractSqlLikeQueryBuilder2.QueryBuilder(), true, null);
            return QueryResult.of(queryState.getFinalQuery(), queryState.getQueryParts(), queryState.getParameterBindings(), queryState.getJoinPaths());
        }
        return super.buildSelect(annotationMetadata, definition);
    }

    @Override
    protected void appendPaginationAndOrder(AnnotationMetadata annotationMetadata, QueryBuilder2.SelectQueryDefinition definition, boolean pagination, final AbstractSqlLikeQueryBuilder2.QueryState queryState) {
        Map<String, Integer> parametersInRole = definition.parametersInRole();
        if (parametersInRole.isEmpty()) {
            this.appendOrder(annotationMetadata, definition, queryState);
            if (pagination) {
                this.appendLimitAndOffset(this.getDialect(), definition.limit(), definition.offset(), queryState.getQuery());
            }
        } else if (parametersInRole.containsKey("sort") || parametersInRole.containsKey("pageable") || parametersInRole.containsKey("pageableRequired")) {
            final Map.Entry<String, Integer> e = parametersInRole.entrySet().iterator().next();
            queryState.pushParameter(new QueryParameterBinding(){

                @Override
                public String getName() {
                    return (String)e.getKey();
                }

                @Override
                public String getKey() {
                    return "";
                }

                @Override
                public int getParameterIndex() {
                    return (Integer)e.getValue();
                }

                @Override
                public DataType getDataType() {
                    return DataType.OBJECT;
                }

                @Override
                public boolean isExpandable() {
                    return true;
                }

                @Override
                public String getRole() {
                    return (String)e.getKey();
                }

                @Override
                public String getTableAlias() {
                    String rootAlias = queryState.getRootAlias();
                    return StringUtils.isNotEmpty((CharSequence)rootAlias) ? rootAlias : null;
                }
            });
        }
    }

    private void appendOrder(AnnotationMetadata annotationMetadata, QueryBuilder2.SelectQueryDefinition definition, AbstractSqlLikeQueryBuilder2.QueryState queryState) {
        List<Order> orders = definition.order();
        if (this.getDialect() == Dialect.SQL_SERVER && orders.isEmpty() && (definition.limit() > 0 || definition.offset() > 0)) {
            PersistentEntity persistentEntity = definition.persistentEntity();
            PersistentProperty identity = persistentEntity.getIdentity();
            if (identity == null) {
                throw new DataAccessException("Pagination requires an entity ID on SQL Server");
            }
            orders = List.of(new PersistentPropertyOrder(new DefaultPersistentPropertyPath(identity, List.of(), null), true));
        }
        this.appendOrder(annotationMetadata, orders, queryState);
    }

    private static /* synthetic */ void lambda$buildCreateTableStatements$12(List leftProperties, List associations1, PersistentProperty property3) {
        leftProperties.add(PersistentPropertyPath.of(associations1, property3, ""));
    }

    private static class DialectConfig {
        Boolean escapeQueries;
        String positionalFormatter;
        String positionalNameFormatter;

        private DialectConfig() {
        }
    }

    private static class IndexConfiguration {
        AnnotationValue<?> index;
        String tableName;
        String unquotedTableName;

        public IndexConfiguration(AnnotationValue<?> index, String tableName, String unquotedTableName) {
            this.index = index;
            this.tableName = tableName;
            this.unquotedTableName = unquotedTableName;
        }
    }

    protected class SqlSelectionVisitor
    extends AbstractSqlLikeQueryBuilder2.SqlSelectionVisitor {
        public SqlSelectionVisitor(AbstractSqlLikeQueryBuilder2.QueryState queryState, AnnotationMetadata annotationMetadata, boolean distinct) {
            super(queryState, annotationMetadata, distinct);
        }

        @Override
        protected void appendRowCount(String logicalName) {
            this.query.append("COUNT(*)");
        }

        @Override
        protected void appendRowCountDistinct(String logicalName) {
            this.query.append("COUNT(DISTINCT(");
            if (this.entity.hasCompositeIdentity()) {
                this.appendConcatProperties(List.of(this.entity.getCompositeIdentity()));
            } else if (this.entity.hasIdentity()) {
                List<PersistentProperty> identityProperties = this.entity.getIdentityProperties();
                if (identityProperties.isEmpty()) {
                    throw new IllegalArgumentException("Cannot query on ID with entity that has no ID");
                }
                long count = identityProperties.stream().mapToInt(PersistentEntityUtils::countPersistentProperties).sum();
                if (count > 1L) {
                    this.appendConcatProperties(identityProperties);
                } else {
                    for (PersistentProperty identity : identityProperties) {
                        this.appendPropertyProjection(SqlQueryBuilder2.this.asQueryPropertyPath(this.tableAlias, identity));
                    }
                }
            } else {
                throw new IllegalArgumentException("Cannot query on ID with entity that has no ID");
            }
            this.query.append("))");
        }

        private void appendConcatProperties(List<PersistentProperty> properties) {
            this.query.append(" CONCAT(");
            Iterator<PersistentProperty> iterator = properties.iterator();
            while (iterator.hasNext()) {
                PersistentProperty identity = iterator.next();
                this.appendPropertyProjection(SqlQueryBuilder2.this.asQueryPropertyPath(this.tableAlias, identity));
                if (!iterator.hasNext()) continue;
                this.query.append(',');
            }
            this.query.append(')');
        }

        @Override
        protected void selectAllColumnsAndJoined() {
            this.selectAllColumns(this.annotationMetadata, this.entity, this.tableAlias);
            Collection<JoinPath> allPaths = this.queryState.baseQueryDefinition().getJoinPaths();
            this.selectAllColumnsFromJoinPaths(allPaths, null);
        }

        @Override
        @Internal
        protected void selectAllColumnsFromJoinPaths(Collection<JoinPath> allPaths, @Nullable Map<JoinPath, String> joinAliasOverride) {
            if (CollectionUtils.isEmpty(allPaths)) {
                return;
            }
            List joinPaths = allPaths.stream().filter(jp -> jp.getJoinType().isFetch()).collect(Collectors.toList());
            Collections.reverse(joinPaths);
            if (CollectionUtils.isEmpty(joinPaths)) {
                return;
            }
            for (JoinPath joinPath : joinPaths) {
                Association association = joinPath.getAssociation();
                if (association.isEmbedded()) continue;
                PersistentEntity associatedEntity = association.getAssociatedEntity();
                NamingStrategy namingStrategy = SqlQueryBuilder2.this.getNamingStrategy(associatedEntity);
                String joinAlias = joinAliasOverride == null ? SqlQueryBuilder2.this.getAliasName(joinPath) : joinAliasOverride.get(joinPath);
                Objects.requireNonNull(joinAlias);
                String joinPathAlias = SqlQueryBuilder2.this.getPathOnlyAliasName(joinPath);
                this.query.append(',');
                boolean includeIdentity = association.isForeignKey();
                PersistentEntityUtils.traversePersistentProperties(associatedEntity, includeIdentity, true, (propertyAssociations, prop) -> {
                    String transformed = SqlQueryBuilder2.this.getDataTransformerReadValue(joinAlias, (PersistentProperty)prop).orElse(null);
                    String columnAlias = SqlQueryBuilder2.this.getColumnAlias((PersistentProperty)prop);
                    String columnName = SqlQueryBuilder2.this.computePropertyPaths() ? SqlQueryBuilder2.this.getMappedName(namingStrategy, (List<Association>)propertyAssociations, (PersistentProperty)prop) : AbstractSqlLikeQueryBuilder2.asPath(propertyAssociations, prop);
                    if (transformed != null) {
                        this.query.append(transformed).append(" AS ");
                    } else {
                        this.query.append(joinAlias).append('.').append(this.queryState.shouldEscape() ? SqlQueryBuilder2.this.quote(columnName) : columnName).append(" AS ");
                    }
                    if (StringUtils.isNotEmpty((CharSequence)columnAlias)) {
                        this.query.append(columnAlias);
                    } else {
                        this.query.append(joinPathAlias).append(columnName);
                    }
                    this.query.append(',');
                });
                this.query.setLength(this.query.length() - 1);
            }
        }

        @Override
        public void selectAllColumns(AnnotationMetadata annotationMetadata, PersistentEntity entity, String alias) {
            if (this.canUseWildcardForSelect(annotationMetadata, entity)) {
                this.selectAllColumns(this.query, alias);
                return;
            }
            boolean escape = SqlQueryBuilder2.this.shouldEscape(entity);
            NamingStrategy namingStrategy = SqlQueryBuilder2.this.getNamingStrategy(entity);
            int length = this.query.length();
            PersistentEntityUtils.traversePersistentProperties(entity, (associations, property) -> this.appendProperty(this.query, (List<Association>)associations, (PersistentProperty)property, namingStrategy, alias, escape));
            int newLength = this.query.length();
            if (newLength == length) {
                this.selectAllColumns(this.query, alias);
            } else {
                this.query.setLength(newLength - 1);
            }
        }

        private void selectAllColumns(StringBuilder sb, String alias) {
            if (alias != null) {
                sb.append(alias).append('.');
            }
            sb.append("*");
        }

        private boolean canUseWildcardForSelect(AnnotationMetadata annotationMetadata, PersistentEntity entity) {
            if (SqlQueryBuilder2.this.isJsonEntity(annotationMetadata, entity)) {
                return true;
            }
            return Stream.concat(entity.getIdentityProperties().stream(), entity.getPersistentProperties().stream()).flatMap(SqlQueryBuilder2::flatMapEmbedded).noneMatch(pp -> {
                if (pp instanceof Association) {
                    Association association = (Association)pp;
                    return !association.isForeignKey();
                }
                return true;
            });
        }
    }

    public static final class InsertQueryDefinitionImpl
    implements QueryBuilder2.InsertQueryDefinition {
        private final PersistentEntity persistentEntity;
        private final Selection<?> returningSelection;

        public InsertQueryDefinitionImpl(PersistentEntity persistentEntity) {
            this.persistentEntity = persistentEntity;
            this.returningSelection = null;
        }

        @Override
        public PersistentEntity persistentEntity() {
            return this.persistentEntity;
        }

        @Override
        public Selection<?> returningSelection() {
            return this.returningSelection;
        }
    }
}

