/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.micronaut.core.annotation.Creator;
import io.micronaut.core.annotation.ReflectiveAccess;
import io.micronaut.data.model.DefaultSlice;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.Pageable;
import io.micronaut.serde.annotation.Serdeable;
import java.util.List;
import java.util.Objects;

@Serdeable
class DefaultPage<T>
extends DefaultSlice<T>
implements Page<T> {
    private final Long totalSize;

    @JsonCreator
    @Creator
    @ReflectiveAccess
    DefaultPage(@JsonProperty(value="content") List<T> content, @JsonProperty(value="pageable") Pageable pageable, @JsonProperty(value="totalSize") Long totalSize) {
        super(content, pageable);
        this.totalSize = totalSize;
    }

    @Override
    public boolean hasTotalSize() {
        return this.totalSize != null && this.totalSize != -1L;
    }

    @Override
    @ReflectiveAccess
    public long getTotalSize() {
        if (this.totalSize == null) {
            throw new IllegalStateException("Page does not contain total count. It is likely that the Pageable needs to be modified to request this information.");
        }
        return this.totalSize;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultPage)) {
            return false;
        }
        DefaultPage that = (DefaultPage)o;
        return this.totalSize == that.totalSize && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.totalSize, super.hashCode());
    }

    @Override
    public String toString() {
        return "DefaultPage{totalSize=" + this.totalSize + ",content=" + String.valueOf(this.getContent()) + ",pageable=" + String.valueOf(this.getPageable()) + "}";
    }
}

