/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.runtime;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.data.annotation.MappedProperty;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.JsonDataType;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.convert.AttributeConverter;
import java.util.Objects;
import java.util.function.Supplier;

public class RuntimePersistentProperty<T>
implements PersistentProperty {
    public static final RuntimePersistentProperty<Object>[] EMPTY_PROPERTY_ARRAY = new RuntimePersistentProperty[0];
    private final RuntimePersistentEntity<T> owner;
    private final BeanProperty<T, Object> property;
    private final AnnotationMetadata annotationMetadata;
    private final Class<?> type;
    private final DataType dataType;
    private final JsonDataType jsonDataType;
    private final boolean constructorArg;
    private final Argument<Object> argument;
    private final Supplier<AttributeConverter<Object, Object>> converter;
    private String persistedName;
    private String alias;

    RuntimePersistentProperty(RuntimePersistentEntity<T> owner, BeanProperty<T, Object> property, boolean constructorArg) {
        this(owner, property, (Argument<Object>)property.asArgument(), property.getAnnotationMetadata(), constructorArg);
    }

    RuntimePersistentProperty(RuntimePersistentEntity<T> owner, BeanProperty<T, Object> property, Argument<Object> argument, AnnotationMetadata annotationMetadata, boolean constructorArg) {
        this.owner = owner;
        this.property = property;
        this.annotationMetadata = annotationMetadata;
        this.type = ReflectionUtils.getWrapperType((Class)property.getType());
        this.dataType = PersistentProperty.super.getDataType();
        this.jsonDataType = this.dataType == DataType.JSON ? PersistentProperty.super.getJsonDataType() : null;
        this.constructorArg = constructorArg;
        this.argument = argument;
        this.converter = annotationMetadata.classValue(MappedProperty.class, "converter").map(converter -> SupplierUtil.memoized(() -> owner.resolveConverter((Class<?>)converter))).orElse(null);
        this.alias = property.getAnnotationMetadata().stringValue(MappedProperty.class, "alias").orElse(null);
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    public Argument<Object> getArgument() {
        return this.argument;
    }

    @Override
    public boolean isConstructorArgument() {
        return this.constructorArg;
    }

    @Override
    public final boolean isOptional() {
        return this.property.isNullable();
    }

    @Override
    public boolean isEnum() {
        return this.type.isEnum();
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public JsonDataType getJsonDataType() {
        return this.jsonDataType;
    }

    @Override
    public boolean isReadOnly() {
        return this.property.isReadOnly();
    }

    @NonNull
    public Class<?> getType() {
        return this.type;
    }

    @Override
    @NonNull
    public String getName() {
        return this.property.getName();
    }

    @Override
    @NonNull
    public String getTypeName() {
        return this.property.getType().getName();
    }

    @Override
    @NonNull
    public RuntimePersistentEntity<T> getOwner() {
        return this.owner;
    }

    @Override
    public boolean isAssignable(@NonNull String type) {
        throw new UnsupportedOperationException("Use isAssignable(Class) instead");
    }

    @Override
    public boolean isAssignable(@NonNull Class<?> type) {
        return type.isAssignableFrom(this.getProperty().getType());
    }

    public AnnotationMetadata getAnnotationMetadata() {
        return this.annotationMetadata;
    }

    public BeanProperty<T, Object> getProperty() {
        return this.property;
    }

    @Override
    public AttributeConverter<Object, Object> getConverter() {
        if (this.converter == null) {
            return null;
        }
        return this.converter.get();
    }

    @Override
    @NonNull
    public String getPersistedName() {
        if (this.persistedName == null) {
            this.persistedName = this.owner.getNamingStrategy().mappedName(this);
        }
        return this.persistedName;
    }

    public String toString() {
        return this.getOwner().getSimpleName() + "." + this.getName();
    }

    public int hashCode() {
        return Objects.hash(this.getOwner(), this.getName());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        RuntimePersistentProperty other = (RuntimePersistentProperty)obj;
        return Objects.equals(other.getOwner(), this.getOwner()) && Objects.equals(other.getName(), this.getName());
    }
}

