/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl.predicate;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.model.jpa.criteria.impl.PredicateVisitor;
import io.micronaut.data.model.jpa.criteria.impl.predicate.AbstractPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.PredicateUnaryOp;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;

@Internal
public final class UnaryPredicate
extends AbstractPredicate {
    private final Expression<?> expression;
    private final PredicateUnaryOp op;

    public UnaryPredicate(@NonNull Expression<?> expression, @NonNull PredicateUnaryOp op) {
        this.expression = expression;
        this.op = op;
        op.validate(expression);
    }

    @NonNull
    public Expression<?> getExpression() {
        return this.expression;
    }

    @NonNull
    public PredicateUnaryOp getOp() {
        return this.op;
    }

    @Override
    public Predicate not() {
        PredicateUnaryOp negatedOp = this.op.negate();
        if (negatedOp != null) {
            return new UnaryPredicate(this.expression, negatedOp);
        }
        return super.not();
    }

    @Override
    public void visitPredicate(PredicateVisitor predicateVisitor) {
        predicateVisitor.visit(this);
    }

    public String toString() {
        return "UnaryPredicate{expression=" + this.expression + ", op=" + this.op + "}";
    }
}

