/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl.predicate;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.jpa.criteria.impl.PredicateVisitor;
import io.micronaut.data.model.jpa.criteria.impl.predicate.AbstractPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.PredicateBinaryOp;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;

@Internal
public final class BinaryPredicate
extends AbstractPredicate {
    private final Expression<?> leftExpression;
    private final Expression<?> rightExpression;
    private final PredicateBinaryOp op;

    public BinaryPredicate(Expression<?> leftExpression, Expression<?> rightExpression, PredicateBinaryOp op) {
        this.leftExpression = leftExpression;
        this.rightExpression = rightExpression;
        this.op = op;
        op.validate(leftExpression, rightExpression);
    }

    public Expression<?> getLeftExpression() {
        return this.leftExpression;
    }

    public Expression<?> getRightExpression() {
        return this.rightExpression;
    }

    public PredicateBinaryOp getOp() {
        return this.op;
    }

    @Override
    public Predicate not() {
        PredicateBinaryOp negatedOp = this.op.negate();
        if (negatedOp != null) {
            return new BinaryPredicate(this.leftExpression, this.rightExpression, negatedOp);
        }
        return super.not();
    }

    @Override
    public void visitPredicate(PredicateVisitor predicateVisitor) {
        predicateVisitor.visit(this);
    }

    public String toString() {
        return "BinaryPredicate{leftExpression=" + this.leftExpression + ", rightExpression=" + this.rightExpression + ", op=" + this.op + "}";
    }
}

