/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl.predicate;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.model.jpa.criteria.impl.PredicateVisitor;
import io.micronaut.data.model.jpa.criteria.impl.predicate.AbstractPredicate;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@Internal
public final class InPredicate<T>
extends AbstractPredicate
implements CriteriaBuilder.In<T> {
    private final Expression<T> expression;
    private final List<Expression<?>> values;
    private final CriteriaBuilder criteriaBuilder;

    public InPredicate(Expression<T> expression, CriteriaBuilder criteriaBuilder) {
        this(expression, Collections.emptyList(), criteriaBuilder);
    }

    public InPredicate(Expression<T> expression, Collection<Expression<?>> values, CriteriaBuilder criteriaBuilder) {
        this.expression = expression;
        this.values = new ArrayList(values);
        this.criteriaBuilder = criteriaBuilder;
    }

    @NonNull
    public List<Expression<?>> getValues() {
        return this.values;
    }

    public Expression<T> getExpression() {
        return this.expression;
    }

    public InPredicate<T> value(T value) {
        this.values.add(this.criteriaBuilder.literal(value));
        return this;
    }

    public InPredicate<T> value(Expression<? extends T> value) {
        this.values.add(value);
        return this;
    }

    @Override
    public void visitPredicate(PredicateVisitor predicateVisitor) {
        predicateVisitor.visit(this);
    }

    public String toString() {
        return "InPredicate{value=" + this.expression + ", values=" + this.values + ", criteriaBuilder=" + this.criteriaBuilder + "}";
    }
}

