/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.jpa.criteria.PersistentAssociationPath;
import io.micronaut.data.model.jpa.criteria.PersistentCollectionAssociationPath;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCollectionJoin;
import io.micronaut.data.model.jpa.criteria.PersistentEntityFrom;
import io.micronaut.data.model.jpa.criteria.PersistentEntityJoin;
import io.micronaut.data.model.jpa.criteria.PersistentEntityListJoin;
import io.micronaut.data.model.jpa.criteria.PersistentEntitySetJoin;
import io.micronaut.data.model.jpa.criteria.PersistentListAssociationPath;
import io.micronaut.data.model.jpa.criteria.PersistentSetAssociationPath;
import io.micronaut.data.model.jpa.criteria.impl.CriteriaUtils;
import io.micronaut.data.model.jpa.criteria.impl.SelectionVisitable;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Fetch;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.MapJoin;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.metamodel.CollectionAttribute;
import jakarta.persistence.metamodel.ListAttribute;
import jakarta.persistence.metamodel.MapAttribute;
import jakarta.persistence.metamodel.PluralAttribute;
import jakarta.persistence.metamodel.SetAttribute;
import jakarta.persistence.metamodel.SingularAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@Internal
public abstract class AbstractPersistentEntityJoinSupport<J, E>
implements PersistentEntityFrom<J, E>,
SelectionVisitable {
    protected final Map<String, PersistentAssociationPath> joins = new LinkedHashMap<String, PersistentAssociationPath>();

    @Override
    public abstract PersistentEntity getPersistentEntity();

    protected abstract <X, Y> PersistentAssociationPath<X, Y> createJoinAssociation(@NonNull Association var1, @Nullable Join.Type var2, @Nullable String var3);

    private <X, Y> PersistentAssociationPath<X, Y> getJoin(String attributeName, Join.Type type, String alias) {
        PersistentProperty persistentProperty = this.getPersistentEntity().getPropertyByName(attributeName);
        if (!(persistentProperty instanceof Association)) {
            throw new IllegalStateException("Expected an association for attribute name: " + attributeName);
        }
        PersistentAssociationPath path = this.joins.computeIfAbsent(attributeName, a -> this.createJoinAssociation((Association)persistentProperty, type, alias));
        if (type != null && type != Join.Type.DEFAULT) {
            path.setAssociationJoinType(type);
        }
        if (alias != null) {
            path.setAlias(alias);
        }
        return path;
    }

    private <X, Y> PersistentCollectionAssociationPath<X, Y> getCollectionJoin(String attributeName, Join.Type type, String alias) {
        PersistentAssociationPath<X, Y> join = this.getJoin(attributeName, type, alias);
        if (!(join instanceof PersistentCollectionAssociationPath)) {
            throw new IllegalStateException("Join is not a Collection!");
        }
        return (PersistentCollectionAssociationPath)join;
    }

    private <X, Y> PersistentSetAssociationPath<X, Y> getSetJoin(String attributeName, Join.Type type, String alias) {
        PersistentAssociationPath<X, Y> join = this.getJoin(attributeName, type, alias);
        if (!(join instanceof PersistentSetAssociationPath)) {
            throw new IllegalStateException("Join is not a Set!");
        }
        return (PersistentSetAssociationPath)join;
    }

    private <X, Y> PersistentListAssociationPath<X, Y> getListJoin(String attributeName, Join.Type type, String alias) {
        PersistentAssociationPath<X, Y> join = this.getJoin(attributeName, type, alias);
        if (!(join instanceof PersistentListAssociationPath)) {
            throw new IllegalStateException("Join is not a List!");
        }
        return (PersistentListAssociationPath)join;
    }

    public Path<?> getParentPath() {
        throw CriteriaUtils.notSupportedOperation();
    }

    public <K, V, M extends Map<K, V>> Expression<M> get(MapAttribute<E, K, V> map) {
        return this.get(map.getName());
    }

    public <K, C extends Collection<K>> Expression<C> get(PluralAttribute<E, C, K> collection) {
        return this.get(collection.getName());
    }

    @Override
    public <X, Y> PersistentEntityJoin<X, Y> join(String attributeName) {
        return this.getJoin(attributeName, null, null);
    }

    @Override
    public <X, Y> PersistentEntityJoin<X, Y> join(String attributeName, JoinType jt) {
        return this.getJoin(attributeName, this.convert(Objects.requireNonNull(jt)), null);
    }

    @Override
    public <X, Y> PersistentEntityJoin<X, Y> join(String attributeName, Join.Type type) {
        return this.getJoin(attributeName, Objects.requireNonNull(type), null);
    }

    @Override
    public <X, Y> PersistentEntityJoin<X, Y> join(String attributeName, Join.Type type, String alias) {
        return this.getJoin(attributeName, Objects.requireNonNull(type), Objects.requireNonNull(alias));
    }

    @Nullable
    private Join.Type convert(@Nullable JoinType joinType) {
        if (joinType == null) {
            return null;
        }
        switch (joinType) {
            case LEFT: {
                return Join.Type.LEFT;
            }
            case RIGHT: {
                return Join.Type.RIGHT;
            }
            case INNER: {
                return Join.Type.INNER;
            }
        }
        return null;
    }

    @Override
    public <Y> PersistentEntityJoin<E, Y> join(SingularAttribute<? super E, Y> attribute) {
        return this.getJoin(attribute.getName(), null, null);
    }

    @Override
    public <Y> PersistentEntityJoin<E, Y> join(SingularAttribute<? super E, Y> attribute, JoinType jt) {
        return this.getJoin(attribute.getName(), this.convert(Objects.requireNonNull(jt)), null);
    }

    @Override
    public <Y> PersistentEntityCollectionJoin<E, Y> join(CollectionAttribute<? super E, Y> collection, JoinType jt) {
        return this.getCollectionJoin(collection.getName(), this.convert(jt), null);
    }

    @Override
    public <Y> PersistentEntityCollectionJoin<E, Y> join(CollectionAttribute<? super E, Y> collection) {
        return this.getCollectionJoin(collection.getName(), null, null);
    }

    @Override
    public <Y> PersistentEntitySetJoin<E, Y> join(SetAttribute<? super E, Y> set) {
        return this.getSetJoin(set.getName(), null, null);
    }

    @Override
    public <Y> PersistentEntityListJoin<E, Y> join(ListAttribute<? super E, Y> list) {
        return this.getListJoin(list.getName(), null, null);
    }

    public <K, V> MapJoin<E, K, V> join(MapAttribute<? super E, K, V> map) {
        throw CriteriaUtils.notSupportedOperation();
    }

    @Override
    public <Y> PersistentEntitySetJoin<E, Y> join(SetAttribute<? super E, Y> set, JoinType jt) {
        return this.getSetJoin(set.getName(), this.convert(Objects.requireNonNull(jt)), null);
    }

    @Override
    public <Y> PersistentEntityListJoin<E, Y> join(ListAttribute<? super E, Y> list, JoinType jt) {
        return this.getListJoin(list.getName(), this.convert(Objects.requireNonNull(jt)), null);
    }

    public <K, V> MapJoin<E, K, V> join(MapAttribute<? super E, K, V> map, JoinType jt) {
        throw CriteriaUtils.notSupportedOperation();
    }

    @Override
    public <X, Y> PersistentEntityCollectionJoin<X, Y> joinCollection(String attributeName) {
        return this.getCollectionJoin(attributeName, null, null);
    }

    @Override
    public <X, Y> PersistentEntitySetJoin<X, Y> joinSet(String attributeName) {
        return this.getSetJoin(attributeName, null, null);
    }

    @Override
    public <X, Y> PersistentEntityListJoin<X, Y> joinList(String attributeName) {
        return this.getListJoin(attributeName, null, null);
    }

    public <X, K, V> MapJoin<X, K, V> joinMap(String attributeName) {
        throw CriteriaUtils.notSupportedOperation();
    }

    @Override
    public <X, Y> PersistentEntityCollectionJoin<X, Y> joinCollection(String attributeName, JoinType jt) {
        return this.getCollectionJoin(attributeName, null, null);
    }

    @Override
    public <X, Y> PersistentEntitySetJoin<X, Y> joinSet(String attributeName, JoinType jt) {
        return this.getSetJoin(attributeName, this.convert(Objects.requireNonNull(jt)), null);
    }

    @Override
    public <X, Y> PersistentEntityListJoin<X, Y> joinList(String attributeName, JoinType jt) {
        return this.getListJoin(attributeName, this.convert(Objects.requireNonNull(jt)), null);
    }

    public <X, K, V> MapJoin<X, K, V> joinMap(String attributeName, JoinType jt) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Set<Join<E, ?>> getJoins() {
        return new HashSet(this.joins.values());
    }

    public boolean isCorrelated() {
        throw CriteriaUtils.notSupportedOperation();
    }

    public From<J, E> getCorrelationParent() {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Set<Fetch<E, ?>> getFetches() {
        throw CriteriaUtils.notSupportedOperation();
    }

    public <Y> Fetch<E, Y> fetch(SingularAttribute<? super E, Y> attribute) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public <Y> Fetch<E, Y> fetch(SingularAttribute<? super E, Y> attribute, JoinType jt) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public <Y> Fetch<E, Y> fetch(PluralAttribute<? super E, ?, Y> attribute) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public <Y> Fetch<E, Y> fetch(PluralAttribute<? super E, ?, Y> attribute, JoinType jt) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public <X, Y> Fetch<X, Y> fetch(String attributeName) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public <X, Y> Fetch<X, Y> fetch(String attributeName, JoinType jt) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public <Y> Path<Y> get(SingularAttribute<? super E, Y> attribute) {
        return this.get(attribute.getName());
    }

    public Expression<Class<? extends E>> type() {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Class<? extends E> getJavaType() {
        throw CriteriaUtils.notSupportedOperation();
    }
}

