/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.query.JoinPath;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@Internal
public final class AssociationUtils {
    static final Pattern CAMEL_CASE_SPLIT_PATTERN = Pattern.compile("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])");

    private AssociationUtils() {
    }

    public static Set<JoinPath> getJoinFetchPaths(AnnotationMetadata annotationMetadata) {
        return annotationMetadata.getAnnotationValuesByType(Join.class).stream().filter(AssociationUtils::isJoinFetch).map(av -> {
            String path = (String)av.stringValue().orElseThrow(() -> new IllegalStateException("Should not include annotations without a value definition"));
            Join.Type joinType = av.get((CharSequence)"type", Join.Type.class).orElse(Join.Type.DEFAULT);
            String alias = av.stringValue("alias").orElse(null);
            return new JoinPath(path, new Association[0], joinType, alias);
        }).collect(Collectors.toSet());
    }

    private static boolean isJoinFetch(AnnotationValue<Join> av) {
        if (!av.stringValue().isPresent()) {
            return false;
        }
        Optional type = av.stringValue("type");
        return !type.isPresent() || ((String)type.get()).contains("FETCH");
    }
}

