/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.jpa.criteria.IExpression;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.impl.SelectionVisitable;
import io.micronaut.data.model.jpa.criteria.impl.SelectionVisitor;

@Internal
public final class IdExpression<E, T>
implements IExpression<T>,
SelectionVisitable {
    private final PersistentEntityRoot<E> root;

    public IdExpression(PersistentEntityRoot<E> root) {
        this.root = root;
    }

    public PersistentEntityRoot<E> getRoot() {
        return this.root;
    }

    @Override
    public void accept(SelectionVisitor selectionVisitor) {
        selectionVisitor.visit(this);
    }

    @Override
    public boolean isBoolean() {
        PersistentEntity persistentEntity = this.root.getPersistentEntity();
        if (persistentEntity.hasCompositeIdentity()) {
            return false;
        }
        return this.root.get(persistentEntity.getIdentity().getName()).isBoolean();
    }

    @Override
    public boolean isNumeric() {
        PersistentEntity persistentEntity = this.root.getPersistentEntity();
        if (persistentEntity.hasCompositeIdentity()) {
            return false;
        }
        return this.root.get(persistentEntity.getIdentity().getName()).isNumeric();
    }

    @Override
    public boolean isComparable() {
        PersistentEntity persistentEntity = this.root.getPersistentEntity();
        if (persistentEntity.hasCompositeIdentity()) {
            return false;
        }
        return this.root.get(persistentEntity.getIdentity().getName()).isComparable();
    }

    public Class<? extends T> getJavaType() {
        PersistentEntity persistentEntity = this.root.getPersistentEntity();
        if (persistentEntity.hasCompositeIdentity()) {
            throw new IllegalStateException("IdClass is unknown!");
        }
        return this.root.get(persistentEntity.getIdentity().getName()).getJavaType();
    }

    public String toString() {
        return "IdExpression{root=" + this.root + "}";
    }
}

