/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.query.builder.sql;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.model.DataType;
import java.util.EnumSet;

public enum Dialect {
    H2(true, false, true, EnumSet.of(Join.Type.DEFAULT, new Join.Type[]{Join.Type.LEFT, Join.Type.LEFT_FETCH, Join.Type.RIGHT, Join.Type.RIGHT_FETCH, Join.Type.FETCH, Join.Type.INNER})),
    MYSQL(true, true, false, EnumSet.of(Join.Type.DEFAULT, new Join.Type[]{Join.Type.LEFT, Join.Type.LEFT_FETCH, Join.Type.RIGHT, Join.Type.RIGHT_FETCH, Join.Type.FETCH, Join.Type.INNER})),
    POSTGRES(true, false, true, Join.Type.ALL_TYPES),
    SQL_SERVER(false, false, false, Join.Type.ALL_TYPES),
    ORACLE(true, true, false, Join.Type.ALL_TYPES),
    ANSI(true, false, true, Join.Type.ALL_TYPES);

    private final boolean supportsBatch;
    private final boolean stringUUID;
    private final boolean supportsArrays;
    private final EnumSet<Join.Type> joinTypesSupported;

    private Dialect(boolean supportsBatch, boolean stringUUID, boolean supportsArrays, EnumSet<Join.Type> joinTypesSupported) {
        this.supportsBatch = supportsBatch;
        this.stringUUID = stringUUID;
        this.supportsArrays = supportsArrays;
        this.joinTypesSupported = joinTypesSupported;
    }

    public final boolean allowBatch() {
        return this.supportsBatch;
    }

    public final boolean supportsArrays() {
        return this.supportsArrays;
    }

    public final DataType getDataType(@NonNull DataType type) {
        if (type == DataType.UUID && this.stringUUID) {
            return DataType.STRING;
        }
        return type;
    }

    public final boolean requiresStringUUID(@NonNull DataType type) {
        return type == DataType.UUID && this.stringUUID;
    }

    public final boolean supportsJoinType(@NonNull Join.Type joinType) {
        return this.joinTypesSupported.contains((Object)joinType);
    }
}

