/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.operations.reactive;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.propagation.ReactorPropagation;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.runtime.DeleteBatchOperation;
import io.micronaut.data.model.runtime.DeleteOperation;
import io.micronaut.data.model.runtime.InsertBatchOperation;
import io.micronaut.data.model.runtime.InsertOperation;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.UpdateBatchOperation;
import io.micronaut.data.model.runtime.UpdateOperation;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.operations.reactive.ReactorReactiveCapableRepository;
import java.util.Optional;
import java.util.stream.Stream;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public interface BlockingReactorRepositoryOperations
extends RepositoryOperations,
ReactorReactiveCapableRepository {
    @NonNull
    private ContextView getContextView() {
        return ReactorPropagation.addPropagatedContext((Context)Context.empty(), (PropagatedContext)PropagatedContext.getOrEmpty());
    }

    @Override
    @Nullable
    default public <T> T findOne(@NonNull Class<T> type, @NonNull Object id) {
        return (T)this.reactive().findOne(type, id).contextWrite(this.getContextView()).block();
    }

    @Override
    @Nullable
    default public <T, R> R findOne(@NonNull PreparedQuery<T, R> preparedQuery) {
        return (R)this.reactive().findOne(preparedQuery).contextWrite(this.getContextView()).block();
    }

    @Override
    @NonNull
    default public <T, R> Iterable<R> findAll(@NonNull PreparedQuery<T, R> preparedQuery) {
        return (Iterable)this.reactive().findAll(preparedQuery).contextWrite(this.getContextView()).collectList().block();
    }

    @Override
    @NonNull
    default public <T, R> Stream<R> findStream(@NonNull PreparedQuery<T, R> preparedQuery) {
        return this.reactive().findAll(preparedQuery).contextWrite(this.getContextView()).toStream();
    }

    @Override
    @NonNull
    default public <T> T persist(@NonNull InsertOperation<T> operation) {
        return (T)this.reactive().persist(operation).contextWrite(this.getContextView()).blockOptional().orElseGet(operation::getEntity);
    }

    @Override
    @NonNull
    default public <T> T update(@NonNull UpdateOperation<T> operation) {
        return (T)this.reactive().update(operation).contextWrite(this.getContextView()).blockOptional().orElseGet(operation::getEntity);
    }

    @Override
    default public <T> Iterable<T> updateAll(UpdateBatchOperation<T> operation) {
        return this.reactive().updateAll(operation).contextWrite(this.getContextView()).collectList().map(it -> it).blockOptional().orElse(operation);
    }

    @Override
    @NonNull
    default public <T> Iterable<T> persistAll(@NonNull InsertBatchOperation<T> operation) {
        return this.reactive().persistAll(operation).contextWrite(this.getContextView()).collectList().map(it -> it).blockOptional().orElse(operation);
    }

    @Override
    @NonNull
    default public Optional<Number> executeUpdate(@NonNull PreparedQuery<?, Number> preparedQuery) {
        return this.reactive().executeUpdate(preparedQuery).contextWrite(this.getContextView()).blockOptional();
    }

    @Override
    default public Optional<Number> executeDelete(@NonNull PreparedQuery<?, Number> preparedQuery) {
        return this.reactive().executeDelete(preparedQuery).contextWrite(this.getContextView()).blockOptional();
    }

    @Override
    default public <T> int delete(@NonNull DeleteOperation<T> operation) {
        return ((Number)this.reactive().delete(operation).contextWrite(this.getContextView()).blockOptional().orElse(0)).intValue();
    }

    @Override
    default public <T> Optional<Number> deleteAll(@NonNull DeleteBatchOperation<T> operation) {
        return this.reactive().deleteAll(operation).contextWrite(this.getContextView()).blockOptional();
    }

    @Override
    default public <T> boolean exists(@NonNull PreparedQuery<T, Boolean> preparedQuery) {
        return this.reactive().exists(preparedQuery).contextWrite(this.getContextView()).blockOptional().orElse(false);
    }

    @Override
    default public <R> Page<R> findPage(@NonNull PagedQuery<R> query) {
        return (Page)this.reactive().findPage(query).contextWrite(this.getContextView()).block();
    }

    @Override
    @NonNull
    default public <T> Iterable<T> findAll(@NonNull PagedQuery<T> query) {
        return (Iterable)this.reactive().findAll(query).contextWrite(this.getContextView()).collectList().block();
    }

    @Override
    default public <T> long count(PagedQuery<T> pagedQuery) {
        return this.reactive().count(pagedQuery).contextWrite(this.getContextView()).blockOptional().orElse(0L);
    }

    @Override
    @NonNull
    default public <T> Stream<T> findStream(@NonNull PagedQuery<T> query) {
        return this.reactive().findAll(query).contextWrite(this.getContextView()).toStream();
    }
}

