/*
 * Copyright 2017-2021 original authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.micronaut.data.model.jpa.criteria.impl.selection;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.jpa.criteria.IExpression;
import io.micronaut.data.model.jpa.criteria.PersistentPropertyPath;
import io.micronaut.data.model.jpa.criteria.impl.SelectionVisitable;

/**
 * The abstract persistent property expression.
 *
 * @param <P> The property type
 * @param <R> The expression type
 * @author Denis Stepanov
 * @since 3.2
 */
@Internal
public abstract class AbstractPersistentPropertyExpression<P, R> implements IExpression<R>, SelectionVisitable {

    protected final PersistentPropertyPath<P> persistentPropertyPath;

    protected AbstractPersistentPropertyExpression(PersistentPropertyPath<P> persistentPropertyPath) {
        this.persistentPropertyPath = persistentPropertyPath;
    }

    public final PersistentProperty getProperty() {
        return persistentPropertyPath.getProperty();
    }

}
