/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.naming;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.data.model.naming.NamingStrategy;
import java.util.Locale;

public class NamingStrategies {

    public static class Raw
    implements NamingStrategy {
        @Override
        @NonNull
        public String mappedName(@NonNull String name) {
            return name;
        }
    }

    public static class UpperCase
    implements NamingStrategy {
        @Override
        @NonNull
        public String mappedName(@NonNull String name) {
            return name.toUpperCase(Locale.ENGLISH);
        }
    }

    public static class LowerCase
    implements NamingStrategy {
        @Override
        @NonNull
        public String mappedName(@NonNull String name) {
            return name.toLowerCase(Locale.ENGLISH);
        }
    }

    public static class KebabCase
    implements NamingStrategy {
        @Override
        @NonNull
        public String mappedName(@NonNull String name) {
            return NameUtils.hyphenate((String)name);
        }
    }

    public static class UnderScoreSeparatedLowerCase
    implements NamingStrategy {
        @Override
        @NonNull
        public String mappedName(@NonNull String name) {
            return NameUtils.underscoreSeparate((String)name).toLowerCase(Locale.ENGLISH);
        }
    }

    public static class UnderScoreSeparatedUpperCase
    implements NamingStrategy {
        @Override
        @NonNull
        public String mappedName(@NonNull String name) {
            return NameUtils.environmentName((String)name);
        }
    }
}

