/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.PersistentAssociationPath;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.naming.NamingStrategy;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.StringJoiner;

public class PersistentPropertyPath {
    private final List<Association> associations;
    private final PersistentProperty property;
    private String path;

    public PersistentPropertyPath(List<Association> associations, @NonNull PersistentProperty property) {
        this(associations, property, null);
    }

    public PersistentPropertyPath(List<Association> associations, @NonNull PersistentProperty property, @Nullable String path) {
        this.associations = associations;
        this.property = property;
        this.path = path;
    }

    public static PersistentPropertyPath of(List<Association> associations, @NonNull PersistentProperty property) {
        return PersistentPropertyPath.of(associations, property, null);
    }

    public static PersistentPropertyPath of(List<Association> associations, @NonNull PersistentProperty property, @Nullable String path) {
        if (property instanceof Association) {
            return new PersistentAssociationPath(associations, (Association)property, path);
        }
        return new PersistentPropertyPath(associations, property, path);
    }

    public Object setPropertyValue(Object bean, Object value) {
        if (!(this.property instanceof RuntimePersistentProperty)) {
            throw new IllegalStateException("Expected runtime property!");
        }
        return this.setProperty(this.associations, (RuntimePersistentProperty)this.property, bean, value);
    }

    private Object setProperty(List<Association> associations, RuntimePersistentProperty property, Object bean, Object value) {
        Object newBean;
        if (associations.isEmpty()) {
            BeanProperty beanProperty = property.getProperty();
            return this.setProperty(beanProperty, bean, value);
        }
        Association association = associations.iterator().next();
        RuntimePersistentProperty p = (RuntimePersistentProperty)((Object)association);
        BeanProperty beanProperty = p.getProperty();
        Object prevBean = beanProperty.get(bean);
        if (prevBean != (newBean = this.setProperty(associations.subList(1, associations.size()), property, prevBean, value))) {
            return this.setProperty(beanProperty, bean, newBean);
        }
        return bean;
    }

    private <X, Y> X setProperty(BeanProperty<X, Y> beanProperty, X x, Y y) {
        if (beanProperty.isReadOnly()) {
            return (X)beanProperty.withValue(x, y);
        }
        beanProperty.set(x, y);
        return x;
    }

    public Object getPropertyValue(Object bean) {
        if (!(this.property instanceof RuntimePersistentProperty)) {
            throw new IllegalStateException("Expected runtime property!");
        }
        Object value = bean;
        for (Association association : this.associations) {
            RuntimePersistentProperty property = (RuntimePersistentProperty)((Object)association);
            BeanProperty beanProperty = property.getProperty();
            value = beanProperty.get(value);
            if (value != null) continue;
            return null;
        }
        RuntimePersistentProperty p = (RuntimePersistentProperty)this.property;
        if (value != null) {
            BeanProperty beanProperty = p.getProperty();
            value = beanProperty.get(value);
        }
        return value;
    }

    @NonNull
    public List<Association> getAssociations() {
        return this.associations;
    }

    @NonNull
    public PersistentProperty getProperty() {
        return this.property;
    }

    @NonNull
    public String getPath() {
        if (this.path == null) {
            if (this.associations.isEmpty()) {
                return this.property.getName();
            }
            StringJoiner joiner = new StringJoiner(".");
            for (Association association : this.associations) {
                joiner.add(association.getName());
            }
            joiner.add(this.property.getName());
            this.path = joiner.toString();
        }
        return this.path;
    }

    public Optional<PersistentEntity> findPropertyOwner() {
        PersistentEntity owner = this.property.getOwner();
        if (!owner.isEmbeddable()) {
            return Optional.of(owner);
        }
        ListIterator<Association> listIterator = this.associations.listIterator(this.associations.size());
        while (listIterator.hasPrevious()) {
            Association association = listIterator.previous();
            if (association.getOwner().isEmbeddable()) continue;
            return Optional.of(association.getOwner());
        }
        return Optional.empty();
    }

    public NamingStrategy getNamingStrategy() {
        PersistentEntity owner = this.property.getOwner();
        if (!owner.isEmbeddable()) {
            return owner.getNamingStrategy();
        }
        Optional<NamingStrategy> namingStrategy = owner.findNamingStrategy();
        if (namingStrategy.isPresent()) {
            return namingStrategy.get();
        }
        ListIterator<Association> listIterator = this.associations.listIterator(this.associations.size());
        while (listIterator.hasPrevious()) {
            Association association = listIterator.previous();
            if (!association.getOwner().isEmbeddable()) {
                return association.getOwner().getNamingStrategy();
            }
            Optional<NamingStrategy> embeddedNamingStrategy = owner.findNamingStrategy();
            if (!embeddedNamingStrategy.isPresent()) continue;
            return embeddedNamingStrategy.get();
        }
        return owner.getNamingStrategy();
    }
}

