/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.intercept;

import io.micronaut.aop.InterceptedMethod;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.BeanLocator;
import io.micronaut.context.Qualifier;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.context.exceptions.NoSuchBeanException;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.util.KotlinUtils;
import io.micronaut.data.annotation.Repository;
import io.micronaut.data.annotation.RepositoryConfiguration;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.exceptions.EmptyResultException;
import io.micronaut.data.intercept.DataInterceptor;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.operations.PrimaryRepositoryOperations;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.inject.qualifiers.Qualifiers;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;

@Singleton
@Internal
public final class DataIntroductionAdvice
implements MethodInterceptor<Object, Object> {
    private final BeanLocator beanLocator;
    private final Map<RepositoryMethodKey, DataInterceptor> interceptorMap = new ConcurrentHashMap<RepositoryMethodKey, DataInterceptor>(20);

    DataIntroductionAdvice(BeanLocator beanLocator) {
        this.beanLocator = beanLocator;
    }

    public Object intercept(MethodInvocationContext<Object, Object> context) {
        RepositoryMethodKey key = new RepositoryMethodKey(context.getTarget(), context.getExecutableMethod());
        DataInterceptor dataInterceptor = this.interceptorMap.get(key);
        if (dataInterceptor != null) {
            return this.intercept(context, dataInterceptor, key);
        }
        String dataSourceName = context.stringValue(Repository.class).orElse(null);
        Class<PrimaryRepositoryOperations> operationsType = context.classValue(RepositoryConfiguration.class, "operations").orElse(PrimaryRepositoryOperations.class);
        Class interceptorType = context.classValue(DataMethod.class, "interceptor").orElse(null);
        if (interceptorType != null && DataInterceptor.class.isAssignableFrom(interceptorType)) {
            DataInterceptor<Object, Object> childInterceptor = this.findInterceptor(dataSourceName, operationsType, interceptorType);
            this.interceptorMap.put(key, childInterceptor);
            return this.intercept(context, childInterceptor, key);
        }
        AnnotationValue declaredAnnotation = context.getDeclaredAnnotation(DataMethod.class);
        if (declaredAnnotation != null && (interceptorType = (Class)declaredAnnotation.classValue("interceptor").orElse(null)) != null && DataInterceptor.class.isAssignableFrom(interceptorType)) {
            DataInterceptor<Object, Object> childInterceptor = this.findInterceptor(dataSourceName, operationsType, interceptorType);
            this.interceptorMap.put(key, childInterceptor);
            return this.intercept(context, childInterceptor, key);
        }
        String interceptorName = context.getAnnotationMetadata().stringValue(DataMethod.class, "interceptor").orElse(null);
        if (interceptorName != null) {
            throw new IllegalStateException("Micronaut Data Interceptor [" + interceptorName + "] is not on the classpath but required by the method: " + context.getExecutableMethod().toString());
        }
        throw new IllegalStateException("Micronaut Data method is missing compilation time query information. Ensure that the Micronaut Data annotation processors are declared in your build and try again with a clean re-build.");
    }

    private Object intercept(MethodInvocationContext<Object, Object> context, DataInterceptor<Object, Object> dataInterceptor, RepositoryMethodKey key) {
        InterceptedMethod interceptedMethod = InterceptedMethod.of(context);
        try {
            Object result = dataInterceptor.intercept(key, context);
            switch (interceptedMethod.resultType()) {
                case PUBLISHER: {
                    return interceptedMethod.handleResult(result);
                }
                case COMPLETION_STAGE: {
                    if (context.isSuspend()) {
                        CompletionStage completionStage = (CompletionStage)result;
                        completionStage.whenComplete((value, throwable) -> {
                            if (throwable == null) {
                                interceptedMethod.handleResult(CompletableFuture.completedFuture(value));
                            } else {
                                if (throwable instanceof CompletionException) {
                                    throwable = throwable.getCause();
                                }
                                if (throwable instanceof EmptyResultException && context.isSuspend() && context.isNullable()) {
                                    interceptedMethod.handleResult(CompletableFuture.completedFuture(null));
                                } else {
                                    CompletableFuture completableFuture = new CompletableFuture();
                                    completableFuture.completeExceptionally((Throwable)throwable);
                                    interceptedMethod.handleResult(completableFuture);
                                }
                            }
                        });
                        return KotlinUtils.COROUTINE_SUSPENDED;
                    }
                    return interceptedMethod.handleResult(result);
                }
                case SYNCHRONOUS: {
                    return result;
                }
            }
            return interceptedMethod.unsupported();
        }
        catch (Exception e) {
            return interceptedMethod.handleException(e);
        }
    }

    @NonNull
    private DataInterceptor<Object, Object> findInterceptor(@Nullable String dataSourceName, @NonNull Class<?> operationsType, @NonNull Class<?> interceptorType) {
        RepositoryOperations datastore;
        if (!RepositoryOperations.class.isAssignableFrom(operationsType)) {
            throw new IllegalArgumentException("Repository type must be an instance of RepositoryOperations!");
        }
        try {
            if (dataSourceName != null) {
                Qualifier qualifier = Qualifiers.byName((String)dataSourceName);
                datastore = (RepositoryOperations)this.beanLocator.getBean(operationsType, qualifier);
            } else {
                datastore = (RepositoryOperations)this.beanLocator.getBean(operationsType);
            }
        }
        catch (NoSuchBeanException e) {
            throw new ConfigurationException("No backing RepositoryOperations configured for repository. Check your configuration and try again", (Throwable)e);
        }
        BeanIntrospection introspection = (BeanIntrospection)BeanIntrospector.SHARED.findIntrospections(ref -> ref.isPresent() && interceptorType.isAssignableFrom(ref.getBeanType())).stream().findFirst().orElseThrow(() -> new DataAccessException("No Data interceptor found for type: " + interceptorType));
        DataInterceptor interceptor = introspection.getConstructorArguments().length == 0 ? (DataInterceptor)introspection.instantiate() : (DataInterceptor)introspection.instantiate(new Object[]{datastore});
        return interceptor;
    }
}

