/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.model.jpa.criteria.IExpression;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.PersistentPropertyPath;
import io.micronaut.data.model.jpa.criteria.impl.LiteralExpression;
import io.micronaut.data.model.jpa.criteria.impl.predicate.ConjunctionPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.DisjunctionPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.PersistentPropertyBinaryPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.PersistentPropertyInValuesPredicate;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.ParameterExpression;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Internal
public final class CriteriaUtils {
    private CriteriaUtils() {
    }

    public static boolean isNumeric(@NonNull Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return Number.class.isAssignableFrom(ReflectionUtils.getPrimitiveType(clazz));
        }
        return Number.class.isAssignableFrom(clazz);
    }

    public static List<IExpression<Boolean>> requireBoolExpressions(Iterable<? extends Expression<?>> restrictions) {
        return CollectionUtils.iterableToList(restrictions).stream().map(CriteriaUtils::requireBoolExpression).collect(Collectors.toList());
    }

    public static IExpression<Boolean> requireBoolExpression(Expression<?> exp) {
        if (exp instanceof IExpression) {
            IExpression expression = (IExpression)exp;
            if (!expression.isBoolean()) {
                throw new IllegalStateException("Expected a boolean expression! Got: " + exp);
            }
            return expression;
        }
        throw new IllegalStateException("Expression is unknown! Got: " + exp);
    }

    public static <T> PersistentPropertyPath<T> requireBoolProperty(Expression<Boolean> exp) {
        if (exp instanceof PersistentPropertyPath) {
            PersistentPropertyPath propertyPath = (PersistentPropertyPath)exp;
            if (!propertyPath.isBoolean()) {
                throw new IllegalStateException("Expected a boolean expression property! Got: " + exp);
            }
            return propertyPath;
        }
        throw new IllegalStateException("Expression is expected to be a property path! Got: " + exp);
    }

    public static <T> PersistentPropertyPath<T> requireNumericProperty(Expression<T> exp) {
        if (exp instanceof PersistentPropertyPath) {
            PersistentPropertyPath propertyPath = (PersistentPropertyPath)exp;
            if (!propertyPath.isNumeric()) {
                throw new IllegalStateException("Expected a numeric expression property! Got: " + exp);
            }
            return propertyPath;
        }
        throw new IllegalStateException("Expression is expected to be a property path! Got: " + exp);
    }

    public static <T> Expression<T> requireNumericPropertyParameterOrLiteral(Expression<T> exp) {
        if ((exp = CriteriaUtils.requirePropertyParameterOrLiteral(exp)) instanceof PersistentPropertyPath) {
            PersistentPropertyPath propertyPath = (PersistentPropertyPath)exp;
            if (!propertyPath.isNumeric()) {
                throw new IllegalStateException("Expected a numeric expression property! Got: " + exp);
            }
            return exp;
        }
        if (exp instanceof ParameterExpression) {
            return exp;
        }
        if (exp instanceof LiteralExpression) {
            return exp;
        }
        return exp;
    }

    public static <T> ParameterExpression<T> requireParameter(Expression<T> exp) {
        if (exp instanceof ParameterExpression) {
            return (ParameterExpression)exp;
        }
        throw new IllegalStateException("Expression is expected to be a parameter! Got: " + exp);
    }

    public static <T> PersistentPropertyPath<T> requireProperty(Expression<T> exp) {
        if (exp instanceof PersistentPropertyPath) {
            return (PersistentPropertyPath)exp;
        }
        throw new IllegalStateException("Expression is expected to be a property path! Got: " + exp);
    }

    public static <T> Expression<T> requirePropertyParameterOrLiteral(Expression<T> exp) {
        if (exp instanceof PersistentPropertyPath || exp instanceof ParameterExpression || exp instanceof LiteralExpression) {
            return exp;
        }
        throw new IllegalStateException("Expression is expected to be a property path, a parameter or literal! Got: " + exp);
    }

    public static <T> IExpression<T> requirePropertyOrRoot(Expression<T> exp) {
        if (exp instanceof PersistentPropertyPath || exp instanceof PersistentEntityRoot) {
            return (IExpression)exp;
        }
        throw new IllegalStateException("Expression is expected to be a property path or a root! Got: " + exp);
    }

    public static IllegalStateException notSupportedOperation() {
        return new IllegalStateException("Not supported operation!");
    }

    public static boolean hasVersionPredicate(Expression<?> predicate) {
        if (predicate instanceof PersistentPropertyBinaryPredicate) {
            PersistentPropertyBinaryPredicate pp = (PersistentPropertyBinaryPredicate)predicate;
            return pp.getProperty() == pp.getProperty().getOwner().getVersion();
        }
        if (predicate instanceof ConjunctionPredicate) {
            ConjunctionPredicate conjunctionPredicate = (ConjunctionPredicate)predicate;
            for (IExpression<Boolean> iExpression : conjunctionPredicate.getPredicates()) {
                if (!CriteriaUtils.hasVersionPredicate(iExpression)) continue;
                return true;
            }
        }
        if (predicate instanceof DisjunctionPredicate) {
            DisjunctionPredicate disjunctionPredicate = (DisjunctionPredicate)predicate;
            for (IExpression<Boolean> iExpression : disjunctionPredicate.getPredicates()) {
                if (!CriteriaUtils.hasVersionPredicate(iExpression)) continue;
                return true;
            }
        }
        return false;
    }

    public static Set<ParameterExpression<?>> extractPredicateParameters(Expression<?> predicate) {
        if (predicate == null) {
            return Collections.emptySet();
        }
        LinkedHashSet properties = new LinkedHashSet();
        CriteriaUtils.extractPredicateParameters(predicate, properties);
        return properties;
    }

    private static void extractPredicateParameters(Expression<?> predicate, Set<ParameterExpression<?>> parameters) {
        block9: {
            block8: {
                if (!(predicate instanceof PersistentPropertyBinaryPredicate)) break block8;
                PersistentPropertyBinaryPredicate pp = (PersistentPropertyBinaryPredicate)predicate;
                if (!(pp.getExpression() instanceof ParameterExpression)) break block9;
                parameters.add((ParameterExpression)pp.getExpression());
                break block9;
            }
            if (predicate instanceof PersistentPropertyInValuesPredicate) {
                PersistentPropertyInValuesPredicate pp = (PersistentPropertyInValuesPredicate)predicate;
                for (Expression<?> expression : pp.getValues()) {
                    if (!(expression instanceof ParameterExpression)) continue;
                    parameters.add((ParameterExpression)expression);
                }
            } else if (predicate instanceof ConjunctionPredicate) {
                ConjunctionPredicate conjunctionPredicate = (ConjunctionPredicate)predicate;
                for (IExpression<Boolean> iExpression : conjunctionPredicate.getPredicates()) {
                    CriteriaUtils.extractPredicateParameters(iExpression, parameters);
                }
            } else if (predicate instanceof DisjunctionPredicate) {
                DisjunctionPredicate disjunctionPredicate = (DisjunctionPredicate)predicate;
                for (IExpression<Boolean> iExpression : disjunctionPredicate.getPredicates()) {
                    CriteriaUtils.extractPredicateParameters(iExpression, parameters);
                }
            }
        }
    }
}

