/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.intercept.annotation;

import io.micronaut.context.annotation.Property;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.intercept.DataInterceptor;
import io.micronaut.data.intercept.annotation.DataMethodQueryParameter;
import io.micronaut.data.model.DataType;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD, ElementType.ANNOTATION_TYPE})
@Internal
@Inherited
public @interface DataMethod {
    public static final String NAME = DataMethod.class.getName();
    public static final String META_MEMBER_EXPANDABLE_QUERY = "expandableQuery";
    public static final String META_MEMBER_EXPANDABLE_COUNT_QUERY = "expandableCountQuery";
    public static final String META_MEMBER_COUNT_QUERY = "countQuery";
    public static final String META_MEMBER_RESULT_TYPE = "resultType";
    public static final String META_MEMBER_RESULT_DATA_TYPE = "resultDataType";
    public static final String META_MEMBER_ROOT_ENTITY = "rootEntity";
    public static final String META_MEMBER_INTERCEPTOR = "interceptor";
    public static final String META_MEMBER_PARAMETER_BINDING = "parameterBinding";
    public static final String META_MEMBER_PARAMETER_BINDING_PATHS = "parameterBindingPaths";
    public static final String META_MEMBER_PARAMETER_AUTO_POPULATED_PROPERTY_PATHS = "parameterBindingAutoPopulatedPaths";
    public static final String META_MEMBER_PARAMETER_AUTO_POPULATED_PREVIOUS_PROPERTY_PATHS = "parameterBindingAutoPopulatedPreviousPaths";
    public static final String META_MEMBER_PARAMETER_AUTO_POPULATED_PREVIOUS_PROPERTY_INDEXES = "parameterBindingAutoPopulatedPrevious";
    public static final String META_MEMBER_ID_TYPE = "idType";
    public static final String META_MEMBER_PAGE_SIZE = "pageSize";
    public static final String META_MEMBER_PAGE_INDEX = "pageIndex";
    public static final String META_MEMBER_ENTITY = "entity";
    public static final String META_MEMBER_ID = "id";
    public static final String META_MEMBER_DTO = "dto";
    public static final String META_MEMBER_OPTIMISTIC_LOCK = "optimisticLock";
    public static final String META_MEMBER_QUERY_BUILDER = "queryBuilder";
    public static final String META_MEMBER_RAW_QUERY = "rawQuery";
    public static final String META_MEMBER_RAW_COUNT_QUERY = "rawCountQuery";
    public static final String META_MEMBER_PARAMETER_TYPE_DEFS = "parameterTypeDefs";
    public static final String META_MEMBER_PARAMETER_CONVERTERS = "parameterConverters";
    public static final String META_MEMBER_PARAMETERS = "parameters";

    public Class<? extends DataInterceptor> interceptor();

    public Class<?> rootEntity() default void.class;

    public Class<?> resultType() default void.class;

    public DataType resultDataType() default DataType.OBJECT;

    public Class<?> idType() default Serializable.class;

    public Property[] parameterBinding() default {};

    public String pageable() default "";

    public String entity() default "";

    public String id() default "";

    public int pageSize() default -1;

    public long pageIndex() default 0L;

    public DataMethodQueryParameter[] parameters() default {};
}

