/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.ReflectiveAccess;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.data.model.DefaultPage;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.Slice;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
@TypeHint(value={Page.class})
@JsonDeserialize(as=DefaultPage.class)
public interface Page<T>
extends Slice<T> {
    public static final Page<?> EMPTY = new DefaultPage(Collections.emptyList(), Pageable.unpaged(), 0L);

    public long getTotalSize();

    default public int getTotalPages() {
        int size = this.getSize();
        return size == 0 ? 1 : (int)Math.ceil((double)this.getTotalSize() / (double)size);
    }

    @Override
    @NonNull
    default public <T2> Page<T2> map(Function<T, T2> function) {
        List content = this.getContent().stream().map(function).collect(Collectors.toList());
        return new DefaultPage(content, this.getPageable(), this.getTotalSize());
    }

    @JsonCreator
    @ReflectiveAccess
    @NonNull
    public static <T> Page<T> of(@JsonProperty(value="content") @NonNull List<T> content, @JsonProperty(value="pageable") @NonNull Pageable pageable, @JsonProperty(value="totalSize") long totalSize) {
        return new DefaultPage<T>(content, pageable, totalSize);
    }

    @NonNull
    public static <T2> Page<T2> empty() {
        return EMPTY;
    }
}

