/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.query.builder;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.query.QueryParameter;

@Internal
public final class QueryParameterBinding {
    private final String key;
    private final String path;
    private final DataType dataType;
    @Nullable
    private final QueryParameter queryParameter;
    private final boolean autoPopulatedUpdatable;

    private QueryParameterBinding(String key, String path, DataType dataType, QueryParameter queryParameter, boolean autoPopulatedUpdatable) {
        this.key = key;
        this.path = path;
        this.dataType = dataType;
        this.queryParameter = queryParameter;
        this.autoPopulatedUpdatable = autoPopulatedUpdatable;
    }

    public static QueryParameterBinding of(String key, String path, DataType dataType) {
        return QueryParameterBinding.of(key, path, dataType, null, false);
    }

    public static QueryParameterBinding of(String key, String path, DataType dataType, boolean autoPopulated) {
        return new QueryParameterBinding(key, path, dataType, null, autoPopulated);
    }

    public static QueryParameterBinding of(String key, String path, DataType dataType, @Nullable QueryParameter queryParameter) {
        return new QueryParameterBinding(key, path, dataType, queryParameter, false);
    }

    public static QueryParameterBinding of(String key, String path, DataType dataType, @Nullable QueryParameter queryParameter, boolean autoPopulated) {
        return new QueryParameterBinding(key, path, dataType, queryParameter, autoPopulated);
    }

    public String getKey() {
        return this.key;
    }

    public String getPath() {
        return this.path;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public boolean isAutoPopulatedUpdatable() {
        return this.autoPopulatedUpdatable;
    }

    @Nullable
    public QueryParameter getQueryParameter() {
        return this.queryParameter;
    }
}

