/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.query.builder;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.reflect.exception.InstantiationException;
import io.micronaut.core.type.Argument;
import io.micronaut.data.annotation.RepositoryConfiguration;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.builder.QueryResult;
import io.micronaut.data.model.query.builder.jpa.JpaQueryBuilder;
import java.util.List;
import java.util.regex.Pattern;

@Introspected
public interface QueryBuilder {
    public static final Pattern VARIABLE_PATTERN = Pattern.compile("([^:])(:([a-zA-Z0-9]+))");
    @Deprecated
    public static final Pattern IN_VARIABLES_PATTERN = Pattern.compile("(?<singleGroup>:[a-zA-Z0-9]+)|(?<inGroup>IN\\((:[a-zA-Z0-9]+)\\))");

    @Nullable
    public QueryResult buildInsert(AnnotationMetadata var1, PersistentEntity var2);

    @NonNull
    default public QueryResult buildQuery(@NonNull QueryModel query) {
        return this.buildQuery(AnnotationMetadata.EMPTY_METADATA, query);
    }

    public QueryResult buildQuery(@NonNull AnnotationMetadata var1, @NonNull QueryModel var2);

    @NonNull
    default public QueryResult buildUpdate(@NonNull QueryModel query, @NonNull List<String> propertiesToUpdate) {
        return this.buildUpdate(AnnotationMetadata.EMPTY_METADATA, query, propertiesToUpdate);
    }

    public QueryResult buildUpdate(@NonNull AnnotationMetadata var1, @NonNull QueryModel var2, @NonNull List<String> var3);

    @NonNull
    default public QueryResult buildDelete(@NonNull QueryModel query) {
        return this.buildDelete(AnnotationMetadata.EMPTY_METADATA, query);
    }

    public QueryResult buildDelete(@NonNull AnnotationMetadata var1, @NonNull QueryModel var2);

    @NonNull
    public QueryResult buildOrderBy(@NonNull PersistentEntity var1, @NonNull Sort var2);

    @NonNull
    public QueryResult buildPagination(@NonNull Pageable var1);

    @NonNull
    public static QueryBuilder newQueryBuilder(@NonNull AnnotationMetadata annotationMetadata) {
        return annotationMetadata.stringValue(RepositoryConfiguration.class, "queryBuilder").flatMap(type -> BeanIntrospector.SHARED.findIntrospections(ref -> ref.isPresent() && ref.getBeanType().getName().equals(type)).stream().findFirst().map(introspection -> {
            try {
                Argument[] constructorArguments = introspection.getConstructorArguments();
                if (constructorArguments.length == 0) {
                    return (QueryBuilder)introspection.instantiate();
                }
                if (constructorArguments.length == 1 && constructorArguments[0].getType() == AnnotationMetadata.class) {
                    return (QueryBuilder)introspection.instantiate(new Object[]{annotationMetadata});
                }
            }
            catch (InstantiationException e) {
                return new JpaQueryBuilder();
            }
            return new JpaQueryBuilder();
        })).orElse(new JpaQueryBuilder());
    }

    default public boolean shouldAliasProjections() {
        return true;
    }

    default public boolean supportsForUpdate() {
        return false;
    }
}

