/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.naming.NamingStrategy;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;

public class PersistentPropertyPath {
    private final List<Association> associations;
    private final PersistentProperty property;
    private final String path;

    public PersistentPropertyPath(List<Association> associations, @NonNull PersistentProperty property, @NonNull String path) {
        this.associations = associations;
        this.property = property;
        this.path = path;
    }

    @NonNull
    public List<Association> getAssociations() {
        return this.associations;
    }

    @NonNull
    public PersistentProperty getProperty() {
        return this.property;
    }

    @NonNull
    public String getPath() {
        return this.path;
    }

    public Optional<PersistentEntity> findPropertyOwner() {
        PersistentEntity owner = this.property.getOwner();
        if (!owner.isEmbeddable()) {
            return Optional.of(owner);
        }
        ListIterator<Association> listIterator = this.associations.listIterator(this.associations.size());
        while (listIterator.hasPrevious()) {
            Association association = listIterator.previous();
            if (association.getOwner().isEmbeddable()) continue;
            return Optional.of(association.getOwner());
        }
        return Optional.empty();
    }

    public NamingStrategy getNamingStrategy() {
        PersistentEntity owner = this.property.getOwner();
        if (!owner.isEmbeddable()) {
            return owner.getNamingStrategy();
        }
        Optional<NamingStrategy> namingStrategy = owner.findNamingStrategy();
        if (namingStrategy.isPresent()) {
            return namingStrategy.get();
        }
        ListIterator<Association> listIterator = this.associations.listIterator(this.associations.size());
        while (listIterator.hasPrevious()) {
            Association association = listIterator.previous();
            if (!association.getOwner().isEmbeddable()) {
                return association.getOwner().getNamingStrategy();
            }
            Optional<NamingStrategy> embeddedNamingStrategy = owner.findNamingStrategy();
            if (!embeddedNamingStrategy.isPresent()) continue;
            return embeddedNamingStrategy.get();
        }
        return owner.getNamingStrategy();
    }
}

