/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.query.builder;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.AutoPopulated;
import io.micronaut.data.annotation.DataTransformer;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.annotation.Where;
import io.micronaut.data.annotation.repeatable.WhereSpecifications;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.Embedded;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.PersistentPropertyPath;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.naming.NamingStrategy;
import io.micronaut.data.model.query.AssociationQuery;
import io.micronaut.data.model.query.JoinPath;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.QueryParameter;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.model.query.builder.QueryParameterBinding;
import io.micronaut.data.model.query.builder.QueryResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;

public abstract class AbstractSqlLikeQueryBuilder
implements QueryBuilder {
    public static final String AUTO_POPULATED_PARAMETER_PREFIX = "$";
    public static final String ORDER_BY_CLAUSE = " ORDER BY ";
    protected static final String SELECT_CLAUSE = "SELECT ";
    protected static final String AS_CLAUSE = " AS ";
    protected static final String FROM_CLAUSE = " FROM ";
    protected static final String WHERE_CLAUSE = " WHERE ";
    protected static final char COMMA = ',';
    protected static final char CLOSE_BRACKET = ')';
    protected static final char OPEN_BRACKET = '(';
    protected static final char SPACE = ' ';
    protected static final char DOT = '.';
    protected static final String NOT_CLAUSE = " NOT";
    protected static final String AND = "AND";
    protected static final String LOGICAL_AND = " AND ";
    protected static final String UPDATE_CLAUSE = "UPDATE ";
    protected static final String DELETE_CLAUSE = "DELETE ";
    protected static final String OR = "OR";
    protected static final String LOGICAL_OR = " OR ";
    protected static final String FUNCTION_COUNT = "COUNT";
    protected static final String AVG = "AVG";
    protected static final String DISTINCT = "DISTINCT";
    protected static final String SUM = "SUM";
    protected static final String MIN = "MIN";
    protected static final String MAX = "MAX";
    protected static final String COUNT_DISTINCT = "COUNT(DISTINCT";
    protected static final String IS_NOT_NULL = " IS NOT NULL ";
    protected static final String IS_EMPTY = " IS EMPTY ";
    protected static final String IS_NOT_EMPTY = " IS NOT EMPTY ";
    protected static final String IS_NULL = " IS NULL ";
    protected static final String EQUALS_TRUE = " = TRUE ";
    protected static final String EQUALS_FALSE = " = FALSE ";
    protected static final String GREATER_THAN_OR_EQUALS = " >= ";
    protected static final String LESS_THAN_OR_EQUALS = " <= ";
    protected static final String LESS_THAN = " < ";
    protected static final String GREATER_THAN = " > ";
    protected static final String EQUALS = " = ";
    protected static final String NOT_EQUALS = " != ";
    protected static final String ALIAS_REPLACE = "@.";
    protected static final String ALIAS_REPLACE_QUOTED = Matcher.quoteReplacement("@.");
    protected final Map<Class, CriterionHandler> queryHandlers = new HashMap<Class, CriterionHandler>(30);

    public AbstractSqlLikeQueryBuilder() {
        this.addCriterionHandler(AssociationQuery.class, this::handleAssociationCriteria);
        this.addCriterionHandler(QueryModel.Negation.class, (ctx, negation) -> {
            ctx.whereClause().append(NOT_CLAUSE).append('(');
            this.handleJunction(ctx, (QueryModel.Junction)negation);
            ctx.whereClause().append(')');
        });
        this.addCriterionHandler(QueryModel.Conjunction.class, (ctx, conjunction) -> {
            ctx.whereClause().append('(');
            this.handleJunction(ctx, (QueryModel.Junction)conjunction);
            ctx.whereClause().append(')');
        });
        this.addCriterionHandler(QueryModel.Disjunction.class, (ctx, disjunction) -> {
            ctx.whereClause().append('(');
            this.handleJunction(ctx, (QueryModel.Junction)disjunction);
            ctx.whereClause().append(')');
        });
        this.addCriterionHandler(QueryModel.Equals.class, this.optionalCaseValueComparison(EQUALS));
        this.addCriterionHandler(QueryModel.NotEquals.class, this.optionalCaseValueComparison(NOT_EQUALS));
        this.addCriterionHandler(QueryModel.EqualsProperty.class, this.comparison("="));
        this.addCriterionHandler(QueryModel.NotEqualsProperty.class, this.comparison("!="));
        this.addCriterionHandler(QueryModel.GreaterThanProperty.class, this.comparison(">"));
        this.addCriterionHandler(QueryModel.GreaterThanEqualsProperty.class, this.comparison(">="));
        this.addCriterionHandler(QueryModel.LessThanProperty.class, this.comparison("<"));
        this.addCriterionHandler(QueryModel.LessThanEqualsProperty.class, this.comparison("<="));
        this.addCriterionHandler(QueryModel.IsNull.class, this.expression(IS_NULL));
        this.addCriterionHandler(QueryModel.IsTrue.class, this.expression(EQUALS_TRUE));
        this.addCriterionHandler(QueryModel.IsFalse.class, this.expression(EQUALS_FALSE));
        this.addCriterionHandler(QueryModel.IsNotNull.class, this.expression(IS_NOT_NULL));
        this.addCriterionHandler(QueryModel.IsEmpty.class, (ctx, isEmpty) -> this.appendEmptyExpression(ctx, " IS NULL OR ", " = '' ", IS_EMPTY, isEmpty.getProperty()));
        this.addCriterionHandler(QueryModel.IsNotEmpty.class, (ctx, isNotEmpty) -> this.appendEmptyExpression(ctx, " IS NOT NULL AND ", " <> '' ", IS_NOT_EMPTY, isNotEmpty.getProperty()));
        this.addCriterionHandler(QueryModel.IdEquals.class, (ctx, idEquals) -> {
            StringBuilder whereClause = ctx.whereClause();
            PersistentEntity persistentEntity = ctx.getPersistentEntity();
            if (persistentEntity.hasCompositeIdentity()) {
                for (PersistentProperty prop : persistentEntity.getCompositeIdentity()) {
                    Object value = idEquals.getValue();
                    if (value instanceof QueryParameter) {
                        QueryParameter qp = (QueryParameter)value;
                        this.appendCriteriaForOperator(whereClause, ctx, this.asQueryPropertyPath(ctx.getCurrentTableAlias(), prop), new QueryParameter(qp.getName() + "." + prop.getName()), EQUALS);
                    }
                    whereClause.append(LOGICAL_AND);
                }
                whereClause.setLength(whereClause.length() - LOGICAL_AND.length());
            } else if (persistentEntity.hasIdentity()) {
                this.appendCriteriaForOperator(whereClause, ctx, ctx.getRequiredProperty("id", idEquals.getClass()), idEquals.getValue(), EQUALS);
            } else {
                throw new IllegalStateException("No ID found for entity: " + persistentEntity.getName());
            }
        });
        this.addCriterionHandler(QueryModel.VersionEquals.class, (ctx, criterion) -> {
            PersistentProperty prop = ctx.getPersistentEntity().getVersion();
            if (prop == null) {
                throw new IllegalStateException("No Version found for entity: " + ctx.getPersistentEntity().getName());
            }
            this.appendCriteriaForOperator(ctx.whereClause(), ctx, this.asQueryPropertyPath(ctx.getCurrentTableAlias(), prop), criterion.getValue(), EQUALS);
        });
        this.addCriterionHandler(QueryModel.GreaterThan.class, this.valueComparison(GREATER_THAN));
        this.addCriterionHandler(QueryModel.LessThanEquals.class, this.valueComparison(LESS_THAN_OR_EQUALS));
        this.addCriterionHandler(QueryModel.GreaterThanEquals.class, this.valueComparison(GREATER_THAN_OR_EQUALS));
        this.addCriterionHandler(QueryModel.LessThan.class, this.valueComparison(LESS_THAN));
        this.addCriterionHandler(QueryModel.Like.class, this.valueComparison(" like "));
        this.addCriterionHandler(QueryModel.ILike.class, this.caseInsensitiveValueComparison(" like "));
        this.addCriterionHandler(QueryModel.Between.class, (ctx, between) -> {
            QueryPropertyPath prop = ctx.getRequiredProperty((QueryModel.PropertyNameCriterion)between);
            String fromParam = ctx.addParameter(prop.getProperty(), prop.getPath(), between.getFrom());
            String toParam = ctx.addParameter(prop.getProperty(), prop.getPath(), between.getTo());
            StringBuilder whereClause = ctx.whereClause();
            whereClause.append('(');
            this.appendPropertyRef(whereClause, prop);
            whereClause.append(GREATER_THAN_OR_EQUALS).append(fromParam).append(LOGICAL_AND);
            this.appendPropertyRef(whereClause, prop);
            whereClause.append(LESS_THAN_OR_EQUALS).append(toParam).append(')');
        });
        this.addCriterionHandler(QueryModel.StartsWith.class, this.valueComparison(this::formatStartsWithBeginning, this::formatEndsWith));
        this.addCriterionHandler(QueryModel.Contains.class, this.valueComparison(this::formatStartsWith, this::formatEndsWith));
        this.addCriterionHandler(QueryModel.EndsWith.class, this.valueComparison(this::formatStartsWith, this::formEndsWithEnd));
        this.addCriterionHandler(QueryModel.In.class, (ctx, inQuery) -> {
            QueryPropertyPath propertyPath = ctx.getRequiredProperty(inQuery.getProperty(), QueryModel.In.class);
            String placeholder = ctx.addParameter(propertyPath.getProperty(), propertyPath.getPath(), (QueryParameter)inQuery.getValue());
            StringBuilder whereClause = ctx.whereClause();
            this.appendPropertyRef(whereClause, propertyPath);
            this.encodeInExpression(whereClause, placeholder);
        });
        this.addCriterionHandler(QueryModel.NotIn.class, (ctx, notIn) -> this.handleSubQuery(ctx, (QueryModel.SubqueryCriterion)notIn, " NOT IN ("));
    }

    private <T extends QueryModel.PropertyCriterion> CriterionHandler<T> valueComparison(Supplier<String> prefix, Supplier<String> suffix) {
        return (ctx, propertyCriterion) -> {
            QueryPropertyPath propertyPath = ctx.getRequiredProperty((QueryModel.PropertyNameCriterion)propertyCriterion);
            String placeholder = ctx.addParameter(propertyPath.getProperty(), propertyPath.getPath(), (QueryParameter)propertyCriterion.getValue());
            this.appendPropertyRef(ctx.whereClause(), propertyPath);
            ctx.whereClause().append((String)prefix.get()).append(placeholder).append((String)suffix.get());
        };
    }

    private <T extends QueryModel.PropertyCriterion> CriterionHandler<T> valueComparison(String op) {
        return (ctx, propertyCriterion) -> {
            QueryPropertyPath prop = ctx.getRequiredProperty((QueryModel.PropertyNameCriterion)propertyCriterion);
            this.appendCriteriaForOperator(ctx.whereClause(), ctx, prop, propertyCriterion.getValue(), op);
        };
    }

    private <T extends QueryModel.PropertyCriterion> CriterionHandler<T> optionalCaseValueComparison(String op) {
        return (ctx, propertyCriterion) -> {
            if (propertyCriterion.isIgnoreCase()) {
                this.appendCaseInsensitiveCriterion(ctx, (QueryModel.PropertyCriterion)propertyCriterion, op);
            } else {
                this.valueComparison(op).handle(ctx, (QueryModel.PropertyCriterion)propertyCriterion);
            }
        };
    }

    private <T extends QueryModel.PropertyCriterion> CriterionHandler<T> caseInsensitiveValueComparison(String op) {
        return (ctx, propertyCriterion) -> this.appendCaseInsensitiveCriterion(ctx, (QueryModel.PropertyCriterion)propertyCriterion, op);
    }

    private <T extends QueryModel.PropertyComparisonCriterion> CriterionHandler<T> comparison(String operator) {
        return (ctx, comparisonCriterion) -> this.appendPropertyComparison(ctx, (QueryModel.PropertyComparisonCriterion)comparisonCriterion, operator);
    }

    private <T extends QueryModel.PropertyNameCriterion> CriterionHandler<T> expression(String expression) {
        return (ctx, expressionCriterion) -> {
            this.appendPropertyRef(ctx.whereClause(), ctx.getRequiredProperty((QueryModel.PropertyNameCriterion)expressionCriterion));
            ctx.whereClause().append(expression);
        };
    }

    private QueryPropertyPath asQueryPropertyPath(String tableAlias, PersistentProperty persistentProperty) {
        return new QueryPropertyPath(this.asPersistentPropertyPath(persistentProperty), tableAlias);
    }

    private PersistentPropertyPath asPersistentPropertyPath(PersistentProperty persistentProperty) {
        return new PersistentPropertyPath(Collections.emptyList(), persistentProperty, persistentProperty.getName());
    }

    protected String formEndsWithEnd() {
        return ")";
    }

    protected String formatStartsWithBeginning() {
        return " LIKE CONCAT(";
    }

    protected String formatEndsWith() {
        return ",'%')";
    }

    protected String formatStartsWith() {
        return " LIKE CONCAT('%',";
    }

    private void appendEmptyExpression(CriteriaContext ctx, String charSequencePrefix, String charSequenceSuffix, String listSuffix, String name) {
        QueryPropertyPath propertyPath = ctx.getRequiredProperty(name, QueryModel.IsEmpty.class);
        StringBuilder whereClause = ctx.whereClause();
        if (propertyPath.getProperty().isAssignable(CharSequence.class)) {
            this.appendPropertyRef(whereClause, propertyPath);
            whereClause.append(charSequencePrefix);
            this.appendPropertyRef(whereClause, propertyPath);
            whereClause.append(charSequenceSuffix);
        } else {
            this.appendPropertyRef(whereClause, propertyPath);
            whereClause.append(listSuffix);
        }
    }

    private void encodeInExpression(StringBuilder whereClause, String placeholder) {
        whereClause.append(" IN (").append(placeholder).append(')');
    }

    @Override
    public QueryResult buildQuery(@NonNull AnnotationMetadata annotationMetadata, @NonNull QueryModel query) {
        ArgumentUtils.requireNonNull((String)"annotationMetadata", (Object)annotationMetadata);
        ArgumentUtils.requireNonNull((String)"query", (Object)query);
        QueryState queryState = this.newQueryState(query, true, true);
        Collection<JoinPath> joinPaths = query.getJoinPaths();
        for (JoinPath joinPath : joinPaths) {
            queryState.applyJoin(joinPath);
        }
        StringBuilder select = new StringBuilder(SELECT_CLAUSE);
        this.buildSelectClause(query, queryState, select);
        this.appendForUpdate(QueryPosition.AFTER_TABLE_NAME, query, select);
        queryState.getQuery().insert(0, select.toString());
        QueryModel.Junction criteria = query.getCriteria();
        if (!criteria.isEmpty() || annotationMetadata.hasStereotype(WhereSpecifications.class) || queryState.getEntity().getAnnotationMetadata().hasStereotype(WhereSpecifications.class)) {
            this.buildWhereClause(annotationMetadata, criteria, queryState);
        }
        this.appendOrder(query, queryState);
        this.appendForUpdate(QueryPosition.END_OF_QUERY, query, queryState.getQuery());
        return QueryResult.of(queryState.getQuery().toString(), queryState.getParameterBindings(), queryState.getAdditionalRequiredParameters());
    }

    protected abstract String getTableName(PersistentEntity var1);

    protected String getUnescapedTableName(PersistentEntity entity) {
        return entity.getPersistedName();
    }

    protected String getAliasName(PersistentEntity entity) {
        return entity.getAnnotationMetadata().stringValue(MappedEntity.class, "alias").orElseGet(() -> this.getTableName(entity) + "_");
    }

    public String getAliasName(JoinPath joinPath) {
        return joinPath.getAlias().orElseGet(() -> {
            String joinPathAlias = this.getPathOnlyAliasName(joinPath);
            PersistentEntity owner = joinPath.getAssociationPath()[0].getOwner();
            String ownerAlias = this.getAliasName(owner);
            if (ownerAlias.endsWith("_") && joinPathAlias.startsWith("_")) {
                return ownerAlias + joinPathAlias.substring(1);
            }
            return ownerAlias + joinPathAlias;
        });
    }

    @NonNull
    protected String getPathOnlyAliasName(JoinPath joinPath) {
        return joinPath.getAlias().orElseGet(() -> {
            String p = joinPath.getPath().replace('.', '_');
            return NamingStrategy.DEFAULT.mappedName(p) + "_";
        });
    }

    protected abstract String[] buildJoin(String var1, JoinPath var2, String var3, StringBuilder var4, Map<String, String> var5, QueryState var6);

    protected abstract String getColumnName(PersistentProperty var1);

    protected abstract void selectAllColumns(QueryState var1, StringBuilder var2);

    protected abstract void selectAllColumns(PersistentEntity var1, String var2, StringBuilder var3);

    private QueryState newQueryState(@NonNull QueryModel query, boolean allowJoins, boolean useAlias) {
        return new QueryState(query, allowJoins, useAlias);
    }

    private void buildSelectClause(QueryModel query, QueryState queryState, StringBuilder queryString) {
        String logicalName = queryState.getRootAlias();
        PersistentEntity entity = queryState.getEntity();
        this.buildSelect(queryState, queryString, query.getProjections(), logicalName, entity);
        String tableName = this.getTableName(entity);
        queryString.append(FROM_CLAUSE).append(tableName).append(this.getTableAsKeyword()).append(logicalName);
    }

    protected boolean shouldEscape(@NonNull PersistentEntity entity) {
        return entity.getAnnotationMetadata().booleanValue(MappedEntity.class, "escape").orElse(true);
    }

    protected String getTableAsKeyword() {
        return AS_CLAUSE;
    }

    protected String quote(String persistedName) {
        return "\"" + persistedName + "\"";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void buildSelect(QueryState queryState, StringBuilder queryString, List<QueryModel.Projection> projectionList, String tableAlias, PersistentEntity entity) {
        if (projectionList.isEmpty()) {
            this.selectAllColumns(queryState, queryString);
            return;
        } else {
            Iterator<QueryModel.Projection> i = projectionList.iterator();
            while (i.hasNext()) {
                QueryModel.Projection projection = i.next();
                if (projection instanceof QueryModel.CountProjection) {
                    this.appendProjectionRowCount(queryString, tableAlias);
                } else if (projection instanceof QueryModel.DistinctProjection) {
                    queryString.append("DISTINCT(").append(tableAlias).append(')');
                } else if (projection instanceof QueryModel.IdProjection) {
                    if (entity.hasCompositeIdentity()) {
                        for (PersistentProperty identity : entity.getCompositeIdentity()) {
                            this.appendPropertyProjection(queryString, this.asQueryPropertyPath(queryState.getRootAlias(), identity));
                            queryString.append(',');
                        }
                        queryString.setLength(queryString.length() - 1);
                    } else {
                        if (!entity.hasIdentity()) throw new IllegalArgumentException("Cannot query on ID with entity that has no ID");
                        PersistentProperty identity = entity.getIdentity();
                        if (identity == null) {
                            throw new IllegalArgumentException("Cannot query on ID with entity that has no ID");
                        }
                        this.appendPropertyProjection(queryString, this.asQueryPropertyPath(queryState.getRootAlias(), identity));
                    }
                } else if (projection instanceof QueryModel.PropertyProjection) {
                    QueryModel.PropertyProjection pp = (QueryModel.PropertyProjection)projection;
                    String alias = pp.getAlias().orElse(null);
                    if (projection instanceof QueryModel.AvgProjection) {
                        this.appendFunctionProjection(queryState.getEntity(), AVG, pp, tableAlias, queryString);
                    } else if (projection instanceof QueryModel.DistinctPropertyProjection) {
                        this.appendFunctionProjection(queryState.getEntity(), DISTINCT, pp, tableAlias, queryString);
                    } else if (projection instanceof QueryModel.SumProjection) {
                        this.appendFunctionProjection(queryState.getEntity(), SUM, pp, tableAlias, queryString);
                    } else if (projection instanceof QueryModel.MinProjection) {
                        this.appendFunctionProjection(queryState.getEntity(), MIN, pp, tableAlias, queryString);
                    } else if (projection instanceof QueryModel.MaxProjection) {
                        this.appendFunctionProjection(queryState.getEntity(), MAX, pp, tableAlias, queryString);
                    } else if (projection instanceof QueryModel.CountDistinctProjection) {
                        this.appendFunctionProjection(queryState.getEntity(), COUNT_DISTINCT, pp, tableAlias, queryString);
                        queryString.append(')');
                    } else {
                        String propertyName = pp.getPropertyName();
                        PersistentPropertyPath propertyPath = entity.getPropertyPath(propertyName);
                        if (propertyPath == null) {
                            throw new IllegalArgumentException("Cannot project on non-existent property: " + propertyName);
                        }
                        PersistentProperty property = propertyPath.getProperty();
                        if (property instanceof Association && !(property instanceof Embedded)) {
                            String joinAlias = queryState.computeAlias(propertyPath.getPath());
                            this.selectAllColumns(((Association)property).getAssociatedEntity(), joinAlias, queryString);
                        } else {
                            this.appendPropertyProjection(queryString, this.findProperty(queryState, propertyName, null));
                        }
                    }
                    if (alias != null) {
                        queryString.append(AS_CLAUSE).append(alias);
                    }
                }
                if (!i.hasNext()) continue;
                queryString.append(',');
            }
        }
    }

    private void appendPropertyProjection(StringBuilder sb, QueryPropertyPath propertyPath) {
        if (!this.computePropertyPaths()) {
            sb.append(propertyPath.getTableAlias()).append('.').append(propertyPath.getPath());
            return;
        }
        String tableAlias = propertyPath.getTableAlias();
        boolean escape = propertyPath.shouldEscape();
        NamingStrategy namingStrategy = propertyPath.getNamingStrategy();
        int length = sb.length();
        this.traversePersistentProperties(propertyPath.getAssociations(), propertyPath.getProperty(), (associations, property) -> {
            String columnName = namingStrategy.mappedName((List<Association>)associations, (PersistentProperty)property);
            if (escape) {
                columnName = this.quote(columnName);
            }
            sb.append(tableAlias).append('.').append(columnName).append(',');
        });
        int newLength = sb.length();
        if (length != newLength) {
            sb.setLength(newLength - 1);
        }
    }

    private void appendFunctionProjection(PersistentEntity entity, String functionName, QueryModel.PropertyProjection propertyProjection, String tableAlias, StringBuilder queryString) {
        String columnName;
        PersistentPropertyPath propertyPath = entity.getPropertyPath(propertyProjection.getPropertyName());
        if (propertyPath == null) {
            throw new IllegalArgumentException("Cannot project on non-existent property: " + propertyProjection.getPropertyName());
        }
        if (this.computePropertyPaths()) {
            columnName = entity.getNamingStrategy().mappedName(propertyPath.getAssociations(), propertyPath.getProperty());
            if (this.shouldEscape(entity)) {
                columnName = this.quote(columnName);
            }
        } else {
            columnName = propertyPath.getPath();
        }
        queryString.append(functionName).append('(').append(tableAlias).append('.').append(columnName).append(')');
    }

    protected abstract void appendProjectionRowCount(StringBuilder var1, String var2);

    private void handleAssociationCriteria(final CriteriaContext ctx, AssociationQuery associationQuery) {
        final QueryState queryState = ctx.getQueryState();
        Association association = associationQuery.getAssociation();
        if (association == null) {
            return;
        }
        final String associationPath = associationQuery.getPath();
        CriteriaContext associatedContext = new CriteriaContext(){

            @Override
            public String getCurrentTableAlias() {
                return ctx.getCurrentTableAlias();
            }

            @Override
            public QueryState getQueryState() {
                return ctx.getQueryState();
            }

            @Override
            public PersistentEntity getPersistentEntity() {
                return ctx.getPersistentEntity();
            }

            @Override
            public QueryPropertyPath getRequiredProperty(String name, Class<?> criterionClazz) {
                if (StringUtils.isNotEmpty((CharSequence)associationPath)) {
                    name = associationPath + '.' + name;
                }
                return AbstractSqlLikeQueryBuilder.this.findPropertyInternal(queryState, this.getPersistentEntity(), this.getCurrentTableAlias(), name, criterionClazz);
            }
        };
        this.handleJunction(associatedContext, associationQuery.getCriteria());
    }

    private void buildWhereClause(AnnotationMetadata annotationMetadata, QueryModel.Junction criteria, final QueryState queryState) {
        StringBuilder whereClause = queryState.getWhereClause();
        StringBuilder queryClause = queryState.getQuery();
        if (!criteria.isEmpty()) {
            whereClause.append(WHERE_CLAUSE);
            if (criteria instanceof QueryModel.Negation) {
                whereClause.append(NOT_CLAUSE);
            }
            CriteriaContext ctx = new CriteriaContext(){

                @Override
                public String getCurrentTableAlias() {
                    return queryState.getRootAlias();
                }

                @Override
                public QueryState getQueryState() {
                    return queryState;
                }

                @Override
                public PersistentEntity getPersistentEntity() {
                    return queryState.getEntity();
                }

                @Override
                public QueryPropertyPath getRequiredProperty(String name, Class<?> criterionClazz) {
                    return AbstractSqlLikeQueryBuilder.this.findProperty(queryState, name, criterionClazz);
                }
            };
            whereClause.append('(');
            this.handleJunction(ctx, criteria);
            String whereStr = whereClause.toString();
            String additionalWhere = this.buildAdditionalWhereString(queryState.getRootAlias(), queryState.getEntity(), annotationMetadata);
            if (StringUtils.isNotEmpty((CharSequence)additionalWhere)) {
                StringBuffer additionalWhereBuilder = new StringBuffer();
                Matcher matcher = QueryBuilder.VARIABLE_PATTERN.matcher(additionalWhere);
                while (matcher.find()) {
                    String name = matcher.group(3);
                    String placeholder = queryState.addAdditionalRequiredParameter(name);
                    matcher.appendReplacement(additionalWhereBuilder, placeholder);
                }
                matcher.appendTail(additionalWhereBuilder);
                additionalWhere = additionalWhereBuilder.toString();
            }
            if (whereStr.equals(" WHERE (")) {
                if (StringUtils.isNotEmpty((CharSequence)additionalWhere)) {
                    queryClause.append(whereStr).append(additionalWhere).append(')');
                }
            } else {
                queryClause.append(whereStr);
                if (StringUtils.isNotEmpty((CharSequence)additionalWhere)) {
                    queryClause.append(LOGICAL_AND).append('(').append(additionalWhere).append(')');
                }
                queryClause.append(')');
            }
        } else {
            String additionalWhereString = this.buildAdditionalWhereString(queryState.getRootAlias(), queryState.getEntity(), annotationMetadata);
            if (StringUtils.isNotEmpty((CharSequence)additionalWhereString)) {
                whereClause.append(WHERE_CLAUSE).append('(').append(additionalWhereString).append(')');
                queryClause.append(whereClause.toString());
            }
        }
    }

    private String buildAdditionalWhereString(String alias, PersistentEntity entity, AnnotationMetadata annotationMetadata) {
        String whereStr = this.resolveWhereForAnnotationMetadata(alias, annotationMetadata);
        if (StringUtils.isNotEmpty((CharSequence)whereStr)) {
            return whereStr;
        }
        return this.resolveWhereForAnnotationMetadata(alias, entity.getAnnotationMetadata());
    }

    private String resolveWhereForAnnotationMetadata(String alias, AnnotationMetadata annotationMetadata) {
        return annotationMetadata.getAnnotationValuesByType(Where.class).stream().map(av -> av.stringValue().orElse(null)).map(val -> this.replaceAlias(alias, (String)val)).filter(StringUtils::isNotEmpty).collect(Collectors.joining(LOGICAL_AND));
    }

    private void appendOrder(QueryModel query, QueryState queryState) {
        List<Sort.Order> orders = query.getSort().getOrderBy();
        if (!orders.isEmpty()) {
            StringBuilder buff = queryState.getQuery();
            buff.append(ORDER_BY_CLAUSE);
            Iterator<Sort.Order> i = orders.iterator();
            while (i.hasNext()) {
                Sort.Order order = i.next();
                QueryPropertyPath propertyPath = this.findProperty(queryState, order.getProperty(), Sort.Order.class);
                String currentAlias = propertyPath.getTableAlias();
                if (currentAlias != null) {
                    buff.append(currentAlias).append('.');
                }
                if (this.computePropertyPaths()) {
                    buff.append(propertyPath.getColumnName()).append(' ').append(order.getDirection().toString());
                } else {
                    buff.append(propertyPath.getPath()).append(' ').append(order.getDirection().toString());
                }
                if (!i.hasNext()) continue;
                buff.append(",");
            }
        }
    }

    protected void appendForUpdate(QueryPosition queryPosition, QueryModel query, StringBuilder queryBuilder) {
    }

    private void handleJunction(CriteriaContext ctx, QueryModel.Junction criteria) {
        StringBuilder whereClause = ctx.whereClause();
        int length = whereClause.length();
        String operator = criteria instanceof QueryModel.Conjunction ? LOGICAL_AND : LOGICAL_OR;
        for (QueryModel.Criterion criterion : criteria.getCriteria()) {
            CriterionHandler criterionHandler = this.queryHandlers.get(criterion.getClass());
            if (criterionHandler == null) {
                throw new IllegalArgumentException("Queries of type " + criterion.getClass().getSimpleName() + " are not supported by this implementation");
            }
            int beforeHandleLength = whereClause.length();
            criterionHandler.handle(ctx, criterion);
            if (beforeHandleLength == whereClause.length()) continue;
            whereClause.append(operator);
        }
        int newLength = whereClause.length();
        if (newLength != length) {
            whereClause.setLength(newLength - operator.length());
        }
    }

    private void appendCriteriaForOperator(StringBuilder whereClause, PropertyParameterCreator propertyParameterCreator, QueryPropertyPath propertyPath, Object value, String operator) {
        if (value instanceof QueryParameter) {
            QueryParameter queryParameter = (QueryParameter)value;
            boolean computePropertyPaths = this.computePropertyPaths();
            if (!computePropertyPaths) {
                String placeholder = propertyParameterCreator.addParameter(propertyPath.getProperty(), propertyPath.getPath(), queryParameter);
                this.appendPropertyRef(whereClause, propertyPath);
                whereClause.append(operator).append(placeholder);
                return;
            }
            String currentAlias = propertyPath.getTableAlias();
            NamingStrategy namingStrategy = propertyPath.getNamingStrategy();
            boolean shouldEscape = propertyPath.shouldEscape();
            int length = whereClause.length();
            String rootPath = this.asPath(propertyPath.getAssociations(), propertyPath.getProperty());
            this.traversePersistentProperties(propertyPath.getAssociations(), propertyPath.getProperty(), (associations, property) -> {
                String readTransformer = this.getDataTransformerReadValue(currentAlias, (PersistentProperty)property).orElse(null);
                if (readTransformer != null) {
                    whereClause.append(readTransformer);
                } else {
                    if (currentAlias != null) {
                        whereClause.append(currentAlias).append('.');
                    }
                    String columnName = namingStrategy.mappedName((List<Association>)associations, (PersistentProperty)property);
                    if (shouldEscape) {
                        columnName = this.quote(columnName);
                    }
                    whereClause.append(columnName);
                }
                String path = this.asPath((List<Association>)associations, (PersistentProperty)property);
                if (path.startsWith(rootPath)) {
                    path = queryParameter.getName() + path.substring(rootPath.length());
                }
                String placeholder = propertyParameterCreator.addParameter((PersistentProperty)property, this.asPath((List<Association>)associations, (PersistentProperty)property), new QueryParameter(path));
                whereClause.append(operator).append(placeholder).append(LOGICAL_AND);
            });
            int newLength = whereClause.length();
            if (newLength != length) {
                whereClause.setLength(newLength - LOGICAL_AND.length());
            }
        } else {
            throw new IllegalStateException("Unknown value: " + value);
        }
    }

    private void appendPropertyRef(StringBuilder sb, QueryPropertyPath propertyPath) {
        boolean computePropertyPaths;
        String tableAlias = propertyPath.getTableAlias();
        String readTransformer = this.getDataTransformerReadValue(tableAlias, propertyPath.getProperty()).orElse(null);
        if (readTransformer != null) {
            sb.append(readTransformer);
            return;
        }
        if (tableAlias != null) {
            sb.append(tableAlias).append('.');
        }
        if (computePropertyPaths = this.computePropertyPaths()) {
            sb.append(propertyPath.getColumnName());
        } else {
            sb.append(propertyPath.getPath());
        }
    }

    private void appendCaseInsensitiveCriterion(CriteriaContext ctx, QueryModel.PropertyCriterion criterion, String operator) {
        QueryPropertyPath propertyPath = ctx.getRequiredProperty(criterion);
        String placeholder = ctx.addParameter(propertyPath.getProperty(), propertyPath.getPath(), (QueryParameter)criterion.getValue());
        StringBuilder whereClause = ctx.whereClause();
        whereClause.append("lower(");
        this.appendPropertyRef(whereClause, propertyPath);
        whereClause.append(")").append(operator).append("lower(").append(placeholder).append(")");
    }

    protected void handleSubQuery(CriteriaContext ctx, QueryModel.SubqueryCriterion subqueryCriterion, String comparisonExpression) {
        QueryPropertyPath propertyPath = ctx.getRequiredProperty(subqueryCriterion.getProperty(), QueryModel.In.class);
        StringBuilder whereClause = ctx.whereClause();
        this.appendPropertyRef(whereClause, propertyPath);
        whereClause.append(comparisonExpression);
        whereClause.append(')');
    }

    private void buildUpdateStatement(QueryState queryState, List<String> propertiesToUpdate) {
        int newLength;
        StringBuilder queryString = queryState.getQuery();
        queryString.append(' ').append("SET").append(' ');
        List properties = propertiesToUpdate.stream().map(property -> {
            QueryPropertyPath propertyPath = this.findProperty(queryState, (String)property, null);
            if (propertyPath.getProperty() instanceof Association && ((Association)propertyPath.getProperty()).isForeignKey()) {
                throw new IllegalArgumentException("Foreign key associations cannot be updated as part of a batch update statement");
            }
            return propertyPath;
        }).filter(propertyPath -> !propertyPath.getProperty().isGenerated()).collect(Collectors.toList());
        int length = queryString.length();
        if (!this.computePropertyPaths()) {
            for (QueryPropertyPath propertyPath2 : properties) {
                PersistentProperty prop = propertyPath2.getProperty();
                String placeholder = queryState.addParameter(prop, propertyPath2.getPath());
                String tableAlias = propertyPath2.getTableAlias();
                if (tableAlias != null) {
                    queryString.append(tableAlias).append('.');
                }
                queryString.append(propertyPath2.getPath()).append('=');
                this.appendUpdateSetParameter(queryString, tableAlias, prop, placeholder);
                queryString.append(',');
            }
        } else {
            NamingStrategy namingStrategy = queryState.getEntity().getNamingStrategy();
            for (QueryPropertyPath propertyPath3 : properties) {
                this.traversePersistentProperties(propertyPath3.getAssociations(), propertyPath3.getProperty(), (associations, property) -> {
                    String placeholder = queryState.addParameter((PersistentProperty)property, this.asPath((List<Association>)associations, (PersistentProperty)property));
                    String tableAlias = propertyPath3.getTableAlias();
                    if (tableAlias != null) {
                        queryString.append(tableAlias).append('.');
                    }
                    String columnName = namingStrategy.mappedName((List<Association>)associations, (PersistentProperty)property);
                    if (queryState.escape) {
                        columnName = this.quote(columnName);
                    }
                    queryString.append(columnName).append('=');
                    this.appendUpdateSetParameter(queryString, tableAlias, (PersistentProperty)property, placeholder);
                    queryString.append(',');
                });
            }
        }
        if (length != (newLength = queryString.length())) {
            queryString.setLength(newLength - 1);
        }
    }

    protected boolean isExpandEmbedded() {
        return false;
    }

    protected void appendUpdateSetParameter(StringBuilder sb, String alias, PersistentProperty prop, String placeholder) {
        sb.append(this.getDataTransformerWriteValue(alias, prop).orElse(placeholder));
    }

    private void appendPropertyComparison(CriteriaContext ctx, QueryModel.PropertyComparisonCriterion comparisonCriterion, String operator) {
        StringBuilder sb = ctx.whereClause();
        this.appendPropertyRef(sb, ctx.getRequiredProperty(comparisonCriterion.getProperty(), comparisonCriterion.getClass()));
        sb.append(operator);
        this.appendPropertyRef(sb, ctx.getRequiredProperty(comparisonCriterion.getOtherProperty(), comparisonCriterion.getClass()));
    }

    @NonNull
    private QueryPropertyPath findProperty(QueryState queryState, String name, Class criterionType) {
        return this.findPropertyInternal(queryState, queryState.getEntity(), queryState.getRootAlias(), name, criterionType);
    }

    private QueryPropertyPath findPropertyInternal(QueryState queryState, PersistentEntity entity, String tableAlias, String name, Class criterionType) {
        PersistentPropertyPath propertyPath = entity.getPropertyPath(name);
        if (propertyPath != null) {
            if (propertyPath.getAssociations().isEmpty()) {
                return new QueryPropertyPath(propertyPath, tableAlias);
            }
            Association joinAssociation = null;
            StringJoiner joinPathJoiner = new StringJoiner(".");
            for (Association association : propertyPath.getAssociations()) {
                joinPathJoiner.add(association.getName());
                if (association instanceof Embedded) continue;
                if (joinAssociation == null) {
                    joinAssociation = association;
                    continue;
                }
                if (association != joinAssociation.getAssociatedEntity().getIdentity()) {
                    if (!queryState.isAllowJoins()) {
                        throw new IllegalArgumentException("Joins cannot be used in a DELETE or UPDATE operation");
                    }
                    String joinStringPath = joinPathJoiner.toString();
                    String joinAlias = this.joinInPath(queryState, joinStringPath);
                    String joinedPropertyName = name.replaceFirst(Pattern.quote(joinStringPath + '.'), "");
                    return this.findPropertyInternal(queryState, joinAssociation.getAssociatedEntity(), joinAlias, joinedPropertyName, criterionType);
                }
                joinAssociation = null;
            }
            PersistentProperty property = propertyPath.getProperty();
            if (joinAssociation != null && property != joinAssociation.getAssociatedEntity().getIdentity()) {
                String joinAlias = this.joinInPath(queryState, joinPathJoiner.toString());
                return new QueryPropertyPath(new PersistentPropertyPath(Collections.emptyList(), property, property.getName()), joinAlias);
            }
        } else if ("id".equals(name) && entity.getIdentity() != null) {
            return new QueryPropertyPath(new PersistentPropertyPath(Collections.emptyList(), entity.getIdentity(), entity.getIdentity().getName()), queryState.getRootAlias());
        }
        if (propertyPath == null) {
            if (criterionType == null || criterionType == Sort.Order.class) {
                throw new IllegalArgumentException("Cannot order on non-existent property path: " + name);
            }
            throw new IllegalArgumentException("Cannot use [" + criterionType.getSimpleName() + "] criterion on non-existent property path: " + name);
        }
        return new QueryPropertyPath(propertyPath, tableAlias);
    }

    private String joinInPath(QueryState queryState, String joinStringPath) {
        QueryModel queryModel = queryState.getQueryModel();
        JoinPath joinPath = queryModel.getJoinPath(joinStringPath).orElse(null);
        if (joinPath == null) {
            joinPath = queryModel.join(joinStringPath, Join.Type.DEFAULT, null);
        }
        if (queryState.isAllowJoins()) {
            return queryState.applyJoin(joinPath);
        }
        throw new IllegalArgumentException("Joins are not allowed for batch update queries");
    }

    protected abstract boolean computePropertyPaths();

    @Override
    public QueryResult buildUpdate(@NonNull AnnotationMetadata annotationMetadata, @NonNull QueryModel query, @NonNull List<String> propertiesToUpdate) {
        if (propertiesToUpdate.isEmpty()) {
            throw new IllegalArgumentException("No properties specified to update");
        }
        PersistentEntity entity = query.getPersistentEntity();
        QueryState queryState = this.newQueryState(query, false, this.isAliasForBatch());
        StringBuilder queryString = queryState.getQuery();
        String tableAlias = queryState.getRootAlias();
        String tableName = this.getTableName(entity);
        queryString.append(UPDATE_CLAUSE).append(tableName);
        if (tableAlias != null) {
            queryString.append(' ').append(tableAlias);
        }
        this.buildUpdateStatement(queryState, propertiesToUpdate);
        this.buildWhereClause(annotationMetadata, query.getCriteria(), queryState);
        return QueryResult.of(queryState.getQuery().toString(), queryState.getParameterBindings(), queryState.getAdditionalRequiredParameters());
    }

    @Override
    public QueryResult buildDelete(@NonNull AnnotationMetadata annotationMetadata, @NonNull QueryModel query) {
        PersistentEntity entity = query.getPersistentEntity();
        QueryState queryState = this.newQueryState(query, false, this.isAliasForBatch());
        StringBuilder queryString = queryState.getQuery();
        String tableAlias = queryState.getRootAlias();
        StringBuilder buffer = this.appendDeleteClause(queryString);
        String tableName = this.getTableName(entity);
        buffer.append(tableName).append(' ');
        if (tableAlias != null) {
            buffer.append(this.getTableAsKeyword()).append(tableAlias);
        }
        this.buildWhereClause(annotationMetadata, query.getCriteria(), queryState);
        return QueryResult.of(queryString.toString(), queryState.getParameterBindings(), queryState.getAdditionalRequiredParameters());
    }

    protected abstract boolean isAliasForBatch();

    @NonNull
    protected StringBuilder appendDeleteClause(StringBuilder queryString) {
        return queryString.append(DELETE_CLAUSE).append(FROM_CLAUSE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NonNull
    public QueryResult buildOrderBy(@NonNull PersistentEntity entity, @NonNull Sort sort) {
        ArgumentUtils.requireNonNull((String)"entity", (Object)entity);
        ArgumentUtils.requireNonNull((String)"sort", (Object)sort);
        List<Sort.Order> orders = sort.getOrderBy();
        if (CollectionUtils.isEmpty(orders)) {
            throw new IllegalArgumentException("Sort is empty");
        }
        StringBuilder buff = new StringBuilder(ORDER_BY_CLAUSE);
        Iterator<Sort.Order> i = orders.iterator();
        while (i.hasNext()) {
            String aliasName;
            Sort.Order order = i.next();
            String property = order.getProperty();
            PersistentProperty persistentProperty = entity.getPropertyByPath(property).orElseThrow(() -> new IllegalArgumentException("Cannot sort on non-existent property path: " + property));
            if (persistentProperty instanceof Association) {
                Association association = (Association)persistentProperty;
                aliasName = this.getAliasName(new JoinPath(property, new Association[]{association}, Join.Type.DEFAULT, null));
            } else {
                int j = property.indexOf(46);
                if (j > -1) {
                    String associationName = property.substring(0, j);
                    PersistentProperty assProp = entity.getPropertyByName(associationName);
                    if (!(assProp instanceof Association)) throw new IllegalArgumentException("Cannot sort on non-existent property path: " + property);
                    Association association = (Association)assProp;
                    persistentProperty = association.getAssociatedEntity().getPropertyByName(property.substring(j + 1));
                    if (persistentProperty == null) throw new IllegalArgumentException("Cannot sort on non-existent property path: " + property);
                    aliasName = this.getAliasName(new JoinPath(associationName, new Association[]{association}, Join.Type.DEFAULT, null));
                } else {
                    aliasName = this.getAliasName(entity);
                }
            }
            boolean ignoreCase = order.isIgnoreCase();
            if (ignoreCase) {
                buff.append("LOWER(");
            }
            buff.append(aliasName).append('.');
            buff.append(this.getColumnName(persistentProperty));
            if (ignoreCase) {
                buff.append(")");
            }
            buff.append(' ').append((Object)order.getDirection());
            if (!i.hasNext()) continue;
            buff.append(",");
        }
        return QueryResult.of(buff.toString(), Collections.emptyList(), Collections.emptyMap());
    }

    protected String asPath(List<Association> associations, PersistentProperty property) {
        if (associations.isEmpty()) {
            return property.getName();
        }
        StringJoiner joiner = new StringJoiner(".");
        for (Association association : associations) {
            joiner.add(association.getName());
        }
        joiner.add(property.getName());
        return joiner.toString();
    }

    protected void traversePersistentProperties(PersistentProperty property, BiConsumer<List<Association>, PersistentProperty> consumer) {
        this.traversePersistentProperties(Collections.emptyList(), property, consumer);
    }

    protected void traversePersistentProperties(PersistentEntity persistentEntity, BiConsumer<List<Association>, PersistentProperty> consumer) {
        if (persistentEntity.getIdentity() != null) {
            this.traversePersistentProperties(Collections.emptyList(), persistentEntity.getIdentity(), consumer);
        }
        if (persistentEntity.getVersion() != null) {
            this.traversePersistentProperties(Collections.emptyList(), persistentEntity.getVersion(), consumer);
        }
        for (PersistentProperty persistentProperty : persistentEntity.getPersistentProperties()) {
            this.traversePersistentProperties(Collections.emptyList(), persistentProperty, consumer);
        }
    }

    protected void traversePersistentProperties(PersistentEntity persistentEntity, boolean includeIdentity, boolean includeVersion, BiConsumer<List<Association>, PersistentProperty> consumer) {
        if (includeIdentity && persistentEntity.getIdentity() != null) {
            this.traversePersistentProperties(Collections.emptyList(), persistentEntity.getIdentity(), consumer);
        }
        if (includeVersion && persistentEntity.getVersion() != null) {
            this.traversePersistentProperties(Collections.emptyList(), persistentEntity.getVersion(), consumer);
        }
        for (PersistentProperty persistentProperty : persistentEntity.getPersistentProperties()) {
            this.traversePersistentProperties(Collections.emptyList(), persistentProperty, consumer);
        }
    }

    private void traversePersistentProperties(List<Association> associations, PersistentProperty property, BiConsumer<List<Association>, PersistentProperty> consumerProperty) {
        if (property instanceof Embedded) {
            Embedded embedded = (Embedded)property;
            PersistentEntity embeddedEntity = embedded.getAssociatedEntity();
            Collection<? extends PersistentProperty> embeddedProperties = embeddedEntity.getPersistentProperties();
            ArrayList<Association> newAssociations = new ArrayList<Association>(associations);
            newAssociations.add((Association)property);
            for (PersistentProperty persistentProperty : embeddedProperties) {
                this.traversePersistentProperties(newAssociations, persistentProperty, consumerProperty);
            }
        } else if (property instanceof Association) {
            Association association = (Association)property;
            if (association.isForeignKey()) {
                return;
            }
            ArrayList<Association> newAssociations = new ArrayList<Association>(associations);
            newAssociations.add((Association)property);
            PersistentEntity associatedEntity = association.getAssociatedEntity();
            PersistentProperty assocIdentity = associatedEntity.getIdentity();
            if (assocIdentity == null) {
                throw new IllegalStateException("Identity cannot be missing for: " + associatedEntity);
            }
            if (assocIdentity instanceof Association) {
                this.traversePersistentProperties(newAssociations, assocIdentity, consumerProperty);
            } else {
                consumerProperty.accept(newAssociations, assocIdentity);
            }
        } else {
            consumerProperty.accept(associations, property);
        }
    }

    private Optional<String> getDataTransformerValue(String alias, PersistentProperty prop, String val) {
        return prop.getAnnotationMetadata().stringValue(DataTransformer.class, val).map(v -> this.replaceAlias(alias, (String)v));
    }

    private String replaceAlias(String alias, String v) {
        return v.replaceAll(ALIAS_REPLACE_QUOTED, alias == null ? "" : alias + ".");
    }

    protected Optional<String> getDataTransformerReadValue(String alias, PersistentProperty prop) {
        return this.getDataTransformerValue(alias, prop, "read");
    }

    protected Optional<String> getDataTransformerWriteValue(String alias, PersistentProperty prop) {
        return this.getDataTransformerValue(alias, prop, "write");
    }

    protected abstract Placeholder formatParameter(int var1);

    public abstract String resolveJoinType(Join.Type var1);

    protected <T extends QueryModel.Criterion> void addCriterionHandler(Class<T> clazz, CriterionHandler<T> handler) {
        this.queryHandlers.put(clazz, handler);
    }

    protected static enum QueryPosition {
        AFTER_TABLE_NAME,
        END_OF_QUERY;

    }

    protected class QueryPropertyPath {
        private final PersistentPropertyPath propertyPath;
        private final String tableAlias;

        public QueryPropertyPath(@Nullable PersistentPropertyPath propertyPath, String tableAlias) {
            this.propertyPath = propertyPath;
            this.tableAlias = tableAlias;
        }

        @NonNull
        public List<Association> getAssociations() {
            return this.propertyPath.getAssociations();
        }

        @NonNull
        public PersistentProperty getProperty() {
            return this.propertyPath.getProperty();
        }

        @NonNull
        public String getPath() {
            return this.propertyPath.getPath();
        }

        @Nullable
        public String getTableAlias() {
            return this.tableAlias;
        }

        public String getColumnName() {
            String columnName = this.getNamingStrategy().mappedName(this.propertyPath.getAssociations(), this.propertyPath.getProperty());
            if (this.shouldEscape()) {
                return AbstractSqlLikeQueryBuilder.this.quote(columnName);
            }
            return columnName;
        }

        public NamingStrategy getNamingStrategy() {
            return this.propertyPath.getNamingStrategy();
        }

        public boolean shouldEscape() {
            return AbstractSqlLikeQueryBuilder.this.shouldEscape(this.propertyPath.findPropertyOwner().get());
        }
    }

    public static final class Placeholder {
        private final String name;
        private final String key;

        public Placeholder(String name, String key) {
            this.name = name;
            this.key = key;
        }

        public String toString() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public String getKey() {
            return this.key;
        }
    }

    private static interface PropertyParameterCreator {
        default public String addParameter(@NonNull PersistentProperty persistentProperty, @NotNull String path) {
            return this.addParameter(persistentProperty, path, null);
        }

        public String addParameter(@NonNull PersistentProperty var1, @NotNull String var2, @Nullable QueryParameter var3);
    }

    @Internal
    protected final class QueryState
    implements PropertyParameterCreator {
        private final String rootAlias;
        private final Map<String, String> appliedJoinPaths = new HashMap<String, String>();
        private final AtomicInteger position = new AtomicInteger(0);
        private final Map<String, String> additionalRequiredParameters = new LinkedHashMap<String, String>();
        private final List<QueryParameterBinding> parameterBindings;
        private final StringBuilder query = new StringBuilder();
        private final StringBuilder whereClause = new StringBuilder();
        private final boolean allowJoins;
        private final QueryModel queryObject;
        private final boolean escape;
        private final PersistentEntity entity;

        private QueryState(QueryModel query, boolean allowJoins, boolean useAlias) {
            this.allowJoins = allowJoins;
            this.queryObject = query;
            this.entity = query.getPersistentEntity();
            this.escape = AbstractSqlLikeQueryBuilder.this.shouldEscape(this.entity);
            this.rootAlias = useAlias ? AbstractSqlLikeQueryBuilder.this.getAliasName(this.entity) : null;
            this.parameterBindings = new ArrayList<QueryParameterBinding>(this.entity.getPersistentPropertyNames().size());
        }

        @Nullable
        public String getRootAlias() {
            return this.rootAlias;
        }

        public PersistentEntity getEntity() {
            return this.entity;
        }

        public String addAdditionalRequiredParameter(@NonNull String name) {
            Placeholder placeholder = this.newParameter();
            this.additionalRequiredParameters.put(placeholder.key, name);
            return placeholder.name;
        }

        public StringBuilder getQuery() {
            return this.query;
        }

        public StringBuilder getWhereClause() {
            return this.whereClause;
        }

        public boolean isAllowJoins() {
            return this.allowJoins;
        }

        public QueryModel getQueryModel() {
            return this.queryObject;
        }

        private Placeholder newParameter() {
            return AbstractSqlLikeQueryBuilder.this.formatParameter(this.position.incrementAndGet());
        }

        public String applyJoin(@NonNull JoinPath jp) {
            String joinAlias = this.appliedJoinPaths.get(jp.getPath());
            if (joinAlias != null) {
                return joinAlias;
            }
            Optional<JoinPath> ojp = this.getQueryModel().getJoinPath(jp.getPath());
            if (ojp.isPresent()) {
                jp = ojp.get();
            }
            StringBuilder stringBuilder = this.getQuery();
            Join.Type jt = jp.getJoinType();
            String joinType = AbstractSqlLikeQueryBuilder.this.resolveJoinType(jt);
            String[] associationAlias = AbstractSqlLikeQueryBuilder.this.buildJoin(this.getRootAlias(), jp, joinType, stringBuilder, this.appliedJoinPaths, this);
            Association[] associationArray = jp.getAssociationPath();
            StringJoiner associationPath = new StringJoiner(".");
            String lastAlias = null;
            for (int i = 0; i < associationAlias.length; ++i) {
                associationPath.add(associationArray[i].getName());
                String computedAlias = associationAlias[i];
                this.appliedJoinPaths.put(associationPath.toString(), computedAlias);
                lastAlias = computedAlias;
            }
            return lastAlias;
        }

        @NonNull
        public String computeAlias(String associationPath) {
            String p;
            if (this.appliedJoinPaths.containsKey(associationPath)) {
                return this.appliedJoinPaths.get(associationPath);
            }
            int i = associationPath.indexOf(46);
            if (i > -1 && this.appliedJoinPaths.containsKey(p = associationPath.substring(0, i))) {
                return this.appliedJoinPaths.get(p) + '.' + associationPath.substring(i + 1);
            }
            return this.getRootAlias() + '.' + associationPath;
        }

        public boolean shouldEscape() {
            return this.escape;
        }

        @NotNull
        public Map<String, String> getAdditionalRequiredParameters() {
            return this.additionalRequiredParameters;
        }

        public List<QueryParameterBinding> getParameterBindings() {
            return this.parameterBindings;
        }

        @Override
        public String addParameter(@NonNull PersistentProperty persistentProperty, String path, @Nullable QueryParameter queryParameter) {
            Placeholder placeholder = this.newParameter();
            this.parameterBindings.add(QueryParameterBinding.of(placeholder.key, path, persistentProperty.getDataType(), queryParameter, persistentProperty.findAnnotation(AutoPopulated.class).map(ap -> (Boolean)ap.getRequiredValue("updateable", Boolean.class)).orElse(false)));
            return placeholder.name;
        }
    }

    protected static interface CriteriaContext
    extends PropertyParameterCreator {
        public String getCurrentTableAlias();

        public QueryState getQueryState();

        public PersistentEntity getPersistentEntity();

        public QueryPropertyPath getRequiredProperty(String var1, Class<?> var2);

        @Override
        default public String addParameter(@NonNull PersistentProperty persistentProperty, String path, @Nullable QueryParameter value) {
            return this.getQueryState().addParameter(persistentProperty, path, value);
        }

        default public QueryPropertyPath getRequiredProperty(QueryModel.PropertyNameCriterion propertyCriterion) {
            return this.getRequiredProperty(propertyCriterion.getProperty(), propertyCriterion.getClass());
        }

        default public StringBuilder whereClause() {
            return this.getQueryState().getWhereClause();
        }
    }

    protected static interface CriterionHandler<T extends QueryModel.Criterion> {
        public void handle(CriteriaContext var1, T var2);
    }
}

