/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.naming;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.annotation.MappedProperty;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.Embedded;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.naming.NamingStrategies;
import java.util.function.Supplier;

@FunctionalInterface
@Introspected
public interface NamingStrategy {
    public static final NamingStrategy DEFAULT = new NamingStrategies.UnderScoreSeparatedLowerCase();

    @NonNull
    public String mappedName(@NonNull String var1);

    @NonNull
    default public String mappedName(@NonNull PersistentEntity entity) {
        ArgumentUtils.requireNonNull((String)"entity", (Object)entity);
        return entity.getAnnotationMetadata().stringValue(MappedEntity.class).filter(StringUtils::isNotEmpty).orElseGet(() -> this.mappedName(entity.getSimpleName()));
    }

    @NonNull
    default public String mappedName(Embedded embedded, PersistentProperty property) {
        return this.mappedName(embedded.getName() + NameUtils.capitalize((String)property.getPersistedName()));
    }

    @NonNull
    default public String mappedName(@NonNull PersistentProperty property) {
        ArgumentUtils.requireNonNull((String)"property", (Object)property);
        if (property instanceof Association) {
            return this.mappedName((Association)property);
        }
        Supplier<String> defaultNameSupplier = () -> this.mappedName(property.getName());
        return property.getAnnotationMetadata().stringValue(MappedProperty.class).map(s -> StringUtils.isEmpty((CharSequence)s) ? (String)defaultNameSupplier.get() : s).orElseGet(defaultNameSupplier);
    }

    @NonNull
    default public String mappedName(Association association) {
        Supplier<String> defaultNameSupplier = () -> this.mappedName(association.getName());
        if (association.isForeignKey()) {
            return this.mappedName(association.getOwner().getDecapitalizedName() + association.getAssociatedEntity().getSimpleName());
        }
        switch (association.getKind()) {
            case ONE_TO_ONE: 
            case MANY_TO_ONE: {
                return association.getAnnotationMetadata().stringValue(MappedProperty.class).orElseGet(() -> this.mappedName(association.getName() + this.getForeignKeySuffix()));
            }
        }
        return association.getAnnotationMetadata().stringValue(MappedProperty.class).orElseGet(defaultNameSupplier);
    }

    @NonNull
    default public String getForeignKeySuffix() {
        return "Id";
    }
}

