/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.query.builder.sql;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Creator;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.DataTransformer;
import io.micronaut.data.annotation.GeneratedValue;
import io.micronaut.data.annotation.Id;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.annotation.MappedProperty;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.annotation.Repository;
import io.micronaut.data.exceptions.MappingException;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.Embedded;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.naming.NamingStrategy;
import io.micronaut.data.model.query.JoinPath;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.builder.AbstractSqlLikeQueryBuilder;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.model.query.builder.QueryResult;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.model.query.builder.sql.SqlQueryConfiguration;
import java.lang.annotation.Annotation;
import java.sql.Blob;
import java.sql.Clob;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SqlQueryBuilder
extends AbstractSqlLikeQueryBuilder
implements QueryBuilder,
SqlQueryConfiguration.DialectConfiguration {
    public static final String IN_EXPRESSION_START = " ?$IN(";
    public static final String DEFAULT_POSITIONAL_PARAMETER_MARKER = "?";
    private static final String ANN_JOIN_TABLE = "io.micronaut.data.jdbc.annotation.JoinTable";
    private static final String BLANK_SPACE = " ";
    private static final String SEQ_SUFFIX = "_seq";
    private static final String INSERT_INTO = "INSERT INTO ";
    private static final String JDBC_REPO_ANNOTATION = "io.micronaut.data.jdbc.annotation.JdbcRepository";
    private static final String STANDARD_FOR_UPDATE_CLAUSE = " FOR UPDATE";
    private static final String SQL_SERVER_FOR_UPDATE_CLAUSE = " WITH (UPDLOCK, ROWLOCK)";
    private final Dialect dialect;
    private final Map<Dialect, DialectConfig> perDialectConfig = new HashMap<Dialect, DialectConfig>(3);

    @Creator
    public SqlQueryBuilder(AnnotationMetadata annotationMetadata) {
        if (annotationMetadata != null) {
            this.dialect = annotationMetadata.enumValue(JDBC_REPO_ANNOTATION, "dialect", Dialect.class).orElseGet(() -> annotationMetadata.enumValue(Repository.class, "dialect", Dialect.class).orElse(Dialect.ANSI));
            AnnotationValue annotation = annotationMetadata.getAnnotation(SqlQueryConfiguration.class);
            if (annotation != null) {
                List dialectConfigs = annotation.getAnnotations("value", SqlQueryConfiguration.DialectConfiguration.class);
                for (AnnotationValue dialectConfig : dialectConfigs) {
                    dialectConfig.enumValue("dialect", Dialect.class).ifPresent(dialect -> {
                        DialectConfig dc = new DialectConfig();
                        this.perDialectConfig.put((Dialect)((Object)dialect), dc);
                        dialectConfig.stringValue("positionalParameterFormat").ifPresent(format -> {
                            dc.positionalFormatter = format;
                        });
                        dialectConfig.booleanValue("escapeQueries").ifPresent(escape -> {
                            dc.escapeQueries = escape;
                        });
                    });
                }
            }
        } else {
            this.dialect = Dialect.ANSI;
        }
    }

    public SqlQueryBuilder() {
        this.dialect = Dialect.ANSI;
    }

    public SqlQueryBuilder(Dialect dialect) {
        ArgumentUtils.requireNonNull((String)"dialect", (Object)((Object)dialect));
        this.dialect = dialect;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    @Override
    protected boolean shouldEscape(@NonNull PersistentEntity entity) {
        DialectConfig config = this.perDialectConfig.get((Object)this.dialect);
        if (config != null && config.escapeQueries != null) {
            return config.escapeQueries;
        }
        return super.shouldEscape(entity);
    }

    @Override
    public boolean shouldAliasProjections() {
        return false;
    }

    @Override
    protected boolean isExpandEmbedded() {
        return true;
    }

    @NonNull
    public String buildBatchCreateTableStatement(PersistentEntity ... entities) {
        return Arrays.stream(entities).flatMap(entity -> Stream.of(this.buildCreateTableStatements((PersistentEntity)entity))).collect(Collectors.joining(System.getProperty("line.separator")));
    }

    @NonNull
    public String buildBatchDropTableStatement(PersistentEntity ... entities) {
        return Arrays.stream(entities).flatMap(entity -> Stream.of(this.buildDropTableStatements((PersistentEntity)entity))).collect(Collectors.joining("\n"));
    }

    @NonNull
    public String[] buildDropTableStatements(@NonNull PersistentEntity entity) {
        String tableName = this.getTableName(entity);
        boolean escape = this.shouldEscape(entity);
        String sql = "DROP TABLE " + tableName;
        Collection<Association> foreignKeyAssociations = this.getJoinTableAssociations(entity.getPersistentProperties());
        ArrayList<String> dropStatements = new ArrayList<String>();
        for (Association association : foreignKeyAssociations) {
            AnnotationMetadata associationMetadata = association.getAnnotationMetadata();
            NamingStrategy namingStrategy = entity.getNamingStrategy();
            String joinTableName = associationMetadata.stringValue(ANN_JOIN_TABLE, "name").orElseGet(() -> namingStrategy.mappedName(association));
            dropStatements.add("DROP TABLE " + (escape ? this.quote(joinTableName) : joinTableName) + ";");
        }
        dropStatements.add(sql);
        return dropStatements.toArray(new String[0]);
    }

    @NonNull
    public String buildJoinTableInsert(@NonNull PersistentEntity entity, @NonNull Association association) {
        AnnotationMetadata associationMetadata = association.getAnnotationMetadata();
        if (!SqlQueryBuilder.isForeignKeyWithJoinTable(association)) {
            throw new IllegalArgumentException("Join table inserts can only be built for foreign key associations that are mapped with a join table.");
        }
        NamingStrategy namingStrategy = entity.getNamingStrategy();
        String joinTableName = associationMetadata.stringValue(ANN_JOIN_TABLE, "name").orElseGet(() -> namingStrategy.mappedName(association));
        PersistentEntity associatedEntity = association.getAssociatedEntity();
        String[] joinColumns = this.resolveJoinTableColumns(entity, associatedEntity, association, entity.getIdentity(), associatedEntity.getIdentity(), namingStrategy);
        String columnStrs = Arrays.stream(joinColumns).map(this::quote).collect(Collectors.joining(","));
        return INSERT_INTO + this.quote(joinTableName) + " (" + columnStrs + ") VALUES (?, ?)";
    }

    public static boolean isForeignKeyWithJoinTable(@NonNull Association association) {
        return association.isForeignKey() && !association.getAnnotationMetadata().stringValue(Relation.class, "mappedBy").isPresent();
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public String[] buildCreateTableStatements(@NonNull PersistentEntity entity) {
        Collection<Association> foreignKeyAssociations;
        ArgumentUtils.requireNonNull((String)"entity", (Object)entity);
        String unescapedTableName = this.getUnescapedTableName(entity);
        String tableName = this.getTableName(entity);
        boolean escape = this.shouldEscape(entity);
        StringBuilder builder = new StringBuilder("CREATE TABLE ").append(tableName).append(" (");
        ArrayList<? extends PersistentProperty> props = new ArrayList<PersistentProperty>(entity.getPersistentProperties());
        PersistentProperty identity = entity.getIdentity();
        if (identity != null) {
            props.add(0, identity);
        }
        ArrayList<String> createStatements = new ArrayList<String>();
        String schema = entity.getAnnotationMetadata().stringValue(MappedEntity.class, "schema").orElse(null);
        if (StringUtils.isNotEmpty((CharSequence)schema)) {
            if (escape) {
                schema = this.quote(schema);
            }
            createStatements.add("CREATE SCHEMA " + schema + ";");
        }
        if (CollectionUtils.isNotEmpty(foreignKeyAssociations = this.getJoinTableAssociations(props))) {
            for (Association association : foreignKeyAssociations) {
                void var16_29;
                StringBuilder stringBuilder = new StringBuilder("CREATE TABLE ");
                PersistentEntity associatedEntity = association.getAssociatedEntity();
                NamingStrategy namingStrategy = entity.getNamingStrategy();
                String string = association.getAnnotationMetadata().stringValue(ANN_JOIN_TABLE, "name").orElseGet(() -> namingStrategy.mappedName(association));
                if (escape) {
                    String string2 = this.quote(string);
                }
                stringBuilder.append((String)var16_29).append(" (");
                PersistentProperty associatedId = associatedEntity.getIdentity();
                String[] joinColumnNames = this.resolveJoinTableColumns(entity, associatedEntity, association, identity, associatedId, namingStrategy);
                stringBuilder.append(this.addTypeToColumn(identity, false, joinColumnNames[0], true)).append(',').append(this.addTypeToColumn(associatedId, false, joinColumnNames[1], true));
                stringBuilder.append(")");
                if (this.dialect != Dialect.ORACLE) {
                    stringBuilder.append(';');
                }
                createStatements.add(stringBuilder.toString());
            }
        }
        ArrayList<Object> columns = new ArrayList<Object>(props.size());
        for (PersistentProperty persistentProperty : props) {
            boolean isAssociation = false;
            if (persistentProperty instanceof Association) {
                isAssociation = true;
                Association association = (Association)persistentProperty;
                if (association.isForeignKey()) continue;
            }
            if (persistentProperty instanceof Embedded) {
                Embedded embedded = (Embedded)persistentProperty;
                PersistentEntity persistentEntity = embedded.getAssociatedEntity();
                Collection<? extends PersistentProperty> embeddedProperties = persistentEntity.getPersistentProperties();
                for (PersistentProperty persistentProperty2 : embeddedProperties) {
                    String column;
                    String explicitColumn = persistentProperty2.getAnnotationMetadata().stringValue(MappedProperty.class).orElse(null);
                    String string = column = explicitColumn != null ? explicitColumn : entity.getNamingStrategy().mappedName(persistentProperty.getName() + persistentProperty2.getCapitilizedName());
                    if (escape) {
                        column = this.quote(column);
                    }
                    boolean required = persistentProperty.isOptional() ? false : persistentProperty2.isRequired() || persistentProperty.getAnnotationMetadata().hasStereotype(Id.class);
                    column = this.addTypeToColumn(persistentProperty2, persistentProperty2 instanceof Association, column, required);
                    column = this.addGeneratedStatementToColumn(identity, persistentProperty, column);
                    columns.add(column);
                }
                continue;
            }
            Object column = this.getColumnName(persistentProperty);
            if (escape) {
                column = this.quote((String)column);
            }
            column = this.addTypeToColumn(persistentProperty, isAssociation, (String)column, persistentProperty.isRequired());
            column = this.addGeneratedStatementToColumn(identity, persistentProperty, (String)column);
            columns.add(column);
        }
        builder.append(String.join((CharSequence)",", columns));
        if (identity instanceof Embedded) {
            Embedded embedded = (Embedded)identity;
            PersistentEntity persistentEntity = embedded.getAssociatedEntity();
            ArrayList<String> primaryKeyColumns = new ArrayList<String>();
            for (PersistentProperty persistentProperty : persistentEntity.getPersistentProperties()) {
                String column;
                String explicitColumn = persistentProperty.getAnnotationMetadata().stringValue(MappedProperty.class).orElse(null);
                String string = column = explicitColumn != null ? explicitColumn : entity.getNamingStrategy().mappedName(identity.getName() + persistentProperty.getCapitilizedName());
                if (escape) {
                    column = this.quote(column);
                }
                primaryKeyColumns.add(column);
            }
            builder.append(", PRIMARY KEY(").append(String.join((CharSequence)",", primaryKeyColumns)).append(')');
        }
        if (this.dialect == Dialect.ORACLE) {
            builder.append(")");
        } else {
            builder.append(");");
        }
        if (identity != null && identity.isGenerated()) {
            GeneratedValue.Type type = identity.getAnnotationMetadata().enumValue(GeneratedValue.class, GeneratedValue.Type.class).orElseGet(() -> this.selectAutoStrategy(identity));
            boolean bl = type == GeneratedValue.Type.SEQUENCE;
            String generatedDefinition = identity.getAnnotationMetadata().stringValue(GeneratedValue.class, "definition").orElse(null);
            if (generatedDefinition != null) {
                createStatements.add(generatedDefinition);
            } else if (bl) {
                boolean isSqlServer = this.dialect == Dialect.SQL_SERVER;
                String string = this.quote(unescapedTableName + SEQ_SUFFIX);
                String createSequenceStmt = "CREATE SEQUENCE " + string;
                if (isSqlServer) {
                    createSequenceStmt = createSequenceStmt + " AS BIGINT";
                }
                createSequenceStmt = createSequenceStmt + " MINVALUE 1 START WITH 1";
                if (this.dialect == Dialect.ORACLE) {
                    createSequenceStmt = createSequenceStmt + " NOCACHE NOCYCLE";
                } else if (isSqlServer) {
                    createSequenceStmt = createSequenceStmt + " INCREMENT BY 1";
                }
                createStatements.add(createSequenceStmt);
            }
        }
        createStatements.add(builder.toString());
        return createStatements.toArray(new String[0]);
    }

    @Override
    protected String getTableAsKeyword() {
        return BLANK_SPACE;
    }

    private String addGeneratedStatementToColumn(PersistentProperty identity, PersistentProperty prop, String column) {
        if (prop.isGenerated()) {
            GeneratedValue.Type type = prop.getAnnotationMetadata().enumValue(GeneratedValue.class, GeneratedValue.Type.class).orElse(GeneratedValue.Type.AUTO);
            if (type == GeneratedValue.Type.AUTO) {
                type = prop.getDataType() == DataType.UUID ? GeneratedValue.Type.UUID : (this.dialect == Dialect.ORACLE ? GeneratedValue.Type.SEQUENCE : GeneratedValue.Type.IDENTITY);
            }
            switch (this.dialect) {
                case POSTGRES: {
                    if (prop == identity) {
                        column = column + " PRIMARY KEY";
                    }
                    if (type == GeneratedValue.Type.SEQUENCE) {
                        column = column + " NOT NULL";
                        break;
                    }
                    if (type == GeneratedValue.Type.IDENTITY) {
                        if (prop == identity) {
                            column = column + " GENERATED ALWAYS AS IDENTITY";
                            break;
                        }
                        column = column + " NOT NULL";
                        break;
                    }
                    if (type != GeneratedValue.Type.UUID) break;
                    column = column + " NOT NULL DEFAULT uuid_generate_v4()";
                    break;
                }
                case SQL_SERVER: {
                    if (prop == identity) {
                        column = column + " PRIMARY KEY";
                    }
                    if (type == GeneratedValue.Type.UUID) {
                        column = column + " NOT NULL DEFAULT newid()";
                        break;
                    }
                    if (type == GeneratedValue.Type.SEQUENCE) {
                        if (prop != identity) break;
                        column = column + " NOT NULL";
                        break;
                    }
                    column = column + " IDENTITY(1,1) NOT NULL";
                    break;
                }
                case ORACLE: {
                    if (prop == identity) {
                        column = column + " PRIMARY KEY";
                    }
                    if (type == GeneratedValue.Type.UUID) {
                        column = column + " NOT NULL DEFAULT SYS_GUID()";
                        break;
                    }
                    if (type == GeneratedValue.Type.IDENTITY) {
                        if (prop == identity) {
                            column = column + " GENERATED ALWAYS AS IDENTITY";
                            break;
                        }
                        column = column + " NOT NULL";
                        break;
                    }
                    column = column + " NOT NULL";
                    break;
                }
                default: {
                    if (this.dialect != Dialect.H2 && prop == identity) {
                        column = column + " PRIMARY KEY";
                    }
                    column = type == GeneratedValue.Type.UUID ? (this.dialect != Dialect.MYSQL ? column + " NOT NULL DEFAULT random_uuid()" : column + " NOT NULL") : column + " AUTO_INCREMENT";
                    if (this.dialect != Dialect.H2 || prop != identity) break;
                    column = column + " PRIMARY KEY";
                }
            }
        }
        return column;
    }

    @NonNull
    private String[] resolveJoinTableColumns(@NonNull PersistentEntity entity, PersistentEntity associatedEntity, Association association, PersistentProperty identity, PersistentProperty associatedId, NamingStrategy namingStrategy) {
        String[] joinColumnDefinitions;
        List joinColumns = association.getAnnotationMetadata().findAnnotation(ANN_JOIN_TABLE).map(av -> av.getAnnotations("joinColumns", MappedProperty.class)).orElse(Collections.emptyList());
        if (identity == null) {
            throw new MappingException("Cannot have a foreign key association without an ID on entity: " + entity.getName());
        }
        if (associatedId == null) {
            throw new MappingException("Cannot have a foreign key association without an ID on entity: " + associatedEntity.getName());
        }
        if (CollectionUtils.isEmpty(joinColumns)) {
            String thisName = namingStrategy.mappedName(entity.getDecapitalizedName() + namingStrategy.getForeignKeySuffix());
            String thatName = namingStrategy.mappedName(associatedEntity.getDecapitalizedName() + namingStrategy.getForeignKeySuffix());
            joinColumnDefinitions = new String[]{thisName, thatName};
        } else {
            if (joinColumns.size() != 2) {
                throw new MappingException("Expected exactly 2 join columns for association [" + association.getName() + "] of entity: " + entity.getName());
            }
            String thisName = ((AnnotationValue)joinColumns.get(0)).stringValue().orElseGet(() -> namingStrategy.mappedName(entity.getDecapitalizedName() + namingStrategy.getForeignKeySuffix()));
            String thatName = ((AnnotationValue)joinColumns.get(1)).stringValue().orElseGet(() -> namingStrategy.mappedName(associatedEntity.getDecapitalizedName() + namingStrategy.getForeignKeySuffix()));
            joinColumnDefinitions = new String[]{thisName, thatName};
        }
        return joinColumnDefinitions;
    }

    @NonNull
    private Collection<Association> getJoinTableAssociations(Collection<? extends PersistentProperty> props) {
        return props.stream().filter(p -> {
            if (p instanceof Association) {
                Association a = (Association)p;
                return SqlQueryBuilder.isForeignKeyWithJoinTable(a);
            }
            return false;
        }).map(p -> (Association)p).collect(Collectors.toList());
    }

    @Override
    protected void selectAllColumns(AbstractSqlLikeQueryBuilder.QueryState queryState, StringBuilder queryBuffer) {
        Collection joinPaths;
        PersistentEntity entity = queryState.getEntity();
        String alias = queryState.getCurrentAlias();
        this.selectAllColumns(entity, alias, queryBuffer);
        QueryModel queryModel = queryState.getQueryModel();
        Collection<JoinPath> allPaths = queryModel.getJoinPaths();
        if (CollectionUtils.isNotEmpty(allPaths) && CollectionUtils.isNotEmpty((Collection)(joinPaths = (Collection)allPaths.stream().filter(jp -> {
            Join.Type jt = jp.getJoinType();
            return jt.name().contains("FETCH");
        }).collect(Collectors.toList())))) {
            for (JoinPath joinPath : joinPaths) {
                PersistentProperty identity;
                Association association = joinPath.getAssociation();
                if (association instanceof Embedded) continue;
                PersistentEntity associatedEntity = association.getAssociatedEntity();
                List<PersistentProperty> associatedProperties = this.getPropertiesThatAreColumns(associatedEntity);
                if (association.isForeignKey() && (identity = associatedEntity.getIdentity()) != null) {
                    associatedProperties.add(0, identity);
                }
                if (!CollectionUtils.isNotEmpty(associatedProperties)) continue;
                queryBuffer.append(',');
                String aliasName = this.getAliasName(joinPath);
                String joinPathAlias = this.getPathOnlyAliasName(joinPath);
                String columnNames = associatedProperties.stream().map(p -> {
                    String columnName = this.getColumnName((PersistentProperty)p);
                    return aliasName + '.' + this.quote(columnName) + " AS " + joinPathAlias + columnName;
                }).collect(Collectors.joining(","));
                queryBuffer.append(columnNames);
            }
        }
    }

    @Override
    public void selectAllColumns(PersistentEntity entity, String alias, StringBuilder stringBuffer) {
        String columns;
        boolean escape = this.shouldEscape(entity);
        List<PersistentProperty> persistentProperties = this.getPropertiesThatAreColumns(entity);
        if (CollectionUtils.isNotEmpty(persistentProperties)) {
            PersistentProperty identity = entity.getIdentity();
            if (identity != null) {
                persistentProperties.add(0, identity);
            }
            columns = persistentProperties.stream().map(p -> {
                Association association;
                if (p instanceof Association && (association = (Association)p).getKind() == Relation.Kind.EMBEDDED) {
                    PersistentEntity embeddedEntity = association.getAssociatedEntity();
                    List<PersistentProperty> embeddedProps = this.getPropertiesThatAreColumns(embeddedEntity);
                    return embeddedProps.stream().map(ep -> {
                        String columnName = ep.getAnnotationMetadata().stringValue(MappedProperty.class).orElseGet(() -> entity.getNamingStrategy().mappedName(association.getName() + ep.getCapitilizedName()));
                        if (escape) {
                            columnName = this.quote(columnName);
                        }
                        return alias + '.' + columnName;
                    }).collect(Collectors.joining(","));
                }
                return p.getAnnotationMetadata().stringValue(DataTransformer.class, "read").map(str -> str + " AS " + p.getPersistedName()).orElseGet(() -> {
                    String columnName = this.getColumnName((PersistentProperty)p);
                    if (escape) {
                        columnName = this.quote(columnName);
                    }
                    return alias + '.' + columnName;
                });
            }).collect(Collectors.joining(","));
        } else {
            columns = "*";
        }
        stringBuffer.append(columns);
    }

    @NonNull
    private List<PersistentProperty> getPropertiesThatAreColumns(PersistentEntity entity) {
        return entity.getPersistentProperties().stream().filter(pp -> {
            if (pp instanceof Association) {
                Association association = (Association)pp;
                return !association.isForeignKey();
            }
            return true;
        }).collect(Collectors.toList());
    }

    @Override
    public String resolveJoinType(Join.Type jt) {
        String joinType;
        switch (jt) {
            case LEFT: 
            case LEFT_FETCH: {
                joinType = " LEFT JOIN ";
                break;
            }
            case RIGHT: 
            case RIGHT_FETCH: {
                joinType = " RIGHT JOIN ";
                break;
            }
            case OUTER: {
                joinType = " FULL OUTER JOIN ";
                break;
            }
            default: {
                joinType = " INNER JOIN ";
            }
        }
        return joinType;
    }

    @Override
    @NonNull
    public QueryResult buildInsert(AnnotationMetadata repositoryMetadata, PersistentEntity entity) {
        PersistentProperty identity;
        String columnName;
        NamingStrategy namingStrategy;
        String explicitColumn;
        Collection<? extends PersistentProperty> embeddedProps;
        PersistentEntity embeddedEntity;
        StringBuilder builder = new StringBuilder(INSERT_INTO);
        String unescapedTableName = this.getUnescapedTableName(entity);
        String tableName = this.getTableName(entity);
        boolean escape = this.shouldEscape(entity);
        builder.append(tableName);
        builder.append(" (");
        Collection<? extends PersistentProperty> persistentProperties = entity.getPersistentProperties();
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>(persistentProperties.size());
        LinkedHashMap<String, DataType> parameterTypes = new LinkedHashMap<String, DataType>(persistentProperties.size());
        boolean hasProperties = CollectionUtils.isNotEmpty(persistentProperties);
        ArrayList<String> values = new ArrayList<String>(persistentProperties.size());
        if (hasProperties) {
            ArrayList<String> columnNames = new ArrayList<String>(persistentProperties.size());
            for (PersistentProperty persistentProperty : persistentProperties) {
                if (persistentProperty.isGenerated()) continue;
                if (persistentProperty instanceof Association) {
                    Association association = (Association)persistentProperty;
                    if (association instanceof Embedded) {
                        Embedded embedded = (Embedded)association;
                        embeddedEntity = association.getAssociatedEntity();
                        embeddedProps = embeddedEntity.getPersistentProperties();
                        for (PersistentProperty persistentProperty2 : embeddedProps) {
                            explicitColumn = persistentProperty2.getAnnotationMetadata().stringValue(MappedProperty.class).orElse(null);
                            this.addWriteExpression(values, persistentProperty);
                            parameters.put(String.valueOf(values.size()), persistentProperty.getName() + "." + persistentProperty2.getName());
                            if (explicitColumn != null) {
                                if (escape) {
                                    explicitColumn = this.quote(explicitColumn);
                                }
                                columnNames.add(explicitColumn);
                                continue;
                            }
                            namingStrategy = entity.getNamingStrategy();
                            String columnName2 = namingStrategy.mappedName(embedded, persistentProperty2);
                            if (escape) {
                                columnName2 = this.quote(columnName2);
                            }
                            columnNames.add(columnName2);
                        }
                        continue;
                    }
                    if (association.isForeignKey()) continue;
                    parameterTypes.put(persistentProperty.getName(), persistentProperty.getDataType());
                    this.addWriteExpression(values, persistentProperty);
                    parameters.put(String.valueOf(values.size()), persistentProperty.getName());
                    columnName = this.getColumnName(persistentProperty);
                    if (escape) {
                        columnName = this.quote(columnName);
                    }
                    columnNames.add(columnName);
                    continue;
                }
                parameterTypes.put(persistentProperty.getName(), persistentProperty.getDataType());
                this.addWriteExpression(values, persistentProperty);
                parameters.put(String.valueOf(values.size()), persistentProperty.getName());
                String columnName3 = this.getColumnName(persistentProperty);
                if (escape) {
                    columnName3 = this.quote(columnName3);
                }
                columnNames.add(columnName3);
            }
            builder.append(String.join((CharSequence)",", columnNames));
        }
        if ((identity = entity.getIdentity()) != null) {
            boolean assignedOrSequence = false;
            Optional optional = identity.findAnnotation(GeneratedValue.class);
            boolean isSequence = false;
            if (optional.isPresent()) {
                GeneratedValue.Type idGeneratorType = optional.flatMap(av -> av.enumValue(GeneratedValue.Type.class)).orElseGet(() -> this.selectAutoStrategy(identity));
                if (idGeneratorType == GeneratedValue.Type.SEQUENCE) {
                    isSequence = true;
                    assignedOrSequence = true;
                } else if (this.dialect == Dialect.MYSQL && identity.getDataType() == DataType.UUID) {
                    assignedOrSequence = true;
                }
            } else {
                assignedOrSequence = true;
            }
            if (assignedOrSequence) {
                if (hasProperties) {
                    builder.append(',');
                }
                if (identity instanceof Embedded) {
                    ArrayList<String> columnNames = new ArrayList<String>(persistentProperties.size());
                    embeddedEntity = ((Embedded)identity).getAssociatedEntity();
                    embeddedProps = embeddedEntity.getPersistentProperties();
                    for (PersistentProperty persistentProperty : embeddedProps) {
                        explicitColumn = persistentProperty.getAnnotationMetadata().stringValue(MappedProperty.class).orElse(null);
                        this.addWriteExpression(values, persistentProperty);
                        parameters.put(String.valueOf(values.size()), identity.getName() + "." + persistentProperty.getName());
                        if (explicitColumn != null) {
                            if (escape) {
                                explicitColumn = this.quote(explicitColumn);
                            }
                            columnNames.add(explicitColumn);
                            continue;
                        }
                        namingStrategy = entity.getNamingStrategy();
                        String columnName2 = namingStrategy.mappedName(identity.getName() + persistentProperty.getCapitilizedName());
                        if (escape) {
                            columnName2 = this.quote(columnName2);
                        }
                        columnNames.add(columnName2);
                    }
                    builder.append(String.join((CharSequence)",", columnNames));
                } else {
                    columnName = this.getColumnName(identity);
                    if (escape) {
                        columnName = this.quote(columnName);
                    }
                    builder.append(columnName);
                    if (isSequence) {
                        String sequenceName = this.resolveSequenceName(identity, unescapedTableName);
                        if (this.dialect == Dialect.ORACLE) {
                            values.add(this.quote(sequenceName) + ".nextval");
                        } else if (this.dialect == Dialect.POSTGRES) {
                            values.add("nextval('" + sequenceName + "')");
                        } else if (this.dialect == Dialect.SQL_SERVER) {
                            values.add("NEXT VALUE FOR " + this.quote(sequenceName));
                        }
                    } else {
                        this.addWriteExpression(values, identity);
                        parameters.put(String.valueOf(values.size()), identity.getName());
                    }
                }
            }
        }
        builder.append(')');
        builder.append(" VALUES (");
        builder.append(String.join((CharSequence)String.valueOf(','), values));
        builder.append(')');
        return QueryResult.of(builder.toString(), parameters, parameterTypes, Collections.emptySet());
    }

    private String resolveSequenceName(PersistentProperty identity, String unescapedTableName) {
        return identity.getAnnotationMetadata().stringValue(GeneratedValue.class, "ref").map(n -> {
            if (StringUtils.isEmpty((CharSequence)n)) {
                return unescapedTableName + SEQ_SUFFIX;
            }
            return n;
        }).orElseGet(() -> unescapedTableName + SEQ_SUFFIX);
    }

    @Override
    @NonNull
    public QueryResult buildPagination(@NonNull Pageable pageable) {
        int size = pageable.getSize();
        if (size > 0) {
            StringBuilder builder = new StringBuilder(BLANK_SPACE);
            long from = pageable.getOffset();
            switch (this.dialect) {
                case H2: 
                case MYSQL: {
                    if (from == 0L) {
                        builder.append("LIMIT ").append(size);
                        break;
                    }
                    builder.append("LIMIT ").append(from).append(',').append(size);
                    break;
                }
                case POSTGRES: {
                    builder.append("LIMIT ").append(size).append(BLANK_SPACE);
                    if (from == 0L) break;
                    builder.append("OFFSET ").append(from);
                    break;
                }
                case SQL_SERVER: {
                    if (from == 0L) {
                        builder.append("OFFSET ").append(0).append(" ROWS ");
                    }
                }
                default: {
                    if (from != 0L) {
                        builder.append("OFFSET ").append(from).append(" ROWS ");
                    }
                    builder.append("FETCH NEXT ").append(size).append(" ROWS ONLY ");
                }
            }
            return QueryResult.of(builder.toString(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptySet());
        }
        return QueryResult.of("", Collections.emptyMap(), Collections.emptyMap(), Collections.emptySet());
    }

    @Override
    protected void encodeInExpression(StringBuilder whereClause, AbstractSqlLikeQueryBuilder.Placeholder placeholder) {
        whereClause.append(IN_EXPRESSION_START).append(placeholder.getKey()).append(')');
    }

    @Override
    protected String getAliasName(PersistentEntity entity) {
        return entity.getAliasName();
    }

    @Override
    public String getTableName(PersistentEntity entity) {
        boolean escape = this.shouldEscape(entity);
        String tableName = entity.getPersistedName();
        String schema = entity.getAnnotationMetadata().stringValue(MappedEntity.class, "schema").orElse(null);
        if (StringUtils.isNotEmpty((CharSequence)schema)) {
            if (escape) {
                return this.quote(schema) + '.' + this.quote(tableName);
            }
            return schema + '.' + tableName;
        }
        return escape ? this.quote(tableName) : tableName;
    }

    @Override
    protected String formatStartsWith() {
        if (this.dialect == Dialect.ORACLE) {
            return " LIKE '%' || ";
        }
        return super.formatStartsWith();
    }

    @Override
    protected String formEndsWithEnd() {
        if (this.dialect == Dialect.ORACLE) {
            return BLANK_SPACE;
        }
        return super.formEndsWithEnd();
    }

    @Override
    protected String formatEndsWith() {
        if (this.dialect == Dialect.ORACLE) {
            return " || '%'";
        }
        return super.formatEndsWith();
    }

    @Override
    protected String formatStartsWithBeginning() {
        if (this.dialect == Dialect.ORACLE) {
            return " LIKE ";
        }
        return super.formatStartsWithBeginning();
    }

    private boolean addWriteExpression(List<String> values, PersistentProperty property) {
        DataType dt = property.getDataType();
        if (dt == DataType.JSON) {
            switch (this.dialect) {
                case POSTGRES: {
                    return values.add("to_json(" + this.formatParameter(values.size() + 1).getName() + "::json)");
                }
                case H2: {
                    return values.add(this.formatParameter(values.size() + 1).getName() + " FORMAT JSON");
                }
                case MYSQL: {
                    return values.add("CONVERT(" + this.formatParameter(values.size() + 1).getName() + " USING UTF8MB4)");
                }
            }
            return values.add(property.getAnnotationMetadata().stringValue(DataTransformer.class, "write").orElseGet(() -> this.formatParameter(values.size() + 1).getName()));
        }
        return values.add(property.getAnnotationMetadata().stringValue(DataTransformer.class, "write").orElseGet(() -> this.formatParameter(values.size() + 1).getName()));
    }

    @Override
    protected void appendUpdateSetParameter(StringBuilder queryString, PersistentProperty prop, AbstractSqlLikeQueryBuilder.Placeholder param) {
        if (prop.getDataType() == DataType.JSON) {
            switch (this.dialect) {
                case H2: {
                    queryString.append(param.getName()).append(" FORMAT JSON");
                    break;
                }
                case MYSQL: {
                    queryString.append("CONVERT(").append(param.getName()).append(" USING UTF8MB4)");
                    break;
                }
                case POSTGRES: {
                    queryString.append("to_json(").append(param.getName()).append("::json)");
                    break;
                }
                default: {
                    super.appendUpdateSetParameter(queryString, prop, param);
                    break;
                }
            }
        } else {
            super.appendUpdateSetParameter(queryString, prop, param);
        }
    }

    @Override
    protected String[] buildJoin(String alias, JoinPath joinPath, String joinType, StringBuilder target, Map<String, String> appliedJoinPaths, AbstractSqlLikeQueryBuilder.QueryState queryState) {
        Object[] associationPath = joinPath.getAssociationPath();
        if (ArrayUtils.isEmpty((Object[])associationPath)) {
            throw new IllegalArgumentException("Invalid association path [" + joinPath.getPath() + "]");
        }
        String[] joinAliases = new String[associationPath.length];
        StringBuilder pathSoFar = new StringBuilder();
        for (int i = 0; i < associationPath.length; ++i) {
            Object association = associationPath[i];
            String associationName = association.getName();
            pathSoFar.append(associationName);
            String existingAlias = appliedJoinPaths.get(alias + '.' + associationName);
            if (existingAlias != null) {
                joinAliases[i] = existingAlias;
                alias = existingAlias;
            } else {
                PersistentEntity associatedEntity = association.getAssociatedEntity();
                int finalI = i;
                JoinPath joinPathToUse = queryState.getQueryModel().getJoinPath(pathSoFar.toString()).orElseGet(() -> SqlQueryBuilder.lambda$buildJoin$29(pathSoFar, (Association[])associationPath, finalI, joinPath));
                joinAliases[i] = this.getAliasName(joinPathToUse);
                PersistentProperty identity = associatedEntity.getIdentity();
                if (identity == null) {
                    throw new IllegalArgumentException("Associated entity [" + associatedEntity.getName() + "] defines no ID. Cannot join.");
                }
                PersistentEntity associationOwner = association.getOwner();
                boolean escape = this.shouldEscape(associationOwner);
                if (association.isForeignKey()) {
                    String mappedBy = association.getAnnotationMetadata().stringValue(Relation.class, "mappedBy").orElse(null);
                    if (StringUtils.isNotEmpty((CharSequence)mappedBy)) {
                        PersistentProperty mappedProp = associatedEntity.getPropertyByName(mappedBy);
                        if (mappedProp == null) {
                            throw new MappingException("Foreign key association with mappedBy references a property that doesn't exist [" + mappedBy + "] of entity: " + associatedEntity.getName());
                        }
                        PersistentProperty associatedId = associationOwner.getIdentity();
                        if (associatedId == null) {
                            throw new MappingException("Cannot join on entity [" + associationOwner.getName() + "] that has no declared ID");
                        }
                        StringBuilder join = this.joinStringBuilder(queryState.getQueryModel(), joinType, this.getTableName(associatedEntity), joinAliases[i], alias, escape ? this.quote(this.getColumnName(associatedId)) : this.getColumnName(associatedId), escape ? this.quote(this.getColumnName(mappedProp)) : this.getColumnName(mappedProp));
                        String joinStr = join.toString();
                        if (target.indexOf(joinStr) == -1) {
                            target.append(joinStr);
                        }
                    } else {
                        PersistentProperty associatedId = associationOwner.getIdentity();
                        if (associatedId == null) {
                            throw new MappingException("Cannot join on entity [" + associationOwner.getName() + "] that has no declared ID");
                        }
                        NamingStrategy namingStrategy = associationOwner.getNamingStrategy();
                        String joinTableName = association.getAnnotationMetadata().stringValue(ANN_JOIN_TABLE, "name").orElseGet(() -> SqlQueryBuilder.lambda$buildJoin$30(namingStrategy, (Association)association));
                        String[] joinColumnNames = this.resolveJoinTableColumns(associationOwner, associatedEntity, (Association)association, identity, associatedEntity.getIdentity(), namingStrategy);
                        String joinTableAlias = joinAliases[i] + joinTableName + "_";
                        String associatedTableName = this.getTableName(associatedEntity);
                        StringBuilder join = this.joinStringBuilder(queryState.getQueryModel(), joinType, joinTableName, joinTableAlias, alias, escape ? this.quote(this.getColumnName(associatedId)) : this.getColumnName(associatedId), joinColumnNames[0]);
                        String joinStr = join.toString();
                        if (target.indexOf(joinStr) == -1) {
                            target.append(joinStr);
                        }
                        target.append(' ');
                        join = this.joinStringBuilder(queryState.getQueryModel(), joinType, associatedTableName, joinAliases[i], joinTableAlias, joinColumnNames[1], escape ? this.quote(this.getColumnName(associatedEntity.getIdentity())) : this.getColumnName(associatedEntity.getIdentity()));
                        joinStr = join.toString();
                        if (target.indexOf(joinStr) == -1) {
                            target.append(joinStr);
                        }
                    }
                } else {
                    PersistentProperty rootIdentity = queryState.getEntity().getIdentity();
                    String associationColumn = associationOwner.isEmbeddable() && rootIdentity instanceof Embedded && ((Embedded)rootIdentity).getAssociatedEntity() == associationOwner ? this.computeEmbeddedName(rootIdentity, rootIdentity.getName(), (PersistentProperty)association) : this.getColumnName((PersistentProperty)association);
                    StringBuilder join = this.joinStringBuilder(queryState.getQueryModel(), joinType, this.getTableName(associatedEntity), joinAliases[i], alias, escape ? this.quote(associationColumn) : associationColumn, escape ? this.quote(this.getColumnName(identity)) : this.getColumnName(identity));
                    String joinStr = join.toString();
                    if (target.indexOf(joinStr) == -1) {
                        target.append(joinStr);
                    }
                }
                alias = joinAliases[i];
            }
            pathSoFar.append('.');
        }
        return joinAliases;
    }

    private StringBuilder joinStringBuilder(QueryModel queryModel, String joinType, String tableName, String tableAlias, String onTableName, String onTableColumn, String tableColumnName) {
        StringBuilder builder = new StringBuilder();
        builder.append(joinType).append(tableName).append(' ').append(tableAlias);
        this.appendForUpdate(AbstractSqlLikeQueryBuilder.QueryPosition.AFTER_TABLE_NAME, queryModel, builder);
        builder.append(" ON ").append(onTableName).append('.').append(onTableColumn).append('=').append(tableAlias).append('.').append(tableColumnName);
        return builder;
    }

    @Override
    protected String quote(String persistedName) {
        switch (this.dialect) {
            case H2: 
            case MYSQL: {
                return '`' + persistedName + '`';
            }
            case SQL_SERVER: {
                return '[' + persistedName + ']';
            }
            case ORACLE: {
                return '\"' + persistedName.toUpperCase(Locale.ENGLISH) + '\"';
            }
            case POSTGRES: {
                return '\"' + persistedName.toLowerCase(Locale.ENGLISH) + '\"';
            }
        }
        return '\"' + persistedName + '\"';
    }

    @Override
    public String getColumnName(PersistentProperty persistentProperty) {
        return persistentProperty.getPersistedName();
    }

    @Override
    protected void appendProjectionRowCount(StringBuilder queryString, String logicalName) {
        queryString.append("COUNT").append('(').append('*').append(')');
    }

    @Override
    protected void appendForUpdate(AbstractSqlLikeQueryBuilder.QueryPosition queryPosition, QueryModel query, StringBuilder queryBuilder) {
        boolean isSqlServer;
        if (query.isForUpdate() && ((isSqlServer = Dialect.SQL_SERVER.equals((Object)this.dialect)) && queryPosition.equals((Object)AbstractSqlLikeQueryBuilder.QueryPosition.AFTER_TABLE_NAME) || !isSqlServer && queryPosition.equals((Object)AbstractSqlLikeQueryBuilder.QueryPosition.END_OF_QUERY))) {
            queryBuilder.append(isSqlServer ? SQL_SERVER_FOR_UPDATE_CLAUSE : STANDARD_FOR_UPDATE_CLAUSE);
        }
    }

    @Override
    protected final boolean computePropertyPaths() {
        return true;
    }

    @Override
    protected boolean isAliasForBatch() {
        return false;
    }

    @Override
    public AbstractSqlLikeQueryBuilder.Placeholder formatParameter(int index) {
        DialectConfig dialectConfig = this.perDialectConfig.get((Object)this.dialect);
        if (dialectConfig != null && dialectConfig.positionalFormatter != null) {
            return new AbstractSqlLikeQueryBuilder.Placeholder(String.format(dialectConfig.positionalFormatter, index), String.valueOf(index));
        }
        return new AbstractSqlLikeQueryBuilder.Placeholder(DEFAULT_POSITIONAL_PARAMETER_MARKER, String.valueOf(index));
    }

    protected GeneratedValue.Type selectAutoStrategy(PersistentProperty property) {
        if (property.getDataType() == DataType.UUID) {
            return GeneratedValue.Type.UUID;
        }
        if (this.dialect == Dialect.ORACLE) {
            return GeneratedValue.Type.SEQUENCE;
        }
        return GeneratedValue.Type.AUTO;
    }

    private String addTypeToColumn(PersistentProperty prop, boolean isAssociation, String column, boolean required) {
        AnnotationMetadata annotationMetadata = prop.getAnnotationMetadata();
        String definition = annotationMetadata.stringValue(MappedProperty.class, "definition").orElse(null);
        DataType dataType = prop.getDataType();
        if (definition != null) {
            return column + BLANK_SPACE + definition;
        }
        switch (dataType) {
            case STRING: {
                column = column + " VARCHAR(255)";
                if (!required) break;
                column = column + " NOT NULL";
                break;
            }
            case UUID: {
                column = this.dialect == Dialect.ORACLE || this.dialect == Dialect.MYSQL ? column + " VARCHAR(36)" : (this.dialect == Dialect.SQL_SERVER ? column + " UNIQUEIDENTIFIER" : column + " UUID");
                if (!required) break;
                column = column + " NOT NULL";
                break;
            }
            case BOOLEAN: {
                if (this.dialect == Dialect.ORACLE) {
                    column = column + " NUMBER(3)";
                    break;
                }
                if (this.dialect == Dialect.SQL_SERVER) {
                    column = column + " BIT NOT NULL";
                    break;
                }
                column = column + " BOOLEAN";
                if (!required) break;
                column = column + " NOT NULL";
                break;
            }
            case TIMESTAMP: {
                if (this.dialect == Dialect.ORACLE) {
                    column = column + " TIMESTAMP";
                    if (!required) break;
                    column = column + " NOT NULL";
                    break;
                }
                if (this.dialect == Dialect.SQL_SERVER) {
                    column = column + " DATETIME2";
                    if (!required) break;
                    column = column + " NOT NULL";
                    break;
                }
                if (this.dialect == Dialect.MYSQL) {
                    column = column + " TIMESTAMP(6) DEFAULT NOW(6)";
                    break;
                }
                column = column + " TIMESTAMP";
                if (!required) break;
                column = column + " NOT NULL";
                break;
            }
            case DATE: {
                column = column + " DATE";
                if (!required) break;
                column = column + " NOT NULL";
                break;
            }
            case LONG: {
                column = this.dialect == Dialect.ORACLE ? column + " NUMBER(19)" : column + " BIGINT";
                if (!required) break;
                column = column + " NOT NULL";
                break;
            }
            case CHARACTER: 
            case INTEGER: {
                column = this.dialect == Dialect.ORACLE ? column + " NUMBER(10)" : (this.dialect == Dialect.POSTGRES ? column + " INTEGER" : column + " INT");
                if (!required) break;
                column = column + " NOT NULL";
                break;
            }
            case BIGDECIMAL: {
                column = this.dialect == Dialect.ORACLE ? column + " FLOAT(126)" : column + " DECIMAL";
                if (!required) break;
                column = column + " NOT NULL";
                break;
            }
            case FLOAT: {
                column = this.dialect == Dialect.ORACLE || this.dialect == Dialect.SQL_SERVER ? column + " FLOAT(53)" : (this.dialect == Dialect.POSTGRES ? column + " REAL" : column + " FLOAT");
                if (!required) break;
                column = column + " NOT NULL";
                break;
            }
            case BYTE_ARRAY: {
                column = this.dialect == Dialect.POSTGRES ? column + " BYTEA" : (this.dialect == Dialect.SQL_SERVER ? column + " VARBINARY(MAX)" : (this.dialect == Dialect.ORACLE ? column + " BLOB" : column + " BLOB"));
                if (!required) break;
                column = column + " NOT NULL";
                break;
            }
            case DOUBLE: {
                column = this.dialect == Dialect.ORACLE ? column + " FLOAT(23)" : (this.dialect == Dialect.MYSQL || this.dialect == Dialect.H2 ? column + " DOUBLE" : column + " DOUBLE PRECISION");
                if (!required) break;
                column = column + " NOT NULL";
                break;
            }
            case SHORT: 
            case BYTE: {
                column = this.dialect == Dialect.ORACLE ? column + " NUMBER(5)" : (this.dialect == Dialect.POSTGRES ? column + " SMALLINT" : column + " TINYINT");
                if (!required) break;
                column = column + " NOT NULL";
                break;
            }
            case JSON: {
                switch (this.dialect) {
                    case POSTGRES: {
                        column = column + " JSONB";
                        break;
                    }
                    case SQL_SERVER: {
                        column = column + " NVARCHAR(MAX)";
                        break;
                    }
                    case ORACLE: {
                        column = column + " CLOB";
                        break;
                    }
                    default: {
                        column = column + " JSON";
                    }
                }
                if (!required) break;
                column = column + " NOT NULL";
                break;
            }
            default: {
                if (isAssociation) {
                    Association association = (Association)prop;
                    PersistentEntity associatedEntity = association.getAssociatedEntity();
                    PersistentProperty identity = associatedEntity.getIdentity();
                    if (identity == null) break;
                    return this.addTypeToColumn(identity, false, column, required);
                }
                if (prop.isEnum()) {
                    column = column + " VARCHAR(255)";
                    if (!required) break;
                    column = column + " NOT NULL";
                    break;
                }
                if (prop.isAssignable(Clob.class)) {
                    column = this.dialect == Dialect.POSTGRES ? column + " TEXT" : column + " CLOB";
                    if (!required) break;
                    column = column + " NOT NULL";
                    break;
                }
                if (prop.isAssignable(Blob.class)) {
                    column = this.dialect == Dialect.POSTGRES ? column + " BYTEA" : column + " BLOB";
                    if (!required) break;
                    column = column + " NOT NULL";
                    break;
                }
                throw new MappingException("Unable to create table column for property [" + prop.getName() + "] of entity [" + prop.getOwner().getName() + "] with unknown data type: " + (Object)((Object)dataType));
            }
        }
        return column;
    }

    @Override
    public boolean supportsForUpdate() {
        return true;
    }

    @Override
    public Dialect dialect() {
        return this.dialect;
    }

    @Override
    public String positionalParameterFormat() {
        DialectConfig dialectConfig = this.perDialectConfig.get((Object)this.dialect);
        if (dialectConfig != null && dialectConfig.positionalFormatter != null) {
            return dialectConfig.positionalFormatter;
        }
        return DEFAULT_POSITIONAL_PARAMETER_MARKER;
    }

    @Override
    public boolean escapeQueries() {
        DialectConfig dialectConfig = this.perDialectConfig.get((Object)this.dialect);
        if (dialectConfig != null && dialectConfig.escapeQueries != null) {
            return dialectConfig.escapeQueries;
        }
        return true;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return SqlQueryConfiguration.DialectConfiguration.class;
    }

    private static /* synthetic */ String lambda$buildJoin$30(NamingStrategy namingStrategy, Association association) {
        return namingStrategy.mappedName(association);
    }

    private static /* synthetic */ JoinPath lambda$buildJoin$29(StringBuilder pathSoFar, Association[] associationPath, int finalI, JoinPath joinPath) {
        return new JoinPath(pathSoFar.toString(), Arrays.copyOfRange(associationPath, 0, finalI + 1), joinPath.getJoinType(), joinPath.getAlias().orElse(null));
    }

    private static class DialectConfig {
        Boolean escapeQueries;
        String positionalFormatter;

        private DialectConfig() {
        }
    }
}

