/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.query.builder.sql;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.data.model.DataType;

public enum Dialect {
    H2,
    MYSQL(false, true),
    POSTGRES,
    SQL_SERVER(false, false),
    ORACLE(true, true),
    ANSI;

    private final boolean supportsBatch;
    private final boolean stringUUID;

    private Dialect() {
        this(true, false);
    }

    private Dialect(boolean supportsBatch, boolean stringUUID) {
        this.supportsBatch = supportsBatch;
        this.stringUUID = stringUUID;
    }

    public final boolean allowBatch() {
        return this.supportsBatch;
    }

    public final boolean requiresStringUUID(@NonNull DataType type) {
        return type == DataType.UUID && this.stringUUID;
    }
}

