/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.query.builder.jpa;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.query.JoinPath;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.builder.AbstractSqlLikeQueryBuilder;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.model.query.builder.QueryResult;
import java.util.Map;

@Internal
public class JpaQueryBuilder
extends AbstractSqlLikeQueryBuilder
implements QueryBuilder {
    public JpaQueryBuilder() {
        this.queryHandlers.put(QueryModel.EqualsAll.class, (queryState, criterion) -> {
            String comparisonExpression = " = ALL (";
            this.handleSubQuery(queryState, (QueryModel.SubqueryCriterion)criterion, comparisonExpression);
        });
        this.queryHandlers.put(QueryModel.NotEqualsAll.class, (queryState, criterion) -> {
            String comparisonExpression = " != ALL (";
            this.handleSubQuery(queryState, (QueryModel.SubqueryCriterion)criterion, comparisonExpression);
        });
        this.queryHandlers.put(QueryModel.GreaterThanAll.class, (queryState, criterion) -> {
            String comparisonExpression = " > ALL (";
            this.handleSubQuery(queryState, (QueryModel.SubqueryCriterion)criterion, comparisonExpression);
        });
        this.queryHandlers.put(QueryModel.GreaterThanSome.class, (queryState, criterion) -> {
            String comparisonExpression = " > SOME (";
            this.handleSubQuery(queryState, (QueryModel.SubqueryCriterion)criterion, comparisonExpression);
        });
        this.queryHandlers.put(QueryModel.GreaterThanEqualsAll.class, (queryState, criterion) -> {
            String comparisonExpression = " >= ALL (";
            this.handleSubQuery(queryState, (QueryModel.SubqueryCriterion)criterion, comparisonExpression);
        });
        this.queryHandlers.put(QueryModel.GreaterThanEqualsSome.class, (queryState, criterion) -> {
            String comparisonExpression = " >= SOME (";
            this.handleSubQuery(queryState, (QueryModel.SubqueryCriterion)criterion, comparisonExpression);
        });
        this.queryHandlers.put(QueryModel.LessThanAll.class, (queryState, criterion) -> {
            String comparisonExpression = " < ALL (";
            this.handleSubQuery(queryState, (QueryModel.SubqueryCriterion)criterion, comparisonExpression);
        });
        this.queryHandlers.put(QueryModel.LessThanSome.class, (queryState, criterion) -> {
            String comparisonExpression = " < SOME (";
            this.handleSubQuery(queryState, (QueryModel.SubqueryCriterion)criterion, comparisonExpression);
        });
        this.queryHandlers.put(QueryModel.LessThanEqualsAll.class, (queryState, criterion) -> {
            String comparisonExpression = " <= ALL (";
            this.handleSubQuery(queryState, (QueryModel.SubqueryCriterion)criterion, comparisonExpression);
        });
        this.queryHandlers.put(QueryModel.LessThanEqualsSome.class, (queryState, criterion) -> {
            String comparisonExpression = " <= SOME (";
            this.handleSubQuery(queryState, (QueryModel.SubqueryCriterion)criterion, comparisonExpression);
        });
    }

    @Override
    protected String quote(String persistedName) {
        return persistedName;
    }

    @Override
    public String getAliasName(PersistentEntity entity) {
        return entity.getDecapitalizedName() + "_";
    }

    @Override
    protected String[] buildJoin(String alias, JoinPath joinPath, String joinType, StringBuilder target, Map<String, String> appliedJoinPaths, AbstractSqlLikeQueryBuilder.QueryState queryState) {
        Association association = joinPath.getAssociation();
        String joinAlias = this.getAliasName(joinPath);
        target.append(joinType).append(alias).append('.').append(association.getName()).append(' ').append(joinAlias);
        return new String[]{joinAlias};
    }

    @Override
    protected String getTableName(PersistentEntity entity) {
        return entity.getName();
    }

    @Override
    protected String getColumnName(PersistentProperty persistentProperty) {
        return persistentProperty.getName();
    }

    @Override
    protected void selectAllColumns(AbstractSqlLikeQueryBuilder.QueryState queryState) {
        queryState.getQuery().append(queryState.getCurrentAlias());
    }

    @Override
    protected void appendProjectionRowCount(StringBuilder queryString, String logicalName) {
        queryString.append("COUNT").append('(').append(logicalName).append(')');
    }

    @Override
    protected final boolean computePropertyPaths() {
        return false;
    }

    @Override
    protected boolean isAliasForBatch() {
        return true;
    }

    @Override
    protected AbstractSqlLikeQueryBuilder.Placeholder formatParameter(int index) {
        String n = "p" + index;
        return new AbstractSqlLikeQueryBuilder.Placeholder(this, ":" + n, n);
    }

    @Override
    public String resolveJoinType(Join.Type jt) {
        String joinType;
        switch (jt) {
            case LEFT: {
                joinType = " LEFT JOIN ";
                break;
            }
            case LEFT_FETCH: {
                joinType = " LEFT JOIN FETCH ";
                break;
            }
            case RIGHT: {
                joinType = " RIGHT JOIN ";
                break;
            }
            case RIGHT_FETCH: {
                joinType = " RIGHT JOIN FETCH ";
                break;
            }
            case INNER: 
            case FETCH: {
                joinType = " JOIN FETCH ";
                break;
            }
            default: {
                joinType = " JOIN ";
            }
        }
        return joinType;
    }

    @Override
    @Nullable
    public QueryResult buildInsert(AnnotationMetadata repositoryMetadata, PersistentEntity entity) {
        return null;
    }

    @Override
    @NonNull
    protected StringBuilder appendDeleteClause(StringBuilder queryString) {
        return queryString.append("DELETE ");
    }

    @Override
    @NonNull
    public QueryResult buildPagination(@NonNull Pageable pageable) {
        throw new UnsupportedOperationException("JPA-QL does not support pagination in query definitions");
    }
}

