/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.query.builder;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.annotation.DataTransformer;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.annotation.MappedProperty;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.Embedded;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.naming.NamingStrategy;
import io.micronaut.data.model.query.AssociationQuery;
import io.micronaut.data.model.query.JoinPath;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.QueryParameter;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.model.query.builder.QueryResult;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractSqlLikeQueryBuilder
implements QueryBuilder {
    public static final String ORDER_BY_CLAUSE = " ORDER BY ";
    protected static final String SELECT_CLAUSE = "SELECT ";
    protected static final String AS_CLAUSE = " AS ";
    protected static final String FROM_CLAUSE = " FROM ";
    protected static final String WHERE_CLAUSE = " WHERE ";
    protected static final char COMMA = ',';
    protected static final char CLOSE_BRACKET = ')';
    protected static final char OPEN_BRACKET = '(';
    protected static final char SPACE = ' ';
    protected static final char DOT = '.';
    protected static final String NOT_CLAUSE = " NOT";
    protected static final String LOGICAL_AND = " AND ";
    protected static final String UPDATE_CLAUSE = "UPDATE ";
    protected static final String DELETE_CLAUSE = "DELETE ";
    protected static final String LOGICAL_OR = " OR ";
    protected static final String FUNCTION_COUNT = "COUNT";
    private static final String DISTINCT_CLAUSE = "DISTINCT ";
    protected final Map<Class, QueryHandler> queryHandlers = new HashMap<Class, QueryHandler>(30);

    public AbstractSqlLikeQueryBuilder() {
        this.queryHandlers.put(AssociationQuery.class, (queryState, criterion) -> {
            if (!queryState.isAllowJoins()) {
                throw new IllegalArgumentException("Joins cannot be used in a DELETE or UPDATE operation");
            }
            AssociationQuery aq = (AssociationQuery)criterion;
            Association association = aq.getAssociation();
            QueryModel.Junction associationCriteria = aq.getCriteria();
            List<QueryModel.Criterion> associationCriteriaList = associationCriteria.getCriteria();
            this.handleAssociationCriteria(aq, queryState, association, associationCriteria, associationCriteriaList);
        });
        this.queryHandlers.put(QueryModel.Negation.class, (queryState, criterion) -> {
            queryState.getWhereClause().append(NOT_CLAUSE).append('(');
            QueryModel.Negation negation = (QueryModel.Negation)criterion;
            this.buildWhereClauseForCriterion(queryState, negation, negation.getCriteria());
            queryState.getWhereClause().append(')');
        });
        this.queryHandlers.put(QueryModel.Conjunction.class, (queryState, criterion) -> {
            queryState.getWhereClause().append('(');
            QueryModel.Conjunction conjunction = (QueryModel.Conjunction)criterion;
            this.buildWhereClauseForCriterion(queryState, conjunction, conjunction.getCriteria());
            queryState.getWhereClause().append(')');
        });
        this.queryHandlers.put(QueryModel.Disjunction.class, (queryState, criterion) -> {
            queryState.getWhereClause().append('(');
            QueryModel.Disjunction disjunction = (QueryModel.Disjunction)criterion;
            this.buildWhereClauseForCriterion(queryState, disjunction, disjunction.getCriteria());
            queryState.getWhereClause().append(')');
        });
        this.queryHandlers.put(QueryModel.Equals.class, (queryState, criterion) -> {
            QueryModel.Equals eq = (QueryModel.Equals)criterion;
            String name = eq.getProperty();
            PropertyPath prop = this.validateProperty(queryState, name, QueryModel.Equals.class);
            if (eq.isIgnoreCase()) {
                this.appendCaseInsensitiveCriterion(queryState, eq, prop.getProperty(), prop.getPath(), "=");
            } else {
                this.appendCriteriaForOperator(queryState, prop.getProperty(), prop.getPath(), eq.getValue(), " = ");
            }
        });
        this.queryHandlers.put(QueryModel.EqualsProperty.class, (queryState, criterion) -> {
            PersistentEntity entity = queryState.getEntity();
            QueryModel.EqualsProperty eq = (QueryModel.EqualsProperty)criterion;
            String propertyName = eq.getProperty();
            String otherProperty = eq.getOtherProperty();
            PropertyPath left = this.validateProperty(queryState, propertyName, QueryModel.EqualsProperty.class);
            PropertyPath right = this.validateProperty(queryState, otherProperty, QueryModel.EqualsProperty.class);
            AbstractSqlLikeQueryBuilder.appendPropertyComparison(queryState.getWhereClause(), queryState.getCurrentAlias(), propertyName, otherProperty, "=");
        });
        this.queryHandlers.put(QueryModel.NotEqualsProperty.class, (queryState, criterion) -> {
            PersistentEntity entity = queryState.getEntity();
            QueryModel.PropertyComparisonCriterion eq = (QueryModel.PropertyComparisonCriterion)criterion;
            String propertyName = eq.getProperty();
            String otherProperty = eq.getOtherProperty();
            PropertyPath left = this.validateProperty(queryState, propertyName, QueryModel.NotEqualsProperty.class);
            PropertyPath right = this.validateProperty(queryState, otherProperty, QueryModel.NotEqualsProperty.class);
            AbstractSqlLikeQueryBuilder.appendPropertyComparison(queryState.getWhereClause(), queryState.getCurrentAlias(), propertyName, otherProperty, "!=");
        });
        this.queryHandlers.put(QueryModel.GreaterThanProperty.class, (queryState, criterion) -> {
            PersistentEntity entity = queryState.getEntity();
            QueryModel.PropertyComparisonCriterion eq = (QueryModel.PropertyComparisonCriterion)criterion;
            String propertyName = eq.getProperty();
            String otherProperty = eq.getOtherProperty();
            PropertyPath left = this.validateProperty(queryState, propertyName, QueryModel.GreaterThanProperty.class);
            PropertyPath right = this.validateProperty(queryState, otherProperty, QueryModel.GreaterThanProperty.class);
            AbstractSqlLikeQueryBuilder.appendPropertyComparison(queryState.getWhereClause(), queryState.getCurrentAlias(), propertyName, otherProperty, ">");
        });
        this.queryHandlers.put(QueryModel.GreaterThanEqualsProperty.class, (queryState, criterion) -> {
            PersistentEntity entity = queryState.getEntity();
            QueryModel.PropertyComparisonCriterion eq = (QueryModel.PropertyComparisonCriterion)criterion;
            String propertyName = eq.getProperty();
            String otherProperty = eq.getOtherProperty();
            PropertyPath left = this.validateProperty(queryState, propertyName, QueryModel.GreaterThanEqualsProperty.class);
            PropertyPath right = this.validateProperty(queryState, otherProperty, QueryModel.GreaterThanEqualsProperty.class);
            AbstractSqlLikeQueryBuilder.appendPropertyComparison(queryState.getWhereClause(), queryState.getCurrentAlias(), propertyName, otherProperty, ">=");
        });
        this.queryHandlers.put(QueryModel.LessThanProperty.class, (queryState, criterion) -> {
            PersistentEntity entity = queryState.getEntity();
            QueryModel.PropertyComparisonCriterion eq = (QueryModel.PropertyComparisonCriterion)criterion;
            String propertyName = eq.getProperty();
            String otherProperty = eq.getOtherProperty();
            PropertyPath left = this.validateProperty(queryState, propertyName, QueryModel.LessThanProperty.class);
            PropertyPath right = this.validateProperty(queryState, otherProperty, QueryModel.LessThanProperty.class);
            AbstractSqlLikeQueryBuilder.appendPropertyComparison(queryState.getWhereClause(), queryState.getCurrentAlias(), propertyName, otherProperty, "<");
        });
        this.queryHandlers.put(QueryModel.LessThanEqualsProperty.class, (queryState, criterion) -> {
            PersistentEntity entity = queryState.getEntity();
            QueryModel.PropertyComparisonCriterion eq = (QueryModel.PropertyComparisonCriterion)criterion;
            String propertyName = eq.getProperty();
            String otherProperty = eq.getOtherProperty();
            PropertyPath left = this.validateProperty(queryState, propertyName, QueryModel.LessThanEqualsProperty.class);
            PropertyPath right = this.validateProperty(queryState, otherProperty, QueryModel.LessThanEqualsProperty.class);
            AbstractSqlLikeQueryBuilder.appendPropertyComparison(queryState.getWhereClause(), queryState.getCurrentAlias(), propertyName, otherProperty, "<=");
        });
        this.queryHandlers.put(QueryModel.IsNull.class, (queryState, criterion) -> {
            QueryModel.IsNull isNull = (QueryModel.IsNull)criterion;
            this.applyPropertyExpression(queryState, isNull, QueryModel.IsNull.class, " IS NULL ");
        });
        this.queryHandlers.put(QueryModel.IsTrue.class, (queryState, criterion) -> {
            QueryModel.IsTrue isTrue = (QueryModel.IsTrue)criterion;
            this.applyPropertyExpression(queryState, isTrue, QueryModel.IsTrue.class, " = TRUE ");
        });
        this.queryHandlers.put(QueryModel.IsFalse.class, (queryState, criterion) -> {
            QueryModel.IsFalse isFalse = (QueryModel.IsFalse)criterion;
            this.applyPropertyExpression(queryState, isFalse, QueryModel.IsFalse.class, " = FALSE ");
        });
        this.queryHandlers.put(QueryModel.IsNotNull.class, (queryState, criterion) -> {
            QueryModel.IsNotNull isNotNull = (QueryModel.IsNotNull)criterion;
            this.applyPropertyExpression(queryState, isNotNull, QueryModel.IsNotNull.class, " IS NOT NULL ");
        });
        this.queryHandlers.put(QueryModel.IsEmpty.class, (queryState, criterion) -> {
            QueryModel.IsEmpty isEmpty = (QueryModel.IsEmpty)criterion;
            String name = isEmpty.getProperty();
            this.appendEmptyExpression(queryState, " IS NULL OR ", " = '' ", " IS EMPTY ", name);
        });
        this.queryHandlers.put(QueryModel.IsNotEmpty.class, (queryState, criterion) -> {
            QueryModel.IsNotEmpty isNotEmpty = (QueryModel.IsNotEmpty)criterion;
            String name = isNotEmpty.getProperty();
            this.appendEmptyExpression(queryState, " IS NOT NULL AND ", " <> '' ", " IS NOT EMPTY ", name);
        });
        this.queryHandlers.put(QueryModel.IdEquals.class, (queryState, criterion) -> {
            PersistentProperty prop = queryState.getEntity().getIdentity();
            if (prop == null) {
                throw new IllegalStateException("No id found for name entity: " + queryState.getEntity().getIdentity());
            }
            this.appendCriteriaForOperator(queryState, prop, prop.getName(), ((QueryModel.IdEquals)criterion).getValue(), " = ");
        });
        this.queryHandlers.put(QueryModel.NotEquals.class, (queryState, criterion) -> {
            QueryModel.NotEquals eq = (QueryModel.NotEquals)criterion;
            String name = eq.getProperty();
            PropertyPath prop = this.validateProperty(queryState, name, QueryModel.NotEquals.class);
            if (eq.isIgnoreCase()) {
                this.appendCaseInsensitiveCriterion(queryState, eq, prop.getProperty(), prop.getPath(), "!=");
            } else {
                this.appendCriteriaForOperator(queryState, prop.getProperty(), prop.getPath(), eq.getValue(), " != ");
            }
        });
        this.queryHandlers.put(QueryModel.GreaterThan.class, (queryState, criterion) -> {
            QueryModel.GreaterThan eq = (QueryModel.GreaterThan)criterion;
            String name = eq.getProperty();
            PropertyPath prop = this.validateProperty(queryState, name, QueryModel.GreaterThan.class);
            this.appendCriteriaForOperator(queryState, prop.getProperty(), prop.getPath(), eq.getValue(), " > ");
        });
        this.queryHandlers.put(QueryModel.LessThanEquals.class, (queryState, criterion) -> {
            QueryModel.LessThanEquals eq = (QueryModel.LessThanEquals)criterion;
            String name = eq.getProperty();
            PropertyPath prop = this.validateProperty(queryState, name, QueryModel.LessThanEquals.class);
            this.appendCriteriaForOperator(queryState, prop.getProperty(), prop.getPath(), eq.getValue(), " <= ");
        });
        this.queryHandlers.put(QueryModel.GreaterThanEquals.class, (queryState, criterion) -> {
            QueryModel.GreaterThanEquals eq = (QueryModel.GreaterThanEquals)criterion;
            String name = eq.getProperty();
            PropertyPath prop = this.validateProperty(queryState, name, QueryModel.GreaterThanEquals.class);
            this.appendCriteriaForOperator(queryState, prop.getProperty(), prop.getPath(), eq.getValue(), " >= ");
        });
        this.queryHandlers.put(QueryModel.Between.class, (queryState, criterion) -> {
            QueryModel.Between between = (QueryModel.Between)criterion;
            String name = between.getProperty();
            PropertyPath prop = this.validateProperty(queryState, name, QueryModel.Between.class);
            String qualifiedName = queryState.getCurrentAlias() + '.' + (this.computePropertyPaths() ? this.getColumnName(prop.property) : prop.getPath());
            Placeholder fromParam = queryState.newParameter();
            Placeholder toParam = queryState.newParameter();
            queryState.getWhereClause().append('(').append(qualifiedName).append(" >= ").append(fromParam.name);
            queryState.getWhereClause().append(LOGICAL_AND).append(qualifiedName).append(" <= ").append(toParam.name).append(')');
            queryState.getParameters().put(fromParam.key, between.getFrom().getName());
            queryState.getParameters().put(toParam.key, between.getTo().getName());
        });
        this.queryHandlers.put(QueryModel.LessThan.class, (queryState, criterion) -> {
            QueryModel.LessThan eq = (QueryModel.LessThan)criterion;
            String name = eq.getProperty();
            PropertyPath prop = this.validateProperty(queryState, name, QueryModel.LessThan.class);
            this.appendCriteriaForOperator(queryState, prop.getProperty(), prop.getPath(), eq.getValue(), " < ");
        });
        this.queryHandlers.put(QueryModel.Like.class, (queryState, criterion) -> {
            QueryModel.Like eq = (QueryModel.Like)criterion;
            String name = eq.getProperty();
            PropertyPath prop = this.validateProperty(queryState, name, QueryModel.Like.class);
            this.appendCriteriaForOperator(queryState, prop.getProperty(), prop.getPath(), eq.getValue(), " like ");
        });
        this.queryHandlers.put(QueryModel.ILike.class, (queryState, criterion) -> {
            QueryModel.ILike eq = (QueryModel.ILike)criterion;
            String name = eq.getProperty();
            PropertyPath prop = this.validateProperty(queryState, name, QueryModel.ILike.class);
            String operator = "like";
            this.appendCaseInsensitiveCriterion(queryState, eq, prop.getProperty(), prop.getPath(), operator);
        });
        this.queryHandlers.put(QueryModel.StartsWith.class, (queryState, criterion) -> {
            QueryModel.StartsWith eq = (QueryModel.StartsWith)criterion;
            this.appendLikeComparison(queryState, eq, " LIKE CONCAT(", ",'%')");
        });
        this.queryHandlers.put(QueryModel.Contains.class, (queryState, criterion) -> {
            QueryModel.Contains eq = (QueryModel.Contains)criterion;
            this.appendLikeComparison(queryState, eq, " LIKE CONCAT('%',", ",'%')");
        });
        this.queryHandlers.put(QueryModel.EndsWith.class, (queryState, criterion) -> {
            QueryModel.EndsWith eq = (QueryModel.EndsWith)criterion;
            this.appendLikeComparison(queryState, eq, " LIKE CONCAT('%',", ")");
        });
        this.queryHandlers.put(QueryModel.In.class, (queryState, criterion) -> {
            QueryModel.In inQuery = (QueryModel.In)criterion;
            String name = inQuery.getProperty();
            PropertyPath prop = this.validateProperty(queryState, name, QueryModel.In.class);
            Object value = inQuery.getValue();
            if (value instanceof QueryParameter) {
                QueryParameter queryParameter = (QueryParameter)value;
                String currentAlias = queryState.getCurrentAlias();
                String qualifiedName = currentAlias != null ? currentAlias + '.' + (this.computePropertyPaths() ? this.getColumnName(prop.getProperty()) : prop.getPath()) : (this.computePropertyPaths() ? this.getColumnName(prop.getProperty()) : prop.getPath());
                Placeholder placeholder = queryState.newParameter();
                String queryParameterName = queryParameter.getName();
                queryState.getParameters().put(placeholder.key, queryParameterName);
                queryState.addParameterType(queryParameterName, prop.getProperty().getDataType());
                StringBuilder whereClause = queryState.getWhereClause();
                whereClause.append(qualifiedName);
                this.encodeInExpression(whereClause, placeholder);
            }
        });
        this.queryHandlers.put(QueryModel.NotIn.class, (queryState, criterion) -> {
            String comparisonExpression = " NOT IN (";
            this.handleSubQuery(queryState, (QueryModel.SubqueryCriterion)criterion, comparisonExpression);
        });
    }

    private void appendEmptyExpression(QueryState queryState, String charSequencePrefix, String charSequenceSuffix, String listSuffix, String name) {
        String path;
        PropertyPath property = this.validateProperty(queryState, name, QueryModel.IsEmpty.class);
        PersistentProperty persistentProperty = property.getProperty();
        String aliasRef = this.computePropertyPaths() ? this.getColumnName(persistentProperty) : property.getPath();
        String currentAlias = queryState.getCurrentAlias();
        String string = path = currentAlias == null ? "" : currentAlias + '.';
        if (persistentProperty.isAssignable(CharSequence.class)) {
            queryState.getWhereClause().append(path).append(aliasRef).append(charSequencePrefix).append(path).append(aliasRef).append(charSequenceSuffix);
        } else {
            queryState.getWhereClause().append(path).append(aliasRef).append(listSuffix);
        }
    }

    private void appendLikeComparison(QueryState queryState, QueryModel.PropertyCriterion eq, String prefix, String suffix) {
        String name = eq.getProperty();
        PropertyPath prop = this.validateProperty(queryState, name, QueryModel.ILike.class);
        String currentAlias = queryState.getCurrentAlias();
        String qualifiedName = currentAlias != null ? currentAlias + '.' + (this.computePropertyPaths() ? this.getColumnName(prop.getProperty()) : prop.getPath()) : (this.computePropertyPaths() ? this.getColumnName(prop.getProperty()) : prop.getPath());
        Placeholder parameterName = queryState.newParameter();
        queryState.getWhereClause().append(qualifiedName).append(prefix).append(parameterName.name).append(suffix);
        Object value = eq.getValue();
        this.addComputedParameter(queryState, prop.getProperty(), parameterName, value);
    }

    private void addComputedParameter(QueryState queryState, PersistentProperty property, Placeholder placeholder, Object queryValue) {
        if (queryValue instanceof QueryParameter) {
            String queryParameter = ((QueryParameter)queryValue).getName();
            queryState.addParameterType(queryParameter, property.getDataType());
            queryState.getParameters().put(placeholder.key, queryParameter);
        }
    }

    private void applyPropertyExpression(QueryState queryState, QueryModel.PropertyNameCriterion propertyNameCriterion, Class<?> criterionType, String expression) {
        String name = propertyNameCriterion.getProperty();
        PropertyPath prop = this.validateProperty(queryState, name, criterionType);
        String alias = queryState.getCurrentAlias();
        StringBuilder whereClause = queryState.getWhereClause();
        if (alias != null) {
            whereClause.append(alias).append('.');
        }
        whereClause.append(this.computePropertyPaths() ? this.getColumnName(prop.getProperty()) : prop.getPath()).append(expression);
    }

    protected void encodeInExpression(StringBuilder whereClause, Placeholder placeholder) {
        whereClause.append(" IN (").append(placeholder.name).append(')');
    }

    @Override
    @NonNull
    public QueryResult buildQuery(@NonNull QueryModel query) {
        ArgumentUtils.requireNonNull((String)"query", (Object)query);
        QueryState queryState = this.newQueryState(query, true);
        queryState.getQuery().append(SELECT_CLAUSE);
        this.buildSelectClause(query, queryState);
        QueryModel.Junction criteria = query.getCriteria();
        Collection<JoinPath> joinPaths = query.getJoinPaths();
        for (JoinPath joinPath : joinPaths) {
            queryState.applyJoin(joinPath);
        }
        Map<String, String> parameters = null;
        if (!criteria.isEmpty()) {
            parameters = this.buildWhereClause(criteria, queryState);
        }
        this.appendOrder(query, queryState);
        return QueryResult.of(queryState.getQuery().toString(), parameters, queryState.getParameterTypes());
    }

    protected abstract String getTableName(PersistentEntity var1);

    protected String getAliasName(PersistentEntity entity) {
        return this.getTableName(entity) + "_";
    }

    public String getAliasName(JoinPath joinPath) {
        return joinPath.getAlias().orElseGet(() -> {
            String joinPathAlias = this.getPathOnlyAliasName(joinPath);
            PersistentEntity owner = joinPath.getAssociationPath()[0].getOwner();
            String ownerAlias = this.getAliasName(owner);
            if (ownerAlias.endsWith("_") && joinPathAlias.startsWith("_")) {
                return ownerAlias + joinPathAlias.substring(1);
            }
            return ownerAlias + joinPathAlias;
        });
    }

    @NonNull
    protected String getPathOnlyAliasName(JoinPath joinPath) {
        return joinPath.getAlias().orElseGet(() -> {
            String p = joinPath.getPath().replace('.', '_');
            return '_' + NamingStrategy.DEFAULT.mappedName(p) + "_";
        });
    }

    protected abstract String[] buildJoin(String var1, JoinPath var2, String var3, StringBuilder var4, Map<String, String> var5);

    protected abstract String getColumnName(PersistentProperty var1);

    protected abstract void selectAllColumns(QueryState var1);

    private QueryState newQueryState(@NonNull QueryModel query, boolean allowJoins) {
        return new QueryState(query, allowJoins);
    }

    private void buildSelectClause(QueryModel query, QueryState queryState) {
        String logicalName = queryState.getCurrentAlias();
        PersistentEntity entity = queryState.getEntity();
        boolean escape = this.shouldEscape(entity);
        StringBuilder queryString = queryState.getQuery();
        this.buildSelect(queryState, queryString, query.getProjections(), logicalName, entity);
        String tableName = this.getTableName(entity);
        if (escape) {
            tableName = this.quote(tableName);
        }
        queryString.append(FROM_CLAUSE).append(tableName).append(this.getTableAsKeyword()).append(logicalName);
    }

    protected boolean shouldEscape(@NonNull PersistentEntity entity) {
        return entity.getAnnotationMetadata().isTrue(MappedEntity.class, "escape");
    }

    protected String getTableAsKeyword() {
        return AS_CLAUSE;
    }

    protected String quote(String persistedName) {
        return "\"" + persistedName + "\"";
    }

    private void buildSelect(QueryState queryState, StringBuilder queryString, List<QueryModel.Projection> projectionList, String logicalName, PersistentEntity entity) {
        if (projectionList.isEmpty()) {
            this.selectAllColumns(queryState);
        } else {
            Iterator<QueryModel.Projection> i = projectionList.iterator();
            while (i.hasNext()) {
                QueryModel.Projection projection = i.next();
                if (projection instanceof QueryModel.CountProjection) {
                    this.appendProjectionRowCount(queryString, logicalName);
                } else if (projection instanceof QueryModel.DistinctProjection) {
                    queryString.append("DISTINCT(").append(logicalName).append(')');
                } else if (projection instanceof QueryModel.IdProjection) {
                    PersistentProperty identity = entity.getIdentity();
                    if (identity == null) {
                        throw new IllegalArgumentException("Cannot query on ID with entity that has no ID");
                    }
                    this.appendPropertyProjection(queryString, logicalName, identity, identity.getName());
                } else if (projection instanceof QueryModel.PropertyProjection) {
                    QueryModel.PropertyProjection pp = (QueryModel.PropertyProjection)projection;
                    String alias = pp.getAlias().orElse(null);
                    if (projection instanceof QueryModel.AvgProjection) {
                        this.appendProjection(queryState.getEntity(), "AVG", pp, logicalName, queryString);
                    } else if (projection instanceof QueryModel.DistinctPropertyProjection) {
                        this.appendProjection(queryState.getEntity(), "DISTINCT", pp, logicalName, queryString);
                    } else if (projection instanceof QueryModel.SumProjection) {
                        this.appendProjection(queryState.getEntity(), "SUM", pp, logicalName, queryString);
                    } else if (projection instanceof QueryModel.MinProjection) {
                        this.appendProjection(queryState.getEntity(), "MIN", pp, logicalName, queryString);
                    } else if (projection instanceof QueryModel.MaxProjection) {
                        this.appendProjection(queryState.getEntity(), "MAX", pp, logicalName, queryString);
                    } else if (projection instanceof QueryModel.CountDistinctProjection) {
                        this.appendProjection(queryState.getEntity(), "COUNT(DISTINCT", pp, logicalName, queryString);
                        queryString.append(')');
                    } else {
                        String propertyName = pp.getPropertyName();
                        PersistentProperty persistentProperty = entity.getPropertyByPath(propertyName).orElseThrow(() -> new IllegalArgumentException("Cannot project on non-existent property: " + propertyName));
                        this.appendPropertyProjection(queryString, logicalName, persistentProperty, propertyName);
                    }
                    if (alias != null) {
                        queryString.append(AS_CLAUSE).append(alias);
                    }
                }
                if (!i.hasNext()) continue;
                queryString.append(',');
            }
        }
    }

    private void appendPropertyProjection(StringBuilder queryString, String alias, PersistentProperty persistentProperty, String propertyName) {
        PersistentEntity owner = persistentProperty.getOwner();
        boolean escape = this.shouldEscape(owner);
        if (persistentProperty instanceof Embedded) {
            PersistentEntity embedded = ((Embedded)persistentProperty).getAssociatedEntity();
            Iterator<? extends PersistentProperty> embeddedIterator = embedded.getPersistentProperties().iterator();
            while (embeddedIterator.hasNext()) {
                PersistentProperty embeddedProp = embeddedIterator.next();
                String columnName = this.computeEmbeddedName(persistentProperty, persistentProperty.getName(), embeddedProp);
                if (escape) {
                    columnName = this.quote(columnName);
                }
                queryString.append(alias).append('.').append(columnName);
                if (!embeddedIterator.hasNext()) continue;
                queryString.append(',').append(' ');
            }
        } else if (this.computePropertyPaths()) {
            String columnName = this.getColumnName(persistentProperty);
            if (escape) {
                columnName = this.quote(columnName);
            }
            queryString.append(alias).append('.').append(columnName);
        } else {
            queryString.append(alias).append('.').append(propertyName);
        }
    }

    private void appendProjection(PersistentEntity entity, String functionName, QueryModel.PropertyProjection propertyProjection, String logicalName, StringBuilder queryString) {
        boolean escape = this.shouldEscape(entity);
        PersistentProperty persistentProperty = entity.getPropertyByPath(propertyProjection.getPropertyName()).orElseThrow(() -> new IllegalArgumentException("Cannot project on non-existent property: " + propertyProjection.getPropertyName()));
        String columnName = this.getColumnName(persistentProperty);
        if (escape) {
            columnName = this.quote(columnName);
        }
        queryString.append(functionName).append('(').append(logicalName).append('.').append(columnName).append(')');
    }

    protected abstract void appendProjectionRowCount(StringBuilder var1, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAssociationCriteria(AssociationQuery associationQuery, QueryState queryState, Association association, QueryModel.Junction associationCriteria, List<QueryModel.Criterion> associationCriteriaList) {
        if (association == null) {
            return;
        }
        String currentName = queryState.getCurrentAlias();
        PersistentEntity currentEntity = queryState.getEntity();
        PersistentEntity associatedEntity = association.getAssociatedEntity();
        String associationPath = associationQuery.getPath();
        if (!this.computePropertyPaths()) {
            try {
                QueryModel queryModel = queryState.getQueryModel();
                JoinPath joinPath = queryModel.getJoinPath(associationPath).orElse(null);
                if (joinPath == null && association.isForeignKey()) {
                    joinPath = queryModel.join(associationPath, association, Join.Type.DEFAULT, null);
                }
                String alias = joinPath != null ? queryState.applyJoin(joinPath) : queryState.computeAlias(associationPath);
                queryState.setEntity(associatedEntity);
                queryState.setCurrentAlias(alias);
                this.buildWhereClauseForCriterion(queryState, associationCriteria, associationCriteriaList);
            }
            finally {
                queryState.setCurrentAlias(currentName);
                queryState.setEntity(currentEntity);
            }
        }
        QueryModel queryModel = queryState.getQueryModel();
        JoinPath joinPath = queryModel.getJoinPath(associationPath).orElse(null);
        if (joinPath == null) {
            joinPath = queryModel.join(associationPath, association, Join.Type.DEFAULT, null);
        }
        String alias = queryState.applyJoin(joinPath);
        try {
            queryState.setEntity(associatedEntity);
            queryState.setCurrentAlias(alias);
            this.buildWhereClauseForCriterion(queryState, associationCriteria, associationCriteriaList);
        }
        finally {
            queryState.setCurrentAlias(currentName);
            queryState.setEntity(currentEntity);
        }
    }

    private Map<String, String> buildWhereClause(QueryModel.Junction criteria, QueryState queryState) {
        if (!criteria.isEmpty()) {
            List<QueryModel.Criterion> criterionList = criteria.getCriteria();
            StringBuilder whereClause = queryState.getWhereClause();
            whereClause.append(WHERE_CLAUSE);
            if (criteria instanceof QueryModel.Negation) {
                whereClause.append(NOT_CLAUSE);
            }
            whereClause.append('(');
            this.buildWhereClauseForCriterion(queryState, criteria, criterionList);
            String whereStr = whereClause.toString();
            if (!whereStr.equals(" WHERE (")) {
                queryState.getQuery().append(whereStr);
                queryState.getQuery().append(')');
            }
        }
        return queryState.getParameters();
    }

    private void appendOrder(QueryModel query, QueryState queryState) {
        List<Sort.Order> orders = query.getSort().getOrderBy();
        if (!orders.isEmpty()) {
            StringBuilder buff = queryState.getQuery();
            buff.append(ORDER_BY_CLAUSE);
            Iterator<Sort.Order> i = orders.iterator();
            while (i.hasNext()) {
                Sort.Order order = i.next();
                String currentAlias = queryState.getCurrentAlias();
                if (currentAlias != null) {
                    buff.append(currentAlias).append('.');
                }
                String property = order.getProperty();
                PropertyPath propertyPath = this.validateProperty(queryState, property, Sort.Order.class);
                buff.append(this.getColumnName(propertyPath.getProperty())).append(' ').append(order.getDirection().toString());
                if (!i.hasNext()) continue;
                buff.append(",");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildWhereClauseForCriterion(QueryState queryState, QueryModel.Junction criteria, List<QueryModel.Criterion> criterionList) {
        boolean isFirst = true;
        for (QueryModel.Criterion criterion : criterionList) {
            String operator = criteria instanceof QueryModel.Conjunction ? LOGICAL_AND : LOGICAL_OR;
            QueryHandler qh = this.queryHandlers.get(criterion.getClass());
            boolean isAssociationCriteria = criterion instanceof AssociationQuery;
            if (qh != null) {
                if (!isFirst) {
                    if (isAssociationCriteria) {
                        if (!((AssociationQuery)criterion).getCriteria().getCriteria().isEmpty()) {
                            queryState.getWhereClause().append(operator);
                        }
                    } else {
                        queryState.getWhereClause().append(operator);
                    }
                }
                String currentAlias = queryState.getCurrentAlias();
                try {
                    qh.handle(queryState, criterion);
                }
                finally {
                    queryState.setCurrentAlias(currentAlias);
                }
            } else if (isAssociationCriteria) {
                if (!queryState.isAllowJoins()) {
                    throw new IllegalArgumentException("Joins cannot be used in a DELETE or UPDATE operation");
                }
                AssociationQuery ac = (AssociationQuery)criterion;
                Association association = ac.getAssociation();
                QueryModel.Junction junction = ac.getCriteria();
                this.handleAssociationCriteria(ac, queryState, association, junction, junction.getCriteria());
            } else {
                throw new IllegalArgumentException("Queries of type " + criterion.getClass().getSimpleName() + " are not supported by this implementation");
            }
            if (!isFirst) continue;
            if (isAssociationCriteria) {
                if (((AssociationQuery)criterion).getCriteria().getCriteria().isEmpty()) continue;
                isFirst = false;
                continue;
            }
            isFirst = false;
        }
    }

    private void appendCriteriaForOperator(QueryState queryState, PersistentProperty property, String path, Object value, String operator) {
        if (value instanceof QueryParameter) {
            QueryParameter queryParameter = (QueryParameter)value;
            StringBuilder whereClause = queryState.getWhereClause();
            String alias = queryState.getCurrentAlias();
            if (property instanceof Embedded) {
                PersistentEntity embeddedEntity = ((Embedded)property).getAssociatedEntity();
                Iterator<? extends PersistentProperty> iterator = embeddedEntity.getPersistentProperties().iterator();
                while (iterator.hasNext()) {
                    PersistentProperty embeddedProperty = iterator.next();
                    Placeholder placeholder = queryState.newParameter();
                    if (alias != null) {
                        whereClause.append(alias).append('.');
                    }
                    String columnName = this.computeEmbeddedName(property, path, embeddedProperty);
                    whereClause.append(columnName).append(operator).append(placeholder.name);
                    this.addComputedParameter(queryState, property, placeholder, new QueryParameter(queryParameter.getName() + "." + embeddedProperty.getName()));
                    if (!iterator.hasNext()) continue;
                    whereClause.append(LOGICAL_AND);
                }
            } else {
                boolean computePropertyPaths;
                Placeholder placeholder = queryState.newParameter();
                if (alias != null) {
                    whereClause.append(alias).append('.');
                }
                if (computePropertyPaths = this.computePropertyPaths()) {
                    String columnName = this.getColumnName(property);
                    if (queryState.shouldEscape()) {
                        columnName = this.quote(columnName);
                    }
                    whereClause.append(columnName).append(operator).append(placeholder.name);
                } else {
                    whereClause.append(path).append(operator).append(placeholder.name);
                }
                this.addComputedParameter(queryState, property, placeholder, queryParameter);
            }
        }
    }

    private String computeEmbeddedName(PersistentProperty parentProperty, String path, PersistentProperty embeddedProperty) {
        String explicitColumn = embeddedProperty.getAnnotationMetadata().stringValue(MappedProperty.class).orElse(null);
        if (explicitColumn == null) {
            NamingStrategy namingStrategy = parentProperty.getOwner().getNamingStrategy();
            explicitColumn = namingStrategy.mappedName(parentProperty.getName() + embeddedProperty.getCapitilizedName());
        }
        return this.computePropertyPaths() ? explicitColumn : path + "." + embeddedProperty.getName();
    }

    private void appendCaseInsensitiveCriterion(QueryState queryState, QueryModel.PropertyCriterion criterion, PersistentProperty prop, String path, String operator) {
        boolean isComputePaths;
        Placeholder placeholder = queryState.newParameter();
        StringBuilder whereClause = queryState.getWhereClause();
        String currentAlias = queryState.getCurrentAlias();
        whereClause.append("lower(");
        if (currentAlias != null) {
            whereClause.append(currentAlias).append('.');
        }
        if (isComputePaths = this.computePropertyPaths()) {
            String columnName = this.getColumnName(prop);
            if (queryState.shouldEscape()) {
                columnName = this.quote(columnName);
            }
            whereClause.append(columnName);
        } else {
            whereClause.append(path);
        }
        whereClause.append(") ").append(operator).append(" lower(").append(placeholder.name).append(")");
        Object value = criterion.getValue();
        this.addComputedParameter(queryState, prop, placeholder, value);
    }

    protected void handleSubQuery(QueryState queryState, QueryModel.SubqueryCriterion subqueryCriterion, String comparisonExpression) {
        String name = subqueryCriterion.getProperty();
        this.validateProperty(queryState, name, QueryModel.In.class);
        QueryModel subquery = subqueryCriterion.getValue();
        String currentAlias = queryState.getCurrentAlias();
        StringBuilder whereClause = queryState.getWhereClause();
        if (currentAlias != null) {
            whereClause.append(currentAlias).append('.');
        }
        whereClause.append(name).append(comparisonExpression);
        this.buildSubQuery(queryState, subquery);
        whereClause.append(')');
    }

    private void buildSubQuery(QueryState queryState, QueryModel subquery) {
    }

    private void buildUpdateStatement(QueryState queryState, List<String> propertiesToUpdate) {
        StringBuilder queryString = queryState.getQuery();
        Map<String, String> parameters = queryState.getParameters();
        queryString.append(' ').append("SET").append(' ');
        Iterator<String> iterator = propertiesToUpdate.iterator();
        while (iterator.hasNext()) {
            String propertyName = iterator.next();
            PersistentProperty prop = queryState.getEntity().getPropertyByName(propertyName);
            if (prop == null) continue;
            if (prop instanceof Association && ((Association)prop).isForeignKey()) {
                throw new IllegalArgumentException("Foreign key associations cannot be updated as part of a batch update statement");
            }
            String currentAlias = queryState.getCurrentAlias();
            if (currentAlias != null) {
                queryString.append(currentAlias).append('.');
            }
            String columnName = this.getColumnName(prop);
            if (queryState.escape) {
                columnName = this.quote(columnName);
            }
            queryString.append(columnName).append('=');
            Placeholder param = queryState.newParameter();
            queryString.append(prop.getAnnotationMetadata().stringValue(DataTransformer.class, "write").orElse(param.name));
            parameters.put(param.key, prop.getName());
            if (!iterator.hasNext()) continue;
            queryString.append(',');
        }
    }

    private static void appendPropertyComparison(StringBuilder q, String alias, String propertyName, String otherProperty, String operator) {
        if (alias != null) {
            q.append(alias).append('.');
        }
        q.append(propertyName).append(operator);
        if (alias != null) {
            q.append(alias).append('.');
        }
        q.append(otherProperty);
    }

    @NonNull
    private PropertyPath validateProperty(QueryState queryState, String name, Class criterionType) {
        String path;
        PersistentEntity entity = queryState.getEntity();
        PersistentProperty identity = entity.getIdentity();
        if (identity != null && identity.getName().equals(name)) {
            return new PropertyPath(identity, identity.getName());
        }
        PersistentProperty[] compositeIdentity = entity.getCompositeIdentity();
        if (compositeIdentity != null) {
            for (PersistentProperty property : compositeIdentity) {
                if (!property.getName().equals(name)) continue;
                return new PropertyPath(property, property.getName());
            }
        }
        PersistentProperty prop = entity.getPropertyByName(name);
        String string = path = name.contains(".") ? name : (String)entity.getPath(name).orElse(null);
        if (prop == null) {
            PersistentProperty persistentProperty = prop = path != null ? (PersistentProperty)entity.getPropertyByPath(path).orElse(null) : null;
        }
        if (prop == null) {
            if (name.equals("id") && identity != null) {
                return new PropertyPath(identity, identity.getName());
            }
            if (criterionType == Sort.Order.class) {
                throw new IllegalArgumentException("Cannot order on non-existent property path: " + name);
            }
            throw new IllegalArgumentException("Cannot use [" + criterionType.getSimpleName() + "] criterion on non-existent property path: " + name);
        }
        if (this.computePropertyPaths() && name.contains(".")) {
            StringTokenizer tokenizer = new StringTokenizer(name, ".");
            String first = tokenizer.nextToken();
            PersistentProperty p = queryState.getEntity().getPropertyByName(first);
            if (p instanceof Association) {
                QueryModel queryModel = queryState.getQueryModel();
                JoinPath joinPath = queryModel.getJoinPath(name).orElse(null);
                if (joinPath == null) {
                    joinPath = queryModel.join(p.getName(), (Association)p, Join.Type.DEFAULT, null);
                }
                if (queryState.isAllowJoins()) {
                    String alias = queryState.applyJoin(joinPath);
                    queryState.setCurrentAlias(alias);
                } else {
                    throw new IllegalArgumentException("Joins are not allowed for batch update queries");
                }
            }
        }
        return new PropertyPath(prop, path != null ? path : name);
    }

    protected abstract boolean computePropertyPaths();

    @Override
    @NonNull
    public QueryResult buildUpdate(@NonNull QueryModel query, List<String> propertiesToUpdate) {
        if (propertiesToUpdate.isEmpty()) {
            throw new IllegalArgumentException("No properties specified to update");
        }
        PersistentEntity entity = query.getPersistentEntity();
        QueryState queryState = this.newQueryState(query, false);
        StringBuilder queryString = queryState.getQuery();
        if (!this.isAliasForBatch()) {
            queryState.setCurrentAlias(null);
        }
        String currentAlias = queryState.getCurrentAlias();
        String tableName = this.getTableName(entity);
        if (queryState.escape) {
            tableName = this.quote(tableName);
        }
        queryString.append(UPDATE_CLAUSE).append(tableName);
        if (currentAlias != null) {
            queryString.append(' ').append(currentAlias);
        }
        this.buildUpdateStatement(queryState, propertiesToUpdate);
        this.buildWhereClause(query.getCriteria(), queryState);
        return QueryResult.of(queryString.toString(), queryState.getParameters(), queryState.getParameterTypes());
    }

    @Override
    @NonNull
    public QueryResult buildDelete(@NonNull QueryModel query) {
        PersistentEntity entity = query.getPersistentEntity();
        QueryState queryState = this.newQueryState(query, false);
        StringBuilder queryString = queryState.getQuery();
        String currentAlias = queryState.getCurrentAlias();
        if (!this.isAliasForBatch()) {
            currentAlias = null;
            queryState.setCurrentAlias(null);
        }
        StringBuilder buffer = this.appendDeleteClause(queryString);
        String tableName = this.getTableName(entity);
        if (queryState.escape) {
            tableName = this.quote(tableName);
        }
        buffer.append(tableName).append(' ');
        if (currentAlias != null) {
            buffer.append(this.getTableAsKeyword()).append(currentAlias);
        }
        this.buildWhereClause(query.getCriteria(), queryState);
        return QueryResult.of(queryString.toString(), queryState.getParameters(), queryState.getParameterTypes());
    }

    protected abstract boolean isAliasForBatch();

    @NonNull
    protected StringBuilder appendDeleteClause(StringBuilder queryString) {
        return queryString.append(DELETE_CLAUSE).append(FROM_CLAUSE);
    }

    @Override
    @NonNull
    public QueryResult buildOrderBy(@NonNull PersistentEntity entity, @NonNull Sort sort) {
        ArgumentUtils.requireNonNull((String)"entity", (Object)entity);
        ArgumentUtils.requireNonNull((String)"sort", (Object)sort);
        List<Sort.Order> orders = sort.getOrderBy();
        if (CollectionUtils.isEmpty(orders)) {
            throw new IllegalArgumentException("Sort is empty");
        }
        StringBuilder buff = new StringBuilder(ORDER_BY_CLAUSE);
        Iterator<Sort.Order> i = orders.iterator();
        while (i.hasNext()) {
            String aliasName;
            Sort.Order order = i.next();
            String property = order.getProperty();
            PersistentProperty persistentProperty = entity.getPropertyByPath(property).orElseThrow(() -> new IllegalArgumentException("Cannot sort on non-existent property path: " + property));
            if (persistentProperty instanceof Association) {
                Association association = (Association)persistentProperty;
                aliasName = this.getAliasName(new JoinPath(property, new Association[]{association}, Join.Type.DEFAULT, null));
            } else {
                aliasName = this.getAliasName(entity);
            }
            buff.append(aliasName).append('.').append(this.getColumnName(persistentProperty)).append(' ').append((Object)order.getDirection());
            if (!i.hasNext()) continue;
            buff.append(",");
        }
        return QueryResult.of(buff.toString(), Collections.emptyMap(), Collections.emptyMap());
    }

    protected abstract Placeholder formatParameter(int var1);

    public abstract String resolveJoinType(Join.Type var1);

    protected class PropertyPath {
        private final PersistentProperty property;
        private final String path;

        public PropertyPath(@NonNull PersistentProperty property, String path) {
            this.property = property;
            this.path = path;
        }

        @NonNull
        public PersistentProperty getProperty() {
            return this.property;
        }

        @NonNull
        public String getPath() {
            return this.path;
        }
    }

    protected class Placeholder {
        private final String name;
        private final String key;

        public Placeholder(String name, String key) {
            this.name = name;
            this.key = key;
        }

        public String toString() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public String getKey() {
            return this.key;
        }
    }

    protected final class QueryState {
        private final Map<String, String> appliedJoinPaths = new HashMap<String, String>();
        private final AtomicInteger position = new AtomicInteger(0);
        private final Map<String, String> parameters = new LinkedHashMap<String, String>();
        private final Map<String, DataType> parameterTypes = new LinkedHashMap<String, DataType>();
        private final StringBuilder query = new StringBuilder();
        private final StringBuilder whereClause = new StringBuilder();
        private final boolean allowJoins;
        private final QueryModel queryObject;
        private final boolean escape;
        private String currentAlias;
        private PersistentEntity entity;

        private QueryState(QueryModel query, boolean allowJoins) {
            this.allowJoins = allowJoins;
            this.queryObject = query;
            this.entity = query.getPersistentEntity();
            this.escape = AbstractSqlLikeQueryBuilder.this.shouldEscape(this.entity);
            this.currentAlias = AbstractSqlLikeQueryBuilder.this.getAliasName(this.entity);
        }

        @Nullable
        public String getCurrentAlias() {
            return this.currentAlias;
        }

        public void setCurrentAlias(@Nullable String currentAlias) {
            this.currentAlias = currentAlias;
        }

        public PersistentEntity getEntity() {
            return this.entity;
        }

        public void setEntity(@NonNull PersistentEntity entity) {
            this.entity = entity;
        }

        public Map<String, String> getParameters() {
            return this.parameters;
        }

        public Map<String, DataType> getParameterTypes() {
            return Collections.unmodifiableMap(this.parameterTypes);
        }

        public void addParameterType(@NonNull String name, @NonNull DataType dataType) {
            this.parameterTypes.put(name, dataType);
        }

        public StringBuilder getQuery() {
            return this.query;
        }

        public StringBuilder getWhereClause() {
            return this.whereClause;
        }

        public boolean isAllowJoins() {
            return this.allowJoins;
        }

        public QueryModel getQueryModel() {
            return this.queryObject;
        }

        public Placeholder newParameter() {
            return AbstractSqlLikeQueryBuilder.this.formatParameter(this.position.incrementAndGet());
        }

        public String applyJoin(@NonNull JoinPath joinPath) {
            String alias = this.getCurrentAlias();
            StringBuilder associationPath = new StringBuilder(alias + '.' + joinPath.getPath());
            if (!this.appliedJoinPaths.containsKey(associationPath.toString())) {
                Optional<JoinPath> jp = this.getQueryModel().getJoinPath(joinPath.getPath());
                if (jp.isPresent()) {
                    joinPath = jp.get();
                }
                StringBuilder stringBuilder = this.getQuery();
                Join.Type jt = joinPath.getJoinType();
                String joinType = AbstractSqlLikeQueryBuilder.this.resolveJoinType(jt);
                String[] associationAlias = AbstractSqlLikeQueryBuilder.this.buildJoin(alias, joinPath, joinType, stringBuilder, this.appliedJoinPaths);
                Association[] associationArray = joinPath.getAssociationPath();
                associationPath = null;
                for (int i = 0; i < associationAlias.length; ++i) {
                    Association association = associationArray[i];
                    if (associationPath == null) {
                        associationPath = new StringBuilder(association.getName());
                    } else {
                        associationPath.append('.').append(association.getName());
                    }
                    String computedAlias = associationAlias[i];
                    this.appliedJoinPaths.put(alias + '.' + associationPath, computedAlias);
                }
                return associationAlias[associationAlias.length - 1];
            }
            return this.appliedJoinPaths.get(associationPath.toString());
        }

        @NonNull
        public String computeAlias(String associationPath) {
            String p;
            String name = this.getCurrentAlias() + '.' + associationPath;
            if (this.appliedJoinPaths.containsKey(name)) {
                return this.appliedJoinPaths.get(name);
            }
            int i = associationPath.indexOf(46);
            if (i > -1 && this.appliedJoinPaths.containsKey(p = this.getCurrentAlias() + '.' + associationPath.substring(0, i))) {
                return this.appliedJoinPaths.get(p) + '.' + associationPath.substring(i + 1);
            }
            return this.getCurrentAlias() + '.' + associationPath;
        }

        public boolean shouldEscape() {
            return this.escape;
        }
    }

    protected static interface QueryHandler {
        public void handle(QueryState var1, QueryModel.Criterion var2);
    }
}

