/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.query;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.query.AssociationQuery;
import io.micronaut.data.model.query.Criteria;
import io.micronaut.data.model.query.DefaultProjectionList;
import io.micronaut.data.model.query.JoinPath;
import io.micronaut.data.model.query.ProjectionList;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.QueryParameter;
import io.micronaut.data.model.query.factory.Restrictions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DefaultQuery
implements QueryModel {
    private final PersistentEntity entity;
    private QueryModel.Junction criteria = new QueryModel.Conjunction();
    private DefaultProjectionList projections = new DefaultProjectionList();
    private int max = -1;
    private long offset = 0L;
    private Map<String, JoinPath> joinPaths = new HashMap<String, JoinPath>(2);
    private Sort sort = Sort.unsorted();

    protected DefaultQuery(@NonNull PersistentEntity entity) {
        ArgumentUtils.requireNonNull((String)"entity", (Object)entity);
        this.entity = entity;
    }

    @Override
    public Collection<JoinPath> getJoinPaths() {
        return Collections.unmodifiableCollection(this.joinPaths.values());
    }

    public AssociationQuery createQuery(String associationName) {
        PersistentProperty property = this.entity.getPropertyByPath(associationName).orElse(null);
        if (!(property instanceof Association)) {
            throw new IllegalArgumentException("Cannot query association [" + associationName + "] of class [" + this.entity + "]. The specified property is not an association.");
        }
        Association association = (Association)property;
        return new AssociationQuery(associationName, association);
    }

    @Override
    @NonNull
    public PersistentEntity getPersistentEntity() {
        return this.entity;
    }

    @Override
    public QueryModel.Junction getCriteria() {
        return this.criteria;
    }

    @Override
    @NonNull
    public List<QueryModel.Projection> getProjections() {
        return this.projections.getProjectionList();
    }

    @Override
    public Optional<JoinPath> getJoinPath(String path) {
        if (path != null) {
            return Optional.ofNullable(this.joinPaths.get(path));
        }
        return Optional.empty();
    }

    @Override
    public JoinPath join(@NonNull String path, @NonNull Association association, @NonNull Join.Type joinType, String alias) {
        PersistentEntity entity = this.getEntity();
        String[] elements = path.split("\\.");
        Association[] associations = new Association[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            Association a;
            PersistentProperty property = entity.getPropertyByName(elements[i]);
            if (property instanceof Association) {
                a = (Association)property;
                entity = a.getAssociatedEntity();
                if (entity == null) {
                    throw new IllegalArgumentException("Invalid association path. Element [" + elements[i] + "] references an associated entity that doesn't exist.");
                }
            } else {
                throw new IllegalArgumentException("Invalid association path. Element [" + elements[i] + "] is not an association.");
            }
            associations[i] = a;
        }
        JoinPath jp = new JoinPath(path, associations, joinType, alias);
        this.joinPaths.put(path, jp);
        return jp;
    }

    @Override
    public ProjectionList projections() {
        return this.projections;
    }

    @Override
    @NonNull
    public QueryModel add(@NonNull QueryModel.Criterion criterion) {
        ArgumentUtils.requireNonNull((String)"criterion", (Object)criterion);
        QueryModel.Junction currentJunction = this.criteria;
        this.add(currentJunction, criterion);
        return this;
    }

    private void add(QueryModel.Junction currentJunction, QueryModel.Criterion criterion) {
        this.addToJunction(currentJunction, criterion);
    }

    public PersistentEntity getEntity() {
        return this.entity;
    }

    public QueryModel.Junction disjunction() {
        QueryModel.Junction currentJunction = this.criteria;
        return this.disjunction(currentJunction);
    }

    public QueryModel.Junction conjunction() {
        QueryModel.Junction currentJunction = this.criteria;
        return this.conjunction(currentJunction);
    }

    public QueryModel.Junction negation() {
        QueryModel.Junction currentJunction = this.criteria;
        return this.negation(currentJunction);
    }

    private QueryModel.Junction negation(QueryModel.Junction currentJunction) {
        QueryModel.Negation dis = new QueryModel.Negation();
        currentJunction.add(dis);
        return dis;
    }

    @Override
    public DefaultQuery max(int max) {
        this.max = max;
        return this;
    }

    @Override
    public int getMax() {
        return this.max;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public DefaultQuery offset(long offset) {
        this.offset = offset;
        return this;
    }

    @Override
    public Sort getSort() {
        return this.sort;
    }

    @Override
    @NonNull
    public QueryModel sort(@NonNull Sort sort) {
        ArgumentUtils.requireNonNull((String)"sort", (Object)sort);
        this.sort = sort;
        return this;
    }

    @Override
    @NonNull
    public DefaultQuery eq(@NonNull String property, @NonNull QueryParameter parameter) {
        this.criteria.add(Restrictions.eq(property, parameter));
        return this;
    }

    @Override
    @NonNull
    public DefaultQuery allEq(@NonNull Map<String, QueryParameter> values) {
        QueryModel.Junction conjunction = this.conjunction();
        for (String property : values.keySet()) {
            QueryParameter value = values.get(property);
            conjunction.add(Restrictions.eq(property, value));
        }
        return this;
    }

    @Override
    @NonNull
    public Criteria eqAll(@NonNull String propertyName, @NonNull Criteria propertyValue) {
        return null;
    }

    @Override
    @NonNull
    public Criteria gtAll(@NonNull String propertyName, @NonNull Criteria propertyValue) {
        return null;
    }

    @Override
    @NonNull
    public Criteria ltAll(@NonNull String propertyName, @NonNull Criteria propertyValue) {
        return null;
    }

    @Override
    @NonNull
    public Criteria geAll(@NonNull String propertyName, @NonNull Criteria propertyValue) {
        return null;
    }

    @Override
    @NonNull
    public Criteria leAll(@NonNull String propertyName, @NonNull Criteria propertyValue) {
        return null;
    }

    @Override
    @NonNull
    public Criteria gtSome(@NonNull String propertyName, @NonNull Criteria propertyValue) {
        return null;
    }

    @Override
    @NonNull
    public Criteria geSome(@NonNull String propertyName, @NonNull Criteria propertyValue) {
        return null;
    }

    @Override
    @NonNull
    public Criteria ltSome(@NonNull String propertyName, @NonNull Criteria propertyValue) {
        return null;
    }

    @Override
    @NonNull
    public Criteria leSome(@NonNull String propertyName, @NonNull Criteria propertyValue) {
        return null;
    }

    @Override
    @NonNull
    public Criteria idEquals(QueryParameter parameter) {
        return null;
    }

    @Override
    @NonNull
    public DefaultQuery isEmpty(@NonNull String property) {
        this.criteria.add(Restrictions.isEmpty(property));
        return this;
    }

    @Override
    @NonNull
    public DefaultQuery isNotEmpty(@NonNull String property) {
        this.criteria.add(Restrictions.isNotEmpty(property));
        return this;
    }

    @Override
    @NonNull
    public DefaultQuery isNull(@NonNull String property) {
        this.criteria.add(Restrictions.isNull(property));
        return this;
    }

    @Override
    @NonNull
    public Criteria isTrue(@NonNull String propertyName) {
        this.criteria.add(Restrictions.isTrue(propertyName));
        return this;
    }

    @Override
    @NonNull
    public Criteria isFalse(@NonNull String propertyName) {
        this.criteria.add(Restrictions.isFalse(propertyName));
        return this;
    }

    @Override
    @NonNull
    public DefaultQuery isNotNull(@NonNull String property) {
        this.criteria.add(Restrictions.isNotNull(property));
        return this;
    }

    @Override
    @NonNull
    public DefaultQuery idEq(@NonNull QueryParameter value) {
        this.criteria.add(Restrictions.idEq(value));
        return this;
    }

    @Override
    @NonNull
    public Criteria ne(@NonNull String propertyName, @NonNull QueryParameter parameter) {
        this.criteria.add(Restrictions.ne(propertyName, parameter));
        return this;
    }

    @Override
    @NonNull
    public DefaultQuery gt(@NonNull String property, @NonNull QueryParameter value) {
        this.criteria.add(Restrictions.gt(property, value));
        return this;
    }

    @Override
    public DefaultQuery gte(String property, QueryParameter value) {
        this.criteria.add(Restrictions.gte(property, value));
        return this;
    }

    @Override
    public DefaultQuery lte(String property, QueryParameter value) {
        this.criteria.add(Restrictions.lte(property, value));
        return this;
    }

    @Override
    public DefaultQuery ge(String property, QueryParameter value) {
        return this.gte(property, value);
    }

    @Override
    public DefaultQuery le(String property, QueryParameter value) {
        return this.lte(property, value);
    }

    @Override
    public DefaultQuery lt(String property, QueryParameter value) {
        this.criteria.add(Restrictions.lt(property, value));
        return this;
    }

    @Override
    @NonNull
    public DefaultQuery like(@NonNull String propertyName, @NonNull QueryParameter parameter) {
        this.criteria.add(Restrictions.like(propertyName, parameter));
        return this;
    }

    @Override
    @NonNull
    public Criteria startsWith(@NonNull String propertyName, @NonNull QueryParameter parameter) {
        this.criteria.add(Restrictions.startsWith(propertyName, parameter));
        return this;
    }

    @Override
    @NonNull
    public Criteria endsWith(@NonNull String propertyName, @NonNull QueryParameter parameter) {
        this.criteria.add(Restrictions.endsWith(propertyName, parameter));
        return this;
    }

    @Override
    @NonNull
    public Criteria contains(@NonNull String propertyName, @NonNull QueryParameter parameter) {
        this.criteria.add(Restrictions.contains(propertyName, parameter));
        return this;
    }

    @Override
    @NonNull
    public DefaultQuery ilike(@NonNull String propertyName, @NonNull QueryParameter parameter) {
        this.criteria.add(Restrictions.ilike(propertyName, parameter));
        return this;
    }

    @Override
    @NonNull
    public DefaultQuery rlike(@NonNull String propertyName, @NonNull QueryParameter parameter) {
        this.criteria.add(Restrictions.rlike(propertyName, parameter));
        return this;
    }

    @Override
    @NonNull
    public Criteria and(@NonNull Criteria other) {
        return this;
    }

    @Override
    @NonNull
    public Criteria or(@NonNull Criteria other) {
        return this;
    }

    @Override
    @NonNull
    public Criteria not(@NonNull Criteria other) {
        return this;
    }

    @Override
    @NonNull
    public DefaultQuery inList(@NonNull String propertyName, @NonNull QueryModel subquery) {
        this.criteria.add(Restrictions.in(propertyName, subquery));
        return this;
    }

    @Override
    public DefaultQuery inList(String property, QueryParameter values) {
        this.criteria.add(Restrictions.in(property, values));
        return this;
    }

    @Override
    @NonNull
    public DefaultQuery notIn(@NonNull String propertyName, @NonNull QueryModel subquery) {
        this.criteria.add(Restrictions.notIn(propertyName, subquery));
        return this;
    }

    @Override
    @NonNull
    public DefaultQuery sizeEq(@NonNull String propertyName, @NonNull QueryParameter size) {
        this.criteria.add(Restrictions.sizeEq(propertyName, size));
        return this;
    }

    @Override
    @NonNull
    public DefaultQuery sizeGt(@NonNull String propertyName, @NonNull QueryParameter size) {
        this.criteria.add(Restrictions.sizeGt(propertyName, size));
        return this;
    }

    @Override
    @NonNull
    public DefaultQuery sizeGe(@NonNull String propertyName, @NonNull QueryParameter size) {
        this.criteria.add(Restrictions.sizeGe(propertyName, size));
        return this;
    }

    @Override
    @NonNull
    public DefaultQuery sizeLe(@NonNull String propertyName, @NonNull QueryParameter size) {
        this.criteria.add(Restrictions.sizeLe(propertyName, size));
        return this;
    }

    @Override
    @NonNull
    public DefaultQuery sizeLt(@NonNull String propertyName, @NonNull QueryParameter size) {
        this.criteria.add(Restrictions.sizeLt(propertyName, size));
        return this;
    }

    @Override
    @NonNull
    public DefaultQuery sizeNe(@NonNull String propertyName, @NonNull QueryParameter size) {
        this.criteria.add(Restrictions.sizeNe(propertyName, size));
        return this;
    }

    @Override
    @NonNull
    public DefaultQuery eqProperty(@NonNull String propertyName, @NonNull String otherPropertyName) {
        this.criteria.add(Restrictions.eqProperty(propertyName, otherPropertyName));
        return this;
    }

    @Override
    @NonNull
    public DefaultQuery neProperty(@NonNull String propertyName, @NonNull String otherPropertyName) {
        this.criteria.add(Restrictions.neProperty(propertyName, otherPropertyName));
        return this;
    }

    @Override
    @NonNull
    public DefaultQuery gtProperty(@NonNull String propertyName, @NonNull String otherPropertyName) {
        this.criteria.add(Restrictions.gtProperty(propertyName, otherPropertyName));
        return this;
    }

    @Override
    @NonNull
    public DefaultQuery geProperty(@NonNull String propertyName, @NonNull String otherPropertyName) {
        this.criteria.add(Restrictions.geProperty(propertyName, otherPropertyName));
        return this;
    }

    @Override
    @NonNull
    public DefaultQuery ltProperty(@NonNull String propertyName, @NonNull String otherPropertyName) {
        this.criteria.add(Restrictions.ltProperty(propertyName, otherPropertyName));
        return this;
    }

    @Override
    @NonNull
    public DefaultQuery leProperty(String propertyName, @NonNull String otherPropertyName) {
        this.criteria.add(Restrictions.leProperty(propertyName, otherPropertyName));
        return this;
    }

    @Override
    public DefaultQuery between(String property, QueryParameter start, QueryParameter end) {
        this.criteria.add(Restrictions.between(property, start, end));
        return this;
    }

    public DefaultQuery and(QueryModel.Criterion a, QueryModel.Criterion b) {
        Objects.requireNonNull(a, "Left hand side of AND cannot be null");
        Objects.requireNonNull(b, "Right hand side of AND cannot be null");
        this.criteria.add(Restrictions.and(a, b));
        return this;
    }

    public DefaultQuery or(QueryModel.Criterion a, QueryModel.Criterion b) {
        Objects.requireNonNull(a, "Left hand side of AND cannot be null");
        Objects.requireNonNull(b, "Right hand side of AND cannot be null");
        this.criteria.add(Restrictions.or(a, b));
        return this;
    }

    private QueryModel.Junction disjunction(QueryModel.Junction currentJunction) {
        QueryModel.Disjunction dis = new QueryModel.Disjunction();
        currentJunction.add(dis);
        return dis;
    }

    private QueryModel.Junction conjunction(QueryModel.Junction currentJunction) {
        QueryModel.Conjunction con = new QueryModel.Conjunction();
        currentJunction.add(con);
        return con;
    }

    private void addToJunction(QueryModel.Junction currentJunction, QueryModel.Criterion criterion) {
        if (criterion instanceof QueryModel.PropertyCriterion) {
            QueryModel.PropertyCriterion pc = (QueryModel.PropertyCriterion)criterion;
            Object value = pc.getValue();
            pc.setValue(value);
        }
        if (criterion instanceof QueryModel.Junction) {
            QueryModel.Junction j = (QueryModel.Junction)criterion;
            QueryModel.Junction newj = j instanceof QueryModel.Disjunction ? this.disjunction(currentJunction) : (j instanceof QueryModel.Negation ? this.negation(currentJunction) : this.conjunction(currentJunction));
            for (QueryModel.Criterion c : j.getCriteria()) {
                this.addToJunction(newj, c);
            }
        } else {
            currentJunction.add(criterion);
        }
    }
}

