/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.annotation.Embeddable;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.AssociationUtils;
import io.micronaut.data.model.Embedded;
import io.micronaut.data.model.PersistentElement;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.naming.NamingStrategy;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public interface PersistentEntity
extends PersistentElement {
    @NonNull
    public String getName();

    @NonNull
    public String getAliasName();

    @Nullable
    public PersistentProperty[] getCompositeIdentity();

    @Nullable
    public PersistentProperty getIdentity();

    @Nullable
    public PersistentProperty getVersion();

    default public boolean isVersioned() {
        return this.getVersion() != null;
    }

    @NonNull
    public Collection<? extends PersistentProperty> getPersistentProperties();

    @NonNull
    public Collection<Association> getAssociations();

    @NonNull
    public Collection<Embedded> getEmbedded();

    @Nullable
    public PersistentProperty getPropertyByName(String var1);

    @NonNull
    public Collection<String> getPersistentPropertyNames();

    default public boolean isEmbeddable() {
        return this.getAnnotationMetadata().hasAnnotation(Embeddable.class);
    }

    default public String getSimpleName() {
        return NameUtils.getSimpleName((String)this.getName());
    }

    @NonNull
    default public String getDecapitalizedName() {
        return NameUtils.decapitalize((String)this.getSimpleName());
    }

    public boolean isOwningEntity(PersistentEntity var1);

    @Nullable
    public PersistentEntity getParentEntity();

    default public Optional<String> getPath(String camelCasePath) {
        List path = Arrays.stream(AssociationUtils.CAMEL_CASE_SPLIT_PATTERN.split(camelCasePath)).map(NameUtils::decapitalize).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(path)) {
            Iterator i = path.iterator();
            StringBuilder b = new StringBuilder();
            PersistentEntity currentEntity = this;
            while (i.hasNext()) {
                PersistentProperty identity;
                String name = (String)i.next();
                PersistentProperty sp = currentEntity.getPropertyByName(name);
                if (sp == null && (identity = currentEntity.getIdentity()) != null && identity.getName().equals(name)) {
                    sp = identity;
                }
                if (sp != null) {
                    b.append(name);
                    if (i.hasNext()) {
                        b.append('.');
                    }
                    if (!(sp instanceof Association)) continue;
                    currentEntity = ((Association)sp).getAssociatedEntity();
                    continue;
                }
                if (i.hasNext()) {
                    sp = currentEntity.getPropertyByName(name = name + NameUtils.capitalize((String)((String)i.next())));
                    if (sp != null) {
                        if (sp instanceof Association) {
                            currentEntity = ((Association)sp).getAssociatedEntity();
                        }
                        b.append(name);
                        if (!i.hasNext()) continue;
                        b.append(".");
                        continue;
                    }
                    return Optional.empty();
                }
                return Optional.empty();
            }
            return Optional.of(b.toString());
        }
        return Optional.empty();
    }

    @NonNull
    default public PersistentEntity getRootEntity() {
        return this;
    }

    default public boolean isRoot() {
        return this.getRootEntity() == this;
    }

    default public Optional<PersistentProperty> getPropertyByPath(String path) {
        if (path.indexOf(46) == -1) {
            PersistentProperty identity;
            PersistentProperty pp = this.getPropertyByName(path);
            if (pp == null && (identity = this.getIdentity()) != null && identity.getName().equals(path)) {
                pp = identity;
            }
            return Optional.ofNullable(pp);
        }
        String[] tokens = path.split("\\.");
        PersistentEntity startingEntity = this;
        PersistentProperty prop = null;
        for (String token : tokens) {
            prop = startingEntity.getPropertyByName(token);
            if (prop == null) {
                PersistentProperty identity = startingEntity.getIdentity();
                if (identity != null && identity.getName().equals(token)) {
                    prop = identity;
                    continue;
                }
                return Optional.empty();
            }
            if (!(prop instanceof Association)) continue;
            startingEntity = ((Association)prop).getAssociatedEntity();
        }
        return Optional.ofNullable(prop);
    }

    @NonNull
    public NamingStrategy getNamingStrategy();

    @NonNull
    public static <T> RuntimePersistentEntity<T> of(@NonNull Class<T> type) {
        ArgumentUtils.requireNonNull((String)"type", type);
        return new RuntimePersistentEntity<T>(type);
    }

    @NonNull
    public static <T> RuntimePersistentEntity<T> of(@NonNull BeanIntrospection<T> introspection) {
        ArgumentUtils.requireNonNull((String)"introspection", introspection);
        return new RuntimePersistentEntity<T>(introspection);
    }
}

