/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.query.builder.sql;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Creator;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.DataTransformer;
import io.micronaut.data.annotation.GeneratedValue;
import io.micronaut.data.annotation.Id;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.annotation.MappedProperty;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.annotation.Repository;
import io.micronaut.data.exceptions.MappingException;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.Embedded;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.naming.NamingStrategy;
import io.micronaut.data.model.query.JoinPath;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.builder.AbstractSqlLikeQueryBuilder;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.model.query.builder.QueryResult;
import io.micronaut.data.model.query.builder.sql.Dialect;
import java.sql.Blob;
import java.sql.Clob;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SqlQueryBuilder
extends AbstractSqlLikeQueryBuilder
implements QueryBuilder {
    public static final String IN_EXPRESSION_START = " ?$IN(";
    private static final String ANN_JOIN_TABLE = "io.micronaut.data.jdbc.annotation.JoinTable";
    private static final String BLANK_SPACE = " ";
    private Dialect dialect = Dialect.ANSI;

    @Creator
    public SqlQueryBuilder(AnnotationMetadata annotationMetadata) {
        if (annotationMetadata != null) {
            this.dialect = annotationMetadata.findAnnotation(Repository.class).flatMap(av -> av.enumValue("dialect", Dialect.class)).orElse(Dialect.ANSI);
        }
    }

    public SqlQueryBuilder() {
    }

    public SqlQueryBuilder(Dialect dialect) {
        ArgumentUtils.requireNonNull((String)"dialect", (Object)((Object)dialect));
        this.dialect = dialect;
    }

    @NonNull
    public String buildBatchCreateTableStatement(PersistentEntity ... entities) {
        return Arrays.stream(entities).flatMap(entity -> Stream.of(this.buildCreateTableStatements((PersistentEntity)entity))).collect(Collectors.joining("\n"));
    }

    @NonNull
    public String buildBatchDropTableStatement(PersistentEntity ... entities) {
        return Arrays.stream(entities).flatMap(entity -> Stream.of(this.buildDropTableStatements((PersistentEntity)entity))).collect(Collectors.joining("\n"));
    }

    @NonNull
    public String[] buildDropTableStatements(@NonNull PersistentEntity entity) {
        String tableName = this.getTableName(entity);
        String sql = "DROP TABLE " + tableName + ";";
        Collection<Association> foreignKeyAssociations = this.getJoinTableAssociations(entity.getPersistentProperties());
        ArrayList<String> dropStatements = new ArrayList<String>();
        for (Association association : foreignKeyAssociations) {
            AnnotationMetadata associationMetadata = association.getAnnotationMetadata();
            NamingStrategy namingStrategy = entity.getNamingStrategy();
            String joinTableName = associationMetadata.stringValue(ANN_JOIN_TABLE, "name").orElseGet(() -> namingStrategy.mappedName(association));
            dropStatements.add("DROP TABLE " + joinTableName + ";");
        }
        dropStatements.add(sql);
        return dropStatements.toArray(new String[0]);
    }

    @NonNull
    public String[] buildCreateTableStatements(@NonNull PersistentEntity entity) {
        Collection<Association> foreignKeyAssociations;
        ArgumentUtils.requireNonNull((String)"entity", (Object)entity);
        String tableName = this.getTableName(entity);
        StringBuilder builder = new StringBuilder("CREATE TABLE ").append(tableName).append(" (");
        ArrayList<? extends PersistentProperty> props = new ArrayList<PersistentProperty>(entity.getPersistentProperties());
        PersistentProperty identity = entity.getIdentity();
        if (identity != null) {
            props.add(0, identity);
        }
        ArrayList<String> createStatements = new ArrayList<String>();
        String schema = entity.getAnnotationMetadata().stringValue(MappedEntity.class, "schema").orElse(null);
        if (StringUtils.isNotEmpty((CharSequence)schema)) {
            createStatements.add("CREATE SCHEMA " + schema + ";");
        }
        if (CollectionUtils.isNotEmpty(foreignKeyAssociations = this.getJoinTableAssociations(props))) {
            for (Association association : foreignKeyAssociations) {
                StringBuilder stringBuilder = new StringBuilder("CREATE TABLE ");
                PersistentEntity associatedEntity = association.getAssociatedEntity();
                NamingStrategy namingStrategy = entity.getNamingStrategy();
                String string = association.getAnnotationMetadata().stringValue(ANN_JOIN_TABLE, "name").orElseGet(() -> namingStrategy.mappedName(association));
                stringBuilder.append(string).append(" (");
                PersistentProperty associatedId = associatedEntity.getIdentity();
                String[] joinColumnNames = this.resolveJoinTableColumns(entity, associatedEntity, association, identity, associatedId, namingStrategy);
                stringBuilder.append(this.addTypeToColumn(identity, false, joinColumnNames[0], true)).append(',').append(this.addTypeToColumn(associatedId, false, joinColumnNames[1], true));
                stringBuilder.append(");");
                createStatements.add(stringBuilder.toString());
            }
        }
        ArrayList<String> columns = new ArrayList<String>(props.size());
        for (PersistentProperty persistentProperty : props) {
            boolean isAssociation = false;
            if (persistentProperty instanceof Association) {
                isAssociation = true;
                Association association = (Association)persistentProperty;
                if (association.isForeignKey()) continue;
            }
            if (persistentProperty instanceof Embedded) {
                Embedded embedded = (Embedded)persistentProperty;
                PersistentEntity persistentEntity = embedded.getAssociatedEntity();
                Collection<? extends PersistentProperty> embeddedProperties = persistentEntity.getPersistentProperties();
                for (PersistentProperty persistentProperty2 : embeddedProperties) {
                    String explicitColumn = persistentProperty2.getAnnotationMetadata().stringValue(MappedProperty.class).orElse(null);
                    String column = explicitColumn != null ? explicitColumn : entity.getNamingStrategy().mappedName(persistentProperty.getName() + persistentProperty2.getCapitilizedName());
                    boolean required = persistentProperty2.isRequired() || persistentProperty.getAnnotationMetadata().hasStereotype(Id.class);
                    column = this.addTypeToColumn(persistentProperty2, persistentProperty2 instanceof Association, column, required);
                    column = this.addGeneratedStatementToColumn(identity, persistentProperty, column);
                    columns.add(column);
                }
                continue;
            }
            String column = this.getColumnName(persistentProperty);
            column = this.addTypeToColumn(persistentProperty, isAssociation, column, persistentProperty.isRequired());
            column = this.addGeneratedStatementToColumn(identity, persistentProperty, column);
            columns.add(column);
        }
        builder.append(String.join((CharSequence)",", columns));
        if (identity instanceof Embedded) {
            Embedded embedded = (Embedded)identity;
            PersistentEntity persistentEntity = embedded.getAssociatedEntity();
            ArrayList<String> primaryKeyColumns = new ArrayList<String>();
            for (PersistentProperty persistentProperty : persistentEntity.getPersistentProperties()) {
                String explicitColumn = persistentProperty.getAnnotationMetadata().stringValue(MappedProperty.class).orElse(null);
                String column = explicitColumn != null ? explicitColumn : entity.getNamingStrategy().mappedName(identity.getName() + persistentProperty.getCapitilizedName());
                primaryKeyColumns.add(column);
            }
            builder.append(", PRIMARY KEY(").append(String.join((CharSequence)",", primaryKeyColumns)).append(')');
        }
        builder.append(");");
        createStatements.add(builder.toString());
        return createStatements.toArray(new String[0]);
    }

    @Override
    protected String getTableAsKeyword() {
        return BLANK_SPACE;
    }

    private String addGeneratedStatementToColumn(PersistentProperty identity, PersistentProperty prop, String column) {
        if (prop.isGenerated()) {
            switch (this.dialect) {
                case POSTGRES: {
                    column = column + " GENERATED ALWAYS AS IDENTITY";
                    break;
                }
                case SQL_SERVER: {
                    if (prop == identity) {
                        column = column + " PRIMARY KEY";
                    }
                    column = column + " IDENTITY(1,1) NOT NULL";
                    break;
                }
                default: {
                    column = column + " AUTO_INCREMENT";
                    if (prop != identity) break;
                    column = column + " PRIMARY KEY";
                }
            }
        }
        return column;
    }

    @NonNull
    private String[] resolveJoinTableColumns(@NonNull PersistentEntity entity, PersistentEntity associatedEntity, Association association, PersistentProperty identity, PersistentProperty associatedId, NamingStrategy namingStrategy) {
        String[] joinColumnDefinitions;
        List joinColumns = association.getAnnotationMetadata().findAnnotation(ANN_JOIN_TABLE).map(av -> av.getAnnotations("joinColumns", MappedProperty.class)).orElse(Collections.emptyList());
        if (identity == null) {
            throw new MappingException("Cannot have a foreign key association without an ID on entity: " + entity.getName());
        }
        if (associatedId == null) {
            throw new MappingException("Cannot have a foreign key association without an ID on entity: " + associatedEntity.getName());
        }
        if (CollectionUtils.isEmpty(joinColumns)) {
            String thisName = namingStrategy.mappedName(entity.getDecapitalizedName() + namingStrategy.getForeignKeySuffix());
            String thatName = namingStrategy.mappedName(associatedEntity.getDecapitalizedName() + namingStrategy.getForeignKeySuffix());
            joinColumnDefinitions = new String[]{thisName, thatName};
        } else {
            if (joinColumns.size() != 2) {
                throw new MappingException("Expected exactly 2 join columns for association [" + association.getName() + "] of entity: " + entity.getName());
            }
            String thisName = ((AnnotationValue)joinColumns.get(0)).stringValue().orElseGet(() -> namingStrategy.mappedName(entity.getDecapitalizedName() + namingStrategy.getForeignKeySuffix()));
            String thatName = ((AnnotationValue)joinColumns.get(1)).stringValue().orElseGet(() -> namingStrategy.mappedName(associatedEntity.getDecapitalizedName() + namingStrategy.getForeignKeySuffix()));
            joinColumnDefinitions = new String[]{thisName, thatName};
        }
        return joinColumnDefinitions;
    }

    @NonNull
    private Collection<Association> getJoinTableAssociations(Collection<? extends PersistentProperty> props) {
        return props.stream().filter(p -> {
            if (p instanceof Association) {
                Association a = (Association)p;
                return a.isForeignKey() && !a.getAnnotationMetadata().stringValue(Relation.class, "mappedBy").isPresent();
            }
            return false;
        }).map(p -> (Association)p).collect(Collectors.toList());
    }

    @Override
    protected void selectAllColumns(AbstractSqlLikeQueryBuilder.QueryState queryState) {
        Collection joinPaths;
        PersistentEntity entity = queryState.getEntity();
        String alias = queryState.getCurrentAlias();
        StringBuilder queryBuffer = queryState.getQuery();
        String columns = this.selectAllColumns(entity, alias);
        queryBuffer.append(columns);
        QueryModel queryModel = queryState.getQueryModel();
        Collection<JoinPath> allPaths = queryModel.getJoinPaths();
        if (CollectionUtils.isNotEmpty(allPaths) && CollectionUtils.isNotEmpty((Collection)(joinPaths = (Collection)allPaths.stream().filter(jp -> {
            Join.Type jt = jp.getJoinType();
            return jt.name().contains("FETCH");
        }).collect(Collectors.toList())))) {
            for (JoinPath joinPath : joinPaths) {
                Association association = joinPath.getAssociation();
                if (association instanceof Embedded) continue;
                PersistentEntity associatedEntity = association.getAssociatedEntity();
                List<PersistentProperty> associatedProperties = this.getPropertiesThatAreColumns(associatedEntity);
                PersistentProperty identity = associatedEntity.getIdentity();
                if (identity != null) {
                    associatedProperties.add(0, identity);
                }
                if (!CollectionUtils.isNotEmpty(associatedProperties)) continue;
                queryBuffer.append(',');
                String aliasName = this.getAliasName(joinPath);
                String joinPathAlias = this.getPathOnlyAliasName(joinPath);
                String columnNames = associatedProperties.stream().map(p -> {
                    String columnName = this.getColumnName((PersistentProperty)p);
                    return aliasName + '.' + columnName + " AS " + joinPathAlias + columnName;
                }).collect(Collectors.joining(","));
                queryBuffer.append(columnNames);
            }
        }
    }

    public String selectAllColumns(PersistentEntity entity, String alias) {
        String columns;
        List<PersistentProperty> persistentProperties = this.getPropertiesThatAreColumns(entity);
        if (CollectionUtils.isNotEmpty(persistentProperties)) {
            PersistentProperty identity = entity.getIdentity();
            if (identity != null) {
                persistentProperties.add(0, identity);
            }
            columns = persistentProperties.stream().map(p -> {
                Association association;
                if (p instanceof Association && (association = (Association)p).getKind() == Relation.Kind.EMBEDDED) {
                    PersistentEntity embeddedEntity = association.getAssociatedEntity();
                    List<PersistentProperty> embeddedProps = this.getPropertiesThatAreColumns(embeddedEntity);
                    return embeddedProps.stream().map(ep -> alias + '.' + ep.getAnnotationMetadata().stringValue(MappedProperty.class).orElseGet(() -> entity.getNamingStrategy().mappedName(association.getName() + ep.getCapitilizedName()))).collect(Collectors.joining(","));
                }
                return p.getAnnotationMetadata().stringValue(DataTransformer.class, "read").map(str -> str + " AS " + p.getPersistedName()).orElseGet(() -> alias + '.' + this.getColumnName((PersistentProperty)p));
            }).collect(Collectors.joining(","));
        } else {
            columns = "*";
        }
        return columns;
    }

    @NonNull
    private List<PersistentProperty> getPropertiesThatAreColumns(PersistentEntity entity) {
        return entity.getPersistentProperties().stream().filter(pp -> {
            if (pp instanceof Association) {
                Association association = (Association)pp;
                return !association.isForeignKey();
            }
            return true;
        }).collect(Collectors.toList());
    }

    @Override
    public String resolveJoinType(Join.Type jt) {
        String joinType;
        switch (jt) {
            case LEFT: 
            case LEFT_FETCH: {
                joinType = " LEFT JOIN ";
                break;
            }
            case RIGHT: 
            case RIGHT_FETCH: {
                joinType = " RIGHT JOIN ";
                break;
            }
            case OUTER: {
                joinType = " FULL OUTER JOIN ";
                break;
            }
            default: {
                joinType = " INNER JOIN ";
            }
        }
        return joinType;
    }

    @Override
    @Nullable
    public QueryResult buildInsert(AnnotationMetadata repositoryMetadata, PersistentEntity entity) {
        PersistentProperty identity;
        NamingStrategy namingStrategy;
        String explicitColumn;
        Collection<? extends PersistentProperty> embeddedProps;
        PersistentEntity embeddedEntity;
        StringBuilder builder = new StringBuilder("INSERT INTO ");
        builder.append(this.getTableName(entity));
        builder.append(" (");
        Collection<? extends PersistentProperty> persistentProperties = entity.getPersistentProperties();
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>(persistentProperties.size());
        LinkedHashMap<String, DataType> parameterTypes = new LinkedHashMap<String, DataType>(persistentProperties.size());
        boolean hasProperties = CollectionUtils.isNotEmpty(persistentProperties);
        ArrayList<String> values = new ArrayList<String>(persistentProperties.size());
        if (hasProperties) {
            ArrayList<String> columnNames = new ArrayList<String>(persistentProperties.size());
            for (PersistentProperty persistentProperty : persistentProperties) {
                if (persistentProperty.isGenerated()) continue;
                if (persistentProperty instanceof Association) {
                    Association association = (Association)persistentProperty;
                    if (association instanceof Embedded) {
                        embeddedEntity = association.getAssociatedEntity();
                        embeddedProps = embeddedEntity.getPersistentProperties();
                        for (PersistentProperty persistentProperty2 : embeddedProps) {
                            explicitColumn = persistentProperty2.getAnnotationMetadata().stringValue(MappedProperty.class).orElse(null);
                            this.addWriteExpression(values, persistentProperty);
                            parameters.put(persistentProperty.getName() + "." + persistentProperty2.getName(), String.valueOf(values.size()));
                            if (explicitColumn != null) {
                                columnNames.add(explicitColumn);
                                continue;
                            }
                            namingStrategy = entity.getNamingStrategy();
                            columnNames.add(namingStrategy.mappedName(persistentProperty.getName() + persistentProperty2.getCapitilizedName()));
                        }
                        continue;
                    }
                    if (association.isForeignKey()) continue;
                    parameterTypes.put(persistentProperty.getName(), persistentProperty.getDataType());
                    this.addWriteExpression(values, persistentProperty);
                    parameters.put(persistentProperty.getName(), String.valueOf(values.size()));
                    columnNames.add(this.getColumnName(persistentProperty));
                    continue;
                }
                parameterTypes.put(persistentProperty.getName(), persistentProperty.getDataType());
                this.addWriteExpression(values, persistentProperty);
                parameters.put(persistentProperty.getName(), String.valueOf(values.size()));
                columnNames.add(this.getColumnName(persistentProperty));
            }
            builder.append(String.join((CharSequence)",", columnNames));
        }
        if ((identity = entity.getIdentity()) != null) {
            boolean assignedOrSequence = false;
            Optional optional = identity.findAnnotation(GeneratedValue.class);
            if (optional.isPresent()) {
                GeneratedValue.Type idGeneratorType = optional.flatMap(av -> av.enumValue(GeneratedValue.Type.class)).orElseGet(this::selectAutoStrategy);
                if (idGeneratorType == GeneratedValue.Type.SEQUENCE) {
                    assignedOrSequence = true;
                }
            } else {
                assignedOrSequence = true;
            }
            if (assignedOrSequence) {
                if (hasProperties) {
                    builder.append(',');
                }
                if (identity instanceof Embedded) {
                    ArrayList<String> columnNames = new ArrayList<String>(persistentProperties.size());
                    embeddedEntity = ((Embedded)identity).getAssociatedEntity();
                    embeddedProps = embeddedEntity.getPersistentProperties();
                    for (PersistentProperty persistentProperty : embeddedProps) {
                        explicitColumn = persistentProperty.getAnnotationMetadata().stringValue(MappedProperty.class).orElse(null);
                        this.addWriteExpression(values, persistentProperty);
                        parameters.put(identity.getName() + "." + persistentProperty.getName(), String.valueOf(values.size()));
                        if (explicitColumn != null) {
                            columnNames.add(explicitColumn);
                            continue;
                        }
                        namingStrategy = entity.getNamingStrategy();
                        columnNames.add(namingStrategy.mappedName(identity.getName() + persistentProperty.getCapitilizedName()));
                    }
                    builder.append(String.join((CharSequence)",", columnNames));
                } else {
                    builder.append(this.getColumnName(identity));
                    this.addWriteExpression(values, identity);
                    parameters.put(identity.getName(), String.valueOf(values.size()));
                }
            }
        }
        builder.append(')');
        builder.append(" VALUES (");
        builder.append(String.join((CharSequence)String.valueOf(','), values));
        builder.append(')');
        return QueryResult.of(builder.toString(), parameters, parameterTypes);
    }

    private boolean addWriteExpression(List<String> values, PersistentProperty property) {
        return values.add(property.getAnnotationMetadata().stringValue(DataTransformer.class, "write").orElse("?"));
    }

    @Override
    @NonNull
    public QueryResult buildPagination(@NonNull Pageable pageable) {
        StringBuilder builder = new StringBuilder(BLANK_SPACE);
        int size = pageable.getSize();
        long from = pageable.getOffset();
        long to = from + (long)size;
        if (to < 0L) {
            from = 0L;
            to = size;
        }
        switch (this.dialect) {
            case H2: 
            case MYSQL: {
                if (from == 0L) {
                    builder.append("LIMIT ").append(to);
                    break;
                }
                builder.append("LIMIT ").append(from).append(',').append(to);
                break;
            }
            case POSTGRES: {
                builder.append("LIMIT ").append(to).append(BLANK_SPACE);
                if (from == 0L) break;
                builder.append("OFFSET ").append(to);
                break;
            }
            case SQL_SERVER: {
                if (from == 0L) {
                    builder.append("OFFSET ").append(0).append(" ROWS ");
                }
            }
            default: {
                if (from != 0L) {
                    builder.append("OFFSET ").append(to).append(" ROWS ");
                }
                builder.append("FETCH NEXT ").append(to).append(" ROWS ONLY ");
            }
        }
        return QueryResult.of(builder.toString(), Collections.emptyMap(), Collections.emptyMap());
    }

    @Override
    protected void encodeInExpression(StringBuilder whereClause, AbstractSqlLikeQueryBuilder.Placeholder placeholder) {
        whereClause.append(IN_EXPRESSION_START).append(placeholder.getKey()).append(')');
    }

    @Override
    protected String getAliasName(PersistentEntity entity) {
        return entity.getPersistedName() + "_";
    }

    @Override
    public String getTableName(PersistentEntity entity) {
        String tableName = entity.getPersistedName();
        String schema = entity.getAnnotationMetadata().stringValue(MappedEntity.class, "schema").orElse(null);
        if (StringUtils.isNotEmpty((CharSequence)schema)) {
            return schema + '.' + tableName;
        }
        return tableName;
    }

    @Override
    protected String[] buildJoin(String alias, JoinPath joinPath, String joinType, StringBuilder target, Map<String, String> appliedJoinPaths) {
        Object[] associationPath = joinPath.getAssociationPath();
        if (ArrayUtils.isEmpty((Object[])associationPath)) {
            throw new IllegalArgumentException("Invalid association path [" + joinPath.getPath() + "]");
        }
        String[] joinAliases = new String[associationPath.length];
        StringBuilder pathSoFar = new StringBuilder();
        for (int i = 0; i < associationPath.length; ++i) {
            Object association = associationPath[i];
            String associationName = association.getName();
            pathSoFar.append(associationName);
            String existingAlias = appliedJoinPaths.get(alias + '.' + associationName);
            if (existingAlias != null) {
                joinAliases[i] = existingAlias;
                alias = existingAlias;
            } else {
                PersistentEntity associatedEntity = association.getAssociatedEntity();
                joinAliases[i] = this.getAliasName(new JoinPath(pathSoFar.toString(), (Association[])Arrays.copyOfRange(associationPath, 0, i + 1), joinPath.getJoinType(), joinPath.getAlias().orElse(null)));
                PersistentProperty identity = associatedEntity.getIdentity();
                if (identity == null) {
                    throw new IllegalArgumentException("Associated entity [" + associatedEntity.getName() + "] defines no ID. Cannot join.");
                }
                if (association.isForeignKey()) {
                    String mappedBy = association.getAnnotationMetadata().stringValue(Relation.class, "mappedBy").orElse(null);
                    if (mappedBy != null) {
                        PersistentProperty mappedProp = associatedEntity.getPropertyByName(mappedBy);
                        if (mappedProp == null) {
                            throw new MappingException("Foreign key association with mappedBy references a property that doesn't exist [" + mappedBy + "] of entity: " + associatedEntity.getName());
                        }
                        target.append(joinType).append(this.getTableName(associatedEntity)).append(' ').append(joinAliases[i]).append(" ON ").append(alias).append('.').append(this.getColumnName(identity)).append('=').append(joinAliases[i]).append('.').append(this.getColumnName(mappedProp));
                        alias = joinAliases[i];
                    } else {
                        target.append(joinType);
                        PersistentEntity entity = association.getOwner();
                        NamingStrategy namingStrategy = entity.getNamingStrategy();
                        String joinTableName = association.getAnnotationMetadata().stringValue(ANN_JOIN_TABLE, "name").orElseGet(() -> SqlQueryBuilder.lambda$buildJoin$19(namingStrategy, (Association)association));
                        String[] joinColumnNames = this.resolveJoinTableColumns(entity, associatedEntity, (Association)association, identity, associatedEntity.getIdentity(), namingStrategy);
                        String joinTableAlias = joinAliases[i] + joinTableName + "_";
                        String associatedTableName = this.getTableName(associatedEntity);
                        target.append(joinTableName).append(' ').append(joinTableAlias).append(" ON ").append(alias).append('.').append(this.getColumnName(identity)).append('=').append(joinTableAlias).append('.').append(joinColumnNames[0]).append(' ').append(joinType).append(associatedTableName).append(' ').append(joinAliases[i]).append(" ON ").append(joinTableAlias).append('.').append(joinColumnNames[1]).append('=').append(joinAliases[i]).append('.').append(this.getColumnName(associatedEntity.getIdentity()));
                    }
                } else {
                    target.append(joinType).append(this.getTableName(associatedEntity)).append(' ').append(joinAliases[i]).append(" ON ").append(alias).append('.').append(this.getColumnName((PersistentProperty)association)).append('=').append(joinAliases[i]).append('.').append(this.getColumnName(identity));
                    alias = joinAliases[i];
                }
            }
            pathSoFar.append('.');
        }
        return joinAliases;
    }

    protected String quote(String persistedName) {
        switch (this.dialect) {
            case H2: 
            case MYSQL: {
                return '`' + persistedName + '`';
            }
            case SQL_SERVER: {
                return '[' + persistedName + ']';
            }
        }
        return '\"' + persistedName + '\"';
    }

    @Override
    public String getColumnName(PersistentProperty persistentProperty) {
        return persistentProperty.getPersistedName();
    }

    @Override
    protected void appendProjectionRowCount(StringBuilder queryString, String logicalName) {
        queryString.append("COUNT").append('(').append('*').append(')');
    }

    @Override
    protected final boolean computePropertyPaths() {
        return true;
    }

    @Override
    protected boolean isAliasForBatch() {
        return false;
    }

    @Override
    protected AbstractSqlLikeQueryBuilder.Placeholder formatParameter(int index) {
        return new AbstractSqlLikeQueryBuilder.Placeholder(this, "?", String.valueOf(index));
    }

    protected GeneratedValue.Type selectAutoStrategy() {
        return GeneratedValue.Type.AUTO;
    }

    private String addTypeToColumn(PersistentProperty prop, boolean isAssociation, String column, boolean required) {
        AnnotationMetadata annotationMetadata = prop.getAnnotationMetadata();
        String definition = annotationMetadata.stringValue(MappedProperty.class, "definition").orElse(null);
        DataType dataType = prop.getDataType();
        if (definition != null) {
            return column + BLANK_SPACE + definition;
        }
        switch (dataType) {
            case STRING: {
                column = column + " VARCHAR(255)";
                if (!required) break;
                column = column + " NOT NULL";
                break;
            }
            case BOOLEAN: {
                if (this.dialect == Dialect.SQL_SERVER) {
                    column = column + " BIT NOT NULL";
                    break;
                }
                column = column + " BOOLEAN";
                if (!required) break;
                column = column + " NOT NULL";
                break;
            }
            case TIMESTAMP: {
                if (this.dialect == Dialect.SQL_SERVER) {
                    column = column + " DATETIME";
                    if (!required) break;
                    column = column + " NOT NULL";
                    break;
                }
                if (this.dialect == Dialect.MYSQL) {
                    column = column + " TIMESTAMP DEFAULT NOW()";
                    break;
                }
                column = column + " TIMESTAMP";
                if (!required) break;
                column = column + " NOT NULL";
                break;
            }
            case DATE: {
                column = column + " DATE";
                if (!required) break;
                column = column + " NOT NULL";
                break;
            }
            case LONG: {
                column = column + " BIGINT";
                if (!required) break;
                column = column + " NOT NULL";
                break;
            }
            case CHARACTER: 
            case INTEGER: {
                column = this.dialect == Dialect.POSTGRES ? column + " INTEGER" : column + " INT";
                if (!required) break;
                column = column + " NOT NULL";
                break;
            }
            case BIGDECIMAL: {
                column = column + " DECIMAL";
                if (!required) break;
                column = column + " NOT NULL";
                break;
            }
            case FLOAT: {
                column = this.dialect == Dialect.POSTGRES || this.dialect == Dialect.SQL_SERVER ? column + " REAL" : column + " FLOAT";
                if (!required) break;
                column = column + " NOT NULL";
                break;
            }
            case BYTE_ARRAY: {
                column = this.dialect == Dialect.POSTGRES ? column + " BYTEA" : (this.dialect == Dialect.SQL_SERVER ? column + " VARBINARY(MAX)" : column + " BLOB");
                if (!required) break;
                column = column + " NOT NULL";
                break;
            }
            case DOUBLE: {
                column = this.dialect == Dialect.ORACLE ? column + " NUMBER" : (this.dialect == Dialect.MYSQL || this.dialect == Dialect.H2 ? column + " DOUBLE" : column + " DOUBLE PRECISION");
                if (!required) break;
                column = column + " NOT NULL";
                break;
            }
            case SHORT: 
            case BYTE: {
                column = this.dialect == Dialect.POSTGRES ? column + " SMALLINT" : column + " TINYINT";
                if (!required) break;
                column = column + " NOT NULL";
                break;
            }
            default: {
                if (isAssociation) {
                    Association association = (Association)prop;
                    PersistentEntity associatedEntity = association.getAssociatedEntity();
                    PersistentProperty identity = associatedEntity.getIdentity();
                    if (identity == null) break;
                    return this.addTypeToColumn(identity, false, column, required);
                }
                if (prop.isEnum()) {
                    column = column + " VARCHAR(255)";
                    if (!required) break;
                    column = column + " NOT NULL";
                    break;
                }
                if (prop.isAssignable(Clob.class)) {
                    column = this.dialect == Dialect.POSTGRES ? column + " TEXT" : column + " CLOB";
                    if (!required) break;
                    column = column + " NOT NULL";
                    break;
                }
                if (prop.isAssignable(Blob.class)) {
                    column = this.dialect == Dialect.POSTGRES ? column + " BYTEA" : column + " BLOB";
                    if (!required) break;
                    column = column + " NOT NULL";
                    break;
                }
                throw new MappingException("Unable to create table column for property [" + prop.getName() + "] of entity [" + prop.getOwner().getName() + "] with unknown data type: " + (Object)((Object)dataType));
            }
        }
        return column;
    }

    private static /* synthetic */ String lambda$buildJoin$19(NamingStrategy namingStrategy, Association association) {
        return namingStrategy.mappedName(association);
    }
}

