/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.jpa.repository.intercept;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.jpa.operations.JpaRepositoryOperations;
import io.micronaut.data.jpa.repository.criteria.Specification;
import io.micronaut.data.jpa.repository.intercept.AbstractSpecificationInterceptor;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.Sort;
import io.micronaut.data.operations.RepositoryOperations;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.List;

@Internal
public class FindPageSpecificationInterceptor
extends AbstractSpecificationInterceptor<Object, Object> {
    private final JpaRepositoryOperations jpaOperations;

    protected FindPageSpecificationInterceptor(@NonNull RepositoryOperations operations) {
        super(operations);
        JpaRepositoryOperations jpaRepositoryOperations;
        if (!(operations instanceof JpaRepositoryOperations)) {
            throw new IllegalStateException("Repository operations must be na instance of JpaRepositoryOperations");
        }
        this.jpaOperations = jpaRepositoryOperations = (JpaRepositoryOperations)operations;
    }

    protected final Pageable getPageable(MethodInvocationContext<?, ?> context) {
        Object parameterValue = context.getParameterValues()[1];
        if (parameterValue instanceof Pageable) {
            Pageable pageable = (Pageable)parameterValue;
            return pageable;
        }
        return Pageable.UNPAGED;
    }

    public Page intercept(RepositoryMethodKey methodKey, MethodInvocationContext<Object, Object> context) {
        Predicate predicate;
        if (context.getParameterValues().length != 2) {
            throw new IllegalStateException("Expected exactly 2 arguments to method");
        }
        Specification specification = this.getSpecification(context, true);
        EntityManager entityManager = this.jpaOperations.getCurrentEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        Class rootEntity = this.getRequiredRootEntity(context);
        CriteriaQuery query = criteriaBuilder.createQuery(rootEntity);
        Root root = query.from(rootEntity);
        Predicate predicate2 = predicate = specification != null ? specification.toPredicate(root, query, criteriaBuilder) : null;
        if (predicate != null) {
            query.where((Expression)predicate);
        }
        query.select((Selection)root);
        Pageable pageable = this.getPageable(context);
        Sort sort = pageable.getSort();
        if (sort.isSorted()) {
            query.orderBy(this.getOrders(sort, root, criteriaBuilder));
        }
        TypedQuery typedQuery = entityManager.createQuery(query);
        if (pageable.isUnpaged()) {
            List resultList = typedQuery.getResultList();
            return Page.of((List)resultList, (Pageable)pageable, (Long)Long.valueOf(resultList.size()));
        }
        typedQuery.setFirstResult((int)pageable.getOffset());
        typedQuery.setMaxResults(pageable.getSize());
        List results = typedQuery.getResultList();
        Long totalCount = null;
        if (pageable.requestTotal()) {
            Predicate countPredicate;
            CriteriaQuery countQuery = criteriaBuilder.createQuery(Long.class);
            Root countRoot = countQuery.from(rootEntity);
            Predicate predicate3 = countPredicate = specification != null ? specification.toPredicate(countRoot, countQuery, criteriaBuilder) : null;
            if (countPredicate != null) {
                countQuery.where((Expression)countPredicate);
            }
            if (countQuery.isDistinct()) {
                countQuery.select((Selection)criteriaBuilder.countDistinct((Expression)countRoot));
            } else {
                countQuery.select((Selection)criteriaBuilder.count((Expression)countRoot));
            }
            totalCount = (Long)entityManager.createQuery(countQuery).getSingleResult();
        }
        return Page.of((List)results, (Pageable)pageable, totalCount);
    }
}

