/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.jdbc.config;

import io.micronaut.context.BeanLocator;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.context.exceptions.NoSuchBeanException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.jdbc.config.DataJdbcConfiguration;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilder;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.runtime.config.DataSettings;
import io.micronaut.data.runtime.config.SchemaGenerate;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.transaction.jdbc.DelegatingDataSource;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;

@Context
@Internal
public class SchemaGenerator {
    private final List<DataJdbcConfiguration> configurations;

    public SchemaGenerator(List<DataJdbcConfiguration> configurations) {
        this.configurations = configurations == null ? Collections.emptyList() : configurations;
    }

    /*
     * Unable to fully structure code
     */
    @PostConstruct
    public void createSchema(BeanLocator beanLocator) {
        runtimeEntityRegistry = (RuntimeEntityRegistry)beanLocator.getBean(RuntimeEntityRegistry.class);
        block43: for (DataJdbcConfiguration configuration : this.configurations) {
            dialect = configuration.getDialect();
            schemaGenerate = configuration.getSchemaGenerate();
            if (schemaGenerate == null || schemaGenerate == SchemaGenerate.NONE) continue;
            name = configuration.getName();
            packages = configuration.getPackages();
            introspections = CollectionUtils.isNotEmpty(packages) != false ? BeanIntrospector.SHARED.findIntrospections(MappedEntity.class, packages.toArray(new String[0])) : BeanIntrospector.SHARED.findIntrospections(MappedEntity.class);
            entities = (PersistentEntity[])introspections.stream().filter((Predicate<BeanIntrospection>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$createSchema$0(io.micronaut.core.beans.BeanIntrospection ), (Lio/micronaut/core/beans/BeanIntrospection;)Z)()).filter((Predicate<BeanIntrospection>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$createSchema$1(io.micronaut.core.beans.BeanIntrospection ), (Lio/micronaut/core/beans/BeanIntrospection;)Z)()).map((Function<BeanIntrospection, RuntimePersistentEntity>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$createSchema$2(io.micronaut.data.model.runtime.RuntimeEntityRegistry io.micronaut.core.beans.BeanIntrospection ), (Lio/micronaut/core/beans/BeanIntrospection;)Lio/micronaut/data/model/runtime/RuntimePersistentEntity;)((RuntimeEntityRegistry)runtimeEntityRegistry)).toArray((IntFunction<PersistentEntity[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$createSchema$3(int ), (I)[Lio/micronaut/data/model/PersistentEntity;)());
            if (!ArrayUtils.isNotEmpty((Object[])entities)) continue;
            dataSource = DelegatingDataSource.unwrapDataSource((DataSource)((DataSource)beanLocator.getBean(DataSource.class, Qualifiers.byName((String)name))));
            try {
                try {
                    connection = dataSource.getConnection();
                    try {
                        block55: {
                            builder = new SqlQueryBuilder(dialect);
                            if (!dialect.allowBatch() || !configuration.isBatchGenerate()) break block55;
                            switch (1.$SwitchMap$io$micronaut$data$runtime$config$SchemaGenerate[schemaGenerate.ordinal()]) {
                                case 1: {
                                    try {
                                        sql = builder.buildBatchDropTableStatement((PersistentEntity[])entities);
                                        if (DataSettings.QUERY_LOG.isDebugEnabled()) {
                                            DataSettings.QUERY_LOG.debug("Dropping Tables: \n{}", (Object)sql);
                                        }
                                        ps = connection.prepareStatement(sql);
                                        try {
                                            ps.executeUpdate();
                                        }
                                        finally {
                                            if (ps != null) {
                                                ps.close();
                                            }
                                        }
                                    }
                                    catch (SQLException e) {
                                        if (!DataSettings.QUERY_LOG.isTraceEnabled()) ** GOTO lbl36
                                        DataSettings.QUERY_LOG.trace("Drop Unsuccessful: " + e.getMessage());
                                    }
                                }
lbl36:
                                // 4 sources

                                case 2: {
                                    sql = builder.buildBatchCreateTableStatement((PersistentEntity[])entities);
                                    if (DataSettings.QUERY_LOG.isDebugEnabled()) {
                                        DataSettings.QUERY_LOG.debug("Creating Tables: \n{}", (Object)sql);
                                    }
                                    ps = connection.prepareStatement(sql);
                                    try {
                                        ps.executeUpdate();
                                        continue block43;
                                    }
                                    finally {
                                        if (ps == null) continue block43;
                                        ps.close();
                                        continue block43;
                                    }
                                }
                            }
                            continue;
                        }
                        switch (1.$SwitchMap$io$micronaut$data$runtime$config$SchemaGenerate[schemaGenerate.ordinal()]) {
                            case 1: {
                                for (Object entity : entities) {
                                    try {
                                        statements = builder.buildDropTableStatements((PersistentEntity)entity);
                                        for (String sql : statements) {
                                            if (DataSettings.QUERY_LOG.isDebugEnabled()) {
                                                DataSettings.QUERY_LOG.debug("Dropping Table: \n{}", (Object)sql);
                                            }
                                            ps = connection.prepareStatement(sql);
                                            try {
                                                ps.executeUpdate();
                                            }
                                            finally {
                                                if (ps != null) {
                                                    ps.close();
                                                }
                                            }
                                        }
                                    }
                                    catch (SQLException e) {
                                        if (!DataSettings.QUERY_LOG.isTraceEnabled()) continue;
                                        DataSettings.QUERY_LOG.trace("Drop Unsuccessful: " + e.getMessage());
                                    }
                                }
                            }
                            case 2: {
                                for (Object entity : entities) {
                                    for (String stmt : sql = builder.buildCreateTableStatements((PersistentEntity)entity)) {
                                        if (DataSettings.QUERY_LOG.isDebugEnabled()) {
                                            DataSettings.QUERY_LOG.debug("Executing CREATE statement: \n{}", (Object)stmt);
                                        }
                                        try {
                                            ps = connection.prepareStatement(stmt);
                                            try {
                                                ps.executeUpdate();
                                            }
                                            finally {
                                                if (ps != null) {
                                                    ps.close();
                                                }
                                            }
                                        }
                                        catch (SQLException e) {
                                            if (!DataSettings.QUERY_LOG.isWarnEnabled()) continue;
                                            DataSettings.QUERY_LOG.warn("CREATE Statement Unsuccessful: " + e.getMessage());
                                        }
                                    }
                                }
                                continue block43;
                            }
                            ** default:
lbl95:
                            // 1 sources

                            continue block43;
                        }
                    }
                    finally {
                        if (connection == null) continue;
                        connection.close();
                    }
                }
                catch (SQLException e) {
                    throw new DataAccessException("Unable to create database schema: " + e.getMessage(), (Throwable)e);
                }
            }
            catch (NoSuchBeanException e) {
                throw new ConfigurationException("No DataSource configured for setting [datasources" + name + "]. Ensure the DataSource is configured correctly and try again.", (Throwable)e);
            }
        }
    }

    private static /* synthetic */ PersistentEntity[] lambda$createSchema$3(int x$0) {
        return new PersistentEntity[x$0];
    }

    private static /* synthetic */ RuntimePersistentEntity lambda$createSchema$2(RuntimeEntityRegistry runtimeEntityRegistry, BeanIntrospection beanIntrospection) {
        return runtimeEntityRegistry.getEntity(beanIntrospection.getBeanType());
    }

    private static /* synthetic */ boolean lambda$createSchema$1(BeanIntrospection i) {
        return !Modifier.isAbstract(i.getBeanType().getModifiers());
    }

    private static /* synthetic */ boolean lambda$createSchema$0(BeanIntrospection i) {
        return !i.getBeanType().getName().contains("$");
    }
}

