/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.jdbc.config;

import io.micronaut.context.BeanLocator;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.context.exceptions.NoSuchBeanException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.jdbc.config.DataJdbcConfiguration;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilder;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.runtime.config.DataSettings;
import io.micronaut.data.runtime.config.SchemaGenerate;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.transaction.jdbc.DelegatingDataSource;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;

@Context
@Internal
public class SchemaGenerator {
    private final List<DataJdbcConfiguration> configurations;

    public SchemaGenerator(List<DataJdbcConfiguration> configurations) {
        this.configurations = configurations == null ? Collections.emptyList() : configurations;
    }

    /*
     * Unable to fully structure code
     */
    @PostConstruct
    public void createSchema(BeanLocator beanLocator) {
        runtimeEntityRegistry = (RuntimeEntityRegistry)beanLocator.getBean(RuntimeEntityRegistry.class);
        block62: for (DataJdbcConfiguration configuration : this.configurations) {
            dialect = configuration.getDialect();
            schemaGenerate = configuration.getSchemaGenerate();
            if (schemaGenerate == null || schemaGenerate == SchemaGenerate.NONE) continue;
            name = configuration.getName();
            packages = configuration.getPackages();
            introspections = CollectionUtils.isNotEmpty(packages) != false ? BeanIntrospector.SHARED.findIntrospections(MappedEntity.class, packages.toArray(new String[0])) : BeanIntrospector.SHARED.findIntrospections(MappedEntity.class);
            entities = (PersistentEntity[])introspections.stream().filter((Predicate<BeanIntrospection>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$createSchema$0(io.micronaut.core.beans.BeanIntrospection ), (Lio/micronaut/core/beans/BeanIntrospection;)Z)()).filter((Predicate<BeanIntrospection>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$createSchema$1(io.micronaut.core.beans.BeanIntrospection ), (Lio/micronaut/core/beans/BeanIntrospection;)Z)()).map((Function<BeanIntrospection, RuntimePersistentEntity>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$createSchema$2(io.micronaut.data.model.runtime.RuntimeEntityRegistry io.micronaut.core.beans.BeanIntrospection ), (Lio/micronaut/core/beans/BeanIntrospection;)Lio/micronaut/data/model/runtime/RuntimePersistentEntity;)((RuntimeEntityRegistry)runtimeEntityRegistry)).toArray((IntFunction<PersistentEntity[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$createSchema$3(int ), (I)[Lio/micronaut/data/model/PersistentEntity;)());
            if (!ArrayUtils.isNotEmpty((Object[])entities)) continue;
            dataSource = DelegatingDataSource.unwrapDataSource((DataSource)((DataSource)beanLocator.getBean(DataSource.class, Qualifiers.byName((String)name))));
            try {
                try {
                    connection = dataSource.getConnection();
                    var13_15 = null;
                    try {
                        block84: {
                            builder = new SqlQueryBuilder(dialect);
                            if (!dialect.allowBatch() || !configuration.isBatchGenerate()) break block84;
                            switch (1.$SwitchMap$io$micronaut$data$runtime$config$SchemaGenerate[schemaGenerate.ordinal()]) {
                                case 1: {
                                    try {
                                        sql = builder.buildBatchDropTableStatement((PersistentEntity[])entities);
                                        if (DataSettings.QUERY_LOG.isDebugEnabled()) {
                                            DataSettings.QUERY_LOG.debug("Dropping Tables: \n{}", (Object)sql);
                                        }
                                        ps = connection.prepareStatement(sql);
                                        var17_23 = null;
                                        try {
                                            ps.executeUpdate();
                                        }
                                        catch (Throwable var18_27) {
                                            var17_23 = var18_27;
                                            throw var18_27;
                                        }
                                        finally {
                                            if (ps != null) {
                                                if (var17_23 != null) {
                                                    try {
                                                        ps.close();
                                                    }
                                                    catch (Throwable var18_26) {
                                                        var17_23.addSuppressed(var18_26);
                                                    }
                                                } else {
                                                    ps.close();
                                                }
                                            }
                                        }
                                    }
                                    catch (SQLException e) {
                                        if (!DataSettings.QUERY_LOG.isTraceEnabled()) ** GOTO lbl48
                                        DataSettings.QUERY_LOG.trace("Drop Unsuccessful: " + e.getMessage());
                                    }
                                }
lbl48:
                                // 4 sources

                                case 2: {
                                    sql = builder.buildBatchCreateTableStatement((PersistentEntity[])entities);
                                    if (DataSettings.QUERY_LOG.isDebugEnabled()) {
                                        DataSettings.QUERY_LOG.debug("Creating Tables: \n{}", (Object)sql);
                                    }
                                    ps = connection.prepareStatement(sql);
                                    var17_23 = null;
                                    ps.executeUpdate();
                                    if (ps == null) continue block62;
                                    if (var17_23 == null) ** GOTO lbl65
                                    try {
                                        ps.close();
                                    }
                                    catch (Throwable var18_28) {
                                        var17_23.addSuppressed(var18_28);
                                    }
                                    break;
lbl65:
                                    // 1 sources

                                    ps.close();
                                    break;
                                    catch (Throwable var18_29) {
                                        try {
                                            var17_23 = var18_29;
                                            throw var18_29;
                                        }
                                        catch (Throwable var21_36) {
                                            if (ps != null) {
                                                if (var17_23 != null) {
                                                    try {
                                                        ps.close();
                                                    }
                                                    catch (Throwable var22_38) {
                                                        var17_23.addSuppressed(var22_38);
                                                    }
                                                } else {
                                                    ps.close();
                                                }
                                            }
                                            throw var21_36;
                                        }
                                    }
                                }
                            }
                            continue;
                        }
                        switch (1.$SwitchMap$io$micronaut$data$runtime$config$SchemaGenerate[schemaGenerate.ordinal()]) {
                            case 1: {
                                for (Object entity : entities) {
                                    try {
                                        statements = builder.buildDropTableStatements((PersistentEntity)entity);
                                        for (String sql : statements) {
                                            if (DataSettings.QUERY_LOG.isDebugEnabled()) {
                                                DataSettings.QUERY_LOG.debug("Dropping Table: \n{}", (Object)sql);
                                            }
                                            ps = connection.prepareStatement(sql);
                                            var25_42 = null;
                                            try {
                                                ps.executeUpdate();
                                            }
                                            catch (Throwable var26_45) {
                                                var25_42 = var26_45;
                                                throw var26_45;
                                            }
                                            finally {
                                                if (ps != null) {
                                                    if (var25_42 != null) {
                                                        try {
                                                            ps.close();
                                                        }
                                                        catch (Throwable var26_44) {
                                                            var25_42.addSuppressed(var26_44);
                                                        }
                                                    } else {
                                                        ps.close();
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    catch (SQLException e) {
                                        if (!DataSettings.QUERY_LOG.isTraceEnabled()) continue;
                                        DataSettings.QUERY_LOG.trace("Drop Unsuccessful: " + e.getMessage());
                                    }
                                }
                            }
                            case 2: {
                                for (Object entity : entities) {
                                    for (String stmt : sql = builder.buildCreateTableStatements((PersistentEntity)entity)) {
                                        if (DataSettings.QUERY_LOG.isDebugEnabled()) {
                                            DataSettings.QUERY_LOG.debug("Executing CREATE statement: \n{}", (Object)stmt);
                                        }
                                        try {
                                            ps = connection.prepareStatement(stmt);
                                            var25_42 = null;
                                            try {
                                                ps.executeUpdate();
                                            }
                                            catch (Throwable var26_47) {
                                                var25_42 = var26_47;
                                                throw var26_47;
                                            }
                                            finally {
                                                if (ps != null) {
                                                    if (var25_42 != null) {
                                                        try {
                                                            ps.close();
                                                        }
                                                        catch (Throwable var26_46) {
                                                            var25_42.addSuppressed(var26_46);
                                                        }
                                                    } else {
                                                        ps.close();
                                                    }
                                                }
                                            }
                                        }
                                        catch (SQLException e) {
                                            if (!DataSettings.QUERY_LOG.isWarnEnabled()) continue;
                                            DataSettings.QUERY_LOG.warn("CREATE Statement Unsuccessful: " + e.getMessage());
                                        }
                                    }
                                }
                                continue block62;
                            }
                            ** default:
lbl150:
                            // 1 sources

                            continue block62;
                        }
                    }
                    catch (Throwable var14_18) {
                        var13_15 = var14_18;
                        throw var14_18;
                    }
                    finally {
                        if (connection == null) continue;
                        if (var13_15 != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable var14_17) {
                                var13_15.addSuppressed(var14_17);
                            }
                            continue;
                        }
                        connection.close();
                    }
                }
                catch (SQLException e) {
                    throw new DataAccessException("Unable to create database schema: " + e.getMessage(), (Throwable)e);
                }
            }
            catch (NoSuchBeanException e) {
                throw new ConfigurationException("No DataSource configured for setting [datasources" + name + "]. Ensure the DataSource is configured correctly and try again.", (Throwable)e);
            }
        }
    }

    private static /* synthetic */ PersistentEntity[] lambda$createSchema$3(int x$0) {
        return new PersistentEntity[x$0];
    }

    private static /* synthetic */ RuntimePersistentEntity lambda$createSchema$2(RuntimeEntityRegistry runtimeEntityRegistry, BeanIntrospection beanIntrospection) {
        return runtimeEntityRegistry.getEntity(beanIntrospection.getBeanType());
    }

    private static /* synthetic */ boolean lambda$createSchema$1(BeanIntrospection i) {
        return !Modifier.isAbstract(i.getBeanType().getModifiers());
    }

    private static /* synthetic */ boolean lambda$createSchema$0(BeanIntrospection i) {
        return !i.getBeanType().getName().contains("$");
    }
}

