/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.jdbc.operations;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.DateUpdated;
import io.micronaut.data.annotation.Query;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.jdbc.mapper.ColumnIndexResultSetReader;
import io.micronaut.data.jdbc.mapper.ColumnNameResultSetReader;
import io.micronaut.data.jdbc.mapper.JdbcQueryStatement;
import io.micronaut.data.jdbc.mapper.SqlResultConsumer;
import io.micronaut.data.jdbc.operations.AbstractSqlRepositoryOperations;
import io.micronaut.data.jdbc.operations.JdbcRepositoryOperations;
import io.micronaut.data.jdbc.runtime.ConnectionCallback;
import io.micronaut.data.jdbc.runtime.PreparedStatementCallback;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.Embedded;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilder;
import io.micronaut.data.model.runtime.DeleteBatchOperation;
import io.micronaut.data.model.runtime.DeleteOperation;
import io.micronaut.data.model.runtime.InsertBatchOperation;
import io.micronaut.data.model.runtime.InsertOperation;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.RuntimeAssociation;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.model.runtime.UpdateOperation;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.operations.async.AsyncCapableRepository;
import io.micronaut.data.operations.reactive.ReactiveCapableRepository;
import io.micronaut.data.operations.reactive.ReactiveRepositoryOperations;
import io.micronaut.data.runtime.date.DateTimeProvider;
import io.micronaut.data.runtime.mapper.DTOMapper;
import io.micronaut.data.runtime.mapper.ResultConsumer;
import io.micronaut.data.runtime.mapper.ResultReader;
import io.micronaut.data.runtime.mapper.TypeMapper;
import io.micronaut.data.runtime.mapper.sql.SqlDTOMapper;
import io.micronaut.data.runtime.mapper.sql.SqlResultEntityTypeMapper;
import io.micronaut.data.runtime.mapper.sql.SqlTypeMapper;
import io.micronaut.data.runtime.operations.ExecutorAsyncOperations;
import io.micronaut.data.runtime.operations.ExecutorReactiveOperations;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.transaction.TransactionOperations;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.PreDestroy;
import javax.inject.Named;
import javax.sql.DataSource;

@EachBean(value=DataSource.class)
public class DefaultJdbcRepositoryOperations
extends AbstractSqlRepositoryOperations<ResultSet, PreparedStatement>
implements JdbcRepositoryOperations,
AsyncCapableRepository,
ReactiveCapableRepository,
AutoCloseable {
    private final TransactionOperations<Connection> transactionOperations;
    private final DataSource dataSource;
    private ExecutorAsyncOperations asyncOperations;
    private ExecutorService executorService;

    @Internal
    protected DefaultJdbcRepositoryOperations(@Parameter String dataSourceName, DataSource dataSource, @Parameter TransactionOperations<Connection> transactionOperations, @Named(value="io") @Nullable ExecutorService executorService, BeanContext beanContext, List<MediaTypeCodec> codecs, @NonNull DateTimeProvider dateTimeProvider, RuntimeEntityRegistry entityRegistry) {
        super(dataSourceName, new ColumnNameResultSetReader(), new ColumnIndexResultSetReader(), new JdbcQueryStatement(), codecs, (DateTimeProvider<Object>)dateTimeProvider, entityRegistry, beanContext);
        ArgumentUtils.requireNonNull((String)"dataSource", (Object)dataSource);
        ArgumentUtils.requireNonNull((String)"transactionOperations", transactionOperations);
        this.dataSource = dataSource;
        this.transactionOperations = transactionOperations;
        this.executorService = executorService;
    }

    @NonNull
    private ExecutorService newLocalThreadPool() {
        this.executorService = Executors.newCachedThreadPool();
        return this.executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ExecutorAsyncOperations async() {
        ExecutorAsyncOperations asyncOperations = this.asyncOperations;
        if (asyncOperations == null) {
            DefaultJdbcRepositoryOperations defaultJdbcRepositoryOperations = this;
            synchronized (defaultJdbcRepositoryOperations) {
                asyncOperations = this.asyncOperations;
                if (asyncOperations == null) {
                    this.asyncOperations = asyncOperations = new ExecutorAsyncOperations((RepositoryOperations)this, (Executor)(this.executorService != null ? this.executorService : this.newLocalThreadPool()));
                }
            }
        }
        return asyncOperations;
    }

    @NonNull
    public ReactiveRepositoryOperations reactive() {
        return new ExecutorReactiveOperations(this.async());
    }

    @Nullable
    public <T, R> R findOne(@NonNull PreparedQuery<T, R> preparedQuery) {
        return (R)this.transactionOperations.executeRead(status -> {
            Connection connection = (Connection)status.getConnection();
            try (PreparedStatement ps = this.prepareStatement(connection::prepareStatement, preparedQuery, false, true);
                 ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return null;
                Class resultType = preparedQuery.getResultType();
                if (preparedQuery.getResultDataType() == DataType.ENTITY) {
                    RuntimePersistentEntity persistentEntity = this.getEntity(resultType);
                    Set joinFetchPaths = preparedQuery.getJoinFetchPaths();
                    SqlResultEntityTypeMapper mapper = new SqlResultEntityTypeMapper(persistentEntity, this.columnNameResultSetReader, joinFetchPaths, this.jsonCodec, (loadedEntity, o) -> {
                        if (loadedEntity.hasPostLoadEventListeners()) {
                            return this.triggerPostLoad(o, loadedEntity, preparedQuery.getAnnotationMetadata());
                        }
                        return o;
                    });
                    Object result = mapper.map((Object)rs, resultType);
                    if (preparedQuery.hasResultConsumer()) {
                        preparedQuery.getParameterInRole("sqlMappingFunction", SqlResultConsumer.class).ifPresent(consumer -> consumer.accept(result, this.newMappingContext(rs)));
                    }
                    Object object = result;
                    return object;
                }
                if (preparedQuery.isDtoProjection()) {
                    RuntimePersistentEntity persistentEntity = this.getEntity(preparedQuery.getRootEntity());
                    DTOMapper introspectedDataMapper = new DTOMapper(persistentEntity, this.columnNameResultSetReader, this.jsonCodec);
                    Object object = introspectedDataMapper.map((Object)rs, resultType);
                    return object;
                }
                Object v = this.columnIndexResultSetReader.readDynamic((Object)rs, (Object)1, preparedQuery.getResultDataType());
                if (v == null) {
                    Object var10_19 = null;
                    return var10_19;
                }
                if (resultType.isInstance(v)) {
                    Object object = v;
                    return object;
                }
                Object object = this.columnIndexResultSetReader.convertRequired(v, resultType);
                return object;
            }
            catch (SQLException e) {
                throw new DataAccessException("Error executing SQL Query: " + e.getMessage(), (Throwable)e);
            }
        });
    }

    @NonNull
    private ResultConsumer.Context<ResultSet> newMappingContext(final ResultSet rs) {
        return new ResultConsumer.Context<ResultSet>(){

            public ResultSet getResultSet() {
                return rs;
            }

            public ResultReader<ResultSet, String> getResultReader() {
                return DefaultJdbcRepositoryOperations.this.columnNameResultSetReader;
            }

            @NonNull
            public <E> E readEntity(String prefix, Class<E> type) throws DataAccessException {
                RuntimePersistentEntity<E> entity = DefaultJdbcRepositoryOperations.this.getEntity(type);
                SqlResultEntityTypeMapper mapper = new SqlResultEntityTypeMapper(prefix, entity, DefaultJdbcRepositoryOperations.this.columnNameResultSetReader, DefaultJdbcRepositoryOperations.this.jsonCodec);
                return (E)mapper.map((Object)rs, type);
            }

            @NonNull
            public <E, D> D readDTO(@NonNull String prefix, @NonNull Class<E> rootEntity, @NonNull Class<D> dtoType) throws DataAccessException {
                RuntimePersistentEntity<E> entity = DefaultJdbcRepositoryOperations.this.getEntity(rootEntity);
                DTOMapper introspectedDataMapper = new DTOMapper(entity, DefaultJdbcRepositoryOperations.this.columnNameResultSetReader, DefaultJdbcRepositoryOperations.this.jsonCodec);
                return (D)introspectedDataMapper.map((Object)rs, dtoType);
            }
        };
    }

    public <T> boolean exists(@NonNull PreparedQuery<T, Boolean> preparedQuery) {
        return (Boolean)this.transactionOperations.executeRead(status -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    @NonNull
    public <T, R> Stream<R> findStream(@NonNull PreparedQuery<T, R> preparedQuery) {
        return (Stream)this.transactionOperations.executeRead(status -> {
            Connection connection = (Connection)status.getConnection();
            return this.findStream(preparedQuery, connection);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private <T, R> Stream<R> findStream(final @NonNull PreparedQuery<T, R> preparedQuery, Connection connection) {
        PreparedStatement ps;
        final Class resultType = preparedQuery.getResultType();
        final AtomicBoolean finished = new AtomicBoolean();
        try {
            ps = this.prepareStatement(connection::prepareStatement, preparedQuery, false, false);
        }
        catch (Exception e) {
            throw new DataAccessException("SQL Error preparing Query: " + e.getMessage(), (Throwable)e);
        }
        ResultSet openedRs = null;
        try {
            Spliterators.AbstractSpliterator spliterator;
            boolean isEntity;
            final ResultSet rs = openedRs = ps.executeQuery();
            boolean dtoProjection = preparedQuery.isDtoProjection();
            boolean bl = isEntity = preparedQuery.getResultDataType() == DataType.ENTITY;
            if (isEntity || dtoProjection) {
                SqlDTOMapper mapper;
                SqlResultConsumer sqlMappingConsumer = preparedQuery.hasResultConsumer() ? (SqlResultConsumer)preparedQuery.getParameterInRole("sqlMappingFunction", SqlResultConsumer.class).orElse(null) : null;
                RuntimePersistentEntity persistentEntity = this.getEntity(resultType);
                if (dtoProjection) {
                    mapper = new SqlDTOMapper(persistentEntity, this.columnNameResultSetReader, this.jsonCodec);
                } else {
                    Set joinFetchPaths = preparedQuery.getJoinFetchPaths();
                    SqlResultEntityTypeMapper entityTypeMapper = new SqlResultEntityTypeMapper(persistentEntity, this.columnNameResultSetReader, joinFetchPaths, this.jsonCodec, (loadedEntity, o) -> {
                        if (loadedEntity.hasPostLoadEventListeners()) {
                            return this.triggerPostLoad(o, loadedEntity, preparedQuery.getAnnotationMetadata());
                        }
                        return o;
                    });
                    if (!joinFetchPaths.isEmpty()) {
                        HashMap<Object, Object> processedEntities = new HashMap<Object, Object>();
                        ArrayList<Object> values = new ArrayList<Object>();
                        try {
                            while (entityTypeMapper.hasNext((Object)rs)) {
                                Object processedEntity;
                                Object id = entityTypeMapper.readId((Object)rs);
                                if (id != null && (processedEntity = processedEntities.get(id)) != null) {
                                    entityTypeMapper.readChildren((Object)rs, processedEntity);
                                    continue;
                                }
                                Object o2 = entityTypeMapper.map((Object)rs, resultType);
                                if (sqlMappingConsumer != null) {
                                    sqlMappingConsumer.accept(rs, o2);
                                }
                                values.add(o2);
                                if (id == null) continue;
                                processedEntities.put(id, o2);
                            }
                            Stream stream = values.stream();
                            return stream;
                        }
                        finally {
                            this.closeResultSet(ps, rs, finished);
                        }
                    }
                    mapper = entityTypeMapper;
                }
                spliterator = new Spliterators.AbstractSpliterator<R>(Long.MAX_VALUE, 1040, (SqlTypeMapper)mapper, rs, resultType, sqlMappingConsumer, ps){
                    final /* synthetic */ SqlTypeMapper val$mapper;
                    final /* synthetic */ ResultSet val$rs;
                    final /* synthetic */ Class val$resultType;
                    final /* synthetic */ SqlResultConsumer val$sqlMappingConsumer;
                    final /* synthetic */ PreparedStatement val$ps;
                    {
                        this.val$mapper = sqlTypeMapper;
                        this.val$rs = resultSet;
                        this.val$resultType = clazz;
                        this.val$sqlMappingConsumer = sqlResultConsumer;
                        this.val$ps = preparedStatement;
                        super(x0, x1);
                    }

                    @Override
                    public boolean tryAdvance(Consumer<? super R> action) {
                        if (finished.get()) {
                            return false;
                        }
                        boolean hasNext = this.val$mapper.hasNext((Object)this.val$rs);
                        if (hasNext) {
                            Object o = this.val$mapper.map((Object)this.val$rs, this.val$resultType);
                            if (this.val$sqlMappingConsumer != null) {
                                this.val$sqlMappingConsumer.accept(this.val$rs, o);
                            }
                            action.accept(o);
                        } else {
                            DefaultJdbcRepositoryOperations.this.closeResultSet(this.val$ps, this.val$rs, finished);
                        }
                        return hasNext;
                    }
                };
            } else {
                spliterator = new Spliterators.AbstractSpliterator<R>(Long.MAX_VALUE, 1040){

                    @Override
                    public boolean tryAdvance(Consumer<? super R> action) {
                        if (finished.get()) {
                            return false;
                        }
                        try {
                            boolean hasNext = rs.next();
                            if (hasNext) {
                                Object r;
                                Object v = DefaultJdbcRepositoryOperations.this.columnIndexResultSetReader.readDynamic((Object)rs, (Object)1, preparedQuery.getResultDataType());
                                if (resultType.isInstance(v)) {
                                    action.accept(v);
                                } else if (v != null && (r = DefaultJdbcRepositoryOperations.this.columnIndexResultSetReader.convertRequired(v, resultType)) != null) {
                                    action.accept(r);
                                }
                            } else {
                                DefaultJdbcRepositoryOperations.this.closeResultSet(ps, rs, finished);
                            }
                            return hasNext;
                        }
                        catch (SQLException e) {
                            throw new DataAccessException("Error retrieving next JDBC result: " + e.getMessage(), (Throwable)e);
                        }
                    }
                };
            }
            return (Stream)StreamSupport.stream(spliterator, false).onClose(() -> this.closeResultSet(ps, rs, finished));
        }
        catch (Exception e) {
            this.closeResultSet(ps, openedRs, finished);
            throw new DataAccessException("SQL Error executing Query: " + e.getMessage(), (Throwable)e);
        }
    }

    private void closeResultSet(PreparedStatement ps, ResultSet rs, AtomicBoolean finished) {
        if (finished.compareAndSet(false, true)) {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                throw new DataAccessException("Error closing JDBC result stream: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    @NonNull
    public <T, R> Iterable<R> findAll(@NonNull PreparedQuery<T, R> preparedQuery) {
        return (Iterable)this.transactionOperations.executeRead(status -> {
            Connection connection = (Connection)status.getConnection();
            return this.findStream(preparedQuery, connection).collect(Collectors.toList());
        });
    }

    @NonNull
    public Optional<Number> executeUpdate(@NonNull PreparedQuery<?, Number> preparedQuery) {
        return (Optional)this.transactionOperations.executeWrite(status -> {
            try {
                Connection connection = (Connection)status.getConnection();
                try (PreparedStatement ps = this.prepareStatement(connection::prepareStatement, preparedQuery, true, false);){
                    int result = ps.executeUpdate();
                    if (QUERY_LOG.isTraceEnabled()) {
                        QUERY_LOG.trace("Update operation updated {} records", (Object)result);
                    }
                    Optional<Integer> optional = Optional.of(result);
                    return optional;
                }
            }
            catch (SQLException e) {
                throw new DataAccessException("Error executing SQL UPDATE: " + e.getMessage(), (Throwable)e);
            }
        });
    }

    public <T> Optional<Number> deleteAll(@NonNull DeleteBatchOperation<T> operation) {
        if (operation.all()) {
            AnnotationMetadata annotationMetadata = operation.getAnnotationMetadata();
            String query = annotationMetadata.stringValue(Query.class).orElse(null);
            if (query == null) {
                throw new UnsupportedOperationException("The deleteAll method via batch is unsupported. Execute the SQL update directly");
            }
            Object[] params = annotationMetadata.stringValues(DataMethod.class, "parameterBindingPaths");
            if (params.length != 0) {
                throw new IllegalStateException("Unexpected parameters: " + Arrays.toString(params));
            }
            return (Optional)this.transactionOperations.executeWrite(status -> {
                try {
                    Connection connection = (Connection)status.getConnection();
                    if (QUERY_LOG.isDebugEnabled()) {
                        QUERY_LOG.debug("Executing SQL DELETE ALL: {}", (Object)query);
                    }
                    try (PreparedStatement ps = connection.prepareStatement(query);){
                        Optional<Integer> optional = Optional.of(ps.executeUpdate());
                        return optional;
                    }
                }
                catch (SQLException e) {
                    throw new DataAccessException("Error executing SQL DELETE: " + e.getMessage(), (Throwable)e);
                }
            });
        }
        return Optional.of(operation.split().stream().mapToInt(this::delete).sum());
    }

    public <T> int delete(@NonNull DeleteOperation<T> operation) {
        Object finalEntity;
        AnnotationMetadata annotationMetadata = operation.getAnnotationMetadata();
        String[] params = annotationMetadata.stringValues(DataMethod.class, "parameterBindingPaths");
        String query = annotationMetadata.stringValue(Query.class).orElse(null);
        Dialect dialect = this.queryBuilders.getOrDefault(operation.getRepositoryType(), DEFAULT_SQL_BUILDER).dialect();
        Objects.requireNonNull(query, "Query cannot be null");
        Object opEntity = operation.getEntity();
        Objects.requireNonNull(opEntity, "Passed entity cannot be null");
        RuntimePersistentEntity<?> finalPersistentEntity = this.getEntity(opEntity.getClass());
        if (finalPersistentEntity.hasPreRemoveEventListeners()) {
            finalEntity = this.triggerPreRemove(opEntity, finalPersistentEntity, annotationMetadata);
            if (finalEntity == null) {
                return 0;
            }
        } else {
            finalEntity = opEntity;
        }
        return (Integer)this.transactionOperations.executeWrite(status -> {
            try {
                Connection connection = (Connection)status.getConnection();
                if (QUERY_LOG.isDebugEnabled()) {
                    QUERY_LOG.debug("Executing SQL DELETE: {}", (Object)query);
                }
                Object entity = finalEntity;
                RuntimePersistentEntity<?> persistentEntity = finalPersistentEntity;
                RuntimePersistentProperty identity = persistentEntity.getIdentity();
                if (identity != null && identity instanceof Embedded) {
                    BeanProperty idProp = identity.getProperty();
                    Object idEntity = idProp.get(entity);
                    if (idEntity == null) {
                        throw new IllegalStateException("Cannot delete an entity with null ID: " + entity);
                    }
                    entity = idEntity;
                    persistentEntity = this.getEntity(idEntity.getClass());
                }
                try (PreparedStatement ps = connection.prepareStatement(query);){
                    for (int i = 0; i < params.length; ++i) {
                        RuntimePersistentProperty pp;
                        String propertyName = params[i];
                        if (propertyName.isEmpty()) {
                            this.setStatementParameter(ps, i + 1, DataType.ENTITY, entity, dialect);
                            continue;
                        }
                        if (propertyName.startsWith("0.")) {
                            propertyName = propertyName.replace("0.", "");
                        }
                        if ((pp = persistentEntity.getPropertyByName(propertyName)) == null) {
                            throw new IllegalStateException("Cannot perform delete for non-existent property: " + persistentEntity.getSimpleName() + "." + propertyName);
                        }
                        this.setStatementParameter(ps, i + 1, pp.getDataType(), pp.getProperty().get(entity), dialect);
                    }
                    int updated = ps.executeUpdate();
                    if (updated > 0 && persistentEntity.hasPostRemoveEventListeners()) {
                        this.triggerPostRemove(finalEntity, persistentEntity, annotationMetadata);
                    }
                    Integer n = updated;
                    return n;
                }
            }
            catch (SQLException e) {
                throw new DataAccessException("Error executing SQL DELETE: " + e.getMessage(), (Throwable)e);
            }
        });
    }

    @NonNull
    public <T> T update(@NonNull UpdateOperation<T> operation) {
        AnnotationMetadata annotationMetadata = operation.getAnnotationMetadata();
        String[] params = annotationMetadata.stringValues(DataMethod.class, "parameterBindingPaths");
        String query = annotationMetadata.stringValue(Query.class).orElse(null);
        Object entity = operation.getEntity();
        HashSet persisted = new HashSet(10);
        Class repositoryType = operation.getRepositoryType();
        return (T)this.updateOne(repositoryType, annotationMetadata, query, params, entity, persisted);
    }

    private <T> T updateOne(Class<?> repositoryType, AnnotationMetadata annotationMetadata, String query, String[] params, T entity, Set persisted) {
        Objects.requireNonNull(entity, "Passed entity cannot be null");
        if (StringUtils.isNotEmpty((CharSequence)query) && ArrayUtils.isNotEmpty((Object[])params)) {
            Object resolvedEntity;
            RuntimePersistentEntity<?> persistentEntity = this.getEntity(entity.getClass());
            Dialect dialect = this.queryBuilders.getOrDefault(repositoryType, DEFAULT_SQL_BUILDER).dialect();
            if (persistentEntity.hasPreUpdateEventListeners()) {
                resolvedEntity = this.triggerPreUpdate(entity, persistentEntity, annotationMetadata);
                if (resolvedEntity == null) {
                    return entity;
                }
            } else {
                resolvedEntity = entity;
            }
            return (T)this.transactionOperations.executeWrite(status -> {
                try {
                    Connection connection = (Connection)status.getConnection();
                    if (QUERY_LOG.isDebugEnabled()) {
                        QUERY_LOG.debug("Executing SQL UPDATE: {}", (Object)query);
                    }
                    try (PreparedStatement ps = connection.prepareStatement(query);){
                        for (int i = 0; i < params.length; ++i) {
                            Object newValue;
                            String propertyName = params[i];
                            RuntimePersistentProperty pp = persistentEntity.getPropertyByName(propertyName);
                            if (pp == null) {
                                Association assoc;
                                int j = propertyName.indexOf(46);
                                if (j <= -1) throw new IllegalStateException("Cannot perform update for non-existent property: " + persistentEntity.getSimpleName() + "." + propertyName);
                                RuntimePersistentProperty embeddedProp = persistentEntity.getPropertyByPath(propertyName).orElse(null);
                                if (embeddedProp == null) throw new IllegalStateException("Cannot perform update for non-existent property: " + persistentEntity.getSimpleName() + "." + propertyName);
                                pp = persistentEntity.getPropertyByName(propertyName.substring(0, j));
                                if (!(pp instanceof Association) || (assoc = (Association)pp).getKind() != Relation.Kind.EMBEDDED) continue;
                                Object embeddedInstance = pp.getProperty().get(resolvedEntity);
                                Object embeddedValue = embeddedInstance != null ? embeddedProp.getProperty().get(embeddedInstance) : null;
                                DataType dataType = embeddedValue == null ? this.getEntity(embeddedProp.getProperty().getType()).getIdentity().getDataType() : embeddedProp.getDataType();
                                int index = i + 1;
                                this.setStatementParameter(ps, index, dataType, embeddedValue, dialect);
                                continue;
                            }
                            BeanProperty beanProperty = pp.getProperty();
                            if (beanProperty.hasAnnotation(DateUpdated.class)) {
                                newValue = this.dateTimeProvider.getNow();
                                beanProperty.convertAndSet(resolvedEntity, newValue);
                            } else {
                                newValue = beanProperty.get(resolvedEntity);
                            }
                            DataType dataType = pp.getDataType();
                            if (dataType == DataType.ENTITY && pp instanceof Association) {
                                Association association = (Association)pp;
                                if (newValue == null) {
                                    RuntimePersistentEntity associatedEntity = (RuntimePersistentEntity)association.getAssociatedEntity();
                                    RuntimePersistentProperty identity = associatedEntity.getIdentity();
                                    this.setStatementParameter(ps, i + 1, identity.getDataType(), null, dialect);
                                    continue;
                                }
                                RuntimePersistentProperty<Object> idReader = this.getIdReader(newValue);
                                BeanProperty idReaderProperty = idReader.getProperty();
                                Object id = idReaderProperty.get(newValue);
                                if (id != null) {
                                    this.setStatementParameter(ps, i + 1, idReader.getDataType(), id, dialect);
                                    if (!association.doesCascade(new Relation.Cascade[]{Relation.Cascade.PERSIST}) || persisted.contains(newValue)) continue;
                                    Relation.Kind kind = association.getKind();
                                    RuntimePersistentEntity associatedEntity = (RuntimePersistentEntity)association.getAssociatedEntity();
                                    switch (kind) {
                                        case ONE_TO_ONE: 
                                        case MANY_TO_ONE: {
                                            persisted.add(newValue);
                                            AbstractSqlRepositoryOperations.StoredInsert updateStatement = this.resolveEntityUpdate(annotationMetadata, repositoryType, associatedEntity.getIntrospection().getBeanType(), associatedEntity);
                                            this.updateOne(repositoryType, annotationMetadata, updateStatement.getSql(), updateStatement.getParameterBinding(), newValue, persisted);
                                            break;
                                        }
                                    }
                                    continue;
                                }
                                if (!association.doesCascade(new Relation.Cascade[]{Relation.Cascade.PERSIST}) || persisted.contains(newValue)) continue;
                                RuntimePersistentEntity associatedEntity = (RuntimePersistentEntity)association.getAssociatedEntity();
                                AbstractSqlRepositoryOperations.StoredInsert associatedInsert = this.resolveEntityInsert(annotationMetadata, repositoryType, associatedEntity.getIntrospection().getBeanType(), associatedEntity);
                                this.persistOne(annotationMetadata, repositoryType, associatedInsert, newValue, persisted);
                                Object assignedId = idReaderProperty.get(newValue);
                                if (assignedId == null) continue;
                                this.setStatementParameter(ps, i + 1, idReader.getDataType(), assignedId, dialect);
                                continue;
                            }
                            this.setStatementParameter(ps, i + 1, dataType, newValue, dialect);
                        }
                        ps.executeUpdate();
                        if (persistentEntity.hasPostUpdateEventListeners()) {
                            this.triggerPostUpdate(resolvedEntity, persistentEntity, annotationMetadata);
                        }
                        Object object = resolvedEntity;
                        return object;
                    }
                }
                catch (SQLException e) {
                    throw new DataAccessException("Error executing SQL UPDATE: " + e.getMessage(), (Throwable)e);
                }
            });
        }
        return entity;
    }

    @NonNull
    public <T> T persist(@NonNull InsertOperation<T> operation) {
        AbstractSqlRepositoryOperations.StoredInsert<T> insert = this.resolveInsert(operation);
        Class repositoryType = operation.getRepositoryType();
        AnnotationMetadata annotationMetadata = operation.getAnnotationMetadata();
        Object entity = operation.getEntity();
        return (T)this.persistOne(annotationMetadata, repositoryType, insert, entity, new HashSet(5));
    }

    private <T> T persistOne(AnnotationMetadata annotationMetadata, Class<?> repositoryType, AbstractSqlRepositoryOperations.StoredInsert<T> insert, T entity, Set persisted) {
        return (T)this.transactionOperations.executeWrite(status -> {
            try {
                boolean hasGeneratedID;
                Connection connection = (Connection)status.getConnection();
                boolean generateId = insert.isGenerateId();
                String insertSql = insert.getSql();
                BeanProperty identity = insert.getIdentityProperty();
                boolean bl = hasGeneratedID = generateId && identity != null;
                if (QUERY_LOG.isDebugEnabled()) {
                    QUERY_LOG.debug("Executing SQL Insert: {}", (Object)insertSql);
                }
                try (PreparedStatement stmt = this.persistOnePreparedStatement(insert, connection, generateId, insertSql, hasGeneratedID);){
                    Object resolvedEntity;
                    RuntimePersistentEntity pe = insert.getPersistentEntity();
                    if (pe.hasPrePersistEventListeners()) {
                        Object newEntity = this.triggerPrePersist(entity, pe, annotationMetadata);
                        if (newEntity == null) {
                            Object object = entity;
                            return object;
                        }
                        resolvedEntity = newEntity;
                    } else {
                        resolvedEntity = entity;
                    }
                    this.setInsertParameters(insert, resolvedEntity, stmt);
                    stmt.executeUpdate();
                    persisted.add(resolvedEntity);
                    if (hasGeneratedID) {
                        ResultSet generatedKeys = stmt.getGeneratedKeys();
                        if (!generatedKeys.next()) throw new DataAccessException("ID failed to generate. No result returned.");
                        Object id = this.getEntityId(generatedKeys, insert.getIdentity().getDataType(), identity.getType());
                        resolvedEntity = this.updateEntityId(identity, resolvedEntity, id);
                    }
                    if (pe.hasPostPersistEventListeners()) {
                        resolvedEntity = this.triggerPostPersist(resolvedEntity, insert.getPersistentEntity(), annotationMetadata);
                    }
                    this.cascadeInserts(annotationMetadata, repositoryType, insert, resolvedEntity, persisted, connection, identity);
                    Object object = resolvedEntity;
                    return object;
                }
            }
            catch (SQLException e) {
                throw new DataAccessException("SQL Error executing INSERT: " + e.getMessage(), (Throwable)e);
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> T updateEntityId(BeanProperty<T, Object> identity, T resolvedEntity, Object id) {
        if (id == null) {
            return resolvedEntity;
        }
        if (identity.getType().isInstance(id)) {
            if (identity.isReadOnly()) {
                if (!identity.hasSetterOrConstructorArgument()) return resolvedEntity;
                resolvedEntity = identity.withValue(resolvedEntity, (Object)id);
                return resolvedEntity;
            } else {
                identity.set(resolvedEntity, (Object)id);
            }
            return resolvedEntity;
        } else if (identity.isReadOnly()) {
            if (!identity.hasSetterOrConstructorArgument()) return resolvedEntity;
            Object converted = ConversionService.SHARED.convert((Object)id, identity.asArgument()).orElse(null);
            if (converted == null) return resolvedEntity;
            resolvedEntity = identity.withValue(resolvedEntity, converted);
            return resolvedEntity;
        } else {
            identity.convertAndSet(resolvedEntity, (Object)id);
        }
        return resolvedEntity;
    }

    private <T> PreparedStatement persistOnePreparedStatement(AbstractSqlRepositoryOperations.StoredInsert<T> insert, Connection connection, boolean generateId, String insertSql, boolean hasGeneratedID) throws SQLException {
        PreparedStatement stmt = hasGeneratedID && (insert.getDialect() == Dialect.ORACLE || insert.getDialect() == Dialect.SQL_SERVER) ? connection.prepareStatement(insertSql, new String[]{insert.getIdentity().getPersistedName()}) : connection.prepareStatement(insertSql, generateId ? 1 : 2);
        return stmt;
    }

    private <T> void cascadeInserts(AnnotationMetadata annotationMetadata, Class<?> repositoryType, AbstractSqlRepositoryOperations.StoredInsert<T> insert, T entity, Set persisted, Connection connection, BeanProperty<T, Object> identity) throws SQLException {
        if (identity != null) {
            Dialect dialect = insert.getDialect();
            RuntimePersistentEntity<?> persistentEntity = this.getEntity(entity.getClass());
            block12: for (RuntimeAssociation association : persistentEntity.getAssociations()) {
                Iterable batchResult;
                BeanProperty bp;
                AbstractSqlRepositoryOperations.StoredInsert associatedInsert;
                if (!association.doesCascade(new Relation.Cascade[]{Relation.Cascade.PERSIST})) continue;
                Relation.Kind kind = association.getKind();
                RuntimePersistentEntity associatedEntity = association.getAssociatedEntity();
                Class associationType = associatedEntity.getIntrospection().getBeanType();
                RuntimePersistentProperty associatedId = associatedEntity.getIdentity();
                BeanProperty associatedIdProperty = associatedId.getProperty();
                switch (kind) {
                    case ONE_TO_ONE: 
                    case MANY_TO_ONE: {
                        Object id;
                        Object associated = association.getProperty().get(entity);
                        if (associated == null || persisted.contains(associated)) continue block12;
                        if (association.isForeignKey()) {
                            association.getInverseSide().ifPresent(inverse -> {
                                BeanProperty property = inverse.getProperty();
                                property.set(associated, entity);
                            });
                        }
                        associatedInsert = this.resolveEntityInsert(annotationMetadata, repositoryType, associationType, associatedEntity);
                        if (associatedId != null && (id = associatedIdProperty.get(associated)) != null) continue block12;
                        this.persistOne(annotationMetadata, repositoryType, associatedInsert, associated, persisted);
                        continue block12;
                    }
                }
                Object many = association.getProperty().get(entity);
                RuntimeAssociation inverse2 = association.getInverseSide().orElse(null);
                associatedInsert = this.resolveEntityInsert(annotationMetadata, repositoryType, associationType, associatedEntity);
                if (!(many instanceof Iterable)) continue;
                Iterable entities = (Iterable)many;
                ArrayList toPersist = new ArrayList(15);
                for (Object o : entities) {
                    Object id;
                    if (o == null || persisted.contains(o)) continue;
                    if (inverse2 != null && inverse2.getKind() == Relation.Kind.MANY_TO_ONE) {
                        BeanProperty property = inverse2.getProperty();
                        property.set(o, entity);
                    }
                    if (associatedId == null || (id = (bp = associatedIdProperty).get(o)) != null) continue;
                    toPersist.add(o);
                }
                if (insert.doesSupportBatch()) {
                    batchResult = this.persistInBatch(annotationMetadata, repositoryType, toPersist, associatedInsert, persisted);
                } else {
                    ArrayList arrayList = new ArrayList(toPersist);
                    bp = toPersist.iterator();
                    while (bp.hasNext()) {
                        Object o = bp.next();
                        arrayList.add(this.persistOne(annotationMetadata, repositoryType, associatedInsert, o, persisted));
                    }
                    batchResult = arrayList;
                }
                if (!SqlQueryBuilder.isForeignKeyWithJoinTable((Association)association)) continue;
                String associationInsert = this.resolveAssociationInsert(repositoryType, persistentEntity, association);
                PreparedStatement ps = connection.prepareStatement(associationInsert);
                Throwable throwable = null;
                try {
                    if (QUERY_LOG.isDebugEnabled()) {
                        QUERY_LOG.debug("Executing SQL Insert: {}", (Object)associationInsert);
                    }
                    Object parentId = identity.get(entity);
                    for (Object o : batchResult) {
                        Object childId = associatedIdProperty.get(o);
                        this.setStatementParameter(ps, 1, persistentEntity.getIdentity().getDataType(), parentId, dialect);
                        this.setStatementParameter(ps, 2, associatedId.getDataType(), childId, dialect);
                        ps.addBatch();
                    }
                    ps.executeBatch();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ps == null) continue;
                    if (throwable != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ps.close();
                }
            }
        }
    }

    @Nullable
    public <T> T findOne(@NonNull Class<T> type, @NonNull Serializable id) {
        throw new UnsupportedOperationException("The findOne method by ID is not supported. Execute the SQL query directly");
    }

    @NonNull
    public <T> Iterable<T> findAll(@NonNull PagedQuery<T> query) {
        throw new UnsupportedOperationException("The findAll method without an explicit query is not supported. Use findAll(PreparedQuery) instead");
    }

    public <T> long count(PagedQuery<T> pagedQuery) {
        throw new UnsupportedOperationException("The count method without an explicit query is not supported. Use findAll(PreparedQuery) instead");
    }

    @NonNull
    public <T> Stream<T> findStream(@NonNull PagedQuery<T> query) {
        throw new UnsupportedOperationException("The findStream method without an explicit query is not supported. Use findStream(PreparedQuery) instead");
    }

    public <R> Page<R> findPage(@NonNull PagedQuery<R> query) {
        throw new UnsupportedOperationException("The findPage method without an explicit query is not supported. Use findPage(PreparedQuery) instead");
    }

    @NonNull
    public <T> Iterable<T> persistAll(@NonNull InsertBatchOperation<T> operation) {
        AbstractSqlRepositoryOperations.StoredInsert<T> insert = this.resolveInsert(operation);
        if (!insert.doesSupportBatch()) {
            return operation.split().stream().map(this::persist).collect(Collectors.toList());
        }
        return this.persistInBatch(operation.getAnnotationMetadata(), operation.getRepositoryType(), (Iterable<T>)operation, insert, new HashSet(10));
    }

    private <T> Iterable<T> persistInBatch(AnnotationMetadata annotationMetadata, Class<?> repositoryType, @NonNull Iterable<T> entities, AbstractSqlRepositoryOperations.StoredInsert<T> insert, Set persisted) {
        return (Iterable)this.transactionOperations.executeWrite(status -> {
            Connection connection = (Connection)status.getConnection();
            ArrayList results = new ArrayList(10);
            boolean generateId = insert.isGenerateId();
            String insertSql = insert.getSql();
            BeanProperty identity = insert.getIdentityProperty();
            boolean hasGeneratedID = generateId && identity != null;
            RuntimePersistentEntity persistentEntity = insert.getPersistentEntity();
            try (PreparedStatement stmt = connection.prepareStatement(insertSql, generateId ? 1 : 2);){
                if (QUERY_LOG.isDebugEnabled()) {
                    QUERY_LOG.debug("Executing Batch SQL Insert: {}", (Object)insertSql);
                }
                boolean hasPrePersistEventListeners = persistentEntity.hasPrePersistEventListeners();
                for (Object entity : entities) {
                    if (persisted.contains(entity)) continue;
                    if (hasPrePersistEventListeners) {
                        Object eventResult = this.triggerPrePersist(entity, persistentEntity, annotationMetadata);
                        if (eventResult == null) {
                            results.add(entity);
                            continue;
                        }
                        entity = eventResult;
                    }
                    this.setInsertParameters(insert, entity, stmt);
                    stmt.addBatch();
                    results.add(entity);
                }
                stmt.executeBatch();
                if (hasGeneratedID && !identity.isReadOnly()) {
                    ListIterator resultIterator = results.listIterator();
                    ResultSet generatedKeys = stmt.getGeneratedKeys();
                    while (resultIterator.hasNext()) {
                        Object entity = resultIterator.next();
                        if (!generatedKeys.next()) {
                            throw new DataAccessException("Failed to generate ID for entity: " + entity);
                        }
                        Object id = this.getEntityId(generatedKeys, insert.getIdentity().getDataType(), identity.getType());
                        Object resolvedEntity = this.updateEntityId(identity, entity, id);
                        if (resolvedEntity == entity) continue;
                        resultIterator.set(resolvedEntity);
                    }
                }
                boolean hasPostPersistEventListeners = persistentEntity.hasPostPersistEventListeners();
                for (Object result : results) {
                    if (hasPostPersistEventListeners) {
                        result = this.triggerPostPersist(result, persistentEntity, annotationMetadata);
                    }
                    this.cascadeInserts(annotationMetadata, repositoryType, insert, result, persisted, connection, identity);
                }
                ArrayList arrayList = results;
                return arrayList;
            }
            catch (SQLException e) {
                throw new DataAccessException("SQL error executing INSERT: " + e.getMessage(), (Throwable)e);
            }
        });
    }

    private Object getEntityId(ResultSet generatedKeys, DataType dataType, Class<Object> type) throws SQLException {
        Object id;
        switch (dataType) {
            case LONG: {
                id = generatedKeys.getLong(1);
                break;
            }
            case STRING: {
                id = generatedKeys.getString(1);
                break;
            }
            default: {
                id = generatedKeys.getObject(1, type);
            }
        }
        return id;
    }

    @Override
    @PreDestroy
    public void close() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    @Override
    @NonNull
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    @NonNull
    public Connection getConnection() {
        return (Connection)this.transactionOperations.getConnection();
    }

    @Override
    @NonNull
    public <R> R execute(@NonNull ConnectionCallback<R> callback) {
        try {
            return callback.call((Connection)this.transactionOperations.getConnection());
        }
        catch (SQLException e) {
            throw new DataAccessException("Error executing SQL Callback: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NonNull
    public <R> R prepareStatement(@NonNull String sql, @NonNull PreparedStatementCallback<R> callback) {
        ArgumentUtils.requireNonNull((String)"sql", (Object)sql);
        ArgumentUtils.requireNonNull((String)"callback", callback);
        if (QUERY_LOG.isDebugEnabled()) {
            QUERY_LOG.debug("Executing Query: {}", (Object)sql);
        }
        try (PreparedStatement ps = ((Connection)this.transactionOperations.getConnection()).prepareStatement(sql);){
            R r = callback.call(ps);
            return r;
        }
        catch (SQLException e) {
            throw new DataAccessException("Error preparing SQL statement: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @NonNull
    public <T> Stream<T> entityStream(@NonNull ResultSet resultSet, @NonNull Class<T> rootEntity) {
        return this.entityStream(resultSet, null, rootEntity);
    }

    @Override
    @NonNull
    public <E> E readEntity(@NonNull String prefix, @NonNull ResultSet resultSet, @NonNull Class<E> type) throws DataAccessException {
        return (E)new SqlResultEntityTypeMapper(prefix, this.getEntity(type), this.columnNameResultSetReader, this.jsonCodec).map((Object)resultSet, type);
    }

    @Override
    @NonNull
    public <E, D> D readDTO(@NonNull String prefix, @NonNull ResultSet resultSet, @NonNull Class<E> rootEntity, @NonNull Class<D> dtoType) throws DataAccessException {
        return (D)new DTOMapper(this.getEntity(rootEntity), this.columnNameResultSetReader, this.jsonCodec).map((Object)resultSet, dtoType);
    }

    @Override
    @NonNull
    public <T> Stream<T> entityStream(@NonNull ResultSet resultSet, @Nullable String prefix, @NonNull Class<T> rootEntity) {
        ArgumentUtils.requireNonNull((String)"resultSet", (Object)resultSet);
        ArgumentUtils.requireNonNull((String)"rootEntity", rootEntity);
        SqlResultEntityTypeMapper mapper = new SqlResultEntityTypeMapper(prefix, this.getEntity(rootEntity), this.columnNameResultSetReader, this.jsonCodec);
        Iterable iterable = () -> this.lambda$entityStream$15(resultSet, (TypeMapper)mapper, rootEntity);
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    private /* synthetic */ Iterator lambda$entityStream$15(final ResultSet resultSet, final TypeMapper mapper, final Class rootEntity) {
        return new Iterator<T>(){
            boolean nextCalled = false;

            @Override
            public boolean hasNext() {
                try {
                    if (!this.nextCalled) {
                        this.nextCalled = true;
                        return resultSet.next();
                    }
                    return this.nextCalled;
                }
                catch (SQLException e) {
                    throw new DataAccessException("Error retrieving next JDBC result: " + e.getMessage(), (Throwable)e);
                }
            }

            @Override
            public T next() {
                this.nextCalled = false;
                return mapper.map((Object)resultSet, rootEntity);
            }
        };
    }
}

