/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.hibernate.reactive.repository.jpa.intercept;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.hibernate.reactive.repository.jpa.intercept.AbstractSpecificationInterceptor;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.jpa.repository.criteria.Specification;
import io.micronaut.data.operations.RepositoryOperations;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.Collections;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@Internal
public class ReactiveCountSpecificationInterceptor
extends AbstractSpecificationInterceptor {
    public ReactiveCountSpecificationInterceptor(@NonNull RepositoryOperations operations) {
        super(operations);
    }

    protected Publisher<?> interceptPublisher(RepositoryMethodKey methodKey, MethodInvocationContext<Object, Object> context) {
        Predicate predicate;
        Specification<Object> specification = this.getSpecification(context);
        CriteriaBuilder criteriaBuilder = this.operations.getCriteriaBuilder();
        CriteriaQuery query = criteriaBuilder.createQuery(Long.class);
        Root root = query.from(this.getRequiredRootEntity(context));
        Predicate predicate2 = predicate = specification != null ? specification.toPredicate(root, query, criteriaBuilder) : null;
        if (predicate != null) {
            query.where((Expression)predicate);
        }
        if (query.isDistinct()) {
            query.select((Selection)criteriaBuilder.countDistinct((Expression)root));
        } else {
            query.select((Selection)criteriaBuilder.count((Expression)root));
        }
        query.orderBy(Collections.emptyList());
        return this.operations.withSession(session -> Mono.fromCompletionStage(() -> session.createQuery(query).getSingleResult()));
    }
}

