/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.hibernate.reactive.repository.jpa.intercept;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.hibernate.reactive.repository.jpa.intercept.AbstractSpecificationInterceptor;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.jpa.repository.criteria.Specification;
import io.micronaut.data.operations.RepositoryOperations;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@Internal
public class ReactiveFindOneSpecificationInterceptor
extends AbstractSpecificationInterceptor {
    protected ReactiveFindOneSpecificationInterceptor(@NonNull RepositoryOperations operations) {
        super(operations);
    }

    protected Publisher<?> interceptPublisher(RepositoryMethodKey methodKey, MethodInvocationContext<Object, Object> context) {
        Predicate predicate;
        Specification<Object> specification = this.getSpecification(context);
        CriteriaBuilder criteriaBuilder = this.operations.getCriteriaBuilder();
        CriteriaQuery query = criteriaBuilder.createQuery(this.getRequiredRootEntity(context));
        Root root = query.from(this.getRequiredRootEntity(context));
        Predicate predicate2 = predicate = specification != null ? specification.toPredicate(root, query, criteriaBuilder) : null;
        if (predicate != null) {
            query.where((Expression)predicate);
        }
        query.select((Selection)root);
        return this.operations.withSession(session -> Mono.fromCompletionStage(() -> session.createQuery(query).getSingleResult()));
    }
}

