/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.hibernate.reactive.operations;

import io.micronaut.aop.InvocationContext;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.data.annotation.QueryHint;
import io.micronaut.data.connection.reactive.ReactorConnectionOperations;
import io.micronaut.data.hibernate.conf.RequiresReactiveHibernate;
import io.micronaut.data.hibernate.operations.AbstractHibernateOperations;
import io.micronaut.data.hibernate.reactive.operations.HibernateReactorRepositoryOperations;
import io.micronaut.data.hibernate.reactive.operations.ReactiveHibernateHelper;
import io.micronaut.data.model.Limit;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.runtime.DeleteBatchOperation;
import io.micronaut.data.model.runtime.DeleteOperation;
import io.micronaut.data.model.runtime.InsertBatchOperation;
import io.micronaut.data.model.runtime.InsertOperation;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.StoredQuery;
import io.micronaut.data.model.runtime.UpdateBatchOperation;
import io.micronaut.data.model.runtime.UpdateOperation;
import io.micronaut.data.operations.reactive.ReactorCriteriaRepositoryOperations;
import io.micronaut.data.runtime.convert.DataConversionService;
import io.micronaut.transaction.reactive.ReactorReactiveTransactionOperations;
import jakarta.persistence.EntityGraph;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.Tuple;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.hibernate.SessionFactory;
import org.hibernate.reactive.stage.Stage;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RequiresReactiveHibernate
@EachBean(value=SessionFactory.class)
@Internal
final class DefaultHibernateReactiveRepositoryOperations
extends AbstractHibernateOperations<Stage.Session, Stage.AbstractQuery, Stage.SelectionQuery<?>>
implements HibernateReactorRepositoryOperations,
ReactorCriteriaRepositoryOperations {
    private final SessionFactory sessionFactory;
    private final Stage.SessionFactory stageSessionFactory;
    private final ReactiveHibernateHelper helper;
    private final ReactorConnectionOperations<Stage.Session> connectionOperations;
    private final ReactorReactiveTransactionOperations<Stage.Session> transactionOperations;

    DefaultHibernateReactiveRepositoryOperations(SessionFactory sessionFactory, RuntimeEntityRegistry runtimeEntityRegistry, DataConversionService dataConversionService, @Parameter ReactorConnectionOperations<Stage.Session> connectionOperations, @Parameter ReactorReactiveTransactionOperations<Stage.Session> transactionOperations) {
        super(runtimeEntityRegistry, dataConversionService);
        this.sessionFactory = sessionFactory;
        this.stageSessionFactory = (Stage.SessionFactory)sessionFactory.unwrap(Stage.SessionFactory.class);
        this.connectionOperations = connectionOperations;
        this.transactionOperations = transactionOperations;
        this.helper = new ReactiveHibernateHelper(this.stageSessionFactory);
    }

    protected void setParameter(Stage.AbstractQuery query, String parameterName, Object value) {
        query.setParameter(parameterName, value);
    }

    protected void setParameter(Stage.AbstractQuery query, String parameterName, Object value, Argument<?> argument) {
        query.setParameter(parameterName, value);
    }

    protected void setParameterList(Stage.AbstractQuery query, String parameterName, Collection<Object> value) {
        query.setParameter(parameterName, value);
    }

    protected void setParameterList(Stage.AbstractQuery query, String parameterName, Collection<Object> value, Argument<?> argument) {
        query.setParameter(parameterName, value);
    }

    protected void setParameter(Stage.AbstractQuery query, int parameterIndex, Object value) {
        query.setParameter(parameterIndex, value);
    }

    protected void setParameter(Stage.AbstractQuery query, int parameterIndex, Object value, Argument<?> argument) {
        query.setParameter(parameterIndex, value);
    }

    protected void setParameterList(Stage.AbstractQuery query, int parameterIndex, Collection<Object> value) {
        query.setParameter(parameterIndex, value);
    }

    protected void setParameterList(Stage.AbstractQuery query, int parameterIndex, Collection<Object> value, Argument<?> argument) {
        query.setParameter(parameterIndex, value);
    }

    protected void setHint(Stage.SelectionQuery<?> query, String hintName, Object value) {
        if (value instanceof EntityGraph) {
            EntityGraph plan = (EntityGraph)value;
            query.setPlan(plan);
            return;
        }
        throw new IllegalStateException("Unrecognized parameter: " + hintName + " with value: " + String.valueOf(value));
    }

    protected void setMaxResults(Stage.SelectionQuery<?> query, int max) {
        query.setMaxResults(max);
    }

    protected void setOffset(Stage.SelectionQuery<?> query, int offset) {
        query.setFirstResult(offset);
    }

    protected <T> EntityGraph<T> getEntityGraph(Stage.Session session, Class<T> entityType, String graphName) {
        return session.getEntityGraph(entityType, graphName);
    }

    protected <T> EntityGraph<T> createEntityGraph(Stage.Session session, Class<T> entityType) {
        return session.createEntityGraph(entityType);
    }

    protected <T> RuntimePersistentEntity<T> getEntity(Class<T> type) {
        return this.runtimeEntityRegistry.getEntity(type);
    }

    @Override
    public CriteriaBuilder getCriteriaBuilder() {
        return this.stageSessionFactory.getCriteriaBuilder();
    }

    @Override
    public Mono<Void> flush() {
        return this.withSession(this.helper::flush);
    }

    @Override
    public Mono<Void> persistAndFlush(Object entity) {
        return this.operation(session -> this.helper.persist((Stage.Session)session, entity).then(this.helper.flush((Stage.Session)session)));
    }

    public <T> Mono<T> findOne(Class<T> type, Object id) {
        return this.operation(session -> this.helper.find((Stage.Session)session, type, id));
    }

    public <T> Mono<Boolean> exists(PreparedQuery<T, Boolean> preparedQuery) {
        return this.findOne((PreparedQuery<T, R>)((PreparedQuery)preparedQuery)).hasElement();
    }

    protected Stage.SelectionQuery<?> createNativeQuery(Stage.Session session, String query, Class<?> resultType) {
        if (resultType == null) {
            return session.createNativeQuery(query);
        }
        return session.createNativeQuery(query, resultType);
    }

    protected Stage.SelectionQuery<?> createQuery(Stage.Session session, String query, Class<?> resultType) {
        if (resultType == null) {
            return session.createQuery(query);
        }
        return session.createQuery(query, resultType);
    }

    protected Stage.SelectionQuery<?> createQuery(Stage.Session session, CriteriaQuery<?> criteriaQuery) {
        return session.createQuery(criteriaQuery);
    }

    public <T, R> Mono<R> findOne(PreparedQuery<T, R> preparedQuery) {
        return this.operation(session -> {
            FirstResultCollector collector = new FirstResultCollector(false);
            this.collectFindOne(session, preparedQuery, collector);
            return collector.result;
        });
    }

    public <T> Mono<T> findOptional(Class<T> type, Object id) {
        return this.findOne(type, id);
    }

    public <T, R> Mono<R> findOptional(PreparedQuery<T, R> preparedQuery) {
        return this.findOne(preparedQuery);
    }

    public <T> Flux<T> findAll(PagedQuery<T> pagedQuery) {
        return this.operationFlux(session -> this.findPaged((Stage.Session)session, pagedQuery));
    }

    public <R> Mono<Page<R>> findPage(PagedQuery<R> pagedQuery) {
        if (pagedQuery instanceof PreparedQuery) {
            PreparedQuery pg;
            PreparedQuery preparedQuery = pg = (PreparedQuery)pagedQuery;
            return this.findAll((PreparedQuery<T, R>)preparedQuery).collectList().map(content -> Page.of((List)content, (Pageable)pagedQuery.getPageable(), (Long)-1L));
        }
        return this.operation(session -> this.findPaged((Stage.Session)session, (PagedQuery)pagedQuery).collectList().flatMap(resultList -> this.countOf((Stage.Session)session, pagedQuery.getRootEntity(), pagedQuery.getQueryLimit()).map(total -> Page.of((List)resultList, (Pageable)pagedQuery.getPageable(), (Long)total))));
    }

    public <T> Mono<Long> count(PagedQuery<T> pagedQuery) {
        return this.operation(session -> this.countOf((Stage.Session)session, (Class)Long.class, null));
    }

    private <T> Flux<T> findPaged(Stage.Session session, PagedQuery<T> pagedQuery) {
        ListResultCollector collector = new ListResultCollector();
        this.collectPagedResults((CriteriaBuilder)this.sessionFactory.getCriteriaBuilder(), session, pagedQuery, collector);
        return collector.result;
    }

    private <T> Mono<Long> countOf(Stage.Session session, Class<T> entity, Limit limit) {
        SingleResultCollector collector = new SingleResultCollector();
        this.collectCountOf((CriteriaBuilder)this.sessionFactory.getCriteriaBuilder(), session, entity, limit, collector);
        return collector.result;
    }

    public <T, R> Flux<R> findAll(PreparedQuery<T, R> preparedQuery) {
        return this.operationFlux(session -> {
            ListResultCollector resultCollector = new ListResultCollector();
            this.collectFindAll(session, preparedQuery, resultCollector);
            return resultCollector.result;
        });
    }

    public <T> Mono<T> persist(InsertOperation<T> operation) {
        return this.operation(session -> {
            StoredQuery storedQuery = operation.getStoredQuery();
            Object entity = operation.getEntity();
            Mono result = storedQuery != null ? this.executeEntityUpdate((Stage.Session)session, (StoredQuery)storedQuery, (InvocationContext<?, ?>)operation.getInvocationContext(), (Object)entity).thenReturn(entity) : this.helper.persist((Stage.Session)session, entity);
            return this.flushIfNecessary((Mono)result, (Stage.Session)session, operation.getAnnotationMetadata());
        });
    }

    public <T> Mono<T> update(UpdateOperation<T> operation) {
        return this.operation(session -> {
            StoredQuery storedQuery = operation.getStoredQuery();
            Object entity = operation.getEntity();
            Mono result = storedQuery != null ? this.executeEntityUpdate((Stage.Session)session, (StoredQuery)storedQuery, (InvocationContext<?, ?>)operation.getInvocationContext(), (Object)entity).thenReturn(entity) : this.helper.merge((Stage.Session)session, entity);
            return this.flushIfNecessary((Mono)result, (Stage.Session)session, operation.getAnnotationMetadata());
        });
    }

    private <T> Mono<Integer> executeEntityUpdate(Stage.Session session, StoredQuery<T, ?> storedQuery, InvocationContext<?, ?> invocationContext, T entity) {
        Stage.MutationQuery query = session.createMutationQuery(storedQuery.getQuery());
        this.bindParameters(query, storedQuery, invocationContext, entity);
        return this.helper.executeUpdate(query);
    }

    public <T> Flux<T> updateAll(UpdateBatchOperation<T> operation) {
        return this.operationFlux(session -> {
            StoredQuery storedQuery = operation.getStoredQuery();
            Flux result = storedQuery != null ? Flux.fromIterable((Iterable)operation).concatMap(t -> this.executeEntityUpdate((Stage.Session)session, (StoredQuery)storedQuery, (InvocationContext<?, ?>)operation.getInvocationContext(), (Object)t).thenReturn(t)) : this.helper.mergeAll((Stage.Session)session, operation);
            return this.flushIfNecessaryFlux((Flux)result, (Stage.Session)session, operation.getAnnotationMetadata());
        });
    }

    public <T> Flux<T> persistAll(InsertBatchOperation<T> operation) {
        return this.operationFlux(session -> {
            StoredQuery storedQuery = operation.getStoredQuery();
            Flux result = storedQuery != null ? Flux.fromIterable((Iterable)operation).concatMap(t -> this.executeEntityUpdate((Stage.Session)session, (StoredQuery)storedQuery, (InvocationContext<?, ?>)operation.getInvocationContext(), (Object)t).thenReturn(t)) : this.helper.persistAll((Stage.Session)session, operation);
            return this.flushIfNecessaryFlux((Flux)result, (Stage.Session)session, operation.getAnnotationMetadata());
        });
    }

    public Mono<Number> executeUpdate(PreparedQuery<?, Number> preparedQuery) {
        return this.operation(session -> {
            String query = preparedQuery.getQuery();
            Stage.MutationQuery q = session.createMutationQuery(query);
            this.bindParameters(q, preparedQuery, true);
            Mono result = this.helper.executeUpdate(q).cast(Number.class);
            return this.flushIfNecessary((Mono)result, (Stage.Session)session, preparedQuery.getAnnotationMetadata());
        });
    }

    public Mono<Number> executeDelete(PreparedQuery<?, Number> preparedQuery) {
        return this.executeUpdate(preparedQuery);
    }

    public <T> Mono<Number> delete(DeleteOperation<T> operation) {
        return this.operation(session -> {
            StoredQuery storedQuery = operation.getStoredQuery();
            Mono result = storedQuery != null ? this.executeEntityUpdate((Stage.Session)session, (StoredQuery)storedQuery, (InvocationContext<?, ?>)operation.getInvocationContext(), (Object)operation.getEntity()).cast(Number.class) : this.helper.remove((Stage.Session)session, operation.getEntity()).thenReturn((Object)1);
            return this.flushIfNecessary((Mono)result, (Stage.Session)session, operation.getAnnotationMetadata());
        });
    }

    public <T> Mono<Number> deleteAll(DeleteBatchOperation<T> operation) {
        return this.operation(session -> {
            StoredQuery storedQuery = operation.getStoredQuery();
            Mono result = storedQuery != null ? Flux.fromIterable((Iterable)operation).concatMap(entity -> this.executeEntityUpdate((Stage.Session)session, (StoredQuery)storedQuery, (InvocationContext<?, ?>)operation.getInvocationContext(), (Object)entity)).reduce((Object)0, (i1, i2) -> i1 + i2).cast(Number.class) : this.helper.removeAll((Stage.Session)session, operation);
            return this.flushIfNecessary((Mono)result, (Stage.Session)session, operation.getAnnotationMetadata());
        });
    }

    private <T> Mono<T> flushIfNecessary(Mono<T> m, Stage.Session session, AnnotationMetadata annotationMetadata) {
        FlushModeType flushModeType;
        if (annotationMetadata.hasAnnotation(QueryHint.class) && (flushModeType = this.getFlushModeType(annotationMetadata)) == FlushModeType.AUTO) {
            return m.flatMap(t -> this.helper.flush(session).thenReturn(t));
        }
        return m;
    }

    private <T> Flux<T> flushIfNecessaryFlux(Flux<T> flux, Stage.Session session, AnnotationMetadata annotationMetadata) {
        return this.flushIfNecessary(flux.collectList(), session, annotationMetadata).flatMapMany(Flux::fromIterable);
    }

    private <T> Mono<T> operation(Function<Stage.Session, Mono<T>> work) {
        return this.transactionOperations.withTransactionMono(tx -> (Mono)work.apply((Stage.Session)tx.getConnection()));
    }

    private <T> Flux<T> operationFlux(Function<Stage.Session, Flux<T>> work) {
        return this.transactionOperations.withTransactionFlux(tx -> (Flux)work.apply((Stage.Session)tx.getConnection()));
    }

    @Override
    public <T> Mono<T> withSession(Function<Stage.Session, Mono<T>> work) {
        return this.connectionOperations.withConnectionMono(status -> (Mono)work.apply((Stage.Session)status.getConnection()));
    }

    @Override
    public <T> Flux<T> withSessionFlux(Function<Stage.Session, Flux<T>> work) {
        return this.connectionOperations.withConnectionFlux(status -> (Flux)work.apply((Stage.Session)status.getConnection()));
    }

    public ConversionService getConversionService() {
        return this.dataConversionService;
    }

    public <R> Mono<R> findOne(CriteriaQuery<R> query) {
        return this.withSession(session -> this.helper.monoFromCompletionStage(() -> session.createQuery(query).getSingleResult()));
    }

    public Publisher<Boolean> exists(CriteriaQuery<?> query) {
        return this.withSession(session -> this.helper.monoFromCompletionStage(() -> session.createQuery(query).setMaxResults(1).getResultList().thenApply(l -> !l.isEmpty())));
    }

    public <T> Flux<T> findAll(CriteriaQuery<T> query) {
        return this.withSession(session -> this.helper.monoFromCompletionStage(() -> session.createQuery(query).getResultList())).flatMapIterable(res -> res);
    }

    public <T> Flux<T> findAll(CriteriaQuery<T> query, int offset, int limit) {
        return this.withSession(session -> this.helper.monoFromCompletionStage(() -> {
            Stage.SelectionQuery sessionQuery = session.createQuery(query);
            if (offset > 0) {
                sessionQuery = sessionQuery.setFirstResult(offset);
            }
            if (limit > 0) {
                sessionQuery = sessionQuery.setMaxResults(limit);
            }
            return sessionQuery.getResultList();
        })).flatMapIterable(res -> res);
    }

    public Mono<Number> updateAll(CriteriaUpdate<Number> query) {
        return this.withSession(session -> this.helper.monoFromCompletionStage(() -> session.createQuery(query).executeUpdate()).map(n -> n));
    }

    public Mono<Number> deleteAll(CriteriaDelete<Number> query) {
        return this.withSession(session -> this.helper.monoFromCompletionStage(() -> session.createQuery(query).executeUpdate()).map(n -> n));
    }

    private final class ListResultCollector<R>
    extends AbstractHibernateOperations.ResultCollector<R> {
        private Flux<R> result;

        private ListResultCollector() {
            super((AbstractHibernateOperations)DefaultHibernateReactiveRepositoryOperations.this);
        }

        protected void collectTuple(Stage.SelectionQuery<?> query, Function<Tuple, R> fn) {
            Flux<?> tuples = DefaultHibernateReactiveRepositoryOperations.this.helper.list(query);
            this.result = tuples.map(fn);
        }

        protected void collect(Stage.SelectionQuery<?> query) {
            this.result = DefaultHibernateReactiveRepositoryOperations.this.helper.list(query);
        }
    }

    private final class SingleResultCollector<R>
    extends AbstractHibernateOperations.ResultCollector<R> {
        private Mono<R> result;

        private SingleResultCollector() {
            super((AbstractHibernateOperations)DefaultHibernateReactiveRepositoryOperations.this);
        }

        protected void collectTuple(Stage.SelectionQuery<?> query, Function<Tuple, R> fn) {
            this.result = DefaultHibernateReactiveRepositoryOperations.this.helper.singleResult(query).map(fn);
        }

        protected void collect(Stage.SelectionQuery<?> query) {
            this.result = DefaultHibernateReactiveRepositoryOperations.this.helper.singleResult(query);
        }
    }

    private final class FirstResultCollector<R>
    extends AbstractHibernateOperations.ResultCollector<R> {
        private final boolean limitOne;
        private Mono<R> result;

        private FirstResultCollector(boolean limitOne) {
            super((AbstractHibernateOperations)DefaultHibernateReactiveRepositoryOperations.this);
            this.limitOne = limitOne;
        }

        protected void collectTuple(Stage.SelectionQuery<?> query, Function<Tuple, R> fn) {
            this.result = this.getFirst(query).map(fn);
        }

        protected void collect(Stage.SelectionQuery<?> query) {
            this.result = this.getFirst(query);
        }

        private <T> Mono<T> getFirst(Stage.SelectionQuery<T> q) {
            if (this.limitOne) {
                q.setMaxResults(1);
            }
            return DefaultHibernateReactiveRepositoryOperations.this.helper.list(q).next();
        }
    }
}

