/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.document.processor.matchers;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.annotation.ParameterExpression;
import io.micronaut.data.annotation.Query;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.model.query.BindingParameter;
import io.micronaut.data.model.query.builder.QueryParameterBinding;
import io.micronaut.data.model.query.builder.QueryResult;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.visitors.MatchFailedException;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.FindersUtils;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.MethodMatcher;
import io.micronaut.data.processor.visitors.finders.RawQueryMethodMatcher;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.annotation.MutableAnnotationMetadata;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.NonNull;

public class MongoRawQueryMethodMatcher
implements MethodMatcher {
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("([^:]*)((?<![:]):([a-zA-Z]+[a-zA-Z0-9]*))([^:]*)");

    public final int getOrder() {
        return -2000;
    }

    public MethodMatcher.MethodMatch match(MethodMatchContext matchContext) {
        AnnotationMetadata annotationMetadata = matchContext.getAnnotationMetadata();
        if (!annotationMetadata.hasAnnotation("io.micronaut.data.mongodb.annotation.MongoRepository")) {
            return null;
        }
        if (annotationMetadata.hasAnnotation("io.micronaut.data.mongodb.annotation.MongoFindQuery") || annotationMetadata.hasAnnotation("io.micronaut.data.mongodb.annotation.MongoAggregateQuery")) {
            return this.methodMatchByFilterQuery(DataMethod.OperationType.QUERY);
        }
        if (annotationMetadata.hasAnnotation("io.micronaut.data.mongodb.annotation.MongoDeleteQuery")) {
            return this.methodMatchByFilterQuery(DataMethod.OperationType.DELETE);
        }
        if (annotationMetadata.hasAnnotation("io.micronaut.data.mongodb.annotation.MongoUpdateQuery")) {
            return this.methodMatchByFilterQuery(DataMethod.OperationType.UPDATE);
        }
        if (annotationMetadata.stringValue(Query.class).isPresent()) {
            throw new MatchFailedException("`@Query` annotations is not supported for MongoDB repositories. Use one of the annotations from `io.micronaut.data.mongodb.annotation` for a custom query.");
        }
        return null;
    }

    private void removeAnnotation(AnnotationMetadata annotationMetadata, String annotation) {
        if (annotationMetadata instanceof AnnotationMetadataHierarchy) {
            AnnotationMetadataHierarchy hierarchy = (AnnotationMetadataHierarchy)annotationMetadata;
            this.removeAnnotation(hierarchy.getDeclaredMetadata(), annotation);
            this.removeAnnotation(hierarchy.getRootMetadata(), annotation);
            return;
        }
        if (annotationMetadata instanceof MutableAnnotationMetadata) {
            MutableAnnotationMetadata mutableAnnotationMetadata = (MutableAnnotationMetadata)annotationMetadata;
            mutableAnnotationMetadata.removeAnnotation(annotation);
            mutableAnnotationMetadata.removeStereotype(annotation);
        }
    }

    private MethodMatcher.MethodMatch methodMatchByFilterQuery(final DataMethod.OperationType operationType) {
        return new MethodMatcher.MethodMatch(){
            final /* synthetic */ MongoRawQueryMethodMatcher this$0;
            {
                this.this$0 = this$0;
            }

            public MethodMatchInfo buildMatchInfo(MethodMatchContext matchContext) {
                ParameterElement entitiesParameter;
                ParameterElement entityParameter;
                ParameterElement[] parameters = matchContext.getParameters();
                if (parameters.length > 1) {
                    entityParameter = null;
                    entitiesParameter = null;
                } else {
                    entityParameter = Arrays.stream(parameters).filter(p -> TypeUtils.isEntity((ClassElement)p.getGenericType())).findFirst().orElse(null);
                    entitiesParameter = Arrays.stream(parameters).filter(p -> TypeUtils.isIterableOfEntity((ClassElement)p.getGenericType())).findFirst().orElse(null);
                }
                FindersUtils.InterceptorMatch entry = FindersUtils.resolveInterceptorTypeByOperationType((entityParameter != null ? 1 : 0) != 0, (entitiesParameter != null ? 1 : 0) != 0, (DataMethod.OperationType)operationType, (MethodMatchContext)matchContext);
                ClassElement resultType = entry.returnType();
                ClassElement interceptorType = entry.interceptor();
                boolean isDto = false;
                if (resultType == null) {
                    resultType = matchContext.getRootEntity().getType();
                } else if (resultType.hasAnnotation(Introspected.class) && !resultType.hasAnnotation(MappedEntity.class)) {
                    isDto = true;
                }
                MethodMatchInfo methodMatchInfo = new MethodMatchInfo(operationType, (TypedElement)resultType, interceptorType);
                methodMatchInfo.dto(isDto);
                this.this$0.buildRawQuery(matchContext, methodMatchInfo, entityParameter, entitiesParameter, operationType);
                if (entityParameter != null) {
                    methodMatchInfo.addParameterRole(entityParameter, "entity");
                } else if (entitiesParameter != null) {
                    methodMatchInfo.addParameterRole(entitiesParameter, "entities");
                }
                return methodMatchInfo;
            }
        };
    }

    private void buildRawQuery(@NonNull MethodMatchContext matchContext, MethodMatchInfo methodMatchInfo, ParameterElement entityParameter, ParameterElement entitiesParameter, DataMethod.OperationType operationType) {
        MethodElement methodElement = matchContext.getMethodElement();
        List<ParameterElement> parameters = Arrays.asList(matchContext.getParameters());
        ParameterElement entityParam = null;
        SourcePersistentEntity persistentEntity = null;
        if (entityParameter != null) {
            entityParam = entityParameter;
            persistentEntity = matchContext.getEntity(entityParameter.getGenericType());
        } else if (entitiesParameter != null) {
            entityParam = entitiesParameter;
            persistentEntity = matchContext.getEntity((ClassElement)entitiesParameter.getGenericType().getFirstTypeArgument().orElseThrow(IllegalStateException::new));
        }
        QueryResult queryResult = operationType == DataMethod.OperationType.UPDATE ? this.getUpdateQueryResult(matchContext, parameters, entityParam, persistentEntity) : this.getQueryResult(matchContext, parameters, entityParam, persistentEntity);
        boolean encodeEntityParameters = persistentEntity != null || operationType == DataMethod.OperationType.INSERT;
        methodElement.annotate(Query.class, builder -> {
            if (queryResult.getUpdate() != null) {
                builder.member("update", queryResult.getUpdate());
            }
            builder.value(queryResult.getQuery());
        });
        methodMatchInfo.encodeEntityParameters(encodeEntityParameters).queryResult(queryResult).countQueryResult(null);
    }

    private QueryResult getQueryResult(MethodMatchContext matchContext, List<ParameterElement> parameters, ParameterElement entityParam, SourcePersistentEntity persistentEntity) {
        String filterQueryString;
        if (matchContext.getMethodElement().hasAnnotation("io.micronaut.data.mongodb.annotation.MongoAggregateQuery")) {
            filterQueryString = (String)matchContext.getMethodElement().stringValue("io.micronaut.data.mongodb.annotation.MongoAggregateQuery").orElseThrow(() -> new MatchFailedException("The pipeline value is missing!"));
            this.removeAnnotation(matchContext.getAnnotationMetadata(), "io.micronaut.data.mongodb.annotation.MongoAggregateQuery");
        } else if (matchContext.getMethodElement().hasAnnotation("io.micronaut.data.mongodb.annotation.MongoFindQuery")) {
            filterQueryString = (String)matchContext.getMethodElement().stringValue("io.micronaut.data.mongodb.annotation.MongoFilter").orElseThrow(() -> new MatchFailedException("The filter value is missing!"));
            this.removeAnnotation(matchContext.getAnnotationMetadata(), "io.micronaut.data.mongodb.annotation.MongoFilter");
            this.removeAnnotation(matchContext.getAnnotationMetadata(), "io.micronaut.data.mongodb.annotation.MongoFindQuery");
        } else if (matchContext.getMethodElement().hasAnnotation("io.micronaut.data.mongodb.annotation.MongoDeleteQuery")) {
            filterQueryString = (String)matchContext.getMethodElement().stringValue("io.micronaut.data.mongodb.annotation.MongoFilter").orElseThrow(() -> new MatchFailedException("The filter value is missing!"));
            this.removeAnnotation(matchContext.getAnnotationMetadata(), "io.micronaut.data.mongodb.annotation.MongoFilter");
            this.removeAnnotation(matchContext.getAnnotationMetadata(), "io.micronaut.data.mongodb.annotation.MongoDeleteQuery");
        } else {
            throw new MatchFailedException("Unknown custom query annotation!");
        }
        ArrayList<QueryParameterBinding> parameterBindings = new ArrayList<QueryParameterBinding>(parameters.size());
        String filterQuery = this.processCustomQuery(matchContext, filterQueryString, parameters, entityParam, persistentEntity, parameterBindings);
        return QueryResult.of((String)filterQuery, parameterBindings);
    }

    private QueryResult getUpdateQueryResult(MethodMatchContext matchContext, List<ParameterElement> parameters, ParameterElement entityParam, SourcePersistentEntity persistentEntity) {
        String filterQueryString = matchContext.getMethodElement().stringValue("io.micronaut.data.mongodb.annotation.MongoFilter").orElse("{}");
        String updateQueryString = (String)matchContext.getMethodElement().stringValue("io.micronaut.data.mongodb.annotation.MongoUpdateQuery", "update").orElseThrow(() -> new MatchFailedException("Update query is missing!"));
        this.removeAnnotation(matchContext.getAnnotationMetadata(), "io.micronaut.data.mongodb.annotation.MongoFilter");
        this.removeAnnotation(matchContext.getAnnotationMetadata(), "io.micronaut.data.mongodb.annotation.MongoUpdateQuery");
        final ArrayList<QueryParameterBinding> parameterBindings = new ArrayList<QueryParameterBinding>(parameters.size());
        final String filterQuery = this.processCustomQuery(matchContext, filterQueryString, parameters, entityParam, persistentEntity, parameterBindings);
        final String updateQuery = this.processCustomQuery(matchContext, updateQueryString, parameters, entityParam, persistentEntity, parameterBindings);
        return new QueryResult(){

            public String getQuery() {
                return filterQuery;
            }

            public String getUpdate() {
                return updateQuery;
            }

            public List<String> getQueryParts() {
                return Collections.emptyList();
            }

            public List<QueryParameterBinding> getParameterBindings() {
                return parameterBindings;
            }
        };
    }

    private String processCustomQuery(MethodMatchContext matchContext, String queryString, List<ParameterElement> parameters, ParameterElement entityParam, SourcePersistentEntity persistentEntity, List<QueryParameterBinding> parameterBindings) {
        List parameterExpressions = matchContext.getMethodElement().getAnnotationMetadata().getAnnotationValuesByType(ParameterExpression.class);
        Matcher matcher = VARIABLE_PATTERN.matcher(queryString);
        ArrayList<Object> queryParts = new ArrayList<Object>();
        int lastOffset = 0;
        while (matcher.find()) {
            int matcherStart = matcher.start(3);
            String start = queryString.substring(lastOffset, matcherStart - 1);
            lastOffset = matcher.end(3);
            if (!start.isEmpty()) {
                queryParts.add(start);
            }
            String name = matcher.group(3);
            QueryParameterBinding binding = RawQueryMethodMatcher.addBinding((MethodMatchContext)matchContext, parameters, (List)parameterExpressions, (ParameterElement)entityParam, (SourcePersistentEntity)persistentEntity, (String)name, (BindingParameter.BindingContext)BindingParameter.BindingContext.create().name(name));
            parameterBindings.add(binding);
            int ind = parameterBindings.size() - 1;
            queryParts.add("{$mn_qp:" + ind + "}");
        }
        String end = queryString.substring(lastOffset);
        if (!end.isEmpty()) {
            queryParts.add(end);
        }
        return String.join((CharSequence)"", queryParts);
    }
}

